/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.misc;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.GregtechMetaTileEntity_SolarTower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class TileEntitySolarHeater
extends GT_MetaTileEntity_TieredMachineBlock {
    public boolean mHasTower = false;
    private GregtechMetaTileEntity_SolarTower mTower = null;
    private int mTX;
    private int mTY;
    private int mTZ;
    private Byte mRequiredFacing;

    public TileEntitySolarHeater(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aSlotCount, aDescription, new ITexture[0]);
    }

    public TileEntitySolarHeater(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aSlotCount, aDescription, aTextures);
    }

    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Point me at a Solar Tower", CORE.GT_Tooltip.get()});
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (side == facing ? 0 : (side == facing.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_IV)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_LuV)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_IV)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_IV)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Bottom)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_LuV)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.SOLARPANEL_IV)};
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntitySolarHeater(this.mName, this.mTier, this.mDescriptionArray, this.mTextures, 0);
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        return new String[]{this.getLocalName(), "Testificate"};
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return false;
    }

    public boolean allowCoverOnSide(byte aSide, int aCoverID) {
        return false;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return null;
    }

    public long maxEUStore() {
        return 0L;
    }

    public int getCapacity() {
        return 0;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesIn() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 0L;
    }

    public boolean isElectric() {
        return false;
    }

    public boolean isValidSlot(int aIndex) {
        return false;
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return facing.offsetY == 0;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
    }

    public void loadNBTData(NBTTagCompound aNBT) {
    }

    public long getInputTier() {
        return 0L;
    }

    public long getOutputTier() {
        return 0L;
    }

    public boolean allowCoverOnSide(ForgeDirection side, GT_ItemStack aStack) {
        return false;
    }

    public void onExplosion() {
    }

    public boolean hasSolarTower() {
        return this.mHasTower;
    }

    public GregtechMetaTileEntity_SolarTower getSolarTower() {
        if (this.mHasTower) {
            return this.mTower;
        }
        return null;
    }

    public boolean canSeeSky() {
        return this.getBaseMetaTileEntity().getWorld().func_72937_j(this.getBaseMetaTileEntity().getXCoord(), this.getBaseMetaTileEntity().getYCoord() + 1, this.getBaseMetaTileEntity().getZCoord());
    }

    public boolean setSolarTower(GregtechMetaTileEntity_SolarTower aTowerTile) {
        if (!this.hasSolarTower()) {
            this.mTX = aTowerTile.getBaseMetaTileEntity().getXCoord();
            this.mTY = aTowerTile.getBaseMetaTileEntity().getYCoord();
            this.mTZ = aTowerTile.getBaseMetaTileEntity().getZCoord();
            this.mHasTower = true;
            this.mTower = aTowerTile;
            return true;
        }
        return false;
    }

    public boolean clearSolarTower() {
        if (this.mHasTower || this.mRequiredFacing != null || this.mTower != null) {
            this.mTX = 0;
            this.mTY = 0;
            this.mTZ = 0;
            this.mRequiredFacing = null;
            this.mTower = null;
            this.mHasTower = false;
            return true;
        }
        return false;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void onRemoval() {
        super.onRemoval();
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return side.offsetY == 0;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public void onFacingChange() {
        super.onFacingChange();
    }

    public void doExplosion(long aExplosionPower) {
    }
}

