/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.draconicevolution.client.handler.ResourceHandler;
import com.brandon3055.draconicevolution.common.blocks.multiblock.IReactorPart;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorCore;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.reactor.TileReactorStabilizer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleReactorBeam
extends EntityFX {
    private final TileEntity tile;

    public ParticleReactorBeam(TileEntity tile) {
        super(tile.func_145831_w(), (double)tile.field_145851_c + 0.5, (double)tile.field_145848_d + 0.5, (double)tile.field_145849_e + 0.5, 0.0, 0.0, 0.0);
        this.tile = tile;
        this.field_70552_h = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70551_j = 1.0f;
        this.field_70145_X = true;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70547_e = 4;
        this.func_70105_a(1.0f, 1.0f);
    }

    public void update() {
        if (this.field_70547_e - this.field_70546_d < 4) {
            this.field_70547_e = this.field_70546_d + 4;
        }
    }

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
    }

    public void func_70539_a(Tessellator tessellator, float partialTick, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        if (!((IReactorPart)this.tile).isActive()) {
            return;
        }
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        double shiftX = this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTick - field_70556_an;
        double shiftY = this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTick - field_70554_ao;
        double shiftZ = this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTick - field_70555_ap;
        GL11.glTranslated((double)shiftX, (double)shiftY, (double)shiftZ);
        MultiblockHelper.TileLocation master = ((IReactorPart)this.tile).getMasterLocation();
        double offsetX = master.field_71574_a - this.tile.field_145851_c;
        double offsetY = master.field_71572_b - this.tile.field_145848_d;
        double offsetZ = master.field_71573_c - this.tile.field_145849_e;
        double offsetLength = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
        double diagonalLength = Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
        GL11.glRotated((double)(Math.toDegrees(-Math.atan2(offsetZ, offsetX)) - 90.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(Math.toDegrees(-Math.atan2(diagonalLength, offsetY)) - 90.0), (double)1.0, (double)0.0, (double)0.0);
        TileReactorCore core = ((IReactorPart)this.tile).getMaster();
        if (this.tile instanceof TileReactorStabilizer && core != null) {
            this.renderStabilizerEffect(tessellator, core, offsetLength, partialTick);
        } else if (core != null) {
            double verY;
            double verX;
            double texU;
            int ray;
            GL11.glShadeModel((int)7425);
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.3);
            GL11.glRotatef((float)(((float)this.field_70546_d + partialTick) * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            ResourceHandler.bindResource("textures/particle/reactorEnergyBeam.png");
            double sizeOrigin = 0.5;
            int color = 0xFF2200;
            int alpha = (int)(200.0 * (double)core.renderSpeed);
            double speed = 20.0;
            double texV2 = ((double)this.field_70546_d + (double)partialTick) * 0.01 * speed;
            double texV1 = offsetLength + texV2;
            tessellator.func_78371_b(5);
            tessellator.func_78380_c(200);
            double sizeTarget = 0.1;
            int raysCount = 16;
            for (ray = 0; ray <= 16; ++ray) {
                texU = (double)ray / 16.0;
                verX = Math.sin(texU * Math.PI * 2.3) * sizeTarget;
                verY = Math.cos(texU * Math.PI * 2.3) * sizeTarget;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a(verX * sizeOrigin, verY * sizeOrigin, -0.55, texU, texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha);
                tessellator.func_78374_a(verX, verY, offsetLength, texU, texV2);
            }
            offsetLength -= core.getCoreRadius() + 0.3;
            sizeTarget = core.getCoreRadius() * 0.2;
            sizeOrigin = 0.1 / sizeTarget;
            for (ray = 0; ray <= 16; ++ray) {
                texU = (double)ray / 16.0;
                verX = Math.sin(texU * Math.PI * 2.13) * sizeTarget;
                verY = Math.cos(texU * Math.PI * 2.13) * sizeTarget;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha);
                tessellator.func_78374_a(verX * sizeOrigin, verY * sizeOrigin, 0.0, texU, texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a(verX, verY, offsetLength, texU, texV2);
            }
            tessellator.func_78381_a();
            GL11.glRotatef((float)(((float)this.field_70546_d + partialTick) * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            tessellator.func_78371_b(5);
            tessellator.func_78380_c(200);
            color = 0xFF4400;
            sizeTarget = core.getCoreRadius() * 0.6;
            sizeOrigin = 0.1 / sizeTarget;
            offsetLength += 0.4;
            GL11.glTranslated((double)0.0, (double)0.0, (double)-0.1);
            for (ray = 0; ray <= 16; ++ray) {
                texU = (double)ray / 16.0;
                verX = Math.sin(texU * Math.PI * (double)2.13f) * sizeTarget;
                verY = Math.cos(texU * Math.PI * (double)2.13f) * sizeTarget;
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, alpha / 2);
                tessellator.func_78374_a(verX * sizeOrigin, verY * sizeOrigin, 0.0, texU, texV1);
                tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, 0);
                tessellator.func_78374_a(verX, verY, offsetLength, texU, texV2);
            }
            tessellator.func_78381_a();
            GL11.glShadeModel((int)7424);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        ResourceHandler.bindDefaultParticles();
        tessellator.func_78382_b();
    }

    private void renderStabilizerEffect(Tessellator tessellator, TileReactorCore core, double offsetLength, float partialTick) {
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.35);
        ResourceHandler.bindResource("textures/particle/reactorBeam.png");
        this.drawBeam(tessellator, core, 1.0, 0.355, 0.8, offsetLength, partialTick, true, false, 65535);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.45);
        double coreSize = core.getCoreRadius() * 0.9;
        double scale = 0.355;
        this.drawBeam(tessellator, core, scale / coreSize, coreSize, offsetLength - core.getCoreDiameter() / 2.5, offsetLength, partialTick, false, false, 65535);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)-0.35);
        this.drawBeam(tessellator, core, 1.0, 0.263, 0.8, offsetLength, partialTick, true, true, 0xFF6600);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)0.45);
        coreSize = core.getCoreRadius() * 0.4;
        scale = 0.263;
        this.drawBeam(tessellator, core, scale / coreSize, coreSize, offsetLength - 0.5, offsetLength, partialTick, false, true, 0xFF6600);
        GL11.glPopMatrix();
        GL11.glShadeModel((int)7424);
    }

    private void drawBeam(Tessellator tessellator, TileReactorCore core, double sizeOrigin, double sizeTarget, double length, double offsetLength, float partialTick, boolean reverseTransparency, boolean reverseDirection, int color) {
        double speed = 3.0;
        double tickOffset = ((double)this.field_70546_d + (double)partialTick) * (reverseDirection ? -0.01 : 0.01) * 3.0;
        double texV1 = offsetLength / 32.0 + tickOffset;
        double texV2 = -0.1 + tickOffset;
        tessellator.func_78371_b(5);
        tessellator.func_78380_c(200);
        int raysCount = 16;
        for (int ray = 0; ray <= 16; ++ray) {
            double texU = (double)ray / 16.0;
            double verX = Math.sin(texU * Math.PI * 2.13325) * sizeTarget;
            double verY = Math.cos(texU * Math.PI * 2.13325) * sizeTarget;
            tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, reverseTransparency ? 0 : (int)(255.0 * (double)core.renderSpeed));
            tessellator.func_78374_a(verX * sizeOrigin, verY * sizeOrigin, 0.0, texU, texV1);
            tessellator.func_78370_a((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, reverseTransparency ? (int)(255.0 * (double)core.renderSpeed) : 0);
            tessellator.func_78374_a(verX, verY, length, texU, texV2);
        }
        tessellator.func_78381_a();
    }
}

