/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.gui.buttons;

import mods.railcraft.common.gui.buttons.IMultiButtonState;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;

public class MultiButtonController<T extends IMultiButtonState> {
    private int currentState;
    private final T[] validStates;

    public MultiButtonController(int startState, T ... validStates) {
        this.currentState = startState;
        this.validStates = validStates;
    }

    protected MultiButtonController(MultiButtonController<T> controller) {
        this.currentState = controller.currentState;
        this.validStates = controller.validStates;
    }

    public MultiButtonController<T> copy() {
        return new MultiButtonController<T>(this);
    }

    public T[] getValidStates() {
        return this.validStates;
    }

    public int incrementState() {
        int newState = this.currentState + 1;
        if (newState >= this.validStates.length) {
            newState = 0;
        }
        this.currentState = newState;
        return this.currentState;
    }

    public int decrementState() {
        int newState = this.currentState - 1;
        if (newState < 0) {
            newState = this.validStates.length - 1;
        }
        this.currentState = newState;
        return this.currentState;
    }

    public void setCurrentState(int state) {
        this.currentState = state;
    }

    public void setCurrentState(T state) {
        for (int i = 0; i < this.validStates.length; ++i) {
            if (this.validStates[i] != state) continue;
            this.currentState = i;
            return;
        }
    }

    public int getCurrentState() {
        return this.currentState;
    }

    public T getButtonState() {
        return this.validStates[this.currentState];
    }

    public void writeToNBT(NBTTagCompound nbt, String tag) {
        nbt.func_74778_a(tag, this.getButtonState().name());
    }

    public void readFromNBT(NBTTagCompound nbt, String tag) {
        if (nbt.func_74781_a(tag) instanceof NBTTagString) {
            String name = nbt.func_74779_i(tag);
            for (int i = 0; i < this.validStates.length; ++i) {
                if (!this.validStates[i].name().equals(name)) continue;
                this.currentState = i;
                break;
            }
        } else if (nbt.func_74781_a(tag) instanceof NBTTagByte) {
            this.currentState = nbt.func_74771_c(tag);
        }
    }
}

