/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.book;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.book.BookMove;
import com.jamesswafford.chess4j.io.PGNGame;
import com.jamesswafford.chess4j.utils.GameResult;
import java.util.List;
import java.util.Random;

public abstract class AbstractOpeningBook {
    private Random r = new Random();

    public abstract void addToBook(Board var1, Move var2);

    public abstract List<BookMove> getMoves(Board var1);

    public abstract long getTotalMoveCount();

    public abstract void initializeBook();

    public void learn(List<Move> moves, Color engineColor, GameResult gameResult) {
    }

    public void addIndexes() {
    }

    public void addToBook(PGNGame game) {
        Board board = Board.INSTANCE;
        board.resetBoard();
        List<Move> gameMoves = game.getMoves();
        for (int i = 0; i < 15 && i < gameMoves.size(); ++i) {
            Move gameMove = gameMoves.get(i);
            this.addToBook(board, gameMove);
            board.applyMove(gameMove);
        }
    }

    public void dropIndexes() {
    }

    public BookMove getMoveWeightedRandomByFrequency(Board board) {
        List<BookMove> bms = this.getMoves(board);
        if (bms.size() == 0) {
            return null;
        }
        int totalWeight = 0;
        for (BookMove bm : bms) {
            totalWeight += bm.getFrequency();
        }
        int val = this.r.nextInt(totalWeight) + 1;
        int countWeight = 0;
        for (BookMove bm : bms) {
            if ((countWeight += bm.getFrequency()) < val) continue;
            return bm;
        }
        throw new RuntimeException("Error in getMoveWeihtedRandomByFrequency().  totalWeight=" + totalWeight + ", val=" + val);
    }
}

