/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.mob.entity;

import cpw.mods.fml.common.network.NetworkRegistry;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.entity.EntityCryoArrow;
import de.katzenpapst.amunra.entity.EntityOsirisBossFireball;
import de.katzenpapst.amunra.helper.NbtHelper;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.mob.DamageSourceAR;
import de.katzenpapst.amunra.mob.entity.IAmunRaBoss;
import de.katzenpapst.amunra.tile.ITileDungeonSpawner;
import de.katzenpapst.amunra.vec.Vector3int;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.entity.IEntityBreathable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityAIArrowAttack;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityMummyBoss
extends EntityMob
implements IBossDisplayData,
IRangedAttackMob,
IEntityBreathable,
IAmunRaBoss {
    protected int deathTicks = 0;
    protected Entity targetEntity;
    protected ITileDungeonSpawner spawner;
    protected AxisAlignedBB roomArea;
    protected Vector3int spawnerPos;
    protected int attackedWithLootLevel = 0;
    protected static List<ItemStack> guaranteedLoot = null;
    protected static List<ItemStack> extraLoot = null;

    public EntityMummyBoss(World world) {
        super(world);
        this.func_70105_a(2.0f, 5.0f);
        this.field_70178_ae = true;
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIArrowAttack((IRangedAttackMob)this, 1.0, 25, 20.0f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 30.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, true));
        if (guaranteedLoot == null) {
            guaranteedLoot = new ArrayList<ItemStack>();
            if (!AmunRa.isNHCoreLoaded) {
                guaranteedLoot.add(ARItems.shuttleSchematic.getItemStack(1));
            }
        }
        if (extraLoot == null) {
            extraLoot = new ArrayList<ItemStack>();
            extraLoot.add(ARItems.mummyDust.getItemStack(3));
            extraLoot.add(new ItemStack(Items.field_151007_F, 3, 0));
            extraLoot.add(new ItemStack(Items.field_151074_bl, 1, 0));
            extraLoot.add(new ItemStack(Items.field_151043_k, 1, 0));
            extraLoot.add(new ItemStack(Items.field_151100_aR, 3, 4));
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source != DamageSource.field_76380_i && source != DamageSourceAR.dsFallOffShip) {
            EntityDamageSourceIndirect indirectSource;
            amount = source instanceof EntityDamageSourceIndirect && (indirectSource = (EntityDamageSourceIndirect)source).func_76346_g() instanceof EntityCryoArrow ? (amount *= 1.5f) : (amount /= 2.0f);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_82196_d(EntityLivingBase p_82196_1_, float p_82196_2_) {
        if (!this.field_70128_L) {
            this.performAttack((Entity)p_82196_1_);
        }
    }

    protected void performAttack(Entity target) {
        double startX = target.field_70165_t - this.field_70165_t;
        double startY = target.field_70163_u - this.field_70163_u - (double)target.field_70131_O - 1.5;
        double startZ = target.field_70161_v - this.field_70161_v;
        EntityOsirisBossFireball entitylargefireball = new EntityOsirisBossFireball(this.field_70170_p, (EntityLivingBase)this, startX, startY, startZ);
        entitylargefireball.damage = 10.0f;
        double d8 = 0.0;
        Vec3 vec3 = this.func_70676_i(1.0f);
        entitylargefireball.field_70165_t = this.field_70165_t + vec3.field_72450_a * 0.0;
        entitylargefireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 1.5;
        entitylargefireball.field_70161_v = this.field_70161_v + vec3.field_72449_c * 0.0;
        this.field_70170_p.func_72838_d((Entity)entitylargefireball);
    }

    public void func_70653_a(Entity p_70653_1_, float p_70653_2_, double p_70653_3_, double p_70653_5_) {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0 * ConfigManagerCore.dungeonBossHealthMod);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
    }

    public boolean canBreath() {
        return true;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        this.func_85030_a(GalacticraftCore.TEXTURE_PREFIX + "entity.bossliving", this.func_70599_aP(), this.func_70647_i() + 6.0f);
        return null;
    }

    protected String func_70673_aS() {
        return null;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        super.func_70645_a(p_70645_1_);
        Entity entity = p_70645_1_.func_76346_g();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            this.attackedWithLootLevel = EnchantmentHelper.func_77519_f((EntityLivingBase)player);
        }
    }

    protected void func_70609_aI() {
        ++this.deathTicks;
        if (this.deathTicks >= 180 && this.deathTicks <= 200) {
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 2.0f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 1.5f;
            this.field_70170_p.func_72869_a("hugeexplosion", this.field_70165_t + (double)f, this.field_70163_u + 2.0 + (double)f1, this.field_70161_v + (double)f2, 0.0, 0.0, 0.0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.deathTicks >= 180 && this.deathTicks % 5 == 0) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_EXPLODE, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
            if (this.deathTicks > 150 && this.deathTicks % 5 == 0) {
                int j;
                for (int i = 30; i > 0; i -= j) {
                    j = EntityXPOrb.func_70527_a((int)i);
                    this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
                }
            }
            if (this.deathTicks == 1) {
                GalacticraftCore.packetPipeline.sendToAllAround((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_PLAY_SOUND_BOSS_DEATH, new Object[0]), new NetworkRegistry.TargetPoint(this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v, 40.0));
            }
        }
        this.func_70091_d(0.0, 0.1f, 0.0);
        this.field_70761_aq = this.field_70177_z += 20.0f;
        if (this.deathTicks == 200 && !this.field_70170_p.field_72995_K) {
            int j;
            for (int i = 20; i > 0; i -= j) {
                j = EntityXPOrb.func_70527_a((int)i);
                this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, j));
            }
            this.dropLoot(true, this.attackedWithLootLevel);
            super.func_70106_y();
            if (this.getSpawner() != null) {
                this.getSpawner().onBossDefeated();
            }
        }
    }

    protected Item func_146068_u() {
        return null;
    }

    protected void dropLoot(boolean hitByPlayer, int lootLevel) {
        List<ItemStack> result = this.getDrops(guaranteedLoot, this.func_70681_au(), 0);
        int lootModifier = (lootLevel + 1) / 2;
        result.addAll(this.getDrops(extraLoot, this.func_70681_au(), lootLevel, lootModifier, 5 + lootModifier));
        for (ItemStack stack : result) {
            this.func_70099_a(stack, 1.0f);
        }
    }

    protected List<ItemStack> getDrops(List<ItemStack> source, Random rand, int lootLevel) {
        return this.getDrops(source, rand, lootLevel, 1, 1);
    }

    protected List<ItemStack> getDrops(List<ItemStack> source, Random rand, int lootLevel, int minStacks, int maxStacks) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int size = source.size();
        if (size == 0) {
            return result;
        }
        for (int i = 0; i < maxStacks; ++i) {
            int stackSize;
            int randIndex = 0;
            if (size > 1) {
                randIndex = rand.nextInt(size);
            }
            ItemStack stack = source.get(randIndex).func_77946_l();
            int stackMin = 0;
            if (minStacks > result.size()) {
                stackMin = 1;
            }
            if ((stackSize = MathHelper.func_76136_a((Random)rand, (int)(stackMin = Math.min(stackMin + lootLevel, stack.field_77994_a)), (int)stack.field_77994_a)) <= 0) continue;
            stack.field_77994_a = stackSize;
            result.add(stack);
        }
        return result;
    }

    protected void func_70600_l(int p_70600_1_) {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        if (this.spawnerPos != null) {
            tagCompound.func_74782_a("spawnerPosition", (NBTBase)this.spawnerPos.toNBT());
        }
        if (this.roomArea != null) {
            tagCompound.func_74782_a("roomArea", (NBTBase)NbtHelper.getAsNBT(this.roomArea));
        }
        tagCompound.func_74768_a("atkLootLevel", this.attackedWithLootLevel);
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        this.attackedWithLootLevel = tagCompund.func_74762_e("atkLootLevel");
        if (tagCompund.func_74764_b("spawnerPosition")) {
            this.spawnerPos = new Vector3int(tagCompund.func_74775_l("spawnerPosition"));
        }
        if (tagCompund.func_74764_b("roomArea")) {
            this.roomArea = NbtHelper.readAABB(tagCompund.func_74775_l("roomArea"));
        }
    }

    @Override
    public void setSpawner(ITileDungeonSpawner spawner) {
        this.spawner = spawner;
        this.spawnerPos = spawner.getBlockPosition();
    }

    @Override
    public ITileDungeonSpawner getSpawner() {
        TileEntity te;
        if (this.spawner == null && this.spawnerPos != null && (te = this.field_70170_p.func_147438_o(this.spawnerPos.x, this.spawnerPos.y, this.spawnerPos.z)) instanceof ITileDungeonSpawner) {
            this.spawner = (ITileDungeonSpawner)te;
        }
        return this.spawner;
    }

    @Override
    public void setRoomArea(AxisAlignedBB aabb) {
        this.roomArea = aabb.func_72329_c();
    }

    @Override
    public AxisAlignedBB getRoomArea() {
        return this.roomArea;
    }

    @Override
    public void despawnBoss() {
        AxisAlignedBB aabb = this.roomArea.func_72314_b(11.0, 11.0, 11.0);
        List entitiesWithin2 = this.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
        for (EntityPlayer p : entitiesWithin2) {
            p.func_145747_a((IChatComponent)new ChatComponentText(GCCoreUtil.translate((String)"gui.skeletonBoss.message")));
        }
        this.func_70106_y();
    }
}

