/*
 * Decompiled with CFR 0.152.
 */
package kubatech.loaders.item.items;

import codechicken.nei.NEIClientUtils;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.ItemDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.IWidgetBuilder;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DynamicTextWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.MultiChildWidget;
import com.gtnewhorizons.modularui.common.widget.TabButton;
import com.gtnewhorizons.modularui.common.widget.TabContainer;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.concurrent.atomic.AtomicReference;
import kubatech.api.Variables;
import kubatech.api.enums.ItemList;
import kubatech.api.tea.TeaNetwork;
import kubatech.api.utils.ModUtils;
import kubatech.api.utils.StringUtils;
import kubatech.loaders.item.IItemProxyGUI;
import kubatech.loaders.item.items.TeaCollection;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class TeaUltimate
extends TeaCollection
implements IItemProxyGUI {
    private static String name = "";
    private static long timeCounter = 0L;
    private static int colorCounter = 0;

    public TeaUltimate() {
        super("ultimate_tea");
    }

    public static String getUltimateTeaDisplayName(String displayName) {
        long current = System.currentTimeMillis();
        if (current - timeCounter > 100L) {
            timeCounter = current;
            name = StringUtils.applyRainbow("ULTIMATE", colorCounter++, EnumChatFormatting.BOLD.toString() + EnumChatFormatting.OBFUSCATED);
        }
        return String.format(displayName, name + EnumChatFormatting.RESET);
    }

    @Override
    public String getDisplayName(ItemStack stack) {
        if (!ModUtils.isClientSided || Minecraft.func_71410_x().field_71439_g == null) {
            return super.getDisplayName(stack);
        }
        if (this.checkTeaOwner(stack, Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            return TeaUltimate.getUltimateTeaDisplayName(super.getDisplayName(stack));
        }
        return EnumChatFormatting.GOLD + "" + EnumChatFormatting.BOLD + "" + EnumChatFormatting.ITALIC + "???????";
    }

    @Override
    public ModularWindow createWindow(ItemStack stack, EntityPlayer player) {
        ModularWindow.Builder builder = ModularWindow.builder((int)200, (int)150);
        builder.setBackground(new IDrawable[]{ModularUITextures.VANILLA_BACKGROUND});
        TeaNetwork teaNetwork = TeaNetwork.getNetwork(player.getPersistentID());
        IDrawable tab1 = new ItemDrawable(ItemList.LegendaryUltimateTea.get(1L, new Object[0])).withFixedSize(18.0f, 18.0f, 4.0f, 6.0f);
        IDrawable tab2 = new ItemDrawable(new ItemStack(Blocks.field_150462_ai)).withFixedSize(18.0f, 18.0f, 4.0f, 6.0f);
        IDrawable tab3 = new ItemDrawable(new ItemStack(Items.field_151153_ao)).withFixedSize(18.0f, 18.0f, 4.0f, 6.0f);
        AtomicReference<BigInteger> teaAmount = new AtomicReference<BigInteger>(BigInteger.ZERO);
        AtomicReference<BigInteger> teaLimit = new AtomicReference<BigInteger>(BigInteger.ZERO);
        builder.widget((Widget)new TabContainer().setButtonSize(28, 32).addTabButton(new TabButton(0).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), tab1}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_START.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), tab1}).setPos(0, -28)).addTabButton(new TabButton(1).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), tab2}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), tab2}).setPos(28, -28)).addTabButton(new TabButton(2).setBackground(false, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.0f, 1.0f, 0.5f), tab3}).setBackground(true, new IDrawable[]{ModularUITextures.VANILLA_TAB_TOP_MIDDLE.getSubArea(0.0f, 0.5f, 1.0f, 1.0f), tab3}).setPos(56, -28)).addPage((Widget)new MultiChildWidget().addChild(new TextWidget(new Text("STATUS").format(EnumChatFormatting.BOLD).format(EnumChatFormatting.GOLD).shadow()).setPos(10, 5)).addChild(new DynamicTextWidget(() -> new Text("Tea: " + (NEIClientUtils.shiftKey() ? Variables.numberFormat.format(teaAmount.get()) : Variables.numberFormatScientific.format(teaAmount.get()))).color(Color.GREEN.dark(3))).setSynced(false).setPos(20, 20).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BigIntegerSyncer(() -> teaNetwork.teaAmount, teaAmount::set), (IWidgetBuilder)builder)).addChild(new DynamicTextWidget(() -> new Text("Tea limit: " + (NEIClientUtils.shiftKey() ? Variables.numberFormat.format(teaLimit.get()) : Variables.numberFormatScientific.format(teaLimit.get()))).color(Color.GREEN.dark(3))).setSynced(false).setPos(20, 30).attachSyncer((FakeSyncWidget)new FakeSyncWidget.BigIntegerSyncer(() -> teaNetwork.teaLimit, teaLimit::set), (IWidgetBuilder)builder))).addPage((Widget)new MultiChildWidget().addChild(new TextWidget(new Text("EXCHANGE").format(EnumChatFormatting.BOLD).format(EnumChatFormatting.GOLD).shadow()).setPos(10, 5)).addChild(new ButtonWidget().setOnClick((clickData, widget) -> {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            if (!teaNetwork.canAfford(50000L, true)) {
                return;
            }
            if (player.field_71071_by.func_70441_a(ItemList.TeaAcceptorResearchNote.get(1L, new Object[0]))) {
                return;
            }
            player.func_70099_a(ItemList.TeaAcceptorResearchNote.get(1L, new Object[0]), 0.5f);
        }).setBackground(new IDrawable[]{new ItemDrawable().setItem(ItemList.TeaAcceptorResearchNote.get(1L, new Object[0]))}).addTooltip("Tea Acceptor Research Note").addTooltip(new Text("Cost: " + NumberFormat.getInstance().format(50000L) + " Tea").color(Color.GRAY.normal)).setPos(20, 20))).addPage((Widget)new MultiChildWidget().addChild(new TextWidget(new Text("BENEFITS").format(EnumChatFormatting.BOLD).format(EnumChatFormatting.GOLD).shadow()).setPos(10, 5))));
        return builder.build();
    }

    @Override
    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer entity) {
        if (world.field_72995_K) {
            return stack;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return stack;
        }
        if (!this.checkTeaOwner(stack, entity.getPersistentID())) {
            return stack;
        }
        TeaUltimate.openHeldItemGUI(entity);
        return stack;
    }

    @Override
    public void onUpdate(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (world.field_72995_K) {
            return;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return;
        }
        super.onUpdate(stack, world, entity, slot, isCurrentItem);
        if (this.checkTeaOwner(stack, entity.getPersistentID())) {
            TeaNetwork teaNetwork = TeaNetwork.getNetwork(entity.getPersistentID());
            teaNetwork.addTea(1L);
        }
    }
}

