/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeElvenTrade;

@ZenClass(value="mods.botania.ElvenTrade")
public class ElvenTrade {
    protected static final String name = "Botania Eleven Trade";

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] input) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeElvenTrade(InputHelper.toStack(output), InputHelper.toObjects(input))));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipeElvenTrade> recipes = new LinkedList<RecipeElvenTrade>();
        for (RecipeElvenTrade entry : BotaniaAPI.elvenTradeRecipes) {
            if (entry == null || entry.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(entry.getOutput()))) continue;
            recipes.add(entry);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipeElvenTrade> {
        public Remove(List<RecipeElvenTrade> recipes) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipeElvenTrade> {
        public Add(RecipeElvenTrade recipe) {
            super(ElvenTrade.name, BotaniaAPI.elvenTradeRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipeElvenTrade recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

