/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.ResultInsufficientHeat;
import gregtech.api.recipe.check.ResultInsufficientMachineTier;
import gregtech.api.recipe.check.ResultInsufficientPower;
import gregtech.api.recipe.check.ResultInsufficientStartupPower;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import java.util.HashMap;
import java.util.Map;

public final class CheckRecipeResultRegistry {
    private static final Map<String, CheckRecipeResult> registry = new HashMap<String, CheckRecipeResult>();
    public static final CheckRecipeResult SUCCESSFUL = SimpleCheckRecipeResult.ofSuccess("success");
    public static final CheckRecipeResult GENERATING = SimpleCheckRecipeResult.ofSuccess("generating");
    public static final CheckRecipeResult NO_RECIPE = SimpleCheckRecipeResult.ofFailure("no_recipe");
    @Deprecated
    public static final CheckRecipeResult OUTPUT_FULL = SimpleCheckRecipeResult.ofFailure("output_full");
    public static final CheckRecipeResult ITEM_OUTPUT_FULL = SimpleCheckRecipeResult.ofFailure("item_output_full");
    public static final CheckRecipeResult FLUID_OUTPUT_FULL = SimpleCheckRecipeResult.ofFailure("fluid_output_full");
    public static final CheckRecipeResult NONE = SimpleCheckRecipeResult.ofFailure("none");
    public static final CheckRecipeResult CRASH = SimpleCheckRecipeResult.ofFailurePersistOnShutdown("crash");
    public static final CheckRecipeResult NO_FUEL_FOUND = SimpleCheckRecipeResult.ofFailure("no_fuel");
    public static final CheckRecipeResult NO_TURBINE_FOUND = SimpleCheckRecipeResult.ofFailure("no_turbine");
    public static final CheckRecipeResult NO_DATA_STICKS = SimpleCheckRecipeResult.ofFailure("no_data_sticks");
    public static final CheckRecipeResult POWER_OVERFLOW = SimpleCheckRecipeResult.ofFailure("power_overflow");
    public static final CheckRecipeResult DURATION_OVERFLOW = SimpleCheckRecipeResult.ofFailure("duration_overflow");
    public static final CheckRecipeResult INTERNAL_ERROR = SimpleCheckRecipeResult.ofFailure("internal_error");
    public static final CheckRecipeResult NO_DRILLING_FLUID = SimpleCheckRecipeResult.ofFailure("no_drilling_fluid");
    public static final CheckRecipeResult MISSING_MINING_PIPE = SimpleCheckRecipeResult.ofFailure("no_mining_pipe");
    public static final CheckRecipeResult BACKFILLER_NO_CONCRETE = SimpleCheckRecipeResult.ofFailure("backfiller_no_concrete");

    public static void register(CheckRecipeResult sample) {
        if (CheckRecipeResultRegistry.isRegistered(sample.getID())) {
            throw new IllegalStateException(String.format("ID %s is already registered for %s", sample.getID(), registry.get(sample.getID()).getClass().getCanonicalName()));
        }
        registry.put(sample.getID(), sample);
    }

    public static CheckRecipeResult getSampleFromRegistry(String id) {
        if (!CheckRecipeResultRegistry.isRegistered(id)) {
            throw new RuntimeException("Unknown id: " + id);
        }
        return registry.get(id);
    }

    public static boolean isRegistered(String id) {
        return registry.containsKey(id);
    }

    public static CheckRecipeResult insufficientPower(long required) {
        return new ResultInsufficientPower(required);
    }

    public static CheckRecipeResult insufficientHeat(int required) {
        return new ResultInsufficientHeat(required);
    }

    public static CheckRecipeResult insufficientMachineTier(int required) {
        return new ResultInsufficientMachineTier(required);
    }

    public static CheckRecipeResult insufficientStartupPower(int required) {
        return new ResultInsufficientStartupPower(required);
    }

    static {
        CheckRecipeResultRegistry.register(new SimpleCheckRecipeResult(false, "", false));
        CheckRecipeResultRegistry.register(new ResultInsufficientPower(0L));
        CheckRecipeResultRegistry.register(new ResultInsufficientHeat(0));
        CheckRecipeResultRegistry.register(new ResultInsufficientMachineTier(0));
        CheckRecipeResultRegistry.register(new ResultInsufficientStartupPower(0));
    }
}

