/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import buildcraft.api.transport.IPipeTile;
import codechicken.translocator.TileItemTranslocator;
import cofh.api.energy.IEnergyReceiver;
import cofh.api.transport.IItemDuct;
import com.google.auto.value.AutoValue;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.arboriculture.ITree;
import forestry.arboriculture.tiles.TileLeaves;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.damagesources.GT_DamageSources;
import gregtech.api.enchants.Enchantment_Hazmat;
import gregtech.api.enchants.Enchantment_Radioactivity;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.Textures;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.events.BlockScanningEvent;
import gregtech.api.interfaces.IBlockContainer;
import gregtech.api.interfaces.IDebugableBlock;
import gregtech.api.interfaces.IHasIndexedTexture;
import gregtech.api.interfaces.IProjectileItem;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IMachineProgress;
import gregtech.api.interfaces.tileentity.IUpgradableMachine;
import gregtech.api.items.GT_EnergyArmor_Item;
import gregtech.api.items.GT_Generic_Item;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.net.GT_Packet_Sound;
import gregtech.api.objects.CollectorUtils;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_ItemStack2;
import gregtech.api.objects.ItemData;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.threads.GT_Runnable_Sound;
import gregtech.api.util.AutoValue_GT_Utility_ItemId;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_PlayedSound;
import gregtech.api.util.GT_Recipe;
import gregtech.common.GT_Pollution;
import gregtech.common.GT_UndergroundOil;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import ic2.api.crops.ICropTile;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.reactor.IReactor;
import ic2.api.reactor.IReactorChamber;
import ic2.api.recipe.ICannerBottleRecipeManager;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.tile.IEnergyStorage;
import ic2.api.tile.IWrenchable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.network.play.server.S1FPacketSetExperience;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class GT_Utility {
    private static final Map<Locale, DecimalFormat> decimalFormatters = new HashMap<Locale, DecimalFormat>();
    private static final List<FluidContainerRegistry.FluidContainerData> sFluidContainerList = new ArrayList<FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, FluidContainerRegistry.FluidContainerData> sFilledContainerToData = new HashMap<GT_ItemStack, FluidContainerRegistry.FluidContainerData>();
    private static final Map<GT_ItemStack, Map<String, FluidContainerRegistry.FluidContainerData>> sEmptyContainerToFluidToData = new HashMap<GT_ItemStack, Map<String, FluidContainerRegistry.FluidContainerData>>();
    private static final Map<String, List<ItemStack>> sFluidToContainers = new HashMap<String, List<ItemStack>>();
    private static final Map<OrePrefixes, Supplier<ItemStack>> sOreToCobble = new HashMap<OrePrefixes, Supplier<ItemStack>>();
    private static final Map<Integer, Boolean> sOreTable = new HashMap<Integer, Boolean>();
    public static boolean TE_CHECK = false;
    public static boolean BC_CHECK = false;
    public static boolean CHECK_ALL = true;
    public static boolean RF_CHECK = false;
    public static Map<GT_PlayedSound, Integer> sPlayedSoundMap = new HashMap<GT_PlayedSound, Integer>();
    private static int sBookCount = 0;
    public static UUID defaultUuid = null;
    public static final ImmutableSet<String> ORE_BLOCK_CLASSES;

    public static int safeInt(long number, int margin) {
        return number > (long)(Integer.MAX_VALUE - margin) ? Integer.MAX_VALUE - margin : (int)number;
    }

    public static int safeInt(long number) {
        return number > GT_Values.V[GT_Values.V.length - 1] ? GT_Utility.safeInt(GT_Values.V[GT_Values.V.length - 1], 1) : (number < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)number);
    }

    public static Field getPublicField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Object aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getClass().getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Field getField(Class<?> aObject, String aField) {
        Field rField = null;
        try {
            rField = aObject.getDeclaredField(aField);
            rField.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rField;
    }

    public static Method getMethod(Class<?> aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rMethod;
    }

    public static Method getMethod(Object aObject, String aMethod, Class<?> ... aParameterTypes) {
        Method rMethod = null;
        try {
            rMethod = aObject.getClass().getMethod(aMethod, aParameterTypes);
            rMethod.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return rMethod;
    }

    public static Field getField(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField;
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object getFieldContent(Object aObject, String aField, boolean aPrivate, boolean aLogErrors) {
        try {
            Field tField;
            Field field = aObject instanceof Class ? ((Class)aObject).getDeclaredField(aField) : (tField = aObject instanceof String ? Class.forName((String)aObject).getDeclaredField(aField) : aObject.getClass().getDeclaredField(aField));
            if (aPrivate) {
                tField.setAccessible(true);
            }
            return tField.get(aObject instanceof Class || aObject instanceof String ? null : aObject);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object callPublicMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, false, false, true, aParameters);
    }

    public static Object callPrivateMethod(Object aObject, String aMethod, Object ... aParameters) {
        return GT_Utility.callMethod(aObject, aMethod, true, false, true, aParameters);
    }

    public static Object callMethod(Object aObject, String aMethod, boolean aPrivate, boolean aUseUpperCasedDataTypes, boolean aLogErrors, Object ... aParameters) {
        try {
            Method tMethod;
            Class[] tParameterTypes = new Class[aParameters.length];
            for (int i = 0; i < aParameters.length; i = (int)((byte)(i + 1))) {
                if (aParameters[i] instanceof Class) {
                    tParameterTypes[i] = (Class)aParameters[i];
                    aParameters[i] = null;
                } else {
                    tParameterTypes[i] = aParameters[i].getClass();
                }
                if (aUseUpperCasedDataTypes) continue;
                if (tParameterTypes[i] == Boolean.class) {
                    tParameterTypes[i] = Boolean.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Byte.class) {
                    tParameterTypes[i] = Byte.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Short.class) {
                    tParameterTypes[i] = Short.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Integer.class) {
                    tParameterTypes[i] = Integer.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Long.class) {
                    tParameterTypes[i] = Long.TYPE;
                    continue;
                }
                if (tParameterTypes[i] == Float.class) {
                    tParameterTypes[i] = Float.TYPE;
                    continue;
                }
                if (tParameterTypes[i] != Double.class) continue;
                tParameterTypes[i] = Double.TYPE;
            }
            Method method = tMethod = aObject instanceof Class ? ((Class)aObject).getMethod(aMethod, tParameterTypes) : aObject.getClass().getMethod(aMethod, tParameterTypes);
            if (aPrivate) {
                tMethod.setAccessible(true);
            }
            return tMethod.invoke(aObject, aParameters);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return null;
        }
    }

    public static Object callConstructor(String aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
        try {
            return GT_Utility.callConstructor(Class.forName(aClass), aConstructorIndex, aReplacementObject, aLogErrors, aParameters);
        }
        catch (Throwable e) {
            if (aLogErrors) {
                e.printStackTrace(GT_Log.err);
            }
            return aReplacementObject;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object callConstructor(Class<?> aClass, int aConstructorIndex, Object aReplacementObject, boolean aLogErrors, Object ... aParameters) {
        if (aConstructorIndex < 0) {
            try {
                for (Constructor<?> tConstructor : aClass.getConstructors()) {
                    try {
                        return tConstructor.newInstance(aParameters);
                    }
                    catch (Throwable throwable) {
                    }
                }
                return aReplacementObject;
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
                return aReplacementObject;
            }
        } else {
            try {
                return aClass.getConstructors()[aConstructorIndex].newInstance(aParameters);
            }
            catch (Throwable e) {
                if (!aLogErrors) return aReplacementObject;
                e.printStackTrace(GT_Log.err);
            }
        }
        return aReplacementObject;
    }

    public static String capitalizeString(String aString) {
        if (aString != null && aString.length() > 0) {
            return aString.substring(0, 1).toUpperCase() + aString.substring(1);
        }
        return "";
    }

    public static boolean getPotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field[] fields;
                Field tPotionHashmap = null;
                for (Field field : fields = EntityLiving.class.getDeclaredFields()) {
                    if (field.getType() != HashMap.class) continue;
                    tPotionHashmap = field;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    return ((HashMap)tPotionHashmap.get(aPlayer)).get(aPotionIndex) != null;
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static String getClassName(Object aObject) {
        if (aObject == null) {
            return "null";
        }
        return aObject.getClass().getName().substring(aObject.getClass().getName().lastIndexOf(".") + 1);
    }

    public static void removePotion(EntityLivingBase aPlayer, int aPotionIndex) {
        block4: {
            try {
                Field[] fields;
                Field tPotionHashmap = null;
                for (Field field : fields = EntityLiving.class.getDeclaredFields()) {
                    if (field.getType() != HashMap.class) continue;
                    tPotionHashmap = field;
                    tPotionHashmap.setAccessible(true);
                    break;
                }
                if (tPotionHashmap != null) {
                    ((HashMap)tPotionHashmap.get(aPlayer)).remove(aPotionIndex);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    public static boolean getFullInvisibility(EntityPlayer aPlayer) {
        block4: {
            try {
                if (aPlayer.func_82150_aj()) {
                    for (int i = 0; i < 4; ++i) {
                        if (aPlayer.field_71071_by.field_70460_b[i] == null || !(aPlayer.field_71071_by.field_70460_b[i].func_77973_b() instanceof GT_EnergyArmor_Item) || (((GT_EnergyArmor_Item)aPlayer.field_71071_by.field_70460_b[i].func_77973_b()).mSpecials & 0x200) == 0 || !GT_ModHandler.canUseElectricItem(aPlayer.field_71071_by.field_70460_b[i], 10000)) continue;
                        return true;
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return false;
    }

    public static ItemStack suckOneItemStackAt(World aWorld, double aX, double aY, double aZ, double aL, double aH, double aW) {
        for (EntityItem tItem : aWorld.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)aX, (double)aY, (double)aZ, (double)(aX + aL), (double)(aY + aH), (double)(aZ + aW)))) {
            if (tItem.field_70128_L) continue;
            aWorld.func_72900_e((Entity)tItem);
            tItem.func_70106_y();
            return tItem.func_92059_d();
        }
        return null;
    }

    public static byte getOppositeSide(ForgeDirection side) {
        return (byte)side.getOpposite().ordinal();
    }

    public static byte getTier(long l) {
        byte i = -1;
        while ((i = (byte)((byte)(i + 1))) < GT_Values.V.length) {
            if (l > GT_Values.V[i]) continue;
            return i;
        }
        return (byte)(GT_Values.V.length - 1);
    }

    public static long getAmperageForTier(long voltage, byte tier) {
        return GT_Utility.ceilDiv(voltage, GT_Values.V[tier]);
    }

    public static long roundUpVoltage(long voltage) {
        if (voltage > GT_Values.V[GT_Values.V.length - 1]) {
            return voltage;
        }
        return GT_Values.V[GT_Utility.getTier(voltage)];
    }

    public static String getColoredTierNameFromVoltage(long voltage) {
        return GT_Utility.getColoredTierNameFromTier(GT_Utility.getTier(voltage));
    }

    public static String getColoredTierNameFromTier(byte tier) {
        return GT_Values.TIER_COLORS[tier] + GT_Values.VN[tier] + EnumChatFormatting.RESET;
    }

    @Nonnull
    public static String getTierNameWithParentheses(long voltage) {
        byte tier = GT_Utility.getTier(voltage);
        if (tier < 0) {
            return "";
        }
        if (tier >= GT_Values.VN.length - 1) {
            return " (MAX+)";
        }
        return " (" + GT_Values.VN[tier] + ")";
    }

    public static void sendChatToPlayer(EntityPlayer aPlayer, String aChatMessage) {
        if (aPlayer instanceof EntityPlayerMP && aChatMessage != null) {
            aPlayer.func_146105_b((IChatComponent)new ChatComponentText(aChatMessage));
        }
    }

    public static void checkAvailabilities() {
        if (CHECK_ALL) {
            Class<IItemDuct> tClass2;
            try {
                tClass2 = IItemDuct.class;
                tClass2.getCanonicalName();
                TE_CHECK = true;
            }
            catch (Throwable tClass2) {
                // empty catch block
            }
            try {
                tClass2 = IPipeTile.class;
                tClass2.getCanonicalName();
                BC_CHECK = true;
            }
            catch (Throwable tClass3) {
                // empty catch block
            }
            try {
                tClass2 = IEnergyReceiver.class;
                tClass2.getCanonicalName();
                RF_CHECK = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            CHECK_ALL = false;
        }
    }

    public static boolean isConnectableNonInventoryPipe(TileEntity tileEntity, ForgeDirection side) {
        if (tileEntity == null) {
            return false;
        }
        GT_Utility.checkAvailabilities();
        if (TE_CHECK && tileEntity instanceof IItemDuct) {
            return true;
        }
        if (BC_CHECK && tileEntity instanceof IPipeTile) {
            IPipeTile pipeTile = (IPipeTile)tileEntity;
            return pipeTile.isPipeConnected(side);
        }
        return Mods.Translocator.isModLoaded() && tileEntity instanceof TileItemTranslocator;
    }

    public static byte moveStackIntoPipe(IInventory aTileEntity1, Object aTileEntity2, int[] aGrabSlots, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        return GT_Utility.moveStackIntoPipe(aTileEntity1, aTileEntity2, aGrabSlots, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
    }

    public static byte moveStackIntoPipe(IInventory fromInventory, Object toObject, int[] fromSlots, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean dropItem) {
        if (fromInventory == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (toObject != null) {
            GT_Utility.checkAvailabilities();
            if (TE_CHECK && toObject instanceof IItemDuct) {
                IItemDuct itemDuct = (IItemDuct)toObject;
                for (int aGrabSlot : fromSlots) {
                    ItemStack rStack;
                    ItemStack tStack;
                    byte tMovedItemCount;
                    if (!GT_Utility.listContainsItem(aFilter, fromInventory.func_70301_a(aGrabSlot), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromInventory, aGrabSlot, fromSide, fromInventory.func_70301_a(aGrabSlot)) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > fromInventory.func_70301_a((int)aGrabSlot).field_77994_a || (tMovedItemCount = (byte)(tStack.field_77994_a - ((rStack = itemDuct.insertItem(putSide, GT_Utility.copyOrNull(tStack = GT_Utility.copyAmount(Math.min(fromInventory.func_70301_a((int)aGrabSlot).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), fromInventory.func_70301_a(aGrabSlot))))) == null ? 0 : rStack.field_77994_a))) < 1) continue;
                    fromInventory.func_70298_a(aGrabSlot, (int)tMovedItemCount);
                    fromInventory.func_70296_d();
                    return tMovedItemCount;
                }
                return 0;
            }
            if (BC_CHECK && toObject instanceof IPipeTile) {
                IPipeTile bcPipe = (IPipeTile)toObject;
                for (int fromSlot : fromSlots) {
                    ItemStack tStack;
                    byte tMovedItemCount;
                    if (!GT_Utility.listContainsItem(aFilter, fromInventory.func_70301_a(fromSlot), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromInventory, fromSlot, fromSide, fromInventory.func_70301_a(fromSlot)) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > fromInventory.func_70301_a((int)fromSlot).field_77994_a || (tMovedItemCount = (byte)bcPipe.injectItem(GT_Utility.copyOrNull(tStack = GT_Utility.copyAmount(Math.min(fromInventory.func_70301_a((int)fromSlot).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), fromInventory.func_70301_a(fromSlot))), false, putSide)) < Math.max(aMinMoveAtOnce, aMinTargetStackSize)) continue;
                    tMovedItemCount = (byte)bcPipe.injectItem(GT_Utility.copyAmount((int)tMovedItemCount, tStack), true, putSide);
                    fromInventory.func_70298_a(fromSlot, (int)tMovedItemCount);
                    fromInventory.func_70296_d();
                    return tMovedItemCount;
                }
                return 0;
            }
        }
        if (fromInventory instanceof TileEntity) {
            TileEntity fromTileEntity = (TileEntity)fromInventory;
            if (fromSide != ForgeDirection.UNKNOWN && fromSide.getOpposite() == ForgeDirection.getOrientation((int)putSide.ordinal())) {
                int tX = fromTileEntity.field_145851_c + fromSide.offsetX;
                int tY = fromTileEntity.field_145848_d + fromSide.offsetY;
                int tZ = fromTileEntity.field_145849_e + fromSide.offsetZ;
                if (!GT_Utility.hasBlockHitBox(((TileEntity)fromInventory).func_145831_w(), tX, tY, tZ) && dropItem) {
                    for (int fromSlot : fromSlots) {
                        if (!GT_Utility.listContainsItem(aFilter, fromInventory.func_70301_a(fromSlot), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromInventory, fromSlot, fromSide, fromInventory.func_70301_a(fromSlot)) || Math.max(aMinMoveAtOnce, aMinTargetStackSize) > fromInventory.func_70301_a((int)fromSlot).field_77994_a) continue;
                        ItemStack tStack = GT_Utility.copyAmount(Math.min(fromInventory.func_70301_a((int)fromSlot).field_77994_a, Math.min(aMaxMoveAtOnce, aMaxTargetStackSize)), fromInventory.func_70301_a(fromSlot));
                        EntityItem tEntity = new EntityItem(((TileEntity)fromInventory).func_145831_w(), (double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5, tStack);
                        tEntity.field_70179_y = 0.0;
                        tEntity.field_70181_x = 0.0;
                        tEntity.field_70159_w = 0.0;
                        ((TileEntity)fromInventory).func_145831_w().func_72838_d((Entity)tEntity);
                        assert (tStack != null);
                        fromInventory.func_70298_a(fromSlot, tStack.field_77994_a);
                        fromInventory.func_70296_d();
                        return (byte)tStack.field_77994_a;
                    }
                }
            }
        }
        return 0;
    }

    public static byte moveStackFromSlotAToSlotB(IInventory aTileEntity1, IInventory aTileEntity2, int aGrabFrom, int aPutTo, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (aTileEntity1 == null || aTileEntity2 == null || aMinTargetStackSize <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMaxMoveAtOnce <= 0 || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        ItemStack tStack1 = aTileEntity1.func_70301_a(aGrabFrom);
        ItemStack tStack2 = aTileEntity2.func_70301_a(aPutTo);
        if (tStack1 != null) {
            if (tStack2 != null && !GT_Utility.areStacksEqual(tStack1, tStack2)) {
                return 0;
            }
            ItemStack tStack3 = GT_Utility.copyOrNull(tStack1);
            aMaxTargetStackSize = (byte)Math.min(aMaxTargetStackSize, Math.min(tStack3.func_77976_d(), Math.min(tStack2 == null ? Integer.MAX_VALUE : tStack2.func_77976_d(), aTileEntity2.func_70297_j_())));
            tStack3.field_77994_a = Math.min(tStack3.field_77994_a, aMaxTargetStackSize - (tStack2 == null ? 0 : tStack2.field_77994_a));
            if (tStack3.field_77994_a > aMaxMoveAtOnce) {
                tStack3.field_77994_a = aMaxMoveAtOnce;
            }
            if (tStack3.field_77994_a + (tStack2 == null ? 0 : tStack2.field_77994_a) >= Math.min(tStack3.func_77976_d(), aMinTargetStackSize) && tStack3.field_77994_a >= aMinMoveAtOnce) {
                tStack3 = aTileEntity1.func_70298_a(aGrabFrom, tStack3.field_77994_a);
                aTileEntity1.func_70296_d();
                if (tStack3 != null) {
                    if (tStack2 == null) {
                        aTileEntity2.func_70299_a(aPutTo, GT_Utility.copyOrNull(tStack3));
                    } else {
                        tStack2.field_77994_a += tStack3.field_77994_a;
                    }
                    aTileEntity2.func_70296_d();
                    return (byte)tStack3.field_77994_a;
                }
            }
        }
        return 0;
    }

    public static boolean isAllowedToTakeFromSlot(IInventory aTileEntity, int aSlot, ForgeDirection side, ItemStack aStack) {
        if (side == ForgeDirection.UNKNOWN) {
            return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).anyMatch(d -> GT_Utility.isAllowedToTakeFromSlot(aTileEntity, aSlot, d, aStack));
        }
        if (aTileEntity instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)aTileEntity;
            return sided.func_102008_b(aSlot, aStack, side.ordinal());
        }
        return true;
    }

    public static boolean isAllowedToPutIntoSlot(IInventory aTileEntity, int aSlot, ForgeDirection side, ItemStack aStack, byte aMaxStackSize) {
        ItemStack tStack = aTileEntity.func_70301_a(aSlot);
        if (!(tStack == null || GT_Utility.areStacksEqual(tStack, aStack) && tStack.field_77994_a < tStack.func_77976_d())) {
            return false;
        }
        if (side == ForgeDirection.UNKNOWN) {
            return Arrays.stream(ForgeDirection.VALID_DIRECTIONS).anyMatch(d -> GT_Utility.isAllowedToPutIntoSlot(aTileEntity, aSlot, d, aStack, aMaxStackSize));
        }
        if (aTileEntity instanceof ISidedInventory && !((ISidedInventory)aTileEntity).func_102007_a(aSlot, aStack, side.ordinal())) {
            return false;
        }
        return aSlot < aTileEntity.func_70302_i_() && aTileEntity.func_94041_b(aSlot, aStack);
    }

    public static int moveMultipleItemStacks(Object aTileEntity1, Object aTileEntity2, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, int aStackAmount) {
        if (aTileEntity1 instanceof IInventory) {
            return GT_Utility.moveMultipleItemStacks((IInventory)aTileEntity1, aTileEntity2, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aStackAmount, true);
        }
        return 0;
    }

    public static int moveMultipleItemStacks(IInventory fromInventory, Object toObject, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, int aMaxStackTransfer, boolean aDoCheckChests) {
        if (fromInventory == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce || aMaxStackTransfer == 0) {
            return 0;
        }
        int[] tGrabSlots = new int[fromInventory.func_70302_i_()];
        int tGrabSlotsSize = 0;
        if (fromInventory instanceof ISidedInventory) {
            for (int i : ((ISidedInventory)fromInventory).func_94128_d(fromSide.ordinal())) {
                ItemStack s = fromInventory.func_70301_a(i);
                if (s == null || !GT_Utility.isAllowedToTakeFromSlot(fromInventory, i, fromSide, s) || s.field_77994_a < aMinMoveAtOnce || !GT_Utility.listContainsItem(aFilter, s, true, aInvertFilter)) continue;
                tGrabSlots[tGrabSlotsSize++] = i;
            }
        } else {
            for (int i = 0; i < tGrabSlots.length; ++i) {
                ItemStack s = fromInventory.func_70301_a(i);
                if (s == null || s.field_77994_a < aMinMoveAtOnce || !GT_Utility.listContainsItem(aFilter, s, true, aInvertFilter)) continue;
                tGrabSlots[tGrabSlotsSize++] = i;
            }
        }
        if (tGrabSlotsSize == 0) {
            if (aDoCheckChests && fromInventory instanceof TileEntityChest) {
                TileEntityChest chest = (TileEntityChest)fromInventory;
                return GT_Utility.moveFromAdjacentChests(chest, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer);
            }
            return 0;
        }
        if (toObject instanceof IInventory) {
            TileEntityChest chest;
            int tAmount;
            IInventory toInventory = (IInventory)toObject;
            HashMap<ItemId, Integer> tPutItems = new HashMap<ItemId, Integer>(toInventory.func_70302_i_());
            HashMap<ItemId, List> tPutItemStacks = new HashMap<ItemId, List>(toInventory.func_70302_i_());
            ArrayList<Integer> tPutFreeSlots = new ArrayList<Integer>(toInventory.func_70302_i_());
            int[] accessibleSlots = null;
            if (toObject instanceof ISidedInventory) {
                ISidedInventory sided = (ISidedInventory)toObject;
                accessibleSlots = sided.func_94128_d(putSide.ordinal());
            }
            for (int i = 0; i < toInventory.func_70302_i_(); ++i) {
                ItemStack s;
                int slot = i;
                if (accessibleSlots != null) {
                    if (accessibleSlots.length <= i) break;
                    slot = accessibleSlots[slot];
                }
                if ((s = toInventory.func_70301_a(slot)) == null) {
                    tPutFreeSlots.add(slot);
                    continue;
                }
                if (s.field_77994_a >= s.func_77976_d() || s.field_77994_a >= toInventory.func_70297_j_() || aMinMoveAtOnce > s.func_77976_d() - s.field_77994_a || !GT_Utility.isAllowedToPutIntoSlot(toInventory, slot, putSide, s, (byte)64)) continue;
                ItemId sID = ItemId.createNoCopy(s);
                tPutItems.merge(sID, Math.min(s.func_77976_d(), toInventory.func_70297_j_()) - s.field_77994_a, Integer::sum);
                tPutItemStacks.computeIfAbsent(sID, k -> new ArrayList()).add(s);
            }
            if (tPutItems.isEmpty() && tPutFreeSlots.isEmpty()) {
                if (aDoCheckChests && toObject instanceof TileEntityChest) {
                    TileEntityChest chest2 = (TileEntityChest)toObject;
                    return GT_Utility.moveToAdjacentChests(fromInventory, chest2, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer);
                }
                return 0;
            }
            int tStacksMoved = 0;
            int tTotalItemsMoved = 0;
            block3: for (int j = 0; j < tGrabSlotsSize; ++j) {
                int tStackSize;
                int tMovedItems;
                int grabSlot = tGrabSlots[j];
                do {
                    List putStack;
                    int canPut;
                    tMovedItems = 0;
                    ItemStack tGrabStack = fromInventory.func_70301_a(grabSlot);
                    if (tGrabStack == null) continue block3;
                    tStackSize = tGrabStack.field_77994_a;
                    ItemId sID = ItemId.createNoCopy(tGrabStack);
                    if (tPutItems.containsKey(sID) && (canPut = Math.min((Integer)tPutItems.get(sID), aMaxMoveAtOnce)) >= aMinMoveAtOnce && !(putStack = (List)tPutItemStacks.get(sID)).isEmpty()) {
                        int toPut;
                        tMovedItems = toPut = Math.min(canPut, tStackSize);
                        for (int i = 0; i < putStack.size(); ++i) {
                            ItemStack s = (ItemStack)putStack.get(i);
                            int sToPut = Math.min(Math.min(Math.min(toPut, s.func_77976_d() - s.field_77994_a), toInventory.func_70297_j_() - s.field_77994_a), aMaxTargetStackSize - s.field_77994_a);
                            if (sToPut <= 0 || sToPut < aMinMoveAtOnce || s.field_77994_a + sToPut < aMinTargetStackSize) continue;
                            toPut -= sToPut;
                            s.field_77994_a += sToPut;
                            if (s.field_77994_a == s.func_77976_d() || s.field_77994_a == toInventory.func_70297_j_()) {
                                putStack.remove(i);
                                --i;
                            }
                            if (toPut == 0) break;
                        }
                        if ((tMovedItems -= toPut) > 0) {
                            tTotalItemsMoved += tMovedItems;
                            tPutItems.merge(sID, tMovedItems, (a, b) -> a.equals(b) ? null : Integer.valueOf(a - b));
                            if ((tStackSize -= tMovedItems) == 0) {
                                fromInventory.func_70299_a(grabSlot, null);
                            } else {
                                tGrabStack.field_77994_a = tStackSize;
                            }
                            fromInventory.func_70296_d();
                            toInventory.func_70296_d();
                        }
                    }
                    if (tStackSize > 0 && !tPutFreeSlots.isEmpty()) {
                        for (int i = 0; i < tPutFreeSlots.size(); ++i) {
                            byte tMoved;
                            int tPutSlot = (Integer)tPutFreeSlots.get(i);
                            if (!GT_Utility.isAllowedToPutIntoSlot(toInventory, tPutSlot, putSide, tGrabStack, (byte)64) || (tMoved = GT_Utility.moveStackFromSlotAToSlotB(fromInventory, toInventory, grabSlot, tPutSlot, aMaxTargetStackSize, aMinTargetStackSize, (byte)(aMaxMoveAtOnce - tMovedItems), aMinMoveAtOnce)) <= 0) continue;
                            ItemStack s = toInventory.func_70301_a(tPutSlot);
                            if (s != null) {
                                int spare = Math.min(s.func_77976_d(), toInventory.func_70297_j_()) - s.field_77994_a;
                                if (spare > 0) {
                                    ItemId ssID = ItemId.createNoCopy(s);
                                    tPutItems.merge(ssID, spare, Integer::sum);
                                    tPutItemStacks.computeIfAbsent(ssID, k -> new ArrayList()).add(s);
                                }
                                tPutFreeSlots.remove(i);
                                --i;
                            }
                            tTotalItemsMoved += tMoved;
                            tMovedItems += tMoved;
                            if ((tStackSize -= tMoved) == 0) break;
                        }
                    }
                    if (tMovedItems <= 0 || ++tStacksMoved < aMaxStackTransfer) continue;
                    return tTotalItemsMoved;
                } while (tMovedItems > 0 && tStackSize > 0);
            }
            if (aDoCheckChests && fromInventory instanceof TileEntityChest && (tAmount = GT_Utility.moveFromAdjacentChests(chest = (TileEntityChest)fromInventory, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer - tStacksMoved)) != 0) {
                return tAmount + tTotalItemsMoved;
            }
            if (aDoCheckChests && toObject instanceof TileEntityChest && (tAmount = GT_Utility.moveToAdjacentChests(fromInventory, chest = (TileEntityChest)toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer - tStacksMoved)) != 0) {
                return tAmount + tTotalItemsMoved;
            }
            return tTotalItemsMoved;
        }
        int tTotalItemsMoved = 0;
        int tGrabInventorySize = tGrabSlots.length;
        for (int i = 0; i < tGrabInventorySize; ++i) {
            byte tMoved = GT_Utility.moveStackIntoPipe(fromInventory, toObject, tGrabSlots, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aDoCheckChests);
            if (tMoved == 0) {
                return tTotalItemsMoved;
            }
            tTotalItemsMoved += tMoved;
        }
        return 0;
    }

    private static int moveToAdjacentChests(IInventory aTileEntity1, TileEntityChest aTargetChest, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, int aMaxStackTransfer) {
        if (aTargetChest.field_145984_a) {
            if (aTargetChest.field_145991_k != null) {
                return GT_Utility.moveMultipleItemStacks(aTileEntity1, aTargetChest.field_145991_k, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
            }
            if (aTargetChest.field_145992_i != null) {
                return GT_Utility.moveMultipleItemStacks(aTileEntity1, aTargetChest.field_145992_i, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
            }
            if (aTargetChest.field_145990_j != null) {
                return GT_Utility.moveMultipleItemStacks(aTileEntity1, aTargetChest.field_145990_j, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
            }
            if (aTargetChest.field_145988_l != null) {
                return GT_Utility.moveMultipleItemStacks(aTileEntity1, aTargetChest.field_145988_l, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
            }
        }
        return 0;
    }

    private static int moveFromAdjacentChests(TileEntityChest fromTileEntityChest, Object toObject, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, int aMaxStackTransfer) {
        if (fromTileEntityChest.field_145991_k != null) {
            return GT_Utility.moveMultipleItemStacks((IInventory)fromTileEntityChest.field_145991_k, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
        }
        if (fromTileEntityChest.field_145992_i != null) {
            return GT_Utility.moveMultipleItemStacks((IInventory)fromTileEntityChest.field_145992_i, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
        }
        if (fromTileEntityChest.field_145990_j != null) {
            return GT_Utility.moveMultipleItemStacks((IInventory)fromTileEntityChest.field_145990_j, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
        }
        if (fromTileEntityChest.field_145988_l != null) {
            return GT_Utility.moveMultipleItemStacks((IInventory)fromTileEntityChest.field_145988_l, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aMaxStackTransfer, false);
        }
        return 0;
    }

    public static byte moveOneItemStack(Object fromObject, Object toObject, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        if (fromObject instanceof IInventory) {
            IInventory inv = (IInventory)fromObject;
            return GT_Utility.moveOneItemStack(inv, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
        }
        return 0;
    }

    private static byte moveOneItemStack(IInventory fromInventory, Object toObject, ForgeDirection fromSide, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean aDoCheckChests) {
        if (fromInventory == null || aMaxTargetStackSize <= 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        int[] tGrabSlots = null;
        if (fromInventory instanceof ISidedInventory) {
            tGrabSlots = ((ISidedInventory)fromInventory).func_94128_d(fromSide.ordinal());
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[fromInventory.func_70302_i_()];
            for (int i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (toObject instanceof IInventory) {
            byte tAmount;
            IInventory inv = (IInventory)toObject;
            int[] tPutSlots = null;
            if (toObject instanceof ISidedInventory) {
                ISidedInventory sided = (ISidedInventory)toObject;
                tPutSlots = sided.func_94128_d(putSide.ordinal());
            }
            if (tPutSlots == null) {
                tPutSlots = new int[inv.func_70302_i_()];
                for (int i = 0; i < tPutSlots.length; ++i) {
                    tPutSlots[i] = i;
                }
            }
            for (int tGrabSlot : tGrabSlots) {
                byte tMovedItemCount = 0;
                ItemStack tGrabStack = fromInventory.func_70301_a(tGrabSlot);
                if (GT_Utility.listContainsItem(aFilter, tGrabStack, true, aInvertFilter) && tGrabStack.field_77994_a >= aMinMoveAtOnce && GT_Utility.isAllowedToTakeFromSlot(fromInventory, tGrabSlot, fromSide, tGrabStack)) {
                    for (int tPutSlot : tPutSlots) {
                        if (!GT_Utility.isAllowedToPutIntoSlot(inv, tPutSlot, putSide, tGrabStack, aMaxTargetStackSize) || (tMovedItemCount = (byte)(tMovedItemCount + GT_Utility.moveStackFromSlotAToSlotB(fromInventory, inv, tGrabSlot, tPutSlot, aMaxTargetStackSize, aMinTargetStackSize, (byte)(aMaxMoveAtOnce - tMovedItemCount), aMinMoveAtOnce))) < aMaxMoveAtOnce && (tMovedItemCount <= 0 || aMaxTargetStackSize >= 64)) continue;
                        return tMovedItemCount;
                    }
                }
                if (tMovedItemCount <= 0) continue;
                return tMovedItemCount;
            }
            if (aDoCheckChests && fromInventory instanceof TileEntityChest) {
                TileEntityChest fromChest = (TileEntityChest)fromInventory;
                if (fromChest.field_145984_a) {
                    tAmount = 0;
                    if (fromChest.field_145991_k != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)fromChest.field_145991_k, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (fromChest.field_145992_i != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)fromChest.field_145992_i, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (fromChest.field_145990_j != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)fromChest.field_145990_j, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (fromChest.field_145988_l != null) {
                        tAmount = GT_Utility.moveOneItemStack((IInventory)fromChest.field_145988_l, toObject, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
            if (aDoCheckChests && toObject instanceof TileEntityChest) {
                TileEntityChest toChest = (TileEntityChest)toObject;
                if (toChest.field_145984_a) {
                    tAmount = 0;
                    if (toChest.field_145991_k != null) {
                        tAmount = GT_Utility.moveOneItemStack(fromInventory, toChest.field_145991_k, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (toChest.field_145992_i != null) {
                        tAmount = GT_Utility.moveOneItemStack(fromInventory, toChest.field_145992_i, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (toChest.field_145990_j != null) {
                        tAmount = GT_Utility.moveOneItemStack(fromInventory, toChest.field_145990_j, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (toChest.field_145988_l != null) {
                        tAmount = GT_Utility.moveOneItemStack(fromInventory, toChest.field_145988_l, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tAmount != 0) {
                        return tAmount;
                    }
                }
            }
        }
        return GT_Utility.moveStackIntoPipe(fromInventory, toObject, tGrabSlots, fromSide, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aDoCheckChests);
    }

    public static byte moveOneItemStackIntoSlot(Object fromTileEntity, Object toTileEntity, ForgeDirection fromSide, int putSlot, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        IInventory fromInv;
        block9: {
            block8: {
                if (!(fromTileEntity instanceof IInventory)) break block8;
                fromInv = (IInventory)fromTileEntity;
                if (aMaxTargetStackSize > 0 && aMinTargetStackSize > 0 && aMaxMoveAtOnce > 0 && aMinTargetStackSize <= aMaxTargetStackSize && aMinMoveAtOnce <= aMaxMoveAtOnce) break block9;
            }
            return 0;
        }
        int[] tGrabSlots = null;
        if (fromTileEntity instanceof ISidedInventory) {
            ISidedInventory sided = (ISidedInventory)fromTileEntity;
            tGrabSlots = sided.func_94128_d(fromSide.ordinal());
        }
        if (tGrabSlots == null) {
            tGrabSlots = new int[fromInv.func_70302_i_()];
            for (int i = 0; i < tGrabSlots.length; ++i) {
                tGrabSlots[i] = i;
            }
        }
        if (toTileEntity instanceof IInventory) {
            IInventory toInv = (IInventory)toTileEntity;
            for (int tGrabSlot : tGrabSlots) {
                byte tMovedItemCount;
                if (!GT_Utility.listContainsItem(aFilter, fromInv.func_70301_a(tGrabSlot), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromInv, tGrabSlot, fromSide, fromInv.func_70301_a(tGrabSlot)) || !GT_Utility.isAllowedToPutIntoSlot(toInv, putSlot, ForgeDirection.UNKNOWN, fromInv.func_70301_a(tGrabSlot), aMaxTargetStackSize) || (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB(fromInv, toInv, tGrabSlot, putSlot, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) <= 0) continue;
                return tMovedItemCount;
            }
        }
        ForgeDirection toSide = fromSide.getOpposite();
        GT_Utility.moveStackIntoPipe(fromInv, toTileEntity, tGrabSlots, fromSide, ForgeDirection.UNKNOWN, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce);
        return 0;
    }

    public static byte moveFromSlotToSlot(IInventory fromInv, IInventory toInv, int aGrabFrom, int aPutTo, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        byte tMovedItemCount;
        if (fromInv == null || toInv == null || aGrabFrom < 0 || aPutTo < 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (GT_Utility.listContainsItem(aFilter, fromInv.func_70301_a(aGrabFrom), true, aInvertFilter) && GT_Utility.isAllowedToTakeFromSlot(fromInv, aGrabFrom, ForgeDirection.UNKNOWN, fromInv.func_70301_a(aGrabFrom)) && GT_Utility.isAllowedToPutIntoSlot(toInv, aPutTo, ForgeDirection.UNKNOWN, fromInv.func_70301_a(aGrabFrom), aMaxTargetStackSize) && (tMovedItemCount = GT_Utility.moveStackFromSlotAToSlotB(fromInv, toInv, aGrabFrom, aPutTo, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce)) > 0) {
            return tMovedItemCount;
        }
        return 0;
    }

    public static byte moveFromSlotToSide(IInventory fromTile, Object toTile, int fromSlot, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce, boolean aDoCheckChests) {
        if (fromTile == null || fromSlot < 0 || aMinTargetStackSize <= 0 || aMaxMoveAtOnce <= 0 || aMinTargetStackSize > aMaxTargetStackSize || aMinMoveAtOnce > aMaxMoveAtOnce) {
            return 0;
        }
        if (!GT_Utility.listContainsItem(aFilter, fromTile.func_70301_a(fromSlot), true, aInvertFilter) || !GT_Utility.isAllowedToTakeFromSlot(fromTile, fromSlot, ForgeDirection.UNKNOWN, fromTile.func_70301_a(fromSlot))) {
            return 0;
        }
        if (toTile instanceof IInventory) {
            int[] tPutSlots = null;
            if (toTile instanceof ISidedInventory) {
                ISidedInventory sided = (ISidedInventory)toTile;
                tPutSlots = sided.func_94128_d(putSide.ordinal());
            }
            if (tPutSlots == null) {
                tPutSlots = new int[((IInventory)toTile).func_70302_i_()];
                for (int i = 0; i < tPutSlots.length; ++i) {
                    tPutSlots[i] = i;
                }
            }
            byte tMovedItemCount = 0;
            for (int tPutSlot : tPutSlots) {
                if (!GT_Utility.isAllowedToPutIntoSlot((IInventory)toTile, tPutSlot, putSide, fromTile.func_70301_a(fromSlot), aMaxTargetStackSize) || (tMovedItemCount = (byte)(tMovedItemCount + GT_Utility.moveStackFromSlotAToSlotB(fromTile, (IInventory)toTile, fromSlot, tPutSlot, aMaxTargetStackSize, aMinTargetStackSize, (byte)(aMaxMoveAtOnce - tMovedItemCount), aMinMoveAtOnce))) < aMaxMoveAtOnce) continue;
                return tMovedItemCount;
            }
            if (tMovedItemCount > 0) {
                return tMovedItemCount;
            }
            if (aDoCheckChests && toTile instanceof TileEntityChest) {
                TileEntityChest tTileEntity2 = (TileEntityChest)toTile;
                if (tTileEntity2.field_145984_a) {
                    if (tTileEntity2.field_145991_k != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.field_145991_k, fromSlot, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145992_i != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.field_145992_i, fromSlot, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145990_j != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.field_145990_j, fromSlot, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    } else if (tTileEntity2.field_145988_l != null) {
                        tMovedItemCount = GT_Utility.moveFromSlotToSide(fromTile, tTileEntity2.field_145988_l, fromSlot, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, false);
                    }
                    if (tMovedItemCount > 0) {
                        return tMovedItemCount;
                    }
                }
            }
        }
        return GT_Utility.moveStackIntoPipe(fromTile, toTile, new int[]{fromSlot}, ForgeDirection.UNKNOWN, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, aDoCheckChests);
    }

    public static byte moveFromSlotToSide(IInventory fromTile, Object toTile, int fromSlot, ForgeDirection putSide, List<ItemStack> aFilter, boolean aInvertFilter, byte aMaxTargetStackSize, byte aMinTargetStackSize, byte aMaxMoveAtOnce, byte aMinMoveAtOnce) {
        return GT_Utility.moveFromSlotToSide(fromTile, toTile, fromSlot, putSide, aFilter, aInvertFilter, aMaxTargetStackSize, aMinTargetStackSize, aMaxMoveAtOnce, aMinMoveAtOnce, true);
    }

    public static boolean listContainsItem(Collection<ItemStack> aList, ItemStack aStack, boolean aTIfListEmpty, boolean aInvertFilter) {
        if (aStack == null || aStack.field_77994_a < 1) {
            return false;
        }
        if (aList == null) {
            return aTIfListEmpty;
        }
        boolean tEmpty = true;
        for (ItemStack tStack : aList) {
            if (tStack == null) continue;
            tEmpty = false;
            if (!GT_Utility.areStacksEqual(aStack, tStack)) continue;
            return !aInvertFilter;
        }
        return tEmpty ? aTIfListEmpty : aInvertFilter;
    }

    public static boolean areStacksOrToolsEqual(ItemStack aStack1, ItemStack aStack2) {
        if (aStack1 != null && aStack2 != null && aStack1.func_77973_b() == aStack2.func_77973_b()) {
            if (aStack1.func_77973_b().func_77645_m()) {
                return true;
            }
            boolean bl = aStack1.func_77978_p() == null;
            boolean bl2 = aStack2.func_77978_p() == null;
            return !(bl != bl2 || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p()) || Items.field_151008_G.getDamage(aStack1) != Items.field_151008_G.getDamage(aStack2) && Items.field_151008_G.getDamage(aStack1) != Short.MAX_VALUE && Items.field_151008_G.getDamage(aStack2) != Short.MAX_VALUE);
        }
        return false;
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2) {
        return GT_Utility.areFluidsEqual(aFluid1, aFluid2, false);
    }

    public static boolean areFluidsEqual(FluidStack aFluid1, FluidStack aFluid2, boolean aIgnoreNBT) {
        return aFluid1 != null && aFluid2 != null && aFluid1.getFluid() == aFluid2.getFluid() && (aIgnoreNBT || aFluid1.tag == null == (aFluid2.tag == null) && (aFluid1.tag == null || aFluid1.tag.equals((Object)aFluid2.tag)));
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areStacksEqual(aStack1, aStack2, false);
    }

    public static boolean areStacksEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return !(aStack1 == null || aStack2 == null || aStack1.func_77973_b() != aStack2.func_77973_b() || !aIgnoreNBT && (aStack1.func_77978_p() == null != (aStack2.func_77978_p() == null) || aStack1.func_77978_p() != null && !aStack1.func_77978_p().equals((Object)aStack2.func_77978_p())) || Items.field_151008_G.getDamage(aStack1) != Items.field_151008_G.getDamage(aStack2) && Items.field_151008_G.getDamage(aStack1) != Short.MAX_VALUE && Items.field_151008_G.getDamage(aStack2) != Short.MAX_VALUE);
    }

    public static boolean areStacksEqualOrNull(ItemStack stack1, ItemStack stack2) {
        return stack1 == null && stack2 == null || GT_Utility.areStacksEqual(stack1, stack2);
    }

    public static boolean areStackListsEqual(List<ItemStack> lhs, List<ItemStack> rhs, boolean ignoreStackSize, boolean ignoreNBT) {
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator<ItemStack> it1 = lhs.iterator();
        Iterator<ItemStack> it2 = rhs.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (GT_Utility.areStacksEqualExtended(it1.next(), it2.next(), ignoreStackSize, ignoreNBT)) continue;
            return false;
        }
        return true;
    }

    private static boolean areStacksEqualExtended(ItemStack lhs, ItemStack rhs, boolean ignoreStackSize, boolean ignoreNBT) {
        if (lhs == null) {
            return rhs == null;
        }
        if (rhs == null) {
            return false;
        }
        return !(lhs.func_77973_b() != rhs.func_77973_b() || !ignoreNBT && !Objects.equals(lhs.field_77990_d, rhs.field_77990_d) || !ignoreStackSize && lhs.field_77994_a != rhs.field_77994_a);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2) {
        return GT_Utility.areUnificationsEqual(aStack1, aStack2, false);
    }

    public static boolean areUnificationsEqual(ItemStack aStack1, ItemStack aStack2, boolean aIgnoreNBT) {
        return GT_Utility.areStacksEqual(GT_OreDictUnificator.get_nocopy(aStack1), GT_OreDictUnificator.get_nocopy(aStack2), aIgnoreNBT);
    }

    public static String getFluidName(Fluid aFluid, boolean aLocalized) {
        String rName;
        if (aFluid == null) {
            return "";
        }
        String string = rName = aLocalized ? aFluid.getLocalizedName(new FluidStack(aFluid, 0)) : aFluid.getUnlocalizedName();
        if (rName.contains("fluid.") || rName.contains("tile.")) {
            return GT_Utility.capitalizeString(rName.replaceAll("fluid.", "").replaceAll("tile.", ""));
        }
        return rName;
    }

    public static String getFluidName(FluidStack aFluid, boolean aLocalized) {
        if (aFluid == null) {
            return "";
        }
        return GT_Utility.getFluidName(aFluid.getFluid(), aLocalized);
    }

    public static void reInit() {
        sFilledContainerToData.clear();
        sEmptyContainerToFluidToData.clear();
        sFluidToContainers.clear();
        for (FluidContainerRegistry.FluidContainerData tData : sFluidContainerList) {
            String fluidName = tData.fluid.getFluid().getName();
            sFilledContainerToData.put(new GT_ItemStack(tData.filledContainer), tData);
            Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(tData.emptyContainer));
            List<ItemStack> tContainers = sFluidToContainers.get(fluidName);
            if (tFluidToContainer == null) {
                tFluidToContainer = new HashMap<String, FluidContainerRegistry.FluidContainerData>();
                sEmptyContainerToFluidToData.put(new GT_ItemStack(tData.emptyContainer), tFluidToContainer);
            }
            tFluidToContainer.put(fluidName, tData);
            if (tContainers == null) {
                tContainers = new ArrayList<ItemStack>();
                tContainers.add(tData.filledContainer);
                sFluidToContainers.put(fluidName, tContainers);
                continue;
            }
            tContainers.add(tData.filledContainer);
        }
    }

    public static void addFluidContainerData(FluidContainerRegistry.FluidContainerData aData) {
        String fluidName = aData.fluid.getFluid().getName();
        sFluidContainerList.add(aData);
        sFilledContainerToData.put(new GT_ItemStack(aData.filledContainer), aData);
        Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aData.emptyContainer));
        List<ItemStack> tContainers = sFluidToContainers.get(fluidName);
        if (tFluidToContainer == null) {
            tFluidToContainer = new HashMap<String, FluidContainerRegistry.FluidContainerData>();
            sEmptyContainerToFluidToData.put(new GT_ItemStack(aData.emptyContainer), tFluidToContainer);
        }
        tFluidToContainer.put(fluidName, aData);
        if (tContainers == null) {
            tContainers = new ArrayList<ItemStack>();
            tContainers.add(aData.filledContainer);
            sFluidToContainers.put(fluidName, tContainers);
        } else {
            tContainers.add(aData.filledContainer);
        }
    }

    public static List<ItemStack> getContainersFromFluid(FluidStack tFluidStack) {
        if (tFluidStack != null) {
            List<ItemStack> tContainers = sFluidToContainers.get(tFluidStack.getFluid().getName());
            if (tContainers == null) {
                return new ArrayList<ItemStack>();
            }
            return tContainers;
        }
        return new ArrayList<ItemStack>();
    }

    public static ItemStack fillFluidContainer(FluidStack aFluid, ItemStack aStack, boolean aRemoveFluidDirectly, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getFluid(aStack) == null && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) <= aFluid.amount) {
            if (aRemoveFluidDirectly) {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = GT_Utility.copyAmount(1, aStack);
                aFluid.amount -= iFluidContainerItem.fill(aStack, aFluid, true);
            } else {
                IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
                aStack = GT_Utility.copyAmount(1, aStack);
                iFluidContainerItem.fill(aStack, aFluid, true);
            }
            return aStack;
        }
        Map<String, FluidContainerRegistry.FluidContainerData> tFluidToContainer = sEmptyContainerToFluidToData.get(new GT_ItemStack(aStack));
        if (tFluidToContainer == null) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = tFluidToContainer.get(aFluid.getFluid().getName());
        if (tData == null || tData.fluid.amount > aFluid.amount) {
            return null;
        }
        if (aRemoveFluidDirectly) {
            aFluid.amount -= tData.fluid.amount;
        }
        return GT_Utility.copyAmount(1, tData.filledContainer);
    }

    public static int calculateRecipeEU(Materials aMaterial, int defaultRecipeEUPerTick) {
        return aMaterial.getProcessingMaterialTierEU() == 0 ? defaultRecipeEUPerTick : aMaterial.getProcessingMaterialTierEU();
    }

    public static ItemStack getFluidDisplayStack(Fluid aFluid) {
        return aFluid == null ? null : GT_Utility.getFluidDisplayStack(new FluidStack(aFluid, 0), false);
    }

    public static ItemStack getFluidDisplayStack(FluidStack aFluid, boolean aUseStackSize) {
        return GT_Utility.getFluidDisplayStack(aFluid, aUseStackSize, false);
    }

    public static ItemStack getFluidDisplayStack(FluidStack aFluid, boolean aUseStackSize, boolean aHideStackSize) {
        if (aFluid == null || aFluid.getFluid() == null) {
            return null;
        }
        int tmp = 0;
        try {
            tmp = aFluid.getFluid().getID();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        ItemStack rStack = ItemList.Display_Fluid.getWithDamage(1L, tmp, new Object[0]);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74772_a("mFluidDisplayAmount", aUseStackSize ? (long)aFluid.amount : 0L);
        tNBT.func_74772_a("mFluidDisplayHeat", (long)aFluid.getFluid().getTemperature(aFluid));
        tNBT.func_74757_a("mFluidState", aFluid.getFluid().isGaseous(aFluid));
        tNBT.func_74757_a("mHideStackSize", aHideStackSize);
        try {
            tNBT.func_74778_a("mFluidMaterialName", Materials.FLUID_MAP.get((Object)aFluid.getFluid()).mName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        rStack.func_77982_d(tNBT);
        return rStack;
    }

    public static FluidStack getFluidFromDisplayStack(ItemStack aDisplayStack) {
        if (!GT_Utility.isStackValid(aDisplayStack) || aDisplayStack.func_77973_b() != ItemList.Display_Fluid.getItem() || !aDisplayStack.func_77942_o()) {
            return null;
        }
        Fluid tFluid = FluidRegistry.getFluid((int)ItemList.Display_Fluid.getItem().getDamage(aDisplayStack));
        return new FluidStack(tFluid, (int)aDisplayStack.func_77978_p().func_74763_f("mFluidDisplayAmount"));
    }

    public static boolean containsFluid(ItemStack aStack, FluidStack aFluid, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack) || aFluid == null) {
            return false;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
            aStack = GT_Utility.copyAmount(1, aStack);
            return aFluid.isFluidEqual(iFluidContainerItem.getFluid(aStack));
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData != null && tData.fluid.isFluidEqual(aFluid);
    }

    public static FluidStack getFluidForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            return ((IFluidContainerItem)aStack.func_77973_b()).drain(GT_Utility.copyAmount(1, aStack), Integer.MAX_VALUE, true);
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        return tData == null ? null : tData.fluid.copy();
    }

    public static ItemStack getContainerForFilledItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData tData = sFilledContainerToData.get(new GT_ItemStack(aStack));
        if (tData != null) {
            return GT_Utility.copyAmount(1, tData.emptyContainer);
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            IFluidContainerItem iFluidContainerItem = (IFluidContainerItem)aStack.func_77973_b();
            aStack = GT_Utility.copyAmount(1, aStack);
            iFluidContainerItem.drain(aStack, Integer.MAX_VALUE, true);
            return aStack;
        }
        return null;
    }

    public static ItemStack getContainerItem(ItemStack aStack, boolean aCheckIFluidContainerItems) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (aStack.func_77973_b().hasContainerItem(aStack)) {
            return aStack.func_77973_b().getContainerItem(aStack);
        }
        if (ItemList.Cell_Empty.isStackEqual(aStack, false, true)) {
            return null;
        }
        if (aStack.func_77973_b() == Items.field_151068_bn || aStack.func_77973_b() == Items.field_151062_by || ItemList.TF_Vial_FieryBlood.isStackEqual(aStack) || ItemList.TF_Vial_FieryTears.isStackEqual(aStack)) {
            return ItemList.Bottle_Empty.get(1L, new Object[0]);
        }
        if (aCheckIFluidContainerItems && aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0) {
            ItemStack tStack = GT_Utility.copyAmount(1, aStack);
            ((IFluidContainerItem)aStack.func_77973_b()).drain(tStack, Integer.MAX_VALUE, true);
            if (!GT_Utility.areStacksEqual(aStack, tStack)) {
                return tStack;
            }
            return null;
        }
        int tCapsuleCount = GT_ModHandler.getCapsuleCellContainerCount(aStack);
        if (tCapsuleCount > 0) {
            return ItemList.Cell_Empty.get(tCapsuleCount, new Object[0]);
        }
        if (ItemList.IC2_ForgeHammer.isStackEqual(aStack) || ItemList.IC2_WireCutter.isStackEqual(aStack)) {
            return GT_Utility.copyMetaData(Items.field_151008_G.getDamage(aStack) + 1, aStack);
        }
        return null;
    }

    public static FluidStack getFluidFromContainerOrFluidDisplay(ItemStack stack) {
        FluidStack fluidStack = GT_Utility.getFluidForFilledItem(stack, true);
        if (fluidStack == null) {
            fluidStack = GT_Utility.getFluidFromDisplayStack(stack);
        }
        return fluidStack;
    }

    public static synchronized boolean removeIC2BottleRecipe(ItemStack aContainer, ItemStack aInput, Map<ICannerBottleRecipeManager.Input, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (GT_Utility.isStackInvalid(aInput) && GT_Utility.isStackInvalid(aOutput) && GT_Utility.isStackInvalid(aContainer) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = GT_OreDictUnificator.get(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<ICannerBottleRecipeManager.Input, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aContainer, aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (aOutput != null && !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static synchronized boolean removeSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, ItemStack aOutput) {
        if (GT_Utility.isStackInvalid(aInput) && GT_Utility.isStackInvalid(aOutput) || aRecipeList == null) {
            return false;
        }
        boolean rReturn = false;
        Iterator<Map.Entry<IRecipeInput, RecipeOutput>> tIterator = aRecipeList.entrySet().iterator();
        aOutput = GT_OreDictUnificator.get(aOutput);
        block0: while (tIterator.hasNext()) {
            List tList;
            Map.Entry<IRecipeInput, RecipeOutput> tEntry = tIterator.next();
            if (aInput != null && !tEntry.getKey().matches(aInput) || (tList = tEntry.getValue().items) == null) continue;
            for (ItemStack tOutput : tList) {
                if (aOutput != null && !GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput)) continue;
                tIterator.remove();
                rReturn = true;
                continue block0;
            }
        }
        return rReturn;
    }

    public static synchronized void bulkRemoveSimpleIC2MachineRecipe(Map<ItemStack, ItemStack> toRemove, Map<IRecipeInput, RecipeOutput> aRecipeList) {
        if (aRecipeList == null || aRecipeList.isEmpty()) {
            return;
        }
        toRemove.entrySet().removeIf(aEntry -> GT_Utility.isStackInvalid((ItemStack)aEntry.getKey()) && GT_Utility.isStackInvalid((ItemStack)aEntry.getValue()));
        Map finalToRemove = Maps.transformValues(toRemove, GT_OreDictUnificator::get_nocopy);
        aRecipeList.entrySet().removeIf(tEntry -> finalToRemove.entrySet().stream().anyMatch(aEntry -> {
            ItemStack aInput = (ItemStack)aEntry.getKey();
            ItemStack aOutput = (ItemStack)aEntry.getValue();
            List tList = ((RecipeOutput)tEntry.getValue()).items;
            if (tList == null) {
                return false;
            }
            if (aInput != null && !((IRecipeInput)tEntry.getKey()).matches(aInput)) {
                return false;
            }
            return tList.stream().anyMatch(tOutput -> aOutput == null || GT_Utility.areStacksEqual(GT_OreDictUnificator.get(tOutput), aOutput));
        }));
    }

    public static boolean addSimpleIC2MachineRecipe(ItemStack aInput, Map<IRecipeInput, RecipeOutput> aRecipeList, NBTTagCompound aNBT, Object ... aOutput) {
        if (GT_Utility.isStackInvalid(aInput) || aOutput.length == 0 || aRecipeList == null) {
            return false;
        }
        ItemData tOreName = GT_OreDictUnificator.getAssociation(aInput);
        for (Object o : aOutput) {
            if (o != null) continue;
            GT_Mod.GT_FML_LOGGER.info("EmptyIC2Output!" + aInput.func_77977_a());
            return false;
        }
        ItemStack[] tStack = GT_OreDictUnificator.getStackArray(true, aOutput);
        if (tStack.length > 0 && GT_Utility.areStacksEqual(aInput, tStack[0])) {
            return false;
        }
        if (tOreName != null) {
            if (tOreName.toString().equals("dustAsh") && tStack[0].func_77977_a().equals("tile.volcanicAsh")) {
                return false;
            }
            aRecipeList.put((IRecipeInput)new RecipeInputOreDict(tOreName.toString(), aInput.field_77994_a), new RecipeOutput(aNBT, tStack));
        } else {
            aRecipeList.put((IRecipeInput)new RecipeInputItemStack(GT_Utility.copyOrNull(aInput), aInput.field_77994_a), new RecipeOutput(aNBT, tStack));
        }
        return true;
    }

    public static ItemStack getWrittenBook(String aMapping, ItemStack aStackToPutNBT) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack == null) {
            return aStackToPutNBT;
        }
        if (aStackToPutNBT != null) {
            aStackToPutNBT.func_77982_d(rStack.func_77978_p());
            return aStackToPutNBT;
        }
        return GT_Utility.copyAmount(1, rStack);
    }

    public static ItemStack getWrittenBook(String aMapping, String aTitle, String aAuthor, String ... aPages) {
        if (GT_Utility.isStringInvalid(aMapping)) {
            return null;
        }
        ItemStack rStack = GregTech_API.sBookList.get(aMapping);
        if (rStack != null) {
            return GT_Utility.copyAmount(1, rStack);
        }
        if (GT_Utility.isStringInvalid(aTitle) || GT_Utility.isStringInvalid(aAuthor) || aPages.length == 0) {
            return null;
        }
        ++sBookCount;
        rStack = new ItemStack(Items.field_151164_bB, 1);
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74778_a("title", GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Name", aTitle));
        tNBT.func_74778_a("author", aAuthor);
        NBTTagList tNBTList = new NBTTagList();
        for (byte i = 0; i < aPages.length; i = (byte)(i + 1)) {
            aPages[i] = GT_LanguageManager.addStringLocalization("Book." + aTitle + ".Page" + (i < 10 ? "0" + i : Byte.valueOf(i)), aPages[i]);
            if (i < 48) {
                if (aPages[i].length() < 256) {
                    tNBTList.func_74742_a((NBTBase)new NBTTagString(aPages[i]));
                    continue;
                }
                GT_Log.err.println("WARNING: String for written Book too long! -> " + aPages[i]);
                continue;
            }
            GT_Log.err.println("WARNING: Too much Pages for written Book! -> " + aTitle);
            break;
        }
        tNBTList.func_74742_a((NBTBase)new NBTTagString("Credits to " + aAuthor + " for writing this Book. This was Book Nr. " + sBookCount + " at its creation. Gotta get 'em all!"));
        tNBT.func_74782_a("pages", (NBTBase)tNBTList);
        rStack.func_77982_d(tNBT);
        GT_Log.out.println("GT_Mod: Added Book to Book List  -  Mapping: '" + aMapping + "'  -  Name: '" + aTitle + "'  -  Author: '" + aAuthor + "'");
        GregTech_API.sBookList.put(aMapping, rStack);
        return GT_Utility.copyOrNull(rStack);
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength) {
        if (aSoundName == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, (Entity)GT_Values.GT.getThePlayer());
    }

    public static boolean doSoundAtClient(SoundResource sound, int aTimeUntilNextSound, float aSoundStrength) {
        return GT_Utility.doSoundAtClient(sound.resourceLocation, aTimeUntilNextSound, aSoundStrength, (Entity)GT_Values.GT.getThePlayer());
    }

    public static boolean doSoundAtClient(ResourceLocation aSoundResourceLocation, int aTimeUntilNextSound, float aSoundStrength) {
        return GT_Utility.doSoundAtClient(aSoundResourceLocation, aTimeUntilNextSound, aSoundStrength, (Entity)GT_Values.GT.getThePlayer());
    }

    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, Entity aEntity) {
        if (aEntity == null || aSoundName == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(aSoundName, aTimeUntilNextSound, aSoundStrength, aEntity.field_70165_t, aEntity.field_70163_u, aEntity.field_70161_v);
    }

    public static boolean doSoundAtClient(ResourceLocation aSoundResourceLocation, int aTimeUntilNextSound, float aSoundStrength, Entity aEntity) {
        if (aEntity == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(aSoundResourceLocation.toString(), aTimeUntilNextSound, aSoundStrength, aEntity.field_70165_t, aEntity.field_70163_u, aEntity.field_70161_v);
    }

    public static boolean doSoundAtClient(ResourceLocation aSoundResourceLocation, int aTimeUntilNextSound, float aSoundStrength, double aX, double aY, double aZ) {
        return GT_Utility.doSoundAtClient(aSoundResourceLocation, aTimeUntilNextSound, aSoundStrength, 1.0181803f, aX, aY, aZ);
    }

    @Deprecated
    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, double aX, double aY, double aZ) {
        if (aSoundName == null) {
            return false;
        }
        return GT_Utility.doSoundAtClient(new ResourceLocation(aSoundName), aTimeUntilNextSound, aSoundStrength, 1.0181803f, aX, aY, aZ);
    }

    public static boolean doSoundAtClient(SoundResource aSound, int aTimeUntilNextSound, float aSoundStrength, double aX, double aY, double aZ) {
        return GT_Utility.doSoundAtClient(aSound.resourceLocation, aTimeUntilNextSound, aSoundStrength, aX, aY, aZ);
    }

    public static boolean doSoundAtClient(SoundResource aSound, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, double aX, double aY, double aZ) {
        return GT_Utility.doSoundAtClient(aSound.resourceLocation, aTimeUntilNextSound, aSoundStrength, aSoundModulation, aX, aY, aZ);
    }

    public static boolean doSoundAtClient(ResourceLocation aSoundResourceLocation, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, double aX, double aY, double aZ) {
        if (!FMLCommonHandler.instance().getEffectiveSide().isClient() || GT_Values.GT.getThePlayer() == null || !GT_Values.GT.getThePlayer().field_70170_p.field_72995_K) {
            return false;
        }
        if (GregTech_API.sMultiThreadedSounds) {
            new Thread((Runnable)new GT_Runnable_Sound(GT_Values.GT.getThePlayer().field_70170_p, aX, aY, aZ, aTimeUntilNextSound, aSoundResourceLocation, aSoundStrength, aSoundModulation), "Sound Effect").start();
        } else {
            new GT_Runnable_Sound(GT_Values.GT.getThePlayer().field_70170_p, aX, aY, aZ, aTimeUntilNextSound, aSoundResourceLocation, aSoundStrength, aSoundModulation).run();
        }
        return true;
    }

    @Deprecated
    public static boolean doSoundAtClient(String aSoundName, int aTimeUntilNextSound, float aSoundStrength, float aSoundModulation, double aX, double aY, double aZ) {
        if (GT_Utility.isStringInvalid(aSoundName)) {
            return false;
        }
        return GT_Utility.doSoundAtClient(new ResourceLocation(aSoundName), aTimeUntilNextSound, aSoundStrength, aSoundModulation, aX, aY, aZ);
    }

    public static boolean sendSoundToPlayers(World aWorld, String aSoundName, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
        if (GT_Utility.isStringInvalid(aSoundName) || aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        GT_Values.NW.sendPacketToAllPlayersInRange(aWorld, new GT_Packet_Sound(aSoundName, aSoundStrength, aSoundModulation, aX, (short)aY, aZ), aX, aZ);
        return true;
    }

    public static boolean sendSoundToPlayers(World aWorld, SoundResource sound, float aSoundStrength, float aSoundModulation, int aX, int aY, int aZ) {
        if (aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        GT_Values.NW.sendPacketToAllPlayersInRange(aWorld, new GT_Packet_Sound(sound.resourceLocation.toString(), aSoundStrength, aSoundModulation, aX, (short)aY, aZ), aX, aZ);
        return true;
    }

    public static int stackToInt(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return GT_Utility.itemToInt(aStack.func_77973_b(), Items.field_151008_G.getDamage(aStack));
    }

    public static int itemToInt(Item aItem, int aMeta) {
        return Item.func_150891_b((Item)aItem) | aMeta << 16;
    }

    public static int stackToWildcard(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return 0;
        }
        return Item.func_150891_b((Item)aStack.func_77973_b()) | 0x7FFF0000;
    }

    public static ItemStack intToStack(int aStack) {
        int tID = aStack & 0xFFFF;
        int tMeta = aStack >>> 16;
        Item tItem = Item.func_150899_d((int)tID);
        if (tItem != null) {
            return new ItemStack(tItem, 1, tMeta);
        }
        return null;
    }

    public static Integer[] stacksToIntegerArray(ItemStack ... aStacks) {
        Integer[] rArray = new Integer[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static int[] stacksToIntArray(ItemStack ... aStacks) {
        int[] rArray = new int[aStacks.length];
        for (int i = 0; i < rArray.length; ++i) {
            rArray[i] = GT_Utility.stackToInt(aStacks[i]);
        }
        return rArray;
    }

    public static boolean arrayContains(Object aObject, Object ... aObjects) {
        return GT_Utility.listContains(aObject, Arrays.asList(aObjects));
    }

    public static boolean listContains(Object aObject, Collection<?> aObjects) {
        if (aObjects == null) {
            return false;
        }
        return aObjects.contains(aObject);
    }

    @SafeVarargs
    public static <T> boolean arrayContainsNonNull(T ... aArray) {
        if (aArray != null) {
            for (T tObject : aArray) {
                if (tObject == null) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> ArrayList<T> getArrayListWithoutNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        for (int i = 0; i < rList.size(); ++i) {
            if (rList.get(i) != null) continue;
            rList.remove(i--);
        }
        return rList;
    }

    @SafeVarargs
    public static <T> ArrayList<T> getArrayListWithoutTrailingNulls(T ... aArray) {
        if (aArray == null) {
            return new ArrayList();
        }
        ArrayList<T> rList = new ArrayList<T>(Arrays.asList(aArray));
        int i = rList.size() - 1;
        while (i >= 0 && rList.get(i) == null) {
            rList.remove(i--);
        }
        return rList;
    }

    @Deprecated
    public static Block getBlock(Object aBlock) {
        return (Block)aBlock;
    }

    public static Block getBlockFromStack(ItemStack itemStack) {
        if (GT_Utility.isStackInvalid(itemStack)) {
            return Blocks.field_150350_a;
        }
        return GT_Utility.getBlockFromItem(itemStack.func_77973_b());
    }

    public static Block getBlockFromItem(Item item) {
        return Block.func_149634_a((Item)item);
    }

    @Deprecated
    public static boolean isBlockValid(Object aBlock) {
        return aBlock instanceof Block;
    }

    @Deprecated
    public static boolean isBlockInvalid(Object aBlock) {
        return !(aBlock instanceof Block);
    }

    public static boolean isStringValid(Object aString) {
        return aString != null && !aString.toString().isEmpty();
    }

    public static boolean isStringInvalid(Object aString) {
        return aString == null || aString.toString().isEmpty();
    }

    @Deprecated
    public static boolean isStackValid(Object aStack) {
        ItemStack stack;
        return aStack instanceof ItemStack && GT_Utility.isStackValid(stack = (ItemStack)aStack);
    }

    public static boolean isStackValid(ItemStack aStack) {
        return aStack != null && aStack.func_77973_b() != null && aStack.field_77994_a >= 0;
    }

    @Deprecated
    public static boolean isStackInvalid(Object aStack) {
        ItemStack stack;
        return !(aStack instanceof ItemStack) || GT_Utility.isStackInvalid(stack = (ItemStack)aStack);
    }

    public static boolean isStackInvalid(ItemStack aStack) {
        return aStack == null || aStack.func_77973_b() == null || aStack.field_77994_a < 0;
    }

    public static boolean isDebugItem(ItemStack aStack) {
        return GT_Utility.areStacksEqual(GT_ModHandler.getIC2Item("debug", 1L), aStack, true);
    }

    public static ItemStack updateItemStack(ItemStack aStack) {
        if (GT_Utility.isStackValid(aStack) && aStack.func_77973_b() instanceof GT_Generic_Item) {
            ((GT_Generic_Item)aStack.func_77973_b()).isItemStackUsable(aStack);
        }
        return aStack;
    }

    public static boolean isOpaqueBlock(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).func_149662_c();
    }

    public static boolean isBlockAir(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).isAir((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public static boolean hasBlockHitBox(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).func_149668_a(aWorld, aX, aY, aZ) != null;
    }

    public static void setCoordsOnFire(World aWorld, int aX, int aY, int aZ, boolean aReplaceCenter) {
        if (aReplaceCenter && aWorld.func_147439_a(aX, aY, aZ).func_149668_a(aWorld, aX, aY, aZ) == null) {
            aWorld.func_147449_b(aX, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX + 1, aY, aZ).func_149668_a(aWorld, aX + 1, aY, aZ) == null) {
            aWorld.func_147449_b(aX + 1, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX - 1, aY, aZ).func_149668_a(aWorld, aX - 1, aY, aZ) == null) {
            aWorld.func_147449_b(aX - 1, aY, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY + 1, aZ).func_149668_a(aWorld, aX, aY + 1, aZ) == null) {
            aWorld.func_147449_b(aX, aY + 1, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY - 1, aZ).func_149668_a(aWorld, aX, aY - 1, aZ) == null) {
            aWorld.func_147449_b(aX, aY - 1, aZ, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY, aZ + 1).func_149668_a(aWorld, aX, aY, aZ + 1) == null) {
            aWorld.func_147449_b(aX, aY, aZ + 1, (Block)Blocks.field_150480_ab);
        }
        if (aWorld.func_147439_a(aX, aY, aZ - 1).func_149668_a(aWorld, aX, aY, aZ - 1) == null) {
            aWorld.func_147449_b(aX, aY, aZ - 1, (Block)Blocks.field_150480_ab);
        }
    }

    public static ItemStack getProjectile(SubTag aProjectileType, IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.func_70302_i_();
            for (int i = 0; i < j; ++i) {
                ItemStack rStack = aInventory.func_70301_a(i);
                if (!GT_Utility.isStackValid(rStack) || !(rStack.func_77973_b() instanceof IProjectileItem) || !((IProjectileItem)rStack.func_77973_b()).hasProjectile(aProjectileType, rStack)) continue;
                return GT_Utility.updateItemStack(rStack);
            }
        }
        return null;
    }

    public static void removeNullStacksFromInventory(IInventory aInventory) {
        if (aInventory != null) {
            int j = aInventory.func_70302_i_();
            for (int i = 0; i < j; ++i) {
                ItemStack tStack = aInventory.func_70301_a(i);
                if (tStack == null || tStack.field_77994_a != 0 && tStack.func_77973_b() != null) continue;
                aInventory.func_70299_a(i, null);
            }
        }
    }

    public static boolean addTexturePage(byte page) {
        if (Textures.BlockIcons.casingTexturePages[page] == null) {
            Textures.BlockIcons.casingTexturePages[page] = new ITexture[128];
            return true;
        }
        return false;
    }

    public static int getTextureId(byte page, byte index) {
        if (page >= 0 && index >= 0) {
            return (page << 7) + index;
        }
        throw new RuntimeException("Index out of range: [" + page + "][" + index + "]");
    }

    public static int getTextureId(byte page, byte startIndex, byte blockMeta) {
        if (page >= 0 && startIndex >= 0 && blockMeta >= 0 && startIndex + blockMeta <= 127) {
            return (page << 7) + (startIndex + blockMeta);
        }
        throw new RuntimeException("Index out of range: [" + page + "][" + startIndex + "+" + blockMeta + "=" + (startIndex + blockMeta) + "]");
    }

    @Deprecated
    public static int getTextureId(ItemStack stack) {
        return GT_Utility.getTextureId(Block.func_149634_a((Item)stack.func_77973_b()), (byte)stack.func_77960_j());
    }

    public static int getTextureId(Block blockFromBlock, byte metaFromBlock) {
        for (int page = 0; page < Textures.BlockIcons.casingTexturePages.length; ++page) {
            ITexture[] casingTexturePage = Textures.BlockIcons.casingTexturePages[page];
            if (casingTexturePage == null) continue;
            for (int index = 0; index < casingTexturePage.length; ++index) {
                ITexture iTexture = casingTexturePage[index];
                if (!(iTexture instanceof IBlockContainer)) continue;
                Block block = ((IBlockContainer)((Object)iTexture)).getBlock();
                byte meta = ((IBlockContainer)((Object)iTexture)).getMeta();
                if (meta != metaFromBlock || blockFromBlock != block) continue;
                return (page << 7) + index;
            }
        }
        throw new RuntimeException("Probably missing mapping or different texture class used for: " + blockFromBlock.func_149739_a() + " meta:" + metaFromBlock);
    }

    public static String parseNumberToString(int aNumber) {
        boolean temp = true;
        boolean negative = false;
        if (aNumber < 0) {
            aNumber *= -1;
            negative = true;
        }
        StringBuilder tStringB = new StringBuilder();
        for (int i = 1000000000; i > 0; i /= 10) {
            int tDigit = aNumber / i % 10;
            if (temp && tDigit != 0) {
                temp = false;
            }
            if (temp) continue;
            tStringB.append(tDigit);
            if (i == 1) continue;
            for (int j = i; j > 0; j /= 1000) {
                if (j != 1) continue;
                tStringB.append(",");
            }
        }
        String tString = tStringB.toString();
        if (tString.equals("")) {
            tString = "0";
        }
        return negative ? "-" + tString : tString;
    }

    public static NBTTagCompound getNBTContainingBoolean(NBTTagCompound aNBT, Object aTag, boolean aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74757_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingByte(NBTTagCompound aNBT, Object aTag, byte aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74774_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingShort(NBTTagCompound aNBT, Object aTag, short aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74777_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingInteger(NBTTagCompound aNBT, Object aTag, int aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74768_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingFloat(NBTTagCompound aNBT, Object aTag, float aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74776_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingDouble(NBTTagCompound aNBT, Object aTag, double aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        aNBT.func_74780_a(aTag.toString(), aValue);
        return aNBT;
    }

    public static NBTTagCompound getNBTContainingString(NBTTagCompound aNBT, Object aTag, Object aValue) {
        if (aNBT == null) {
            aNBT = new NBTTagCompound();
        }
        if (aValue == null) {
            return aNBT;
        }
        aNBT.func_74778_a(aTag.toString(), aValue.toString());
        return aNBT;
    }

    public static boolean isWearingFullFrostHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sFrostHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullHeatHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sHeatHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullBioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sBioHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullRadioHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sRadioHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullElectroHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sElectroHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWearingFullGasHazmat(EntityLivingBase aEntity) {
        for (int i = 1; i < 5; i = (int)((byte)(i + 1))) {
            ItemStack tStack = aEntity.func_71124_b(i);
            if (GT_Utility.isStackInList(tStack, GregTech_API.sGasHazmatList) || GT_Utility.hasHazmatEnchant(tStack)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasHazmatEnchant(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        Map tEnchantments = EnchantmentHelper.func_82781_a((ItemStack)aStack);
        Integer tLevel = (Integer)tEnchantments.get(Enchantment_Hazmat.INSTANCE.field_77352_x);
        return tLevel != null && tLevel >= 1;
    }

    public static float getHeatDamageFromItem(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        return tData == null ? 0.0f : (tData.mPrefix == null ? 0.0f : tData.mPrefix.mHeatDamage) + (tData.hasValidMaterialData() ? tData.mMaterial.mMaterial.mHeatDamage : 0.0f);
    }

    public static int getRadioactivityLevel(ItemStack aStack) {
        ItemData tData = GT_OreDictUnificator.getItemData(aStack);
        if (tData != null && tData.hasValidMaterialData()) {
            if (tData.mMaterial.mMaterial.mEnchantmentArmors instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentArmorsLevel;
            }
            if (tData.mMaterial.mMaterial.mEnchantmentTools instanceof Enchantment_Radioactivity) {
                return tData.mMaterial.mMaterial.mEnchantmentToolsLevel;
            }
        }
        return EnchantmentHelper.func_77506_a((int)Enchantment_Radioactivity.INSTANCE.field_77352_x, (ItemStack)aStack);
    }

    public static boolean isImmuneToBreathingGasses(EntityLivingBase aEntity) {
        return GT_Utility.isWearingFullGasHazmat(aEntity);
    }

    public static boolean applyHeatDamage(EntityLivingBase entity, float damage) {
        return GT_Utility.applyHeatDamage(entity, damage, GT_DamageSources.getHeatDamage());
    }

    public static boolean applyHeatDamageFromItem(EntityLivingBase entity, float damage, ItemStack item) {
        return GT_Utility.applyHeatDamage(entity, damage, new GT_DamageSources.DamageSourceHotItem(item));
    }

    private static boolean applyHeatDamage(EntityLivingBase aEntity, float aDamage, DamageSource source) {
        if (aDamage > 0.0f && aEntity != null && !GT_Utility.isWearingFullHeatHazmat(aEntity)) {
            return aEntity.func_70097_a(source, aDamage);
        }
        return false;
    }

    public static boolean applyFrostDamage(EntityLivingBase aEntity, float aDamage) {
        if (aDamage > 0.0f && aEntity != null && !GT_Utility.isWearingFullFrostHazmat(aEntity)) {
            return aEntity.func_70097_a(GT_DamageSources.getFrostDamage(), aDamage);
        }
        return false;
    }

    public static boolean applyElectricityDamage(EntityLivingBase aEntity, long aVoltage, long aAmperage) {
        long aDamage = (long)GT_Utility.getTier(aVoltage) * aAmperage * 4L;
        if (aDamage > 0L && aEntity != null && !GT_Utility.isWearingFullElectroHazmat(aEntity)) {
            return aEntity.func_70097_a(GT_DamageSources.getElectricDamage(), (float)aDamage);
        }
        return false;
    }

    public static boolean applyRadioactivity(EntityLivingBase aEntity, int aLevel, int aAmountOfItems) {
        if (aLevel > 0 && aEntity != null && aEntity.func_70668_bt() != EnumCreatureAttribute.UNDEAD && aEntity.func_70668_bt() != EnumCreatureAttribute.ARTHROPOD && !GT_Utility.isWearingFullRadioHazmat(aEntity)) {
            PotionEffect tEffect = null;
            tEffect = aEntity.func_70660_b(Potion.field_76421_d);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, aLevel * 140 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76419_f);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76431_k);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76437_t);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, aLevel * 150 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76438_s);
            aEntity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, aLevel * 130 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            tEffect = aEntity.func_70660_b(Potion.field_76425_a[24]);
            aEntity.func_70690_d(new PotionEffect(24, aLevel * 180 * aAmountOfItems + Math.max(0, tEffect == null ? 0 : tEffect.func_76459_b()), Math.max(0, 5 * aLevel / 7)));
            return true;
        }
        return false;
    }

    @Deprecated
    public static ItemStack setStack(Object aSetStack, Object aToStack) {
        if (aSetStack instanceof ItemStack) {
            ItemStack setStack = (ItemStack)aSetStack;
            if (aToStack instanceof ItemStack) {
                ItemStack toStack = (ItemStack)aToStack;
                return GT_Utility.setStack(setStack, toStack);
            }
        }
        return null;
    }

    public static ItemStack setStack(ItemStack aSetStack, ItemStack aToStack) {
        if (GT_Utility.isStackInvalid(aSetStack) || GT_Utility.isStackInvalid(aToStack)) {
            return null;
        }
        aSetStack.func_150996_a(aToStack.func_77973_b());
        aSetStack.field_77994_a = aToStack.field_77994_a;
        Items.field_151008_G.setDamage(aSetStack, Items.field_151008_G.getDamage(aToStack));
        aSetStack.func_77982_d(aToStack.func_77978_p());
        return aSetStack;
    }

    public static FluidStack[] copyFluidArray(FluidStack ... aStacks) {
        if (aStacks == null) {
            return null;
        }
        FluidStack[] rStacks = new FluidStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            if (aStacks[i] == null) continue;
            rStacks[i] = aStacks[i].copy();
        }
        return rStacks;
    }

    public static ItemStack[] copyItemArray(ItemStack ... aStacks) {
        if (aStacks == null) {
            return null;
        }
        ItemStack[] rStacks = new ItemStack[aStacks.length];
        for (int i = 0; i < aStacks.length; ++i) {
            rStacks[i] = GT_Utility.copy(aStacks[i]);
        }
        return rStacks;
    }

    @Deprecated
    public static ItemStack copy(Object ... aStacks) {
        for (Object tStack : aStacks) {
            if (!GT_Utility.isStackValid(tStack)) continue;
            return ((ItemStack)tStack).func_77946_l();
        }
        return null;
    }

    public static ItemStack copy(ItemStack aStack) {
        if (GT_Utility.isStackValid(aStack)) {
            return aStack.func_77946_l();
        }
        return null;
    }

    @Deprecated
    private static ItemStack firstStackOrNull(Object ... aStacks) {
        for (Object tStack : aStacks) {
            if (!(tStack instanceof ItemStack)) continue;
            ItemStack stack = (ItemStack)tStack;
            return stack;
        }
        return null;
    }

    @Nullable
    public static ItemStack copyOrNull(@Nullable ItemStack stack) {
        if (GT_Utility.isStackValid(stack)) {
            return stack.func_77946_l();
        }
        return null;
    }

    public static FluidStack copyAmount(int aAmount, FluidStack aStack) {
        if (aStack == null) {
            return null;
        }
        FluidStack rStack = aStack.copy();
        rStack.amount = aAmount;
        return rStack;
    }

    @Deprecated
    public static ItemStack copyAmount(long aAmount, Object ... aStacks) {
        return GT_Utility.copyAmount(aAmount, GT_Utility.firstStackOrNull(aStacks));
    }

    @Deprecated
    public static ItemStack copyAmount(long aAmount, ItemStack aStack) {
        return GT_Utility.copyAmount((int)aAmount, aStack);
    }

    public static ItemStack copyAmount(int aAmount, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copy(aStack);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        if (aAmount > 64) {
            aAmount = 64;
        } else if (aAmount == -1) {
            aAmount = 111;
        } else if (aAmount < 0) {
            aAmount = 0;
        }
        rStack.field_77994_a = (byte)aAmount;
        return rStack;
    }

    @Deprecated
    public static ItemStack multiplyStack(long aMultiplier, Object ... aStacks) {
        return GT_Utility.multiplyStack((int)aMultiplier, GT_Utility.firstStackOrNull(aStacks));
    }

    public static ItemStack multiplyStack(int aMultiplier, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copy(aStack);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        int tAmount = rStack.field_77994_a * aMultiplier;
        if (tAmount > 64) {
            tAmount = 64;
        } else if (tAmount == -1) {
            tAmount = 111;
        } else if (tAmount < 0) {
            tAmount = 0;
        }
        rStack.field_77994_a = (byte)tAmount;
        return rStack;
    }

    @Deprecated
    public static ItemStack copyAmountUnsafe(long aAmount, Object ... aStacks) {
        return GT_Utility.copyAmountUnsafe((int)aAmount, GT_Utility.firstStackOrNull(aStacks));
    }

    public static ItemStack copyAmountUnsafe(int aAmount, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copy(aStack);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        if (aAmount < 0) {
            aAmount = 0;
        }
        rStack.field_77994_a = aAmount;
        return rStack;
    }

    @Deprecated
    public static ItemStack copyMetaData(long aMetaData, Object ... aStacks) {
        return GT_Utility.copyMetaData((int)aMetaData, GT_Utility.firstStackOrNull(aStacks));
    }

    public static ItemStack copyMetaData(int aMetaData, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copy(aStack);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMetaData);
        return rStack;
    }

    @Deprecated
    public static ItemStack copyAmountAndMetaData(long aAmount, long aMetaData, Object ... aStacks) {
        return GT_Utility.copyAmountAndMetaData(aAmount, aMetaData, GT_Utility.firstStackOrNull(aStacks));
    }

    @Deprecated
    public static ItemStack copyAmountAndMetaData(long aAmount, long aMetaData, ItemStack aStack) {
        return GT_Utility.copyAmountAndMetaData((int)aAmount, (int)aMetaData, aStack);
    }

    public static ItemStack copyAmountAndMetaData(int aAmount, int aMetaData, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copyAmount(aAmount, aStack);
        if (GT_Utility.isStackInvalid(rStack)) {
            return null;
        }
        Items.field_151008_G.setDamage(rStack, aMetaData);
        return rStack;
    }

    @Deprecated
    public static ItemStack mul(long aMultiplier, Object ... aStacks) {
        return GT_Utility.mul((int)aMultiplier, GT_Utility.firstStackOrNull(aStacks));
    }

    public static ItemStack mul(int aMultiplier, ItemStack aStack) {
        ItemStack rStack = GT_Utility.copy(aStack);
        if (rStack == null) {
            return null;
        }
        rStack.field_77994_a *= aMultiplier;
        return rStack;
    }

    public static ItemStack loadItem(NBTTagCompound aNBT, String aTagName) {
        return GT_Utility.loadItem(aNBT.func_74775_l(aTagName));
    }

    public static FluidStack loadFluid(NBTTagCompound aNBT, String aTagName) {
        return GT_Utility.loadFluid(aNBT.func_74775_l(aTagName));
    }

    public static ItemStack loadItem(NBTTagCompound aNBT) {
        if (aNBT == null) {
            return null;
        }
        ItemStack tRawStack = ItemStack.func_77949_a((NBTTagCompound)aNBT);
        int tRealStackSize = 0;
        if (tRawStack != null && aNBT.func_150297_b("Count", 3)) {
            tRawStack.field_77994_a = tRealStackSize = aNBT.func_74762_e("Count");
        } else if (tRawStack != null) {
            tRealStackSize = tRawStack.field_77994_a;
        }
        ItemStack tRet = GT_OreDictUnificator.get(true, tRawStack);
        if (tRet != null) {
            tRet.field_77994_a = tRealStackSize;
        }
        return tRet;
    }

    public static void saveItem(NBTTagCompound aParentTag, String aTagName, ItemStack aStack) {
        if (aStack != null) {
            aParentTag.func_74782_a(aTagName, (NBTBase)GT_Utility.saveItem(aStack));
        }
    }

    public static NBTTagCompound saveItem(ItemStack aStack) {
        if (aStack == null) {
            return new NBTTagCompound();
        }
        NBTTagCompound t = new NBTTagCompound();
        aStack.func_77955_b(t);
        if (aStack.field_77994_a > 127) {
            t.func_74768_a("Count", aStack.field_77994_a);
        }
        return t;
    }

    public static FluidStack loadFluid(NBTTagCompound aNBT) {
        if (aNBT == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT);
    }

    public static <E> E selectItemInList(int aIndex, E aReplacement, List<E> aList) {
        if (aList == null || aList.isEmpty()) {
            return aReplacement;
        }
        if (aList.size() <= aIndex) {
            return aList.get(aList.size() - 1);
        }
        if (aIndex < 0) {
            return aList.get(0);
        }
        return aList.get(aIndex);
    }

    @SafeVarargs
    public static <E> E selectItemInList(int aIndex, E aReplacement, E ... aList) {
        if (aList == null || aList.length == 0) {
            return aReplacement;
        }
        if (aList.length <= aIndex) {
            return aList[aList.length - 1];
        }
        if (aIndex < 0) {
            return aList[0];
        }
        return aList[aIndex];
    }

    public static boolean isStackInList(ItemStack aStack, Collection<GT_ItemStack> aList) {
        if (aStack == null) {
            return false;
        }
        return GT_Utility.isStackInList(new GT_ItemStack(aStack), aList);
    }

    public static boolean isStackInList(ItemStack aStack, Set<GT_ItemStack2> aList) {
        if (aStack == null) {
            return false;
        }
        return GT_Utility.isStackInList(new GT_ItemStack2(aStack), aList);
    }

    public static boolean isStackInList(GT_ItemStack aStack, Collection<GT_ItemStack> aList) {
        return aStack != null && (aList.contains(aStack) || aList.contains(new GT_ItemStack(aStack.mItem, aStack.mStackSize, 32767L)));
    }

    public static boolean isStackInList(GT_ItemStack2 aStack, Set<GT_ItemStack2> aList) {
        return aStack != null && (aList.contains(aStack) || aList.contains(new GT_ItemStack2(aStack.mItem, aStack.mStackSize, 32767L)));
    }

    public static <X, Y> Map<X, Y> reMap(Map<X, Y> aMap) {
        HashMap<X, Y> tMap = new HashMap<X, Y>(aMap);
        aMap.clear();
        aMap.putAll(tMap);
        return aMap;
    }

    public static <X, Y> SetMultimap<X, Y> reMap(SetMultimap<X, Y> aMap) {
        Map.Entry[] entries = aMap.entries().toArray(new Map.Entry[0]);
        aMap.clear();
        for (Map.Entry entry : entries) {
            aMap.put(entry.getKey(), entry.getValue());
        }
        return aMap;
    }

    public static <X, Y extends Comparable<Y>> LinkedHashMap<X, Y> sortMapByValuesAcending(Map<X, Y> map) {
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(CollectorUtils.entriesToMap(LinkedHashMap::new));
    }

    public static <X, Y extends Comparable<Y>> LinkedHashMap<X, Y> sortMapByValuesDescending(Map<X, Y> aMap) {
        LinkedList<Map.Entry<X, Y>> tEntrySet = new LinkedList<Map.Entry<X, Y>>(aMap.entrySet());
        tEntrySet.sort((aValue1, aValue2) -> ((Comparable)aValue2.getValue()).compareTo((Comparable)aValue1.getValue()));
        LinkedHashMap rMap = new LinkedHashMap();
        for (Map.Entry entry : tEntrySet) {
            rMap.put(entry.getKey(), (Comparable)entry.getValue());
        }
        return rMap;
    }

    public static long translateMaterialToFluidAmount(long aMaterialAmount, boolean aRoundUp) {
        return GT_Utility.translateMaterialToAmount(aMaterialAmount, 144L, aRoundUp);
    }

    public static long translateMaterialToAmount(long aMaterialAmount, long aAmountPerUnit, boolean aRoundUp) {
        return Math.max(0L, aMaterialAmount * aAmountPerUnit / 3628800L + (long)(aRoundUp && aMaterialAmount * aAmountPerUnit % 3628800L > 0L ? 1 : 0));
    }

    public static boolean isRealDimension(int aDimensionID) {
        if (aDimensionID <= 1 && aDimensionID >= -1 && !GregTech_API.sDimensionalList.contains(aDimensionID)) {
            return true;
        }
        return !GregTech_API.sDimensionalList.contains(aDimensionID) && DimensionManager.isDimensionRegistered((int)aDimensionID);
    }

    public static boolean moveEntityToDimensionAtCoords(Entity entity, int aDimension, double aX, double aY, double aZ) {
        EntityPlayerMP player;
        boolean interDimensional;
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return false;
        }
        if (entity.field_70154_o != null) {
            entity.func_70078_a(null);
        }
        if (entity.field_70153_n != null) {
            entity.field_70153_n.func_70078_a(null);
        }
        World startWorld = entity.field_70170_p;
        WorldServer destinationWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(aDimension);
        if (destinationWorld == null) {
            return false;
        }
        boolean bl = interDimensional = startWorld.field_73011_w.field_76574_g != destinationWorld.field_73011_w.field_76574_g;
        if (!interDimensional) {
            return false;
        }
        startWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.func_71053_j();
            player.field_71093_bK = aDimension;
            player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, destinationWorld.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
            ((WorldServer)startWorld).func_73040_p().func_72695_c(player);
            startWorld.field_73010_i.remove(player);
            startWorld.func_72854_c();
            int i = entity.field_70176_ah;
            int j = entity.field_70164_aj;
            if (entity.field_70175_ag && startWorld.func_72863_F().func_73149_a(i, j)) {
                startWorld.func_72964_e(i, j).func_76622_b(entity);
                startWorld.func_72964_e((int)i, (int)j).field_76643_l = true;
            }
            startWorld.field_72996_f.remove(entity);
            startWorld.func_72847_b(entity);
        }
        entity.func_70012_b(aX, aY, aZ, entity.field_70177_z, entity.field_70125_A);
        destinationWorld.field_73059_b.func_73158_c((int)aX >> 4, (int)aZ >> 4);
        destinationWorld.field_72984_F.func_76320_a("placing");
        if (!(entity instanceof EntityPlayer)) {
            NBTTagCompound entityNBT = new NBTTagCompound();
            entity.field_70128_L = false;
            entityNBT.func_74778_a("id", EntityList.func_75621_b((Entity)entity));
            entity.func_70109_d(entityNBT);
            entity.field_70128_L = true;
            entity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)destinationWorld);
            if (entity == null) {
                return false;
            }
            entity.field_71093_bK = destinationWorld.field_73011_w.field_76574_g;
        }
        destinationWorld.func_72838_d(entity);
        entity.func_70029_a((World)destinationWorld);
        entity.func_70012_b(aX, aY, aZ, entity.field_70177_z, entity.field_70125_A);
        destinationWorld.func_72866_a(entity, false);
        entity.func_70012_b(aX, aY, aZ, entity.field_70177_z, entity.field_70125_A);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.field_71133_b.func_71203_ab().func_72375_a(player, destinationWorld);
            player.field_71135_a.func_147364_a(aX, aY, aZ, player.field_70177_z, player.field_70125_A);
        }
        destinationWorld.func_72866_a(entity, false);
        if (entity instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entity;
            player.field_71134_c.func_73080_a(destinationWorld);
            player.field_71133_b.func_71203_ab().func_72354_b(player, destinationWorld);
            player.field_71133_b.func_71203_ab().func_72385_f(player);
            for (PotionEffect potionEffect : player.func_70651_bq()) {
                player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potionEffect));
            }
            player.field_71135_a.func_147359_a((Packet)new S1FPacketSetExperience(player.field_71106_cc, player.field_71067_cb, player.field_71068_ca));
            FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, startWorld.field_73011_w.field_76574_g, destinationWorld.field_73011_w.field_76574_g);
        }
        entity.func_70012_b(aX, aY, aZ, entity.field_70177_z, entity.field_70125_A);
        destinationWorld.field_72984_F.func_76319_b();
        entity.field_70143_R = 0.0f;
        return true;
    }

    public static int getScaleCoordinates(double aValue, int aScale) {
        return (int)Math.floor(aValue / (double)aScale);
    }

    public static int getCoordinateScan(ArrayList<String> aList, EntityPlayer aPlayer, World aWorld, int aScanLevel, int aX, int aY, int aZ, ForgeDirection side, float aClickX, float aClickY, float aClickZ) {
        if (aList == null) {
            return 0;
        }
        ArrayList<String> tList = new ArrayList<String>();
        int rEUAmount = 0;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        Block tBlock = aWorld.func_147439_a(aX, aY, aZ);
        GT_Utility.addBaseInfo(aPlayer, aWorld, aX, aY, aZ, tList, tTileEntity, tBlock);
        if (tTileEntity != null) {
            block6: {
                rEUAmount += GT_Utility.addFluidHandlerInfo(side, tList, tTileEntity);
                try {
                    if (tTileEntity instanceof IReactorChamber) {
                        IReactorChamber chamber = (IReactorChamber)tTileEntity;
                        rEUAmount += 500;
                        tTileEntity = (TileEntity)chamber.getReactor();
                    }
                }
                catch (Throwable e) {
                    if (!GT_Values.D1) break block6;
                    e.printStackTrace(GT_Log.err);
                }
            }
            rEUAmount += GT_Utility.addReactorInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addAlignmentInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addIC2WrenchableInfo(aPlayer, tList, tTileEntity);
            rEUAmount += GT_Utility.addIC2EnergyConductorInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addIC2EnergyStorageInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addUpgradableMachineInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addMachineProgressInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addCoverableInfo(side, tList, tTileEntity);
            GT_Utility.addEnergyContainerInfo(tList, tTileEntity);
            GT_Utility.addOwnerInfo(tList, tTileEntity);
            GT_Utility.addDeviceInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addIC2CropInfo(tList, tTileEntity);
            rEUAmount += GT_Utility.addForestryLeavesInfo(tList, tTileEntity);
        }
        Chunk currentChunk = aWorld.func_72938_d(aX, aZ);
        GT_Utility.addUndergroundFluidInfo(aPlayer, tList, currentChunk);
        GT_Utility.addPollutionInfo(tList, currentChunk);
        BlockScanningEvent tEvent = new BlockScanningEvent(aWorld, aPlayer, aX, aY, aZ, side, aScanLevel, tBlock, tTileEntity, tList, aClickX, aClickY, aClickZ);
        tEvent.mEUCost = rEUAmount += GT_Utility.addDebuggableBlockInfo(aPlayer, aX, aY, aZ, tList, tBlock);
        MinecraftForge.EVENT_BUS.post((Event)tEvent);
        if (!tEvent.isCanceled()) {
            aList.addAll(tList);
        }
        return tEvent.mEUCost;
    }

    private static void addBaseInfo(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, ArrayList<String> tList, TileEntity tTileEntity, Block tBlock) {
        block5: {
            tList.add("----- X: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aX) + EnumChatFormatting.RESET + " Y: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aY) + EnumChatFormatting.RESET + " Z: " + EnumChatFormatting.AQUA + GT_Utility.formatNumbers(aZ) + EnumChatFormatting.RESET + " D: " + EnumChatFormatting.AQUA + aWorld.field_73011_w.field_76574_g + EnumChatFormatting.RESET + " -----");
            try {
                String string;
                StringBuilder stringBuilder = new StringBuilder().append(GT_Utility.trans("162", "Name: ")).append(EnumChatFormatting.BLUE);
                if (tTileEntity instanceof IInventory) {
                    IInventory inv = (IInventory)tTileEntity;
                    string = inv.func_145825_b();
                } else {
                    string = tBlock.func_149739_a();
                }
                tList.add(stringBuilder.append(string).append(EnumChatFormatting.RESET).append(GT_Utility.trans("163", " MetaData: ")).append(EnumChatFormatting.AQUA).append(aWorld.func_72805_g(aX, aY, aZ)).append(EnumChatFormatting.RESET).toString());
                tList.add(GT_Utility.trans("164", "Hardness: ") + EnumChatFormatting.YELLOW + tBlock.func_149712_f(aWorld, aX, aY, aZ) + EnumChatFormatting.RESET + GT_Utility.trans("165", " Blast Resistance: ") + EnumChatFormatting.YELLOW + tBlock.getExplosionResistance((Entity)aPlayer, aWorld, aX, aY, aZ, aPlayer.field_70165_t, aPlayer.field_70163_u, aPlayer.field_70161_v) + EnumChatFormatting.RESET);
                if (tBlock.isBeaconBase((IBlockAccess)aWorld, aX, aY, aZ, aX, aY + 1, aZ)) {
                    tList.add(EnumChatFormatting.GOLD + GT_Utility.trans("166", "Is valid Beacon Pyramid Material") + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block5;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    private static int addFluidHandlerInfo(ForgeDirection side, ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block5: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IFluidHandler) {
                    IFluidHandler fluidHandler = (IFluidHandler)tTileEntity;
                    rEUAmount += 500;
                    FluidTankInfo[] tTanks = fluidHandler.getTankInfo(side);
                    if (tTanks != null) {
                        for (int i = 0; i < tTanks.length; i = (int)((byte)(i + 1))) {
                            tList.add(GT_Utility.trans("167", "Tank ") + i + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(tTanks[i].fluid == null ? 0 : tTanks[i].fluid.amount) + EnumChatFormatting.RESET + " L / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tTanks[i].capacity) + EnumChatFormatting.RESET + " L " + EnumChatFormatting.GOLD + GT_Utility.getFluidName(tTanks[i].fluid, true) + EnumChatFormatting.RESET);
                        }
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block5;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addDebuggableBlockInfo(EntityPlayer aPlayer, int aX, int aY, int aZ, ArrayList<String> tList, Block tBlock) {
        int rEUAmount;
        block4: {
            rEUAmount = 0;
            try {
                if (tBlock instanceof IDebugableBlock) {
                    IDebugableBlock debugableBlock = (IDebugableBlock)tBlock;
                    rEUAmount += 500;
                    ArrayList<String> temp = debugableBlock.getDebugInfo(aPlayer, aX, aY, aZ, 3);
                    if (temp != null) {
                        tList.addAll(temp);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static void addPollutionInfo(ArrayList<String> tList, Chunk currentChunk) {
        if (GT_Pollution.hasPollution(currentChunk)) {
            tList.add(GT_Utility.trans("202", "Pollution in Chunk: ") + EnumChatFormatting.RED + GT_Utility.formatNumbers(GT_Pollution.getPollution(currentChunk)) + EnumChatFormatting.RESET + GT_Utility.trans("203", " gibbl"));
        } else {
            tList.add(EnumChatFormatting.GREEN + GT_Utility.trans("204", "No Pollution in Chunk! HAYO!") + EnumChatFormatting.RESET);
        }
    }

    private static void addUndergroundFluidInfo(EntityPlayer aPlayer, ArrayList<String> tList, Chunk currentChunk) {
        if (aPlayer.field_71075_bZ.field_75098_d) {
            FluidStack tFluid = GT_UndergroundOil.undergroundOilReadInformation(currentChunk);
            if (tFluid != null) {
                tList.add(EnumChatFormatting.GOLD + tFluid.getLocalizedName() + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tFluid.amount) + EnumChatFormatting.RESET + " L");
            } else {
                tList.add(EnumChatFormatting.GOLD + GT_Utility.trans("201", "Nothing") + EnumChatFormatting.RESET + ": " + EnumChatFormatting.YELLOW + '0' + EnumChatFormatting.RESET + " L");
            }
        }
    }

    private static int addForestryLeavesInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block4: {
            rEUAmount = 0;
            try {
                TileLeaves tileLeaves;
                ITree tree;
                if (tTileEntity instanceof TileLeaves && (tree = (tileLeaves = (TileLeaves)tTileEntity).getTree()) != null) {
                    rEUAmount += 1000;
                    if (!tree.isAnalyzed()) {
                        tree.analyze();
                    }
                    tree.addTooltip(tList);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addIC2CropInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block7: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof ICropTile) {
                    ICropTile crop = (ICropTile)tTileEntity;
                    rEUAmount += 1000;
                    if (crop.getScanLevel() < 4) {
                        crop.setScanLevel((byte)4);
                    }
                    if (crop.getCrop() != null) {
                        tList.add(GT_Utility.trans("187", "Type -- Crop-Name: ") + crop.getCrop().name() + GT_Utility.trans("188", "  Growth: ") + crop.getGrowth() + GT_Utility.trans("189", "  Gain: ") + crop.getGain() + GT_Utility.trans("190", "  Resistance: ") + crop.getResistance());
                    }
                    tList.add(GT_Utility.trans("191", "Plant -- Fertilizer: ") + crop.getNutrientStorage() + GT_Utility.trans("192", "  Water: ") + crop.getHydrationStorage() + GT_Utility.trans("193", "  Weed-Ex: ") + crop.getWeedExStorage() + GT_Utility.trans("194", "  Scan-Level: ") + crop.getScanLevel());
                    tList.add(GT_Utility.trans("195", "Environment -- Nutrients: ") + crop.getNutrients() + GT_Utility.trans("196", "  Humidity: ") + crop.getHumidity() + GT_Utility.trans("197", "  Air-Quality: ") + crop.getAirQuality());
                    if (crop.getCrop() != null) {
                        StringBuilder tStringB = new StringBuilder();
                        for (String tAttribute : crop.getCrop().attributes()) {
                            tStringB.append(", ").append(tAttribute);
                        }
                        String tString = tStringB.toString();
                        tList.add(GT_Utility.trans("198", "Attributes:") + tString.replaceFirst(",", ""));
                        tList.add(GT_Utility.trans("199", "Discovered by: ") + crop.getCrop().discoveredBy());
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block7;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static void addDeviceInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        block3: {
            try {
                IGregTechDeviceInformation info;
                if (tTileEntity instanceof IGregTechDeviceInformation && (info = (IGregTechDeviceInformation)tTileEntity).isGivingInformation()) {
                    tList.addAll(Arrays.asList(info.getInfoData()));
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    private static void addOwnerInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        block3: {
            try {
                if (tTileEntity instanceof IGregTechTileEntity) {
                    IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
                    tList.add(GT_Utility.trans("186", "Owned by: ") + EnumChatFormatting.BLUE + gtTE.getOwnerName() + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    private static void addEnergyContainerInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        block3: {
            try {
                IBasicEnergyContainer energyContainer;
                if (tTileEntity instanceof IBasicEnergyContainer && (energyContainer = (IBasicEnergyContainer)tTileEntity).getEUCapacity() > 0L) {
                    tList.add(GT_Utility.trans("179", "Max IN: ") + EnumChatFormatting.RED + GT_Utility.formatNumbers(energyContainer.getInputVoltage()) + " (" + GT_Values.VN[GT_Utility.getTier(energyContainer.getInputVoltage())] + ") " + EnumChatFormatting.RESET + GT_Utility.trans("182", " EU at ") + EnumChatFormatting.RED + GT_Utility.formatNumbers(energyContainer.getInputAmperage()) + EnumChatFormatting.RESET + GT_Utility.trans("183", " A"));
                    tList.add(GT_Utility.trans("181", "Max OUT: ") + EnumChatFormatting.RED + GT_Utility.formatNumbers(energyContainer.getOutputVoltage()) + " (" + GT_Values.VN[GT_Utility.getTier(energyContainer.getOutputVoltage())] + ") " + EnumChatFormatting.RESET + GT_Utility.trans("182", " EU at ") + EnumChatFormatting.RED + GT_Utility.formatNumbers(energyContainer.getOutputAmperage()) + EnumChatFormatting.RESET + GT_Utility.trans("183", " A"));
                    tList.add(GT_Utility.trans("184", "Energy: ") + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(energyContainer.getStoredEU()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(energyContainer.getEUCapacity()) + EnumChatFormatting.RESET + " EU");
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
    }

    private static int addCoverableInfo(ForgeDirection side, ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block4: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof ICoverable) {
                    ICoverable coverable = (ICoverable)tTileEntity;
                    rEUAmount += 300;
                    String tString = coverable.getCoverInfoAtSide(side).getBehaviorDescription();
                    if (tString != null && !tString.equals("")) {
                        tList.add(tString);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addMachineProgressInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block6: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IMachineProgress) {
                    IMachineProgress progress = (IMachineProgress)tTileEntity;
                    if (progress.isAllowedToWork()) {
                        tList.add(EnumChatFormatting.RED + "Disabled." + EnumChatFormatting.RESET);
                    }
                    if (progress.wasShutdown()) {
                        tList.add(EnumChatFormatting.RED + "Shut down due to power loss." + EnumChatFormatting.RESET);
                    }
                    rEUAmount += 400;
                    int tValue = 0;
                    tValue = progress.getMaxProgress();
                    if (0 < tValue) {
                        tList.add(GT_Utility.trans("178", "Progress/Load: ") + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(progress.getProgress()) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tValue) + EnumChatFormatting.RESET);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block6;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addUpgradableMachineInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block4: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IUpgradableMachine) {
                    IUpgradableMachine upgradableMachine = (IUpgradableMachine)tTileEntity;
                    rEUAmount += 500;
                    if (upgradableMachine.hasMufflerUpgrade()) {
                        tList.add(EnumChatFormatting.GREEN + GT_Utility.trans("177", "Has Muffler Upgrade") + EnumChatFormatting.RESET);
                    }
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block4;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addIC2EnergyStorageInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block3: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IEnergyStorage) {
                    IEnergyStorage storage = (IEnergyStorage)tTileEntity;
                    rEUAmount += 200;
                    tList.add(GT_Utility.trans("176", "Contained Energy: ") + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(storage.getStored()) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(storage.getCapacity()) + EnumChatFormatting.RESET + " EU");
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addIC2EnergyConductorInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block3: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IEnergyConductor) {
                    IEnergyConductor conductor = (IEnergyConductor)tTileEntity;
                    rEUAmount += 200;
                    tList.add(GT_Utility.trans("175", "Conduction Loss: ") + EnumChatFormatting.YELLOW + conductor.getConductionLoss() + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addIC2WrenchableInfo(EntityPlayer aPlayer, ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block3: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IWrenchable) {
                    IWrenchable wrenchable = (IWrenchable)tTileEntity;
                    rEUAmount += 100;
                    tList.add(GT_Utility.trans("171", "Facing: ") + EnumChatFormatting.GREEN + wrenchable.getFacing() + EnumChatFormatting.RESET + GT_Utility.trans("172", " / Chance: ") + EnumChatFormatting.YELLOW + wrenchable.getWrenchDropRate() * 100.0f + EnumChatFormatting.RESET + "%");
                    tList.add(wrenchable.wrenchCanRemove(aPlayer) ? EnumChatFormatting.GREEN + GT_Utility.trans("173", "You can remove this with a Wrench") + EnumChatFormatting.RESET : EnumChatFormatting.RED + GT_Utility.trans("174", "You can NOT remove this with a Wrench") + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addAlignmentInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block3: {
            rEUAmount = 0;
            try {
                IAlignmentProvider alignmentProvider;
                IAlignment tAlignment;
                if (tTileEntity instanceof IAlignmentProvider && (tAlignment = (alignmentProvider = (IAlignmentProvider)tTileEntity).getAlignment()) != null) {
                    rEUAmount += 100;
                    tList.add(GT_Utility.trans("219", "Extended Facing: ") + EnumChatFormatting.GREEN + tAlignment.getExtendedFacing() + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    private static int addReactorInfo(ArrayList<String> tList, TileEntity tTileEntity) {
        int rEUAmount;
        block3: {
            rEUAmount = 0;
            try {
                if (tTileEntity instanceof IReactor) {
                    IReactor reactor = (IReactor)tTileEntity;
                    rEUAmount += 500;
                    tList.add(GT_Utility.trans("168", "Heat: ") + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(reactor.getHeat()) + EnumChatFormatting.RESET + " / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(reactor.getMaxHeat()) + EnumChatFormatting.RESET);
                    tList.add(GT_Utility.trans("169", "HEM: ") + EnumChatFormatting.YELLOW + reactor.getHeatEffectModifier() + EnumChatFormatting.RESET);
                }
            }
            catch (Throwable e) {
                if (!GT_Values.D1) break block3;
                e.printStackTrace(GT_Log.err);
            }
        }
        return rEUAmount;
    }

    public static String trans(String aKey, String aEnglish) {
        return GT_LanguageManager.addStringLocalization("Interaction_DESCRIPTION_Index_" + aKey, aEnglish, false);
    }

    public static String getTrans(String aKey) {
        return GT_LanguageManager.getTranslation("Interaction_DESCRIPTION_Index_" + aKey);
    }

    public static float[] getClickedFacingCoords(ForgeDirection side, float aX, float aY, float aZ) {
        float[] fArray;
        switch (side) {
            case DOWN: {
                float[] fArray2 = new float[2];
                fArray2[0] = Math.min(0.99f, Math.max(0.0f, 1.0f - aX));
                fArray = fArray2;
                fArray2[1] = Math.min(0.99f, Math.max(0.0f, aZ));
                break;
            }
            case UP: {
                float[] fArray3 = new float[2];
                fArray3[0] = Math.min(0.99f, Math.max(0.0f, aX));
                fArray = fArray3;
                fArray3[1] = Math.min(0.99f, Math.max(0.0f, aZ));
                break;
            }
            case NORTH: {
                float[] fArray4 = new float[2];
                fArray4[0] = Math.min(0.99f, Math.max(0.0f, 1.0f - aX));
                fArray = fArray4;
                fArray4[1] = Math.min(0.99f, Math.max(0.0f, 1.0f - aY));
                break;
            }
            case SOUTH: {
                float[] fArray5 = new float[2];
                fArray5[0] = Math.min(0.99f, Math.max(0.0f, aX));
                fArray = fArray5;
                fArray5[1] = Math.min(0.99f, Math.max(0.0f, 1.0f - aY));
                break;
            }
            case WEST: {
                float[] fArray6 = new float[2];
                fArray6[0] = Math.min(0.99f, Math.max(0.0f, aZ));
                fArray = fArray6;
                fArray6[1] = Math.min(0.99f, Math.max(0.0f, 1.0f - aY));
                break;
            }
            case EAST: {
                float[] fArray7 = new float[2];
                fArray7[0] = Math.min(0.99f, Math.max(0.0f, 1.0f - aZ));
                fArray = fArray7;
                fArray7[1] = Math.min(0.99f, Math.max(0.0f, 1.0f - aY));
                break;
            }
            default: {
                float[] fArray8 = new float[2];
                fArray8[0] = 0.5f;
                fArray = fArray8;
                fArray8[1] = 0.5f;
            }
        }
        return fArray;
    }

    public static ForgeDirection determineWrenchingSide(ForgeDirection side, float aX, float aY, float aZ) {
        ForgeDirection tBack = side.getOpposite();
        switch (side) {
            case DOWN: 
            case UP: {
                if ((double)aX < 0.25) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.WEST;
                }
                if ((double)aX > 0.75) {
                    if ((double)aZ < 0.25) {
                        return tBack;
                    }
                    if ((double)aZ > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.EAST;
                }
                if ((double)aZ < 0.25) {
                    return ForgeDirection.NORTH;
                }
                if ((double)aZ > 0.75) {
                    return ForgeDirection.SOUTH;
                }
                return side;
            }
            case NORTH: 
            case SOUTH: {
                if ((double)aX < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.WEST;
                }
                if ((double)aX > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.EAST;
                }
                if ((double)aY < 0.25) {
                    return ForgeDirection.DOWN;
                }
                if ((double)aY > 0.75) {
                    return ForgeDirection.UP;
                }
                return side;
            }
            case WEST: 
            case EAST: {
                if ((double)aZ < 0.25) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.NORTH;
                }
                if ((double)aZ > 0.75) {
                    if ((double)aY < 0.25) {
                        return tBack;
                    }
                    if ((double)aY > 0.75) {
                        return tBack;
                    }
                    return ForgeDirection.SOUTH;
                }
                if ((double)aY < 0.25) {
                    return ForgeDirection.DOWN;
                }
                if ((double)aY > 0.75) {
                    return ForgeDirection.UP;
                }
                return side;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private static DecimalFormat getDecimalFormat() {
        return decimalFormatters.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(',');
            numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return numberFormat;
        });
    }

    public static String formatNumbers(BigInteger aNumber) {
        return GT_Utility.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(long aNumber) {
        return GT_Utility.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return GT_Utility.getDecimalFormat().format(aNumber);
    }

    public static boolean consumeItems(EntityPlayer player, ItemStack stack, Item item, int count) {
        if (stack != null && stack.func_77973_b() == item && stack.field_77994_a >= count) {
            if (!player.field_71075_bZ.field_75098_d && stack.field_77994_a != 111) {
                stack.field_77994_a -= count;
            }
            return true;
        }
        return false;
    }

    public static boolean consumeItems(EntityPlayer player, ItemStack stack, Materials mat, int count) {
        if (stack != null && GT_OreDictUnificator.getItemData((ItemStack)stack).mMaterial.mMaterial == mat && stack.field_77994_a >= count) {
            if (!player.field_71075_bZ.field_75098_d && stack.field_77994_a != 111) {
                stack.field_77994_a -= count;
            }
            return true;
        }
        return false;
    }

    public static ArrayList<String> sortByValueToList(Map<String, Integer> map) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(map.entrySet());
        list.sort((o1, o2) -> (Integer)o2.getValue() - (Integer)o1.getValue());
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry entry : list) {
            result.add((String)entry.getKey());
        }
        return result;
    }

    public static String joinListToString(List<String> list) {
        StringBuilder result = new StringBuilder(32);
        for (String s : list) {
            result.append(result.length() == 0 ? s : '|' + s);
        }
        return result.toString();
    }

    public static ItemStack getIntegratedCircuit(int config) {
        return ItemList.Circuit_Integrated.getWithDamage(0L, config, new Object[0]);
    }

    public static float getBlockHardnessAt(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_147439_a(aX, aY, aZ).func_149712_f(aWorld, aX, aY, aZ);
    }

    public static FakePlayer getFakePlayer(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.getWorld() instanceof WorldServer) {
            return FakePlayerFactory.get((WorldServer)((WorldServer)aBaseMetaTileEntity.getWorld()), (GameProfile)new GameProfile(aBaseMetaTileEntity.getOwnerUuid(), aBaseMetaTileEntity.getOwnerName()));
        }
        return null;
    }

    public static boolean eraseBlockByFakePlayer(FakePlayer aPlayer, int aX, int aY, int aZ, boolean isSimulate) {
        if (aPlayer == null) {
            return false;
        }
        World aWorld = aPlayer.field_70170_p;
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(aX, aY, aZ, aWorld, aWorld.func_147439_a(aX, aY, aZ), aWorld.func_72805_g(aX, aY, aZ), (EntityPlayer)aPlayer);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            if (!isSimulate) {
                return aWorld.func_147468_f(aX, aY, aZ);
            }
            return true;
        }
        return false;
    }

    public static boolean setBlockByFakePlayer(FakePlayer aPlayer, int aX, int aY, int aZ, Block aBlock, int aMeta, boolean isSimulate) {
        if (aPlayer == null) {
            return false;
        }
        World aWorld = aPlayer.field_70170_p;
        BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)aPlayer, (BlockSnapshot)new BlockSnapshot(aWorld, aX, aY, aZ, aBlock, aMeta), (ForgeDirection)ForgeDirection.UNKNOWN);
        if (!event.isCanceled()) {
            if (!isSimulate) {
                return aWorld.func_147465_d(aX, aY, aZ, aBlock, aMeta, 3);
            }
            return true;
        }
        return false;
    }

    public static int findMatchingStackInList(List<ItemStack> aStacks, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return -1;
        }
        int aStacksSize = aStacks.size();
        for (int i = 0; i < aStacksSize; ++i) {
            ItemStack tStack = aStacks.get(i);
            if (!GT_Utility.areStacksEqual(aStack, tStack)) continue;
            return i;
        }
        return -1;
    }

    public static <T extends Collection<E>, E extends MetaTileEntity> T filterValidMTEs(T metaTileEntities) {
        metaTileEntities.removeIf(mte -> mte == null || !mte.isValid());
        return metaTileEntities;
    }

    public static String toSubscript(long no) {
        char[] chars = Long.toString(no).toCharArray();
        int i = 0;
        while (i < chars.length) {
            int n = i++;
            chars[n] = (char)(chars[n] + 8272);
        }
        return new String(chars);
    }

    public static boolean isPartOfMaterials(ItemStack aStack, Materials aMaterials) {
        return GT_OreDictUnificator.getAssociation(aStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)aStack).mMaterial.mMaterial.equals(aMaterials);
    }

    public static boolean isPartOfOrePrefix(ItemStack aStack, OrePrefixes aPrefix) {
        return GT_OreDictUnificator.getAssociation(aStack) != null && GT_OreDictUnificator.getAssociation((ItemStack)aStack).mPrefix.equals((Object)aPrefix);
    }

    public static boolean isOre(Block aBlock, int aMeta) {
        return aBlock instanceof GT_Block_Ores_Abstract || GT_Utility.isOre(new ItemStack(aBlock, 1, aMeta)) || ORE_BLOCK_CLASSES.contains((Object)aBlock.getClass().getName());
    }

    public static boolean isOre(ItemStack aStack) {
        int tItem = GT_Utility.stackToInt(aStack);
        if (sOreTable.containsKey(tItem)) {
            return sOreTable.get(tItem);
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)aStack)) {
            if (!OreDictionary.getOreName((int)id).startsWith("ore")) continue;
            sOreTable.put(tItem, true);
            return true;
        }
        sOreTable.put(tItem, false);
        return false;
    }

    public static ItemStack getCobbleForOre(Block ore, short metaData) {
        Supplier<ItemStack> supplier;
        ItemData association = GT_OreDictUnificator.getAssociation(new ItemStack(Item.func_150898_a((Block)ore), 1, metaData % 16000));
        if (association != null && (supplier = sOreToCobble.get((Object)association.mPrefix)) != null) {
            return supplier.get();
        }
        return new ItemStack(Blocks.field_150347_e);
    }

    public static Optional<GT_Recipe> reverseShapelessRecipe(ItemStack output, Object ... aRecipe) {
        if (output == null) {
            return Optional.empty();
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        for (Object o : aRecipe) {
            if (o instanceof ItemStack) {
                ItemStack toAdd = ((ItemStack)o).func_77946_l();
                inputs.add(toAdd);
                continue;
            }
            if (o instanceof String) {
                ItemStack stack = GT_OreDictUnificator.get(o, 1L);
                if (stack == null) {
                    Optional oStack = OreDictionary.getOres((String)((String)o)).stream().findAny();
                    if (!oStack.isPresent()) continue;
                    ItemStack copy = ((ItemStack)oStack.get()).func_77946_l();
                    inputs.add(copy);
                    continue;
                }
                ItemStack copy = stack.func_77946_l();
                inputs.add(copy);
                continue;
            }
            if (o instanceof Item) {
                inputs.add(new ItemStack((Item)o));
                continue;
            }
            if (o instanceof Block) {
                inputs.add(new ItemStack((Block)o));
                continue;
            }
            throw new IllegalStateException("A Recipe contains an invalid input! Output: " + output);
        }
        inputs.removeIf(x -> x.func_77973_b() instanceof GT_MetaGenerated_Tool);
        return Optional.of(new GT_Recipe(false, new ItemStack[]{output}, inputs.toArray(new ItemStack[0]), null, null, null, null, 300, 30, 0));
    }

    public static Optional<GT_Recipe> reverseShapedRecipe(ItemStack output, Object ... aRecipe) {
        if (output == null) {
            return Optional.empty();
        }
        HashMap recipeAsMap = new HashMap();
        HashMap<Character, Object> ingridients = new HashMap<Character, Object>();
        HashMap<Character, Integer> amounts = new HashMap<Character, Integer>();
        boolean startFound = false;
        int aRecipeLength = aRecipe.length;
        for (int i = 0; i < aRecipeLength; ++i) {
            Object object = aRecipe[i];
            if (!startFound) {
                if (object instanceof String) {
                    char[] cArray = ((String)object).toCharArray();
                    int n = cArray.length;
                    for (int j = 0; j < n; ++j) {
                        Character c = Character.valueOf(cArray[j]);
                        amounts.merge(c, 1, (a, b) -> {
                            a = a + 1;
                            return a;
                        });
                    }
                    continue;
                }
                if (!(object instanceof Character)) continue;
                startFound = true;
                continue;
            }
            if (object instanceof Character) continue;
            ingridients.put((Character)aRecipe[i - 1], object);
        }
        for (Map.Entry characterObjectEntry : ingridients.entrySet()) {
            for (Map.Entry characterIntegerEntry : amounts.entrySet()) {
                if (characterObjectEntry.getKey() != characterIntegerEntry.getKey()) continue;
                recipeAsMap.put(characterObjectEntry.getValue(), (Integer)characterIntegerEntry.getValue());
            }
        }
        ArrayList<Object> inputs = new ArrayList<Object>();
        for (Map.Entry entry : recipeAsMap.entrySet()) {
            Object toAdd;
            int amount = (Integer)entry.getValue();
            if (entry.getKey() instanceof ItemStack) {
                toAdd = ((ItemStack)entry.getKey()).func_77946_l();
                ((ItemStack)toAdd).field_77994_a = amount;
                inputs.add(toAdd);
                continue;
            }
            toAdd = entry.getKey();
            if (toAdd instanceof String) {
                String dictName = (String)toAdd;
                if (ToolDictNames.contains(dictName)) continue;
                ItemStack stack = GT_OreDictUnificator.get(dictName, null, amount, false, true);
                if (stack == null) {
                    Optional oStack = OreDictionary.getOres((String)dictName).stream().findAny();
                    if (!oStack.isPresent()) continue;
                    ItemStack copy = ((ItemStack)oStack.get()).func_77946_l();
                    copy.field_77994_a = amount;
                    inputs.add(copy);
                    continue;
                }
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = amount;
                inputs.add(copy);
                continue;
            }
            if (entry.getKey() instanceof Item) {
                inputs.add(new ItemStack((Item)entry.getKey(), amount));
                continue;
            }
            if (entry.getKey() instanceof Block) {
                inputs.add(new ItemStack((Block)entry.getKey(), amount));
                continue;
            }
            throw new IllegalStateException("A Recipe contains an invalid input! Output: " + output);
        }
        inputs.removeIf(x -> x.func_77973_b() instanceof GT_MetaGenerated_Tool);
        return Optional.of(new GT_Recipe(false, new ItemStack[]{output}, inputs.toArray(new ItemStack[0]), null, null, null, null, 300, 30, 0));
    }

    public static void addItemToPlayerInventory(EntityPlayer aPlayer, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return;
        }
        if (!aPlayer.field_71071_by.func_70441_a(aStack) && !aPlayer.field_70170_p.field_72995_K) {
            EntityItem dropItem = aPlayer.func_70099_a(aStack, 0.0f);
            dropItem.field_145804_b = 0;
        }
    }

    public static long getNonnullElementCount(Object[] tArray) {
        return Arrays.stream(tArray).filter(Objects::nonNull).count();
    }

    public static int clamp(int val, int lo, int hi) {
        return MathHelper.func_76125_a((int)val, (int)lo, (int)hi);
    }

    public static int ceilDiv(int lhs, int rhs) {
        return (lhs + rhs - 1) / rhs;
    }

    public static long ceilDiv(long lhs, long rhs) {
        return (lhs + rhs - 1L) / rhs;
    }

    public static int persistentHash(ItemStack aStack, boolean aUseStackSize, boolean aUseNBT) {
        if (aStack == null) {
            return 0;
        }
        int result = Objects.hashCode(GameRegistry.findUniqueIdentifierFor((Item)aStack.func_77973_b()));
        result = result * 31 + Items.field_151008_G.getDamage(aStack);
        if (aUseStackSize) {
            result = result * 31 + aStack.field_77994_a;
        }
        if (aUseNBT) {
            result = result * 31 + Objects.hashCode(aStack.field_77990_d);
        }
        return result;
    }

    public static int persistentHash(FluidStack aStack, boolean aUseStackSize, boolean aUseNBT) {
        if (aStack == null) {
            return 0;
        }
        int base = Objects.hashCode(aStack.getFluid().getName());
        if (aUseStackSize) {
            base = base * 31 + aStack.amount;
        }
        if (aUseNBT) {
            base = base * 31 + Objects.hashCode(aStack.tag);
        }
        return base;
    }

    public static int getCasingTextureIndex(Block block, int meta) {
        if (block instanceof IHasIndexedTexture) {
            return ((IHasIndexedTexture)block).getTextureIndex(meta);
        }
        return 225;
    }

    public static boolean isCellEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        ItemStack tStack = ItemList.Cell_Empty.get(1L, new Object[0]);
        tStack.field_77994_a = itemStack.field_77994_a;
        return GT_Utility.areStacksEqual(itemStack, tStack);
    }

    public static FluidStack convertCellToFluid(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        if (GT_Utility.getFluidForFilledItem(itemStack, true) != null) {
            FluidStack fluidStack = GT_Utility.getFluidForFilledItem(itemStack, true);
            if (fluidStack != null) {
                fluidStack.amount *= itemStack.field_77994_a;
            }
            return fluidStack;
        }
        return null;
    }

    @Deprecated
    public static boolean checkIfSameIntegratedCircuit(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        for (int i = 0; i < 25; ++i) {
            if (!itemStack.func_77969_a(GT_Utility.getIntegratedCircuit(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyIntegratedCircuit(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77973_b() == ItemList.Circuit_Integrated.getItem() && 0 <= itemStack.func_77960_j() && itemStack.func_77960_j() < 25;
    }

    public static byte convertRatioToRedstone(long used, long max, int threshold, boolean inverted) {
        byte signal = used <= 0L ? (byte)0 : (used >= max ? (byte)15 : (byte)(1L + 14L * used / max));
        if (inverted) {
            signal = (byte)(15 - signal);
        }
        if (threshold > 0) {
            if (inverted && used >= (long)threshold) {
                return 0;
            }
            if (!inverted && used < (long)threshold) {
                return 0;
            }
        }
        return signal;
    }

    public static ItemStack getNaniteAsCatalyst(Materials material) {
        ItemStack aItem = material.getNanite(1);
        return new ItemStack(aItem.func_77973_b(), 0, aItem.func_77960_j());
    }

    public static Stream<NBTTagCompound> streamCompounds(NBTTagList list) {
        if (list == null) {
            return Stream.empty();
        }
        return IntStream.range(0, list.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)list).func_150305_b(arg_0));
    }

    public static boolean equals(ItemStack[] a, ItemStack[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null != (b == null)) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (GT_Utility.areStacksEqual(a[i], b[i], false)) continue;
            return false;
        }
        return true;
    }

    public static <T, K, U> Collector<T, ?, ImmutableMap<K, U>> toImmutableMapSerial(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(ImmutableMap::builder, (b, t) -> b.put(keyMapper.apply(t), valueMapper.apply(t)), (b1, b2) -> b1.putAll((Map)b2.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]);
    }

    public static boolean isArrayEmptyOrNull(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isArrayOfLength(Object[] arr, int expectedLength) {
        return arr != null && arr.length == expectedLength;
    }

    @SafeVarargs
    public static <E> Collection<E> concat(Collection<E> ... colls) {
        return GT_Utility.concat(Arrays.asList(colls));
    }

    public static <E> Collection<E> concat(Collection<Collection<E>> colls) {
        return new ConcatCollection<E>(colls);
    }

    public static int getPlasmaFuelValueInEUPerLiterFromMaterial(Materials material) {
        return GT_Utility.getPlasmaFuelValueInEUPerLiterFromFluid(material.getPlasma(1L));
    }

    public static int getPlasmaFuelValueInEUPerLiterFromFluid(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GT_Recipe tFuel = RecipeMaps.plasmaFuels.getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    static {
        GregTech_API.sItemStackMappings.add(sFilledContainerToData);
        GregTech_API.sItemStackMappings.add(sEmptyContainerToFluidToData);
        Function<Materials, Supplier> materialToCobble = m -> () -> ((com.google.common.base.Supplier)Suppliers.memoize(() -> GT_OreDictUnificator.getOres(OrePrefixes.stone, m).get(1))).get();
        sOreToCobble.put(OrePrefixes.oreBlackgranite, materialToCobble.apply(Materials.GraniteBlack));
        sOreToCobble.put(OrePrefixes.oreRedgranite, materialToCobble.apply(Materials.GraniteRed));
        sOreToCobble.put(OrePrefixes.oreMarble, materialToCobble.apply(Materials.Marble));
        sOreToCobble.put(OrePrefixes.oreBasalt, materialToCobble.apply(Materials.Basalt));
        sOreToCobble.put(OrePrefixes.oreNetherrack, () -> new ItemStack(Blocks.field_150424_aL));
        sOreToCobble.put(OrePrefixes.oreEndstone, () -> new ItemStack(Blocks.field_150377_bs));
        ORE_BLOCK_CLASSES = ImmutableSet.of((Object)"com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_Ores", (Object)"com.github.bartimaeusnek.bartworks.system.material.BW_MetaGenerated_SmallOres", (Object)"gtPlusPlus.core.block.base.BlockBaseOre");
    }

    @AutoValue
    public static abstract class ItemId {
        public static ItemId create(NBTTagCompound tag) {
            return new AutoValue_GT_Utility_ItemId(Item.func_150899_d((int)tag.func_74765_d("item")), tag.func_74765_d("meta"), tag.func_150297_b("tag", 10) ? tag.func_74775_l("tag") : null);
        }

        public static ItemId create(ItemStack itemStack) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            if (nbt != null) {
                nbt = (NBTTagCompound)nbt.func_74737_b();
            }
            return new AutoValue_GT_Utility_ItemId(itemStack.func_77973_b(), itemStack.func_77960_j(), nbt);
        }

        public static ItemId create(Item item, int metaData, @Nullable NBTTagCompound nbt) {
            if (nbt != null) {
                nbt = (NBTTagCompound)nbt.func_74737_b();
            }
            return new AutoValue_GT_Utility_ItemId(item, metaData, nbt);
        }

        public static ItemId createAsWildcard(ItemStack itemStack) {
            return new AutoValue_GT_Utility_ItemId(itemStack.func_77973_b(), Short.MAX_VALUE, null);
        }

        public static ItemId createWithoutNBT(ItemStack itemStack) {
            return new AutoValue_GT_Utility_ItemId(itemStack.func_77973_b(), itemStack.func_77960_j(), null);
        }

        public static ItemId createNoCopy(ItemStack itemStack) {
            return new AutoValue_GT_Utility_ItemId(itemStack.func_77973_b(), itemStack.func_77960_j(), itemStack.func_77978_p());
        }

        public static ItemId createNoCopy(Item item, int metaData, @Nullable NBTTagCompound nbt) {
            return new AutoValue_GT_Utility_ItemId(item, metaData, nbt);
        }

        protected abstract Item item();

        protected abstract int metaData();

        @Nullable
        protected abstract NBTTagCompound nbt();

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("item", (short)Item.func_150891_b((Item)this.item()));
            tag.func_74777_a("meta", (short)this.metaData());
            if (this.nbt() != null) {
                tag.func_74782_a("tag", (NBTBase)this.nbt());
            }
            return tag;
        }
    }

    private static class ConcatCollection<E>
    extends AbstractCollection<E> {
        private final Collection<Collection<E>> colls;
        private final int size;

        public ConcatCollection(Collection<Collection<E>> lists) {
            Collection colls1 = null;
            for (Collection<E> list : lists) {
                if (list != null && !list.isEmpty()) continue;
                colls1 = lists.stream().filter(c -> c != null && !c.isEmpty()).collect(Collectors.toList());
                break;
            }
            if (colls1 == null) {
                colls1 = lists;
            }
            this.colls = colls1;
            int sum = 0;
            for (Collection<E> list : this.colls) {
                sum += list.size();
            }
            this.size = sum;
        }

        @Override
        @Nonnull
        public Iterator<E> iterator() {
            return this.colls.stream().flatMap(Collection::stream).iterator();
        }

        @Override
        public int size() {
            return this.size;
        }
    }

    public static class GT_EnchantmentHelper {
        private static final BullshitIteratorA mBullshitIteratorA = new BullshitIteratorA();
        private static final BullshitIteratorB mBullshitIteratorB = new BullshitIteratorB();

        private static void applyBullshit(IBullshit aBullshitModifier, ItemStack aStack) {
            NBTTagList nbttaglist;
            if (aStack != null && (nbttaglist = aStack.func_77986_q()) != null) {
                try {
                    for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                        short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                        short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                        if (Enchantment.field_77331_b[short1] == null) continue;
                        aBullshitModifier.calculateModifier(Enchantment.field_77331_b[short1], short2);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private static void applyArrayOfBullshit(IBullshit aBullshitModifier, ItemStack[] aStacks) {
            for (ItemStack itemstack : aStacks) {
                GT_EnchantmentHelper.applyBullshit(aBullshitModifier, itemstack);
            }
        }

        public static void applyBullshitA(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorA.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorA.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorA, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorA, aStack);
            }
        }

        public static void applyBullshitB(EntityLivingBase aPlayer, Entity aEntity, ItemStack aStack) {
            GT_EnchantmentHelper.mBullshitIteratorB.mPlayer = aPlayer;
            GT_EnchantmentHelper.mBullshitIteratorB.mEntity = aEntity;
            if (aPlayer != null) {
                GT_EnchantmentHelper.applyArrayOfBullshit(mBullshitIteratorB, aPlayer.func_70035_c());
            }
            if (aStack != null) {
                GT_EnchantmentHelper.applyBullshit(mBullshitIteratorB, aStack);
            }
        }

        static interface IBullshit {
            public void calculateModifier(Enchantment var1, int var2);
        }

        static final class BullshitIteratorA
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorA() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151367_b(this.mPlayer, this.mEntity, aLevel);
            }
        }

        static final class BullshitIteratorB
        implements IBullshit {
            public EntityLivingBase mPlayer;
            public Entity mEntity;

            BullshitIteratorB() {
            }

            @Override
            public void calculateModifier(Enchantment aEnchantment, int aLevel) {
                aEnchantment.func_151368_a(this.mPlayer, this.mEntity, aLevel);
            }
        }
    }

    public static class ItemNBT {
        public static void setNBT(ItemStack aStack, NBTTagCompound aNBT) {
            if (aNBT == null) {
                aStack.func_77982_d(null);
                return;
            }
            ArrayList<String> tTagsToRemove = new ArrayList<String>();
            for (String tKey : aNBT.func_150296_c()) {
                NBTBase tValue = aNBT.func_74781_a(tKey);
                if (tValue != null && (!(tValue instanceof NBTBase.NBTPrimitive) || ((NBTBase.NBTPrimitive)tValue).func_150291_c() != 0L) && (!(tValue instanceof NBTTagString) || !GT_Utility.isStringInvalid(((NBTTagString)tValue).func_150285_a_()))) continue;
                tTagsToRemove.add(tKey);
            }
            for (String tKey : tTagsToRemove) {
                aNBT.func_82580_o(tKey);
            }
            aStack.func_77982_d(aNBT.func_82582_d() ? null : aNBT);
        }

        public static NBTTagCompound getNBT(ItemStack aStack) {
            NBTTagCompound rNBT = aStack.func_77978_p();
            return rNBT == null ? new NBTTagCompound() : rNBT;
        }

        public static void setPunchCardData(ItemStack aStack, String aPunchCardData) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("GT.PunchCardData", aPunchCardData);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getPunchCardData(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("GT.PunchCardData");
        }

        public static void setLighterFuel(ItemStack aStack, long aFuel) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74772_a("GT.LighterFuel", aFuel);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static long getLighterFuel(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74763_f("GT.LighterFuel");
        }

        public static void setMapID(ItemStack aStack, short aMapID) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74777_a("map_id", aMapID);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static short getMapID(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.func_74764_b("map_id")) {
                return -1;
            }
            return tNBT.func_74765_d("map_id");
        }

        public static void setBookTitle(ItemStack aStack, String aTitle) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("title", aTitle);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookTitle(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("title");
        }

        public static void setBookAuthor(ItemStack aStack, String aAuthor) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74778_a("author", aAuthor);
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static String getBookAuthor(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            return tNBT.func_74779_i("author");
        }

        public static void setProspectionData(ItemStack aStack, int aX, int aY, int aZ, int aDim, FluidStack aFluid, String ... aOres) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            StringBuilder tData = new StringBuilder(aX + "," + aY + "," + aZ + "," + aDim + ",");
            if (aFluid != null) {
                tData.append(aFluid.amount).append(",").append(aFluid.getLocalizedName()).append(",");
            }
            for (String tString : aOres) {
                tData.append(tString).append(",");
            }
            tNBT.func_74778_a("prospection", tData.toString());
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static void setAdvancedProspectionData(byte aTier, ItemStack aStack, int aX, short aY, int aZ, int aDim, ArrayList<String> aOils, ArrayList<String> aOres, int aRadius) {
            ItemNBT.setBookTitle(aStack, "Raw Prospection Data");
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            tNBT.func_74774_a("prospection_tier", aTier);
            tNBT.func_74778_a("prospection_pos", "Dim: " + aDim + "\nX: " + aX + " Y: " + aY + " Z: " + aZ);
            Collections.sort(aOres);
            tNBT.func_74778_a("prospection_ores", GT_Utility.joinListToString(aOres));
            ArrayList<String> tOilsTransformed = new ArrayList<String>(aOils.size());
            for (String aStr : aOils) {
                String[] aStats = aStr.split(",");
                tOilsTransformed.add(aStats[0] + ": " + aStats[1] + "L " + aStats[2]);
            }
            tNBT.func_74778_a("prospection_oils", GT_Utility.joinListToString(tOilsTransformed));
            String tOilsPosStr = "X: " + Math.floorDiv(aX, 128) * 16 * 8 + " Z: " + Math.floorDiv(aZ, 128) * 16 * 8 + "\n";
            int xOff = aX - Math.floorDiv(aX, 128) * 16 * 8;
            int xOffRemain = 7 - (xOff /= 16);
            int zOff = aZ - Math.floorDiv(aZ, 128) * 16 * 8;
            int zOffRemain = 7 - (zOff /= 16);
            while (zOff > 0) {
                tOilsPosStr = tOilsPosStr.concat("--------\n");
                --zOff;
            }
            while (xOff > 0) {
                tOilsPosStr = tOilsPosStr.concat("-");
                --xOff;
            }
            tOilsPosStr = tOilsPosStr.concat("P");
            while (xOffRemain > 0) {
                tOilsPosStr = tOilsPosStr.concat("-");
                --xOffRemain;
            }
            tOilsPosStr = tOilsPosStr.concat("\n");
            while (zOffRemain > 0) {
                tOilsPosStr = tOilsPosStr.concat("--------\n");
                --zOffRemain;
            }
            tOilsPosStr = tOilsPosStr.concat("            X: " + (Math.floorDiv(aX, 128) + 1) * 16 * 8 + " Z: " + (Math.floorDiv(aZ, 128) + 1) * 16 * 8);
            tNBT.func_74778_a("prospection_oils_pos", tOilsPosStr);
            tNBT.func_74778_a("prospection_radius", String.valueOf(aRadius));
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static void convertProspectionData(ItemStack aStack) {
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            byte tTier = tNBT.func_74771_c("prospection_tier");
            if (tTier == 0) {
                String tData = tNBT.func_74779_i("prospection");
                String[] tDataArray = tData.split(",");
                if (tDataArray.length > 6) {
                    tNBT.func_74778_a("author", " Dim: " + tDataArray[3] + "X: " + tDataArray[0] + " Y: " + tDataArray[1] + " Z: " + tDataArray[2]);
                    NBTTagList tNBTList = new NBTTagList();
                    StringBuilder tOres = new StringBuilder(" Prospected Ores: ");
                    for (int i = 6; tDataArray.length > i; ++i) {
                        tOres.append(tDataArray[i]).append(" ");
                    }
                    tNBTList.func_74742_a((NBTBase)new NBTTagString("Tier " + tTier + " Prospecting Data From: X" + tDataArray[0] + " Z:" + tDataArray[2] + " Dim:" + tDataArray[3] + " Produces " + tDataArray[4] + "L " + tDataArray[5] + " " + tOres));
                    tNBT.func_74782_a("pages", (NBTBase)tNBTList);
                }
            } else {
                String tPos = tNBT.func_74779_i("prospection_pos");
                String tRadius = tNBT.func_74779_i("prospection_radius");
                String tOresStr = tNBT.func_74779_i("prospection_ores");
                String tOilsStr = tNBT.func_74779_i("prospection_oils");
                String tOilsPosStr = tNBT.func_74779_i("prospection_oils_pos");
                String[] tOres = tOresStr.isEmpty() ? null : tOresStr.split("\\|");
                String[] tOils = tOilsStr.isEmpty() ? null : tOilsStr.split("\\|");
                NBTTagList tNBTList = new NBTTagList();
                String tPageText = "Prospector report\n" + tPos + "\n\nOils: " + (tOils != null ? tOils.length : 0) + "\n\nOres within " + tRadius + " blocks\n\nLocation is center of orevein\n\nCheck NEI to confirm orevein type";
                tNBTList.func_74742_a((NBTBase)new NBTTagString(tPageText));
                if (tOres != null) {
                    ItemNBT.fillBookWithList(tNBTList, "Ores Found %s\n\n", "\n", 7, tOres);
                }
                if (tOils != null) {
                    ItemNBT.fillBookWithList(tNBTList, "Oils%s\n\n", "\n", 9, tOils);
                }
                tPageText = "Oil notes\n\nProspects from NW to SE 576 chunks(9 8x8 oilfields)\n around and gives min-max amount\n\n[1][2][3]\n[4][5][6]\n[7][8][9]\n\n[5] - Prospector in this 8x8 area";
                tNBTList.func_74742_a((NBTBase)new NBTTagString(tPageText));
                tPageText = "Corners of [5] are \n" + tOilsPosStr + "\nP - Prospector in 8x8 field";
                tNBTList.func_74742_a((NBTBase)new NBTTagString(tPageText));
                tNBT.func_74778_a("author", tPos.replace("\n", " "));
                tNBT.func_74782_a("pages", (NBTBase)tNBTList);
            }
            ItemNBT.setNBT(aStack, tNBT);
        }

        public static void fillBookWithList(NBTTagList aBook, String aPageHeader, String aListDelimiter, int aItemsPerPage, String[] list) {
            StringBuilder tPageText;
            String aPageFormatter = " %d/%d";
            int tTotalPages = list.length / aItemsPerPage + (list.length % aItemsPerPage > 0 ? 1 : 0);
            int tPage = 0;
            do {
                tPageText = new StringBuilder();
                for (int i = tPage * aItemsPerPage; i < (tPage + 1) * aItemsPerPage && i < list.length; ++i) {
                    tPageText.append(tPageText.length() == 0 ? "" : aListDelimiter).append(list[i]);
                }
                if (tPageText.length() > 0) {
                    String tPageCounter = tTotalPages > 1 ? String.format(aPageFormatter, tPage + 1, tTotalPages) : "";
                    NBTTagString tPageTag = new NBTTagString(String.format(aPageHeader, tPageCounter) + tPageText);
                    aBook.func_74742_a((NBTBase)tPageTag);
                }
                ++tPage;
            } while (tPageText.length() > 0);
        }

        public static void addEnchantment(ItemStack aStack, Enchantment aEnchantment, int aLevel) {
            NBTTagCompound tEnchantmentTag;
            NBTTagCompound tNBT = ItemNBT.getNBT(aStack);
            if (!tNBT.func_150297_b("ench", 9)) {
                tNBT.func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList tList = tNBT.func_150295_c("ench", 10);
            boolean temp = true;
            for (int i = 0; i < tList.func_74745_c(); ++i) {
                tEnchantmentTag = tList.func_150305_b(i);
                if (tEnchantmentTag.func_74765_d("id") != aEnchantment.field_77352_x) continue;
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                temp = false;
                break;
            }
            if (temp) {
                tEnchantmentTag = new NBTTagCompound();
                tEnchantmentTag.func_74777_a("id", (short)aEnchantment.field_77352_x);
                tEnchantmentTag.func_74777_a("lvl", (short)((byte)aLevel));
                tList.func_74742_a((NBTBase)tEnchantmentTag);
            }
            aStack.func_77982_d(tNBT);
        }
    }
}

