/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Item;
import gregtech.api.util.GT_ItsNotMyFaultException;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_Utility;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_DigitalTankBase;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_SuperChest;
import gregtech.common.tileentities.storage.GT_MetaTileEntity_SuperTank;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class GT_Item_Machines
extends ItemBlock
implements IFluidContainerItem {
    public GT_Item_Machines(Block block) {
        super(block);
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77637_a(GregTech_API.TAB_GREGTECH);
    }

    public static IMetaTileEntity getMetaTileEntity(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return null;
        }
        if (!(aStack.func_77973_b() instanceof GT_Item_Machines)) {
            return null;
        }
        if (aStack.func_77960_j() < 0 || aStack.func_77960_j() > GregTech_API.METATILEENTITIES.length) {
            return null;
        }
        return GregTech_API.METATILEENTITIES[aStack.func_77960_j()];
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        try {
            NBTTagCompound aNBT;
            int tDamage = this.getDamage(aStack);
            if (tDamage <= 0 || tDamage >= GregTech_API.METATILEENTITIES.length) {
                return;
            }
            if (GregTech_API.METATILEENTITIES[tDamage] != null) {
                IMetaTileEntity tMetaTileEntity;
                IGregTechTileEntity tTileEntity = GregTech_API.METATILEENTITIES[tDamage].getBaseMetaTileEntity();
                if (!GregTech_API.sPostloadFinished && tTileEntity.getMetaTileEntity() instanceof ISecondaryDescribable) {
                    String[] tSecondaryDescription = ((ISecondaryDescribable)((Object)tTileEntity.getMetaTileEntity())).getSecondaryDescription();
                    this.addDescription(null, tSecondaryDescription, tDamage, "_Secondary", true);
                }
                String tSuffix = (tMetaTileEntity = tTileEntity.getMetaTileEntity()) instanceof ISecondaryDescribable && ((ISecondaryDescribable)((Object)tMetaTileEntity)).isDisplaySecondaryDescription() ? "_Secondary" : "";
                this.addDescription(aList, tTileEntity.getDescription(), tDamage, tSuffix, !GregTech_API.sPostloadFinished);
                tMetaTileEntity.addAdditionalTooltipInformation(aStack, aList);
                if (tTileEntity.getEUCapacity() > 0L) {
                    if (tTileEntity.getInputVoltage() > 0L) {
                        byte inputTier = GT_Utility.getTier(tTileEntity.getInputVoltage());
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_IN", "Voltage IN: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(tTileEntity.getInputVoltage()) + " (" + GT_Utility.getColoredTierNameFromTier(inputTier) + EnumChatFormatting.GREEN + ")" + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getOutputVoltage() > 0L) {
                        byte outputTier = GT_Utility.getTier(tTileEntity.getOutputVoltage());
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_OUT", "Voltage OUT: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(tTileEntity.getOutputVoltage()) + " (" + GT_Utility.getColoredTierNameFromTier(outputTier) + EnumChatFormatting.GREEN + ")" + EnumChatFormatting.GRAY);
                    }
                    if (tTileEntity.getOutputAmperage() > 1L) {
                        aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_AMOUNT", "Amperage: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(tTileEntity.getOutputAmperage()) + EnumChatFormatting.GRAY);
                    }
                    aList.add(GT_LanguageManager.addStringLocalization("TileEntity_EUp_STORE", "Capacity: ", !GregTech_API.sPostloadFinished) + EnumChatFormatting.BLUE + GT_Utility.formatNumbers(tTileEntity.getEUCapacity()) + EnumChatFormatting.GRAY + " EU");
                }
            }
            if ((aNBT = aStack.func_77978_p()) != null) {
                if (aNBT.func_74767_n("mMuffler")) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_TileEntity_MUFFLER", "has Muffler Upgrade", !GregTech_API.sPostloadFinished));
                }
                if (aNBT.func_74767_n("mSteamConverter")) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_TileEntity_STEAMCONVERTER", "has Steam Upgrade", !GregTech_API.sPostloadFinished));
                }
                byte tAmount = 0;
                tAmount = aNBT.func_74771_c("mSteamTanks");
                if (tAmount > 0) {
                    aList.add(tAmount + " " + GT_LanguageManager.addStringLocalization("GT_TileEntity_STEAMTANKS", "Steam Tank Upgrades", !GregTech_API.sPostloadFinished));
                }
                CoverableTileEntity.addInstalledCoversInformation(aNBT, aList);
                if (aNBT.func_74764_b("mColor") && aNBT.func_74771_c("mColor") != -1) {
                    aList.add(GT_LanguageManager.addStringLocalization("GT_TileEntity_COLORED", "Colored", !GregTech_API.sPostloadFinished) + " (" + Dyes.get((int)(aNBT.func_74771_c((String)"mColor") - 1)).formatting + Dyes.get((int)(aNBT.func_74771_c((String)"mColor") - 1)).mName + EnumChatFormatting.GRAY + ")");
                }
            }
        }
        catch (Throwable e) {
            GT_Mod.GT_FML_LOGGER.error("addInformation", e);
        }
    }

    private void addDescription(@Nullable List<String> aList, @Nullable String[] aDescription, int aDamage, String aSuffix, boolean aWriteIntoLangFile) {
        if (aDescription == null) {
            return;
        }
        int tLength = aDescription.length;
        for (int i = 0; i < tLength; ++i) {
            String tDescLine = aDescription[i];
            if (!GT_Utility.isStringValid(tDescLine)) continue;
            String tKey = String.format("TileEntity_DESCRIPTION_%05d%s_Index_%02d", aDamage, aSuffix, i);
            if (tDescLine.contains("%%%")) {
                String[] tSplitStrings = tDescLine.split("%%%");
                StringBuilder tBuffer = new StringBuilder();
                String[] tRep = new String[tSplitStrings.length / 2];
                for (int j = 0; j < tSplitStrings.length; ++j) {
                    if (j % 2 == 0) {
                        tBuffer.append(tSplitStrings[j]);
                        continue;
                    }
                    tBuffer.append("%s");
                    tRep[j / 2] = tSplitStrings[j];
                }
                String tTranslated = String.format(GT_LanguageManager.addStringLocalization(tKey, tBuffer.toString(), aWriteIntoLangFile), tRep);
                if (aList == null) continue;
                aList.add(tTranslated);
                continue;
            }
            String tTranslated = GT_LanguageManager.addStringLocalization(tKey, tDescLine, aWriteIntoLangFile);
            if (aList == null) continue;
            aList.add(tTranslated.equals("") ? tDescLine : tTranslated);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerDescription(int aDamage) {
        if (aDamage >= GregTech_API.METATILEENTITIES.length) {
            return;
        }
        if (GregTech_API.METATILEENTITIES[aDamage] != null) {
            IMetaTileEntity tMetaTileEntity = GregTech_API.METATILEENTITIES[aDamage].getBaseMetaTileEntity().getMetaTileEntity();
            if (tMetaTileEntity instanceof ISecondaryDescribable) {
                String[] tSecondaryDescription = ((ISecondaryDescribable)((Object)tMetaTileEntity)).getSecondaryDescription();
                this.addDescription(null, tSecondaryDescription, aDamage, "_Secondary", true);
            }
            this.addDescription(null, tMetaTileEntity.getDescription(), aDamage, "", true);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int ordinalSide, float hitX, float hitY, float hitZ) {
        return false;
    }

    public String func_77667_c(ItemStack aStack) {
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTech_API.METATILEENTITIES.length) {
            return "";
        }
        if (GregTech_API.METATILEENTITIES[tDamage] != null) {
            return this.func_77658_a() + "." + GregTech_API.METATILEENTITIES[tDamage].getMetaName();
        }
        return "";
    }

    public String func_77653_i(ItemStack aStack) {
        String aName = super.func_77653_i(aStack);
        short aDamage = (short)this.getDamage(aStack);
        if (aDamage >= 0 && aDamage < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aDamage] != null) {
            Materials aMaterial = null;
            if (GregTech_API.METATILEENTITIES[aDamage] instanceof GT_MetaPipeEntity_Item) {
                aMaterial = ((GT_MetaPipeEntity_Item)GregTech_API.METATILEENTITIES[aDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[aDamage] instanceof GT_MetaPipeEntity_Fluid) {
                aMaterial = ((GT_MetaPipeEntity_Fluid)GregTech_API.METATILEENTITIES[aDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[aDamage] instanceof GT_MetaPipeEntity_Cable) {
                aMaterial = ((GT_MetaPipeEntity_Cable)GregTech_API.METATILEENTITIES[aDamage]).mMaterial;
            } else if (GregTech_API.METATILEENTITIES[aDamage] instanceof GT_MetaPipeEntity_Frame) {
                aMaterial = ((GT_MetaPipeEntity_Frame)GregTech_API.METATILEENTITIES[aDamage]).mMaterial;
            }
            if (aMaterial != null) {
                aName = aMaterial.getLocalizedNameForItem(aName);
            }
        }
        return aName;
    }

    public void func_77622_d(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        super.func_77622_d(aStack, aWorld, aPlayer);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage < 0 || tDamage >= GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[tDamage] != null) {
            GregTech_API.METATILEENTITIES[tDamage].onCreated(aStack, aWorld, aPlayer);
        }
    }

    public boolean placeBlockAt(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int ordinalSide, float hitX, float hitY, float hitZ, int aMeta) {
        ForgeDirection side = ForgeDirection.getOrientation((int)ordinalSide);
        short tDamage = (short)this.getDamage(aStack);
        if (tDamage > 0) {
            if (GregTech_API.METATILEENTITIES[tDamage] == null) {
                return false;
            }
            byte tMetaData = GregTech_API.METATILEENTITIES[tDamage].getTileEntityBaseType();
            if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tMetaData, 3)) {
                return false;
            }
            if (aWorld.func_147439_a(aX, aY, aZ) != this.field_150939_a) {
                throw new GT_ItsNotMyFaultException("Failed to place Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            if (aWorld.func_72805_g(aX, aY, aZ) != tMetaData) {
                throw new GT_ItsNotMyFaultException("Failed to set the MetaValue of the Block even though World.setBlock returned true. It COULD be MCPC/Bukkit causing that. In case you really have that installed, don't report this Bug to me, I don't know how to fix it.");
            }
            IGregTechTileEntity tTileEntity = (IGregTechTileEntity)aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity != null) {
                IMetaTileEntity iMetaTileEntity;
                IGregTechTileEntity aTileEntity;
                tTileEntity.setInitialValuesAsNBT(tTileEntity.isServerSide() ? aStack.func_77978_p() : null, tDamage);
                if (aPlayer != null) {
                    tTileEntity.setOwnerName(aPlayer.getDisplayName());
                    tTileEntity.setOwnerUuid(aPlayer.func_110124_au());
                }
                tTileEntity.getMetaTileEntity().initDefaultModes(aStack.func_77978_p());
                ForgeDirection oppositeSide = side.getOpposite();
                IMetaTileEntity iMetaTileEntity2 = tTileEntity.getMetaTileEntity();
                if (iMetaTileEntity2 instanceof IConnectable) {
                    IConnectable connectable = (IConnectable)((Object)iMetaTileEntity2);
                    connectable.connect(oppositeSide);
                } else if (aPlayer != null && aPlayer.func_70093_af() && (aTileEntity = tTileEntity.getIGregTechTileEntityAtSide(oppositeSide)) != null && (iMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof IConnectable) {
                    IConnectable connectable = (IConnectable)((Object)iMetaTileEntity);
                    connectable.connect(side);
                }
            }
        } else if (!aWorld.func_147465_d(aX, aY, aZ, this.field_150939_a, (int)tDamage, 3)) {
            return false;
        }
        if (aWorld.func_147439_a(aX, aY, aZ) == this.field_150939_a) {
            this.field_150939_a.func_149689_a(aWorld, aX, aY, aZ, (EntityLivingBase)aPlayer, aStack);
            this.field_150939_a.func_149714_e(aWorld, aX, aY, aZ, (int)tDamage);
        }
        return true;
    }

    public void func_77663_a(ItemStack aStack, World aWorld, Entity aPlayer, int aTimer, boolean aIsInHand) {
        super.func_77663_a(aStack, aWorld, aPlayer, aTimer, aIsInHand);
        short tDamage = (short)this.getDamage(aStack);
        EntityPlayer tPlayer = (EntityPlayer)aPlayer;
        if (GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaTileEntity_SuperChest || GregTech_API.METATILEENTITIES[tDamage] instanceof GT_MetaTileEntity_SuperTank) {
            NBTTagCompound tNBT = aStack.field_77990_d;
            if (tNBT == null) {
                return;
            }
            if (tNBT.func_82582_d()) {
                aStack.func_77982_d(null);
                return;
            }
            if (tNBT.func_74764_b("mItemCount") && tNBT.func_74762_e("mItemCount") > 0 || tNBT.func_74764_b("mFluid") && FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l((String)"mFluid")).amount > 64000) {
                FluidStack tFluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l("mFluid"));
                int tEffectDuration = 1200;
                if (tFluid != null) {
                    double tFluidAmount = tFluid.amount;
                    double tMiddlePoint = 4096000.0;
                    double tSmoothingCoefficient = 2000000.0;
                    int tMaxDuration = 12000;
                    double tmp = (tFluidAmount - 4096000.0) / 2000000.0;
                    tEffectDuration = (int)(Math.exp(tmp) / (Math.exp(tmp) + Math.exp(-tmp)) * 12000.0);
                }
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, tEffectDuration, 1));
                tPlayer.func_70690_d(new PotionEffect(Potion.field_76437_t.field_76415_H, tEffectDuration, 1));
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tNBT;
        if (container != null && (tNBT = container.field_77990_d) != null && tNBT.func_150297_b("mFluid", 10)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tNBT.func_74775_l("mFluid"));
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        int tDamage;
        IMetaTileEntity tMetaTile;
        if (container != null && (tMetaTile = GregTech_API.METATILEENTITIES[tDamage = container.func_77960_j()]) != null) {
            return tMetaTile.getCapacity();
        }
        return 0;
    }

    @Nullable
    private Fluid getLockedFluid(@Nonnull ItemStack container) {
        NBTTagCompound tag = container.field_77990_d;
        if (tag == null) {
            return null;
        }
        String lockedName = tag.func_74779_i("lockedFluidName");
        if (GT_Utility.isStringInvalid(lockedName)) {
            return null;
        }
        return FluidRegistry.getFluid((String)lockedName);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container != null && resource != null) {
            int tDamage = container.func_77960_j();
            IMetaTileEntity tMetaTile = GregTech_API.METATILEENTITIES[tDamage];
            if (!(tMetaTile instanceof GT_MetaTileEntity_DigitalTankBase)) {
                return 0;
            }
            if (container.field_77990_d == null) {
                container.field_77990_d = new NBTTagCompound();
            }
            FluidStack tStoredFluid = this.getFluid(container);
            int tCapacity = this.getCapacity(container);
            if (tCapacity <= 0) {
                return 0;
            }
            Fluid lockedFluid = this.getLockedFluid(container);
            if (lockedFluid != null && resource.getFluid() != lockedFluid) {
                return 0;
            }
            if (tStoredFluid != null && tStoredFluid.isFluidEqual(resource)) {
                int tAmount = Math.min(tCapacity - tStoredFluid.amount, resource.amount);
                if (doFill) {
                    FluidStack tNewFluid = new FluidStack(tStoredFluid, tAmount + tStoredFluid.amount);
                    container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                }
                return tAmount;
            }
            if (tStoredFluid == null) {
                int tAmount = Math.min(tCapacity, resource.amount);
                if (doFill) {
                    FluidStack tNewFluid = new FluidStack(resource, tAmount);
                    container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                }
                return tAmount;
            }
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container != null && container.func_77942_o()) {
            int tDamage = container.func_77960_j();
            IMetaTileEntity tMetaTile = GregTech_API.METATILEENTITIES[tDamage];
            if (!(tMetaTile instanceof GT_MetaTileEntity_DigitalTankBase)) {
                return null;
            }
            FluidStack tStoredFluid = this.getFluid(container);
            if (tStoredFluid != null) {
                int tAmount = Math.min(maxDrain, tStoredFluid.amount);
                FluidStack tNewFluid = new FluidStack(tStoredFluid, tStoredFluid.amount - tAmount);
                FluidStack tOutputFluid = new FluidStack(tStoredFluid, tAmount);
                if (doDrain) {
                    if (tNewFluid.amount <= 0) {
                        container.field_77990_d.func_82580_o("mFluid");
                        if (container.field_77990_d.func_82582_d()) {
                            container.func_77982_d(null);
                        }
                    } else {
                        container.field_77990_d.func_74782_a("mFluid", (NBTBase)tNewFluid.writeToNBT(new NBTTagCompound()));
                    }
                }
                return tOutputFluid;
            }
        }
        return null;
    }
}

