/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.Gui;
import thaumicenergistics.client.gui.EnumGuiParticles;

@SideOnly(value=Side.CLIENT)
public class GuiParticleAnimator {
    private final int distanceX;
    private final int distanceY;
    private final long timeToLive;
    private long epoch;
    private double percentComplete;
    private long delayTime = 0L;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private int framesPerSecond = 1;
    public final int startingX;
    public final int startingY;
    public final int destinationX;
    public final int destinationY;
    public final EnumGuiParticles theParticle;

    public GuiParticleAnimator(int startX, int startY, int destX, int destY, float time, @Nonnull EnumGuiParticles particle) {
        this.startingX = startX;
        this.startingY = startY;
        this.destinationX = destX;
        this.destinationY = destY;
        this.timeToLive = (long)(time * 1000.0f);
        if (this.timeToLive <= 0L) {
            this.percentComplete = 1.0;
        }
        this.epoch = System.currentTimeMillis();
        this.theParticle = particle;
        this.distanceX = destX - startX;
        this.distanceY = destY - startY;
    }

    public boolean draw(Gui gui, boolean needsPrepare) {
        if (this.percentComplete == 1.0) {
            return false;
        }
        int frame = (int)(System.currentTimeMillis() / (long)(1000 / this.framesPerSecond));
        return this.draw(gui, frame, needsPrepare);
    }

    public boolean draw(Gui gui, int particleFrame, boolean needsPrepare) {
        if (this.percentComplete == 1.0) {
            return false;
        }
        this.percentComplete = (double)(System.currentTimeMillis() - this.epoch) / (double)this.timeToLive;
        if (this.percentComplete > 1.0) {
            this.percentComplete = 1.0;
        } else if (this.percentComplete < 0.0) {
            return true;
        }
        int posX = this.startingX + (int)((double)this.distanceX * this.percentComplete);
        int posY = this.startingY + (int)((double)this.distanceY * this.percentComplete);
        this.theParticle.drawParticle(gui, posX, posY, particleFrame, this.red, this.green, this.blue, needsPrepare);
        return true;
    }

    public void reset() {
        this.epoch = System.currentTimeMillis() + this.delayTime;
        this.percentComplete = 0.0;
    }

    public void setColor(float red, float green, float blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public void setDelayTime(long timeMS) {
        this.delayTime = timeMS;
        this.epoch += this.delayTime;
    }

    public void setFPS(int fps) {
        this.framesPerSecond = fps;
    }
}

