/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.util.LangProxy;
import codechicken.nei.NEIActions;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.IInfiniteItemHandler;
import codechicken.nei.api.ItemInfo;
import com.google.common.collect.Iterables;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;

public class NEIClientUtils
extends NEIServerUtils {
    public static LangProxy lang = new LangProxy("nei");
    private static final Map<Locale, DecimalFormat> decimalFormatters = new HashMap<Locale, DecimalFormat>();
    public static final int ALT_HASH = 0x8000000;
    public static final int SHIFT_HASH = 0x4000000;
    public static final int CTRL_HASH = 0x2000000;

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static String translate(String key, Object ... params) {
        return lang.format(key, params);
    }

    public static void printChatMessage(IChatComponent msg) {
        if (NEIClientUtils.mc().field_71456_v != null) {
            NEIClientUtils.mc().field_71456_v.func_146158_b().func_146227_a(msg);
        }
    }

    private static DecimalFormat getDecimalFormat() {
        return decimalFormatters.computeIfAbsent(Locale.getDefault(Locale.Category.FORMAT), locale -> {
            DecimalFormat numberFormat = new DecimalFormat();
            numberFormat.setGroupingUsed(true);
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setRoundingMode(RoundingMode.HALF_UP);
            DecimalFormatSymbols decimalFormatSymbols = numberFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setGroupingSeparator(',');
            numberFormat.setDecimalFormatSymbols(decimalFormatSymbols);
            return numberFormat;
        });
    }

    public static String formatNumbers(BigInteger aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(long aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static String formatNumbers(double aNumber) {
        return NEIClientUtils.getDecimalFormat().format(aNumber);
    }

    public static void deleteHeldItem() {
        NEIClientUtils.deleteSlotStack(-999);
    }

    public static void dropHeldItem() {
        NEIClientUtils.mc().field_71442_b.func_78753_a(((GuiContainer)NEIClientUtils.mc().field_71462_r).field_147002_h.field_75152_c, -999, 0, 0, (EntityPlayer)NEIClientUtils.mc().field_71439_g);
    }

    public static void deleteSlotStack(int slotNumber) {
        NEIClientUtils.setSlotContents(slotNumber, null, true);
    }

    public static void decreaseSlotStack(int slotNumber) {
        ItemStack stack;
        ItemStack itemStack = stack = slotNumber == -999 ? NEIClientUtils.getHeldItem() : NEIClientUtils.mc().field_71439_g.field_71070_bA.func_75139_a(slotNumber).func_75211_c();
        if (stack == null) {
            return;
        }
        if (stack.field_77994_a == 1) {
            NEIClientUtils.deleteSlotStack(slotNumber);
        } else {
            stack = stack.func_77946_l();
            --stack.field_77994_a;
            NEIClientUtils.setSlotContents(slotNumber, stack, true);
        }
    }

    public static void deleteEverything() {
        NEICPH.sendDeleteAllItems();
    }

    public static void deleteItemsOfType(ItemStack type) {
        Container c = NEIClientUtils.getGuiContainer().field_147002_h;
        for (int i = 0; i < c.field_75151_b.size(); ++i) {
            ItemStack stack;
            Slot slot = c.func_75139_a(i);
            if (slot == null || (stack = slot.func_75211_c()) == null || stack.func_77973_b() != type.func_77973_b() || stack.func_77960_j() != type.func_77960_j()) continue;
            NEIClientUtils.setSlotContents(i, null, true);
            slot.func_75215_d(null);
        }
    }

    public static ItemStack getHeldItem() {
        return NEIClientUtils.mc().field_71439_g.field_71071_by.func_70445_o();
    }

    public static void setSlotContents(int slot, ItemStack item, boolean containerInv) {
        NEICPH.sendSetSlot(slot, item, containerInv);
        if (slot == -999) {
            NEIClientUtils.mc().field_71439_g.field_71071_by.func_70437_b(item);
        }
    }

    public static void cheatItem(ItemStack stack, int button, int mode) {
        if (!NEIClientConfig.canCheatItem(stack)) {
            return;
        }
        if (mode == -1 && button == 0 && NEIClientUtils.shiftKey() && NEIClientConfig.hasSMPCounterPart()) {
            for (IInfiniteItemHandler handler : ItemInfo.infiniteHandlers) {
                ItemStack inf;
                if (!handler.canHandleItem(stack) || (inf = handler.getInfiniteItem(stack)) == null) continue;
                NEIClientUtils.giveStack(inf, inf.field_77994_a, true);
                return;
            }
            NEIClientUtils.cheatItem(stack, button, 0);
        } else if (button == 1) {
            NEIClientUtils.giveStack(stack, 1);
        } else if (mode == 1 && stack.field_77994_a < stack.func_77976_d()) {
            NEIClientUtils.giveStack(stack, stack.func_77976_d() - stack.field_77994_a);
        } else {
            NEIClientUtils.giveStack(stack);
        }
    }

    public static void giveStack(ItemStack itemstack) {
        NEIClientUtils.giveStack(itemstack, itemstack.field_77994_a);
    }

    public static void giveStack(ItemStack itemstack, int i) {
        NEIClientUtils.giveStack(itemstack, i, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void giveStack(ItemStack base, int i, boolean infinite) {
        ItemStack stack = NEIClientUtils.copyStack(base, i);
        if (NEIClientConfig.hasSMPCounterPart()) {
            ItemStack typestack = NEIClientUtils.copyStack(stack, 1);
            if (!infinite && !NEIClientUtils.canItemFitInInventory((EntityPlayer)NEIClientUtils.mc().field_71439_g, stack) && NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
                List handlerSlots;
                GuiContainer gui = NEIClientUtils.getGuiContainer();
                try {
                    GuiInfo.readLock.lock();
                    handlerSlots = GuiInfo.guiHandlers.stream().map(handler -> handler.getItemSpawnSlots(gui, typestack)).filter(x -> x != null).collect(Collectors.toCollection(LinkedList::new));
                }
                finally {
                    GuiInfo.readLock.unlock();
                }
                int increment = typestack.func_77976_d();
                int given = 0;
                Iterator iterator = Iterables.concat((Iterable)handlerSlots).iterator();
                while (iterator.hasNext()) {
                    int slotNo = (Integer)iterator.next();
                    Slot slot = gui.field_147002_h.func_75139_a(slotNo);
                    if (!slot.func_75214_a(typestack) || !InventoryUtils.canStack((ItemStack)slot.func_75211_c(), (ItemStack)typestack)) continue;
                    int qty = Math.min(stack.field_77994_a - given, increment);
                    int current = slot.func_75216_d() ? slot.func_75211_c().field_77994_a : 0;
                    qty = Math.min(qty, slot.func_75219_a() - current);
                    ItemStack newStack = NEIClientUtils.copyStack(typestack, qty + current);
                    slot.func_75215_d(newStack);
                    NEIClientUtils.setSlotContents(slotNo, newStack, true);
                    if ((given += qty) < stack.field_77994_a) continue;
                    break;
                }
                if (given > 0) {
                    NEICPH.sendGiveItem(NEIClientUtils.copyStack(typestack, given), false, false);
                }
            } else {
                NEICPH.sendGiveItem(stack, infinite, true);
            }
        } else {
            int qty;
            for (int given = 0; given < stack.field_77994_a; given += qty) {
                qty = Math.min(stack.field_77994_a - given, stack.func_77976_d());
                NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.item"), NEIClientUtils.mc().field_71439_g.func_70005_c_(), Item.func_150891_b((Item)stack.func_77973_b()), qty, stack.func_77960_j(), stack.func_77942_o() ? stack.func_77978_p().toString() : "", Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()));
            }
        }
    }

    public static boolean canItemFitInInventory(EntityPlayer player, ItemStack itemstack) {
        return InventoryUtils.getInsertibleQuantity((InventoryRange)new InventoryRange((IInventory)player.field_71071_by, 0, 36), (ItemStack)itemstack) > 0;
    }

    public static boolean shiftKey() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public static boolean controlKey() {
        if (Minecraft.field_142025_a) {
            return Keyboard.isKeyDown((int)219) || Keyboard.isKeyDown((int)220);
        }
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static int getGamemode() {
        if (NEIClientConfig.invCreativeMode()) {
            return 2;
        }
        if (NEIClientUtils.mc().field_71442_b.func_78758_h()) {
            return 1;
        }
        if (NEIClientUtils.mc().field_71442_b.field_78779_k.func_82752_c()) {
            return 3;
        }
        return 0;
    }

    public static boolean isValidGamemode(String s) {
        return s.equals("survival") || NEIClientConfig.canPerformAction(s) && Arrays.asList(NEIClientConfig.getStringArrSetting("inventory.gamemodes")).contains(s);
    }

    public static int getNextGamemode() {
        int mode;
        int nmode = mode = NEIClientUtils.getGamemode();
        while ((nmode = (nmode + 1) % NEIActions.gameModes.length) != mode && !NEIClientUtils.isValidGamemode(NEIActions.gameModes[nmode])) {
        }
        return nmode;
    }

    public static void cycleGamemode() {
        int nmode;
        int mode = NEIClientUtils.getGamemode();
        if (mode == (nmode = NEIClientUtils.getNextGamemode())) {
            return;
        }
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendGamemode(nmode);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.creative"), NEIClientUtils.getGameType(nmode), NEIClientUtils.mc().field_71439_g.func_70005_c_());
        }
    }

    public static long getTime() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76073_f();
    }

    public static void setTime(long l) {
        NEIClientUtils.mc().field_71441_e.func_72912_H().func_76068_b(l);
    }

    public static void setHourForward(int hour) {
        long day = NEIClientUtils.getTime() / 24000L * 24000L;
        long newTime = day + 24000L + (long)(hour * 1000);
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendSetTime(hour);
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.time"), newTime);
        }
    }

    public static void sendCommand(String command, Object ... args) {
        if (command.length() == 0) {
            return;
        }
        NumberFormat numberformat = NumberFormat.getIntegerInstance();
        numberformat.setGroupingUsed(false);
        MessageFormat messageformat = new MessageFormat(command);
        for (int i = 0; i < args.length; ++i) {
            if (!(args[i] instanceof Integer) && !(args[i] instanceof Long)) continue;
            messageformat.setFormatByArgumentIndex(i, numberformat);
        }
        NEIClientUtils.mc().field_71439_g.func_71165_d(messageformat.format(args));
    }

    public static boolean isRaining() {
        return NEIClientUtils.mc().field_71441_e.func_72912_H().func_76059_o();
    }

    public static void toggleRaining() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleRain();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.rain"), NEIClientUtils.isRaining() ? 0 : 1);
        }
    }

    public static void healPlayer() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendHeal();
        } else {
            NEIClientUtils.sendCommand(NEIClientConfig.getStringSetting("command.heal"), NEIClientUtils.mc().field_71439_g.func_70005_c_());
        }
    }

    public static void toggleMagnetMode() {
        if (NEIClientConfig.hasSMPCounterPart()) {
            NEICPH.sendToggleMagnetMode();
        }
    }

    public static ArrayList<int[]> concatIntegersToRanges(List<Integer> damages) {
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        if (damages.size() == 0) {
            return ranges;
        }
        Collections.sort(damages);
        int start = -1;
        int next = 0;
        for (Integer i : damages) {
            if (start == -1) {
                start = next = i.intValue();
                continue;
            }
            if (next + 1 != i) {
                ranges.add(new int[]{start, next});
                start = next = i.intValue();
                continue;
            }
            next = i;
        }
        ranges.add(new int[]{start, next});
        return ranges;
    }

    public static ArrayList<int[]> addIntegersToRanges(List<int[]> ranges, List<Integer> damages) {
        for (int[] range : ranges) {
            for (int integer = range[0]; integer <= range[1]; ++integer) {
                damages.add(integer);
            }
        }
        return NEIClientUtils.concatIntegersToRanges(damages);
    }

    public static String cropText(FontRenderer fontRenderer, String text, int containerWidth) {
        int textWidth = fontRenderer.func_78256_a(text);
        if (textWidth > containerWidth) {
            textWidth += fontRenderer.func_78256_a("...");
            while (textWidth > containerWidth) {
                textWidth -= fontRenderer.func_78263_a(text.charAt(text.length() - 1));
                text = text.substring(0, text.length() - 1);
            }
            return text + "...";
        }
        return text;
    }

    public static boolean safeKeyDown(int keyCode) {
        try {
            return Keyboard.isKeyDown((int)keyCode);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
    }

    public static void setItemQuantity(int i) {
        NEIClientConfig.world.nbt.func_74768_a("quantity", i);
        NEIClientConfig.world.saveNBT();
    }

    public static GuiContainer getGuiContainer() {
        if (NEIClientUtils.mc().field_71462_r instanceof GuiContainer) {
            return (GuiContainer)NEIClientUtils.mc().field_71462_r;
        }
        return null;
    }

    public static boolean altKey() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }

    public static int getMetaHash() {
        if (Keyboard.getEventKeyState()) {
            int hash = 0;
            if (NEIClientUtils.altKey()) {
                hash |= 0x8000000;
            }
            if (NEIClientUtils.shiftKey()) {
                hash |= 0x4000000;
            }
            if (NEIClientUtils.controlKey()) {
                hash |= 0x2000000;
            }
            return hash;
        }
        return 0;
    }

    public static int getKeyHash() {
        int keycode;
        if (Keyboard.getEventKeyState() && (keycode = Keyboard.getEventKey()) != 42 && keycode != 54 && keycode != 29 && keycode != 157 && keycode != 56 && keycode != 184) {
            return NEIClientUtils.getMetaHash() + keycode;
        }
        return 0;
    }

    public static void playClickSound() {
        NEIClientUtils.mc().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
    }

    public static void reportErrorBuffered(Throwable e, Set<String> buffer, String cause) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackTrace = cause + sw;
        if (buffer.contains(stackTrace)) {
            return;
        }
        System.err.println("Error while rendering: " + cause);
        e.printStackTrace();
        buffer.add(stackTrace);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ChatComponentTranslation chat = new ChatComponentTranslation("nei.chat.render.error", new Object[0]);
            chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            player.func_146105_b((IChatComponent)chat);
        }
    }

    public static void reportErrorBuffered(Throwable e, Set<String> buffer, ItemStack cause) {
        if (cause != null) {
            NEIClientUtils.reportErrorBuffered(e, buffer, cause.toString());
        } else {
            NEIClientUtils.reportErrorBuffered(e, buffer, "null");
        }
    }
}

