/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.Widget;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public abstract class PanelWidget
extends Widget {
    protected static final int PADDING = 2;
    public ItemStack draggedStack;
    public int mouseDownSlot = -1;
    public Button pagePrev;
    public Button pageNext;
    public Label pageLabel;
    protected ItemsGrid grid;

    public ArrayList<ItemStack> getItems() {
        return this.grid.getItems();
    }

    public ItemsGrid getGrid() {
        return this.grid;
    }

    public void init() {
        this.pageLabel = new Label("0/0", true);
        this.pagePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    PanelWidget.this.grid.shiftPage(-1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.pageNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (!rightclick) {
                    PanelWidget.this.grid.shiftPage(1);
                    return true;
                }
                return false;
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
    }

    public abstract String getLabelText();

    protected abstract String getPositioningSettingName();

    public abstract int getMarginLeft(GuiContainer var1);

    public abstract int getMarginTop(GuiContainer var1);

    public abstract int getWidth(GuiContainer var1);

    public abstract int getHeight(GuiContainer var1);

    public void resize(GuiContainer gui) {
        Rectangle4i margin = new Rectangle4i(this.getMarginLeft(gui), this.getMarginTop(gui), this.getWidth(gui), this.getHeight(gui));
        int minWidth = 90;
        int minHeight = 162;
        String settingName = this.getPositioningSettingName();
        int paddingLeft = (int)Math.ceil((double)(margin.w * NEIClientConfig.getSetting(settingName + ".left").getIntValue()) / 100000.0);
        int paddingTop = (int)Math.ceil((double)(margin.h * NEIClientConfig.getSetting(settingName + ".top").getIntValue()) / 100000.0);
        int paddingRight = (int)Math.ceil((double)(margin.w * NEIClientConfig.getSetting(settingName + ".right").getIntValue()) / 100000.0);
        int paddingBottom = (int)Math.ceil((double)(margin.h * NEIClientConfig.getSetting(settingName + ".bottom").getIntValue()) / 100000.0);
        int deltaHeight = Math.min(0, margin.h - paddingTop - paddingBottom - 162) / 2;
        paddingLeft = Math.min(paddingLeft, Math.max(0, margin.w - paddingRight - 90));
        paddingRight = Math.min(paddingRight, Math.max(0, margin.w - paddingLeft - 90));
        paddingTop = Math.min(margin.h - 162, Math.max(0, paddingTop + deltaHeight));
        paddingBottom = Math.min(margin.h - paddingTop - 162, Math.max(0, paddingBottom - deltaHeight));
        this.x = margin.x + paddingLeft;
        this.y = margin.y + paddingTop;
        this.w = margin.w - paddingLeft - paddingRight;
        this.h = margin.h - paddingTop - paddingBottom;
        int header = this.resizeHeader(gui);
        int footer = this.resizeFooter(gui);
        this.grid.setGridSize(this.x, this.y + header, this.w, this.h - header - footer);
        this.grid.refresh(gui);
    }

    protected int resizeHeader(GuiContainer gui) {
        int paddingLeft;
        int BUTTON_SIZE = 16;
        int paddingRight = 0;
        for (paddingLeft = 0; paddingLeft < this.w && GuiInfo.hideItemPanelSlot(gui, new Rectangle4i(this.x + paddingLeft, this.y, 18, 18)); paddingLeft += 18) {
        }
        while (paddingRight < this.w && GuiInfo.hideItemPanelSlot(gui, new Rectangle4i(this.x + this.w - paddingRight - 18, this.y, 18, 18))) {
            paddingRight += 18;
        }
        if (paddingLeft + paddingRight >= this.w) {
            return 0;
        }
        this.pageNext.w = 16;
        this.pagePrev.w = 16;
        this.pageNext.h = 16;
        this.pagePrev.h = 16;
        this.pagePrev.y = this.pageNext.y = this.y;
        this.pagePrev.x = this.x + paddingLeft;
        this.pageNext.x = this.x + this.w - this.pageNext.w - paddingRight;
        this.pageLabel.x = this.x + paddingLeft + (this.w - paddingLeft - paddingRight) / 2;
        this.pageLabel.y = this.y + 5;
        this.pageLabel.text = this.getLabelText();
        return 18;
    }

    protected abstract int resizeFooter(GuiContainer var1);

    public void setVisible() {
        if (this.grid.getPerPage() > 0) {
            LayoutManager.addWidget(this.pagePrev);
            LayoutManager.addWidget(this.pageNext);
            LayoutManager.addWidget(this.pageLabel);
            this.grid.setVisible();
        }
    }

    @Override
    public void update() {
        this.grid.update();
    }

    @Override
    public void draw(int mousex, int mousey) {
        this.grid.draw(mousex, mousey);
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        if (this.draggedStack != null) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.draggedStack);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
    }

    @Override
    public void postDrawTooltips(int mx, int my, List<String> tooltip) {
        this.grid.postDrawTooltips(mx, my, tooltip);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        ItemPanel.ItemPanelSlot mouseOverSlot;
        if (this.mouseDownSlot >= 0 && this.draggedStack == null && NEIClientUtils.getHeldItem() == null && NEIClientConfig.hasSMPCounterPart() && ((mouseOverSlot = this.getSlotMouseOver(mousex, mousey)) == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 500L)) {
            this.draggedStack = this.getDraggedStackWithQuantity(this.mouseDownSlot);
            this.mouseDownSlot = -1;
        }
    }

    protected abstract ItemStack getDraggedStackWithQuantity(int var1);

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        if (this.handleClickExt(mousex, mousey, button)) {
            return true;
        }
        if (NEIClientUtils.getHeldItem() != null) {
            if (!this.grid.contains(mousex, mousey)) {
                return false;
            }
            if (NEIClientConfig.canPerformAction("delete") && NEIClientConfig.canPerformAction("item")) {
                if (button == 1) {
                    NEIClientUtils.decreaseSlotStack(-999);
                } else {
                    NEIClientUtils.deleteHeldItem();
                }
            } else {
                NEIClientUtils.dropHeldItem();
            }
            return true;
        }
        ItemPanel.ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null) {
            if (button == 2) {
                if (hoverSlot.item != null) {
                    this.draggedStack = this.getDraggedStackWithQuantity(hoverSlot.slotIndex);
                }
            } else {
                this.mouseDownSlot = hoverSlot.slotIndex;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClickExt(int mouseX, int mouseY, int button) {
        if (ItemPanels.itemPanel.draggedStack != null && ItemPanels.bookmarkPanel.contains(mouseX, mouseY)) {
            ItemPanels.bookmarkPanel.addOrRemoveItem(ItemPanels.itemPanel.draggedStack, null, null, false, true);
            ItemPanels.itemPanel.draggedStack = null;
            return true;
        }
        if (ItemPanels.itemPanel.draggedStack != null) {
            return ItemPanels.itemPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        if (ItemPanels.bookmarkPanel.draggedStack != null) {
            return ItemPanels.bookmarkPanel.handleDraggedClick(mouseX, mouseY, button);
        }
        if (NEIClientUtils.getHeldItem() != null) {
            ItemStack draggedStack = NEIClientUtils.getHeldItem().func_77946_l();
            return this.handleGUIContainerClick(draggedStack, mouseX, mouseY, button);
        }
        return false;
    }

    protected boolean handleDraggedClick(int mouseX, int mouseY, int button) {
        if (this.draggedStack == null) {
            return false;
        }
        if (this.handleGUIContainerClick(this.draggedStack, mouseX, mouseY, button)) {
            if (this.draggedStack.field_77994_a == 0) {
                this.draggedStack = null;
            }
            return true;
        }
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        if (mouseX < gui.field_147003_i || mouseY < gui.field_147009_r || mouseX >= gui.field_147003_i + gui.field_146999_f || mouseY >= gui.field_147009_r + gui.field_147000_g) {
            this.draggedStack = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleGUIContainerClick(ItemStack draggedStack, int mouseX, int mouseY, int button) {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        boolean handled = false;
        try {
            GuiInfo.readLock.lock();
            for (INEIGuiHandler handler : GuiInfo.guiHandlers) {
                if (!handler.handleDragNDrop(gui, mouseX, mouseY, draggedStack, button)) continue;
                handled = true;
                break;
            }
        }
        finally {
            GuiInfo.readLock.unlock();
        }
        return handled;
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        ItemPanel.ItemPanelSlot hoverSlot = this.getSlotMouseOver(mousex, mousey);
        if (hoverSlot != null && hoverSlot.slotIndex == this.mouseDownSlot && this.draggedStack == null) {
            ItemStack item = hoverSlot.item;
            if (NEIController.manager.window instanceof GuiRecipe || !NEIClientConfig.canCheatItem(item)) {
                if (button == 0) {
                    GuiCraftingRecipe.openRecipeGui("item", item);
                } else if (button == 1) {
                    GuiUsageRecipe.openRecipeGui("item", item);
                }
                this.mouseDownSlot = -1;
                return;
            }
            NEIClientUtils.cheatItem(this.getDraggedStackWithQuantity(hoverSlot.slotIndex), button, -1);
        }
        this.mouseDownSlot = -1;
    }

    @Override
    public boolean onMouseWheel(int i, int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        this.grid.shiftPage(-i);
        return true;
    }

    @Override
    public boolean handleKeyPress(int keyID, char keyChar) {
        if (NEIClientConfig.isKeyHashDown("gui.next")) {
            this.grid.shiftPage(1);
            return true;
        }
        if (NEIClientConfig.isKeyHashDown("gui.prev")) {
            this.grid.shiftPage(-1);
            return true;
        }
        return false;
    }

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousex, mousey);
        return slot == null ? null : slot.item;
    }

    public ItemPanel.ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        return this.grid.getSlotMouseOver(mousex, mousey);
    }

    public int getPage() {
        return this.grid.getPage();
    }

    public int getNumPages() {
        return this.grid.getNumPages();
    }

    @Override
    public boolean contains(int px, int py) {
        return this.grid.contains(px, py);
    }
}

