/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.container;

import com.google.common.collect.ArrayListMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.IgnoreContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.blay09.mods.cookingforblockheads.KitchenMultiBlock;
import net.blay09.mods.cookingforblockheads.api.kitchen.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.container.comparator.ComparatorName;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryCraftBook;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryRecipeBook;
import net.blay09.mods.cookingforblockheads.container.inventory.InventoryRecipeBookMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.SlotCraftMatrix;
import net.blay09.mods.cookingforblockheads.container.slot.SlotRecipe;
import net.blay09.mods.cookingforblockheads.network.MessageClickRecipe;
import net.blay09.mods.cookingforblockheads.network.MessageRecipeInfo;
import net.blay09.mods.cookingforblockheads.network.MessageSyncList;
import net.blay09.mods.cookingforblockheads.network.NetworkHandler;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.food.FoodRecipe;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;

@IgnoreContainer
public class ContainerRecipeBook
extends Container {
    private final EntityPlayer player;
    private boolean allowCrafting;
    private boolean allowSmelting;
    private final boolean isClientSide;
    private final InventoryRecipeBook recipeBook;
    private final SlotRecipe[] recipeBookSlots = new SlotRecipe[12];
    private final InventoryRecipeBookMatrix craftMatrix;
    private final SlotCraftMatrix[] craftMatrixSlots = new SlotCraftMatrix[9];
    private final ArrayListMultimap<String, FoodRecipe> availableRecipes = ArrayListMultimap.create();
    private final List<ItemStack> sortedRecipes = new ArrayList<ItemStack>();
    private String searchTerm = "";
    private final InventoryCraftBook craftBook;
    private Comparator<ItemStack> currentSort = new ComparatorName();
    private int scrollOffset;
    private boolean isFurnaceRecipe;
    private boolean isSelectionDirty;
    private boolean isRecipeListDirty;
    private int syncSlotIndex = -1;
    private int currentSlotIndex = -1;
    private FoodRecipe currentRecipe;
    private boolean hasVariants;
    private boolean isMissingTools;
    private boolean isMissingOven;
    private String currentRecipeKey;
    private List<FoodRecipe> currentRecipeList;
    private int currentRecipeIdx;
    private boolean noFilter;
    private final List<IKitchenItemProvider> emptyProviderList = new ArrayList<IKitchenItemProvider>();
    private final List<IInventory> playerInventoryList = new ArrayList<IInventory>();
    private KitchenMultiBlock kitchenMultiBlock;

    public ContainerRecipeBook(EntityPlayer player, boolean isClientSide) {
        int j;
        int i;
        this.player = player;
        this.playerInventoryList.add((IInventory)player.field_71071_by);
        this.allowCrafting = false;
        this.allowSmelting = false;
        this.isClientSide = isClientSide;
        this.craftMatrix = new InventoryRecipeBookMatrix();
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                this.craftMatrixSlots[j + i * 3] = new SlotCraftMatrix(player, this.craftMatrix, j + i * 3, 24 + j * 18, 20 + i * 18);
                this.craftMatrixSlots[j + i * 3].setSourceInventories(this.playerInventoryList);
                this.craftMatrixSlots[j + i * 3].setItemProviders(this.emptyProviderList);
                this.func_75146_a(this.craftMatrixSlots[j + i * 3]);
            }
        }
        this.recipeBook = new InventoryRecipeBook();
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 3; ++j) {
                this.recipeBookSlots[j + i * 3] = new SlotRecipe(this.recipeBook, j + i * 3, 102 + j * 18, 11 + i * 18);
                this.func_75146_a(this.recipeBookSlots[j + i * 3]);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, j + i * 9 + 9, 8 + j * 18, 92 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, i, 8 + i * 18, 150));
        }
        this.updateRecipeList();
        this.craftBook = new InventoryCraftBook(this);
        this.craftBook.setItemProviders(this.emptyProviderList);
        this.craftBook.setInventories(this.playerInventoryList);
        this.findAvailableRecipes();
    }

    public void setCraftMatrix(FoodRecipe recipe) {
        if (recipe != null) {
            for (SlotCraftMatrix previewSlot : this.craftMatrixSlots) {
                previewSlot.setIngredient(null);
                previewSlot.setEnabled(false);
                if (this.isClientSide) continue;
                previewSlot.updateVisibleStacks();
            }
            this.isFurnaceRecipe = recipe.isSmeltingRecipe();
            if (this.isFurnaceRecipe) {
                this.craftMatrixSlots[4].setIngredient(recipe.getCraftMatrix().get(0));
                this.craftMatrixSlots[4].setEnabled(true);
                if (!this.isClientSide) {
                    this.craftMatrixSlots[4].updateVisibleStacks();
                }
            } else {
                int offset = 0;
                if (recipe.getRecipeWidth() == 1) {
                    ++offset;
                }
                if (recipe.getRecipeHeight() == 1) {
                    offset += 3;
                }
                for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                    int origX = i % recipe.getRecipeWidth();
                    int origY = i / recipe.getRecipeWidth();
                    int targetIdx = origY * 3 + origX;
                    targetIdx += offset;
                    if (i < recipe.getCraftMatrix().size()) {
                        this.craftMatrixSlots[targetIdx].setIngredient(recipe.getCraftMatrix().get(i));
                    }
                    this.craftMatrixSlots[i].setEnabled(true);
                    if (this.isClientSide) continue;
                    this.craftMatrixSlots[i].updateVisibleStacks();
                }
            }
        }
    }

    public boolean hasVariants() {
        return this.hasVariants;
    }

    public void setScrollOffset(int scrollOffset) {
        this.scrollOffset = scrollOffset;
        this.updateRecipeList(false);
    }

    public void search(String term) {
        this.searchTerm = term;
    }

    public void updateRecipeList(boolean resetCraftMatrix) {
        boolean noRecipes = this.getAvailableRecipeCount() == 0;
        for (int i = 0; i < this.recipeBook.func_70302_i_(); ++i) {
            ItemStack lastItemStack = this.recipeBook.func_70301_a(i);
            int recipeIdx = i + this.scrollOffset * 3;
            if (recipeIdx < this.sortedRecipes.size()) {
                this.recipeBook.setFoodItem(i, this.availableRecipes.get((Object)this.sortedRecipes.get(recipeIdx).toString()));
            } else {
                this.recipeBook.setFoodItem(i, null);
            }
            ItemStack itemStack = this.recipeBook.func_70301_a(i);
            if (recipeIdx == this.currentSlotIndex && !ItemStack.func_77989_b((ItemStack)lastItemStack, (ItemStack)itemStack) && resetCraftMatrix) {
                this.currentSlotIndex = -1;
                this.currentRecipe = null;
                this.currentRecipeList = null;
                this.setCraftMatrix(null);
            }
            this.recipeBookSlots[i].func_75215_d(itemStack);
            this.recipeBookSlots[i].setEnabled(!noRecipes);
        }
        if (noRecipes) {
            this.setCraftMatrix(null);
            if (!this.isClientSide) {
                this.currentRecipeList = null;
                this.currentRecipeIdx = -1;
            }
        } else if (!this.isClientSide) {
            this.currentRecipeList = this.availableRecipes.get((Object)this.currentRecipeKey);
        }
    }

    public void updateRecipeList() {
        this.updateRecipeList(true);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_75144_a(int slotIdx, int button, int mode, EntityPlayer player) {
        if (mode == 6) {
            mode = 0;
        }
        if ((mode == 0 || mode == 1) && this.isClientSide) {
            this.clickRecipe(slotIdx, mode == 1);
            NetworkHandler.instance.sendToServer((IMessage)new MessageClickRecipe(slotIdx, this.scrollOffset, mode == 1));
        }
        return super.func_75144_a(slotIdx, button, mode, player);
    }

    public void clickRecipe(int slotIdx, boolean shiftClick) {
        SlotRecipe slot;
        if (slotIdx > 0 && slotIdx < this.field_75151_b.size() && this.field_75151_b.get(slotIdx) instanceof SlotRecipe && (slot = (SlotRecipe)((Object)this.field_75151_b.get(slotIdx))).func_75211_c() != null) {
            if (!this.isClientSide && this.canClickCraft(this.scrollOffset * 3 + slot.getSlotIndex())) {
                this.tryCraft(this.player, this.currentRecipe, shiftClick);
                return;
            }
            if (!this.isClientSide && !this.isMissingOven && this.canClickSmelt(this.scrollOffset * 3 + slot.getSlotIndex())) {
                this.trySmelt(this.player, this.currentRecipe, shiftClick);
                return;
            }
            int oldSlotIndex = this.currentSlotIndex;
            this.currentSlotIndex = this.scrollOffset * 3 + slot.getSlotIndex();
            if (oldSlotIndex != this.currentSlotIndex && !this.isClientSide) {
                this.currentRecipeKey = this.recipeBook.func_70301_a(slot.getSlotIndex()).toString();
                this.currentRecipeList = this.recipeBook.getFoodList(slot.getSlotIndex());
                this.currentRecipeIdx = 0;
                this.currentRecipe = this.currentRecipeList.get(this.currentRecipeIdx);
                this.setCraftMatrix(this.currentRecipe);
                this.isSelectionDirty = true;
            }
        }
    }

    private void trySmelt(EntityPlayer player, FoodRecipe recipe, boolean isShiftDown) {
        if (!recipe.isSmeltingRecipe()) {
            return;
        }
        List<IInventory> sourceInventories = this.kitchenMultiBlock.getSourceInventories(player.field_71071_by);
        for (int i = 0; i < sourceInventories.size(); ++i) {
            for (int j = 0; j < sourceInventories.get(i).func_70302_i_(); ++j) {
                ItemStack itemStack = sourceInventories.get(i).func_70301_a(j);
                if (itemStack == null) continue;
                for (ItemStack ingredientStack : recipe.getCraftMatrix().get(0).getItemStacks()) {
                    if (!CookingRegistry.areItemStacksEqualWithWildcard(itemStack, ingredientStack)) continue;
                    int count = isShiftDown ? Math.min(itemStack.field_77994_a, ingredientStack.func_77976_d()) : 1;
                    ItemStack restStack = this.kitchenMultiBlock.smeltItem(itemStack, count);
                    sourceInventories.get(i).func_70299_a(j, restStack);
                    if (i == 0) {
                        if (j < 9) {
                            ((EntityPlayerMP)player).func_71111_a((Container)this, 48 + j, restStack);
                        } else {
                            ((EntityPlayerMP)player).func_71111_a((Container)this, 21 + j - 9, restStack);
                        }
                    }
                    player.field_71071_by.func_70296_d();
                    return;
                }
            }
        }
    }

    private void tryCraft(EntityPlayer player, FoodRecipe recipe, boolean isShiftDown) {
        if (recipe.isSmeltingRecipe()) {
            return;
        }
        this.craftBook.prepareRecipe(player, recipe);
        if (!isShiftDown) {
            if (this.craftBook.canMouseItemHold(player, recipe)) {
                ItemStack craftingResult = this.craftBook.craft(player, recipe);
                if (craftingResult != null) {
                    ItemStack mouseItem = player.field_71071_by.func_70445_o();
                    if (mouseItem != null) {
                        mouseItem.field_77994_a += craftingResult.field_77994_a;
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(-1, 0, mouseItem));
                    } else {
                        player.field_71071_by.func_70437_b(craftingResult);
                        ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(-1, 0, craftingResult));
                    }
                }
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
            }
        } else {
            ItemStack craftingResult;
            for (int crafted = 0; crafted < 64 && (craftingResult = this.craftBook.craft(player, recipe)) != null; crafted += craftingResult.field_77994_a) {
                if (player.field_71071_by.func_70441_a(craftingResult)) continue;
                if (player.field_71071_by.func_70445_o() == null) {
                    player.field_71071_by.func_70437_b(craftingResult);
                    break;
                }
                player.func_71019_a(craftingResult, false);
                break;
            }
            player.field_71071_by.func_70296_d();
            player.field_71069_bz.func_75142_b();
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int i) {
        ItemStack itemStack = null;
        Slot slot = (Slot)this.field_75151_b.get(i);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (i >= 48 && i < 57 ? !this.func_75135_a(slotStack, 21, 48, false) : i >= 21 && i < 48 && !this.func_75135_a(slotStack, 48, 57, false)) {
                return null;
            }
            if (slotStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.field_77994_a == itemStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, slotStack);
        }
        return itemStack;
    }

    public int getAvailableRecipeCount() {
        return this.sortedRecipes.size();
    }

    public boolean isFurnaceRecipe() {
        return this.isFurnaceRecipe;
    }

    public boolean hasSelection() {
        return this.currentRecipe != null;
    }

    public boolean canClickSmelt(int slotIndex) {
        return this.allowSmelting && this.currentSlotIndex == slotIndex && this.currentRecipe != null && this.currentRecipe.isSmeltingRecipe();
    }

    public boolean canClickCraft(int slotIndex) {
        return this.allowCrafting && this.currentSlotIndex == slotIndex && this.currentRecipe != null && !this.currentRecipe.isSmeltingRecipe();
    }

    public boolean isMissingTools() {
        return this.isMissingTools;
    }

    public boolean isRecipeListDirty() {
        return this.isRecipeListDirty;
    }

    public void markDirty(boolean dirty) {
        this.isRecipeListDirty = dirty;
    }

    @SideOnly(value=Side.CLIENT)
    public void setAvailableItems(List<ItemStack> sortedRecipes, ArrayListMultimap<String, FoodRecipe> availableRecipes) {
        this.sortedRecipes.clear();
        this.sortedRecipes.addAll(sortedRecipes);
        this.availableRecipes.clear();
        this.availableRecipes.putAll(availableRecipes);
        this.search(this.searchTerm);
        this.markDirty(true);
    }

    public boolean gotRecipeInfo() {
        return this.syncSlotIndex == this.currentSlotIndex;
    }

    public void findAvailableRecipes() {
        this.availableRecipes.clear();
        this.sortedRecipes.clear();
        for (FoodRecipe foodRecipe : CookingRegistry.getFoodRecipes()) {
            ItemStack foodStack = foodRecipe.getOutputItem();
            if (foodStack == null || !this.noFilter && !CookingRegistry.areIngredientsAvailableFor(foodRecipe.getCraftMatrix(), this.kitchenMultiBlock != null ? this.kitchenMultiBlock.getSourceInventories(this.player.field_71071_by) : this.playerInventoryList, this.kitchenMultiBlock != null ? this.kitchenMultiBlock.getItemProviders() : this.emptyProviderList)) continue;
            String foodStackString = foodStack.toString();
            if (!this.availableRecipes.containsKey((Object)foodStackString)) {
                this.sortedRecipes.add(foodStack);
            }
            this.availableRecipes.put((Object)foodStackString, (Object)foodRecipe);
        }
        this.isRecipeListDirty = true;
    }

    public void sortRecipes(Comparator<ItemStack> comparator) {
        if (this.currentSort != comparator) {
            this.sortingChanged();
        }
        this.currentSort = comparator;
        this.sortedRecipes.sort(comparator);
        this.updateRecipeList();
        this.isRecipeListDirty = true;
    }

    public void prevRecipe() {
        if (this.currentRecipeList != null) {
            --this.currentRecipeIdx;
            if (this.currentRecipeIdx < 0) {
                this.currentRecipeIdx = this.currentRecipeList.size() - 1;
            }
            this.currentRecipe = this.currentRecipeList.get(this.currentRecipeIdx);
            this.setCraftMatrix(this.currentRecipe);
            this.isSelectionDirty = true;
        }
    }

    public void nextRecipe() {
        if (this.currentRecipeList != null) {
            ++this.currentRecipeIdx;
            if (this.currentRecipeIdx >= this.currentRecipeList.size()) {
                this.currentRecipeIdx = 0;
            }
            this.currentRecipe = this.currentRecipeList.get(this.currentRecipeIdx);
            this.setCraftMatrix(this.currentRecipe);
            this.isSelectionDirty = true;
        }
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (!this.isClientSide) {
            if (this.player.field_71071_by.field_70459_e) {
                this.findAvailableRecipes();
                this.sortRecipes(this.currentSort);
                this.player.field_71071_by.field_70459_e = false;
            }
            if (this.isSelectionDirty) {
                this.isSelectionDirty = false;
                if (this.currentRecipe != null && !this.currentRecipe.isSmeltingRecipe()) {
                    this.craftBook.prepareRecipe(this.player, this.currentRecipe);
                    this.isMissingTools = !this.craftBook.matches(this.player.field_70170_p);
                } else {
                    this.isMissingTools = false;
                }
                this.hasVariants = this.currentRecipeList != null && this.currentRecipeList.size() > 1;
                this.isMissingOven = this.kitchenMultiBlock == null || !this.kitchenMultiBlock.hasSmeltingProvider();
                NetworkHandler.instance.sendTo((IMessage)new MessageRecipeInfo(this.currentSlotIndex, this.currentRecipe, this.isMissingTools, this.hasVariants, this.isMissingOven), (EntityPlayerMP)this.player);
            }
            if (this.isRecipeListDirty) {
                NetworkHandler.instance.sendTo((IMessage)new MessageSyncList(this.sortedRecipes, this.availableRecipes), (EntityPlayerMP)this.player);
                this.isRecipeListDirty = false;
            }
            for (SlotCraftMatrix previewSlot : this.craftMatrixSlots) {
                previewSlot.update();
            }
        }
    }

    public ContainerRecipeBook allowCrafting() {
        this.allowCrafting = true;
        return this;
    }

    public ContainerRecipeBook allowSmelting() {
        this.allowSmelting = true;
        return this;
    }

    public ContainerRecipeBook setNoFilter() {
        this.noFilter = true;
        for (SlotCraftMatrix slotCraftMatrix : this.craftMatrixSlots) {
            slotCraftMatrix.setNoFilter(true);
        }
        this.findAvailableRecipes();
        this.sortRecipes(this.currentSort);
        return this;
    }

    public ContainerRecipeBook setKitchenMultiBlock(KitchenMultiBlock kitchenMultiBlock) {
        this.kitchenMultiBlock = kitchenMultiBlock;
        this.findAvailableRecipes();
        this.sortRecipes(this.currentSort);
        List<IInventory> sourceInventories = kitchenMultiBlock.getSourceInventories(this.player.field_71071_by);
        for (SlotCraftMatrix craftMatrixSlot : this.craftMatrixSlots) {
            craftMatrixSlot.setSourceInventories(sourceInventories);
            craftMatrixSlot.setItemProviders(kitchenMultiBlock.getItemProviders());
        }
        this.craftBook.setInventories(sourceInventories);
        this.craftBook.setItemProviders(kitchenMultiBlock.getItemProviders());
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void setSelectedRecipe(int currentSlotIndex, FoodRecipe currentRecipe, boolean hasVariants, boolean isMissingTools, boolean isMissingOven) {
        this.currentSlotIndex = currentSlotIndex;
        this.syncSlotIndex = currentSlotIndex;
        this.currentRecipe = currentRecipe;
        this.hasVariants = hasVariants;
        this.isMissingTools = isMissingTools;
        this.isMissingOven = isMissingOven;
        this.setCraftMatrix(currentRecipe);
    }

    public boolean isMissingOven() {
        return this.isMissingOven;
    }

    public void sortingChanged() {
        this.currentSlotIndex = -1;
        this.syncSlotIndex = -1;
    }
}

