/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.utils;

import java.lang.reflect.Field;

public class TypedField<T> {
    private Field field;
    private Class<T> cls;

    public TypedField(Field field, Class<T> cls) {
        this.field = field;
        this.cls = cls;
    }

    public T get(Object obj) {
        try {
            Object res = this.field.get(obj);
            if (this.cls.isInstance(res)) {
                return (T)res;
            }
            throw new RuntimeException(String.format("Wrong field type. Expected %s, got %s", this.cls, res.getClass()));
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> TypedField<R> from(Class<?> cls, String name, Class<R> result) throws NoSuchFieldException {
        return new TypedField<R>(cls.getField(name), result);
    }
}

