/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mantle.blocks.abstracts.InventorySlab;
import mantle.blocks.iface.IActiveLogic;
import mantle.blocks.iface.IFacingLogic;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.logic.FurnaceLogic;

public class FurnaceSlab
extends InventorySlab {
    public FurnaceSlab(Material material) {
        super(material);
        this.func_149647_a(TConstructRegistry.blockTab);
        this.func_149711_c(3.5f);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (metadata % 8 == 0) {
            return new FurnaceLogic();
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        return 8;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public String[] getTextureNames() {
        return new String[]{"furnaceslab_front", "furnaceslab_front_active", "furnaceslab_side", "furnace_top"};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity logic = world.func_147438_o(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z) % 8;
        if (meta == 0) {
            if (side == direction) {
                if (((IActiveLogic)logic).getActive()) {
                    return this.icons[1];
                }
                return this.icons[0];
            }
            if (side > 1) {
                return this.icons[2];
            }
            return this.icons[3];
        }
        return this.icons[0];
    }

    public int getTextureIndex(int side) {
        if (side == 0 || side == 1) {
            return 3;
        }
        if (side == 3) {
            return 0;
        }
        return 2;
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    public void func_149651_a(IIconRegister iconRegister) {
        String[] textureNames = this.getTextureNames();
        this.icons = new IIcon[textureNames.length];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = i == 3 ? iconRegister.func_94245_a("minecraft:" + textureNames[i]) : iconRegister.func_94245_a("tinker:" + textureNames[i]);
        }
    }

    public TileEntity func_149915_a(World var1, int metadata) {
        if (metadata % 8 == 0) {
            return new FurnaceLogic();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntity logic = world.func_147438_o(x, y, z);
        int direction = logic instanceof IFacingLogic ? (int)((IFacingLogic)logic).getRenderDirection() : 0;
        int meta = world.func_72805_g(x, y, z);
        int metaType = meta % 8;
        int metaPos = meta / 8;
        if (metaType == 0 && ((IActiveLogic)logic).getActive()) {
            float offset = random.nextFloat() * 0.6f - 0.3f;
            float offsetY = random.nextFloat() * 6.0f / 16.0f;
            if (metaPos == 1) {
                offsetY += 0.5f;
            }
            if (direction == 4) {
                world.func_72869_a("smoke", (double)((float)x - 0.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)((float)x - 0.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
            } else if (direction == 5) {
                world.func_72869_a("smoke", (double)((float)x + 1.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)((float)x + 1.02f), (double)((float)y + offsetY), (double)((float)z + offset + 0.5f), 0.0, 0.0, 0.0);
            } else if (direction == 2) {
                world.func_72869_a("smoke", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z - 0.02f), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z - 0.02f), 0.0, 0.0, 0.0);
            } else if (direction == 3) {
                world.func_72869_a("smoke", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z + 1.02f), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)((float)x + offset + 0.5f), (double)((float)y + offsetY), (double)((float)z + 1.02f), 0.0, 0.0, 0.0);
            }
        }
    }
}

