/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import mantle.common.network.AbstractPacket;
import mantle.common.network.PacketUpdateTE;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.TConstruct;
import tconstruct.smeltery.inventory.SmelteryContainer;
import tconstruct.smeltery.logic.SmelteryLogic;

public class SmelteryPacket
extends AbstractPacket {
    int dimension;
    int x;
    int y;
    int z;
    int fluidID;
    boolean isShiftPressed;

    public SmelteryPacket() {
    }

    public SmelteryPacket(int dimension, int x, int y, int z, boolean isShiftPressed, int fluidID) {
        this.dimension = dimension;
        this.x = x;
        this.y = y;
        this.z = z;
        this.isShiftPressed = isShiftPressed;
        this.fluidID = fluidID;
    }

    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.dimension);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.isShiftPressed);
        buffer.writeInt(this.fluidID);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.dimension = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.isShiftPressed = buffer.readBoolean();
        this.fluidID = buffer.readInt();
    }

    public void handleClientSide(EntityPlayer player) {
    }

    public void handleServerSide(EntityPlayer player) {
        if (player.field_71070_bA instanceof SmelteryContainer) {
            SmelteryContainer container = (SmelteryContainer)player.field_71070_bA;
            SmelteryLogic logic = container.logic;
            if (logic != null && logic.func_145830_o() && logic.func_145831_w().field_73011_w.field_76574_g == this.dimension && logic.field_145851_c == this.x && logic.field_145848_d == this.y && logic.field_145849_e == this.z) {
                FluidStack temp = null;
                for (FluidStack liquid : logic.moltenMetal) {
                    if (liquid.getFluidID() != this.fluidID) continue;
                    temp = liquid;
                }
                if (temp != null) {
                    logic.moltenMetal.remove(temp);
                    if (this.isShiftPressed) {
                        logic.moltenMetal.add(temp);
                    } else {
                        logic.moltenMetal.add(0, temp);
                    }
                }
                NBTTagCompound data = new NBTTagCompound();
                logic.func_145841_b(data);
                TConstruct.packetPipeline.sendToDimension((AbstractPacket)new PacketUpdateTE(this.x, this.y, this.z, data), this.dimension);
            }
        }
    }
}

