/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.client.renderers.entity;

import java.awt.Color;
import makeo.gadomancy.api.golems.cores.AdditionalGolemCore;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;
import thaumcraft.client.renderers.models.entities.ModelGolem;
import thaumcraft.common.entities.golems.EntityGolemBase;

public class RenderGolemHelper {
    private RenderGolemHelper() {
    }

    public static void renderCore(EntityGolemBase golem, AdditionalGolemCore core) {
        GL11.glPushMatrix();
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0875f, (float)-0.96f, (float)(0.15f + (golem.getGolemDecoration().contains("P") ? 0.03f : 0.0f)));
        GL11.glScaled((double)0.175, (double)0.175, (double)0.175);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        ItemStack coreItem = core.getItem();
        IIcon icon = coreItem.func_77973_b().getIcon(coreItem, 0);
        float f1 = icon.func_94212_f();
        float f2 = icon.func_94206_g();
        float f3 = icon.func_94209_e();
        float f4 = icon.func_94210_h();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)f1, (float)f2, (float)f3, (float)f4, (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.2f);
        GL11.glPopMatrix();
    }

    public static boolean requiresRenderFix(EntityGolemBase golem) {
        ItemStack item = golem.getCarriedForDisplay();
        byte core = golem.getCore();
        return item != null && item.func_77973_b().func_77623_v() && core != 5 && core != 6 && core != 11;
    }

    public static void renderCarriedItemsFix(EntityGolemBase golem) {
        GL11.glPushMatrix();
        GL11.glScaled((double)0.4, (double)0.4, (double)0.4);
        GL11.glTranslatef((float)-0.5f, (float)2.5f, (float)-1.25f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        ItemStack item = golem.getCarriedForDisplay();
        int renderPass = 0;
        do {
            IIcon icon;
            if ((icon = item.func_77973_b().getIcon(item, renderPass)) == null) continue;
            Color color = new Color(item.func_77973_b().func_82790_a(item, renderPass));
            GL11.glColor3ub((byte)((byte)color.getRed()), (byte)((byte)color.getGreen()), (byte)((byte)color.getBlue()));
            ItemRenderer.func_78439_a((Tessellator)Tessellator.field_78398_a, (float)icon.func_94212_f(), (float)icon.func_94206_g(), (float)icon.func_94209_e(), (float)icon.func_94210_h(), (int)icon.func_94211_a(), (int)icon.func_94216_b(), (float)0.0625f);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        } while (++renderPass < item.func_77973_b().getRenderPasses(item.func_77960_j()));
        GL11.glPopMatrix();
    }

    public static void renderToolItem(EntityGolemBase golem, ItemStack itemstack, ModelBase mainModel, RenderManager renderManager) {
        float f1;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float angle = (float)(-0.6126105674500096 * (double)((ModelGolem)mainModel).golemRightArm.field_78795_f);
        float y = (float)(Math.cos(angle) * 1.15);
        float z = (float)(Math.sin(angle) * 1.15);
        GL11.glTranslatef((float)-0.25f, (float)y, (float)(z * -0.5f));
        GL11.glRotated((double)((double)angle / Math.PI * 180.0), (double)-1.0, (double)0.0, (double)0.0);
        float fs = 0.66f;
        GL11.glScalef((float)fs, (float)fs, (float)fs);
        IItemRenderer customRenderer = MinecraftForgeClient.getItemRenderer((ItemStack)itemstack, (IItemRenderer.ItemRenderType)IItemRenderer.ItemRenderType.EQUIPPED);
        boolean is3D = customRenderer != null && customRenderer.shouldUseRenderHelper(IItemRenderer.ItemRenderType.EQUIPPED, itemstack, IItemRenderer.ItemRendererHelper.BLOCK_3D);
        Item item = itemstack.func_77973_b();
        if (item instanceof ItemBlock && (is3D || RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)item).func_149645_b()))) {
            f1 = 0.5f;
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)(-(f1 *= 0.75f)), (float)(-f1), (float)f1);
        } else if (item == Items.field_151031_f) {
            f1 = 0.625f;
            GL11.glTranslatef((float)0.0f, (float)0.125f, (float)0.3125f);
            GL11.glRotatef((float)-20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)f1, (float)(-f1), (float)f1);
            GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (item.func_77662_d()) {
            f1 = 0.625f;
            if (item.func_77629_n_()) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)0.0f, (float)-0.125f, (float)0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)0.0f);
            GL11.glScalef((float)f1, (float)(-f1), (float)f1);
            GL11.glRotatef((float)-100.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            f1 = 0.375f;
            GL11.glTranslatef((float)0.25f, (float)0.1875f, (float)-0.1875f);
            GL11.glScalef((float)f1, (float)f1, (float)f1);
            GL11.glRotatef((float)60.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)20.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (itemstack.func_77973_b().func_77623_v()) {
            for (int i = 0; i < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++i) {
                int j = itemstack.func_77973_b().func_82790_a(itemstack, i);
                float f5 = (float)(j >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(j >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(j & 0xFF) / 255.0f;
                GL11.glColor4f((float)f5, (float)f2, (float)f3, (float)1.0f);
                renderManager.field_78721_f.func_78443_a((EntityLivingBase)golem, itemstack, i);
            }
        } else {
            int i = itemstack.func_77973_b().func_82790_a(itemstack, 0);
            float f4 = (float)(i >> 16 & 0xFF) / 255.0f;
            float f5 = (float)(i >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(i & 0xFF) / 255.0f;
            GL11.glColor4f((float)f4, (float)f5, (float)f2, (float)1.0f);
            renderManager.field_78721_f.func_78443_a((EntityLivingBase)golem, itemstack, 0);
        }
        GL11.glScaled((double)1.0, (double)1.0, (double)1.0);
        GL11.glPopMatrix();
    }
}

