/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import com.kuba6000.mobsinfo.api.helper.ByteBufHelper;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public interface IChanceModifier {
    default public int getPriority() {
        return 0;
    }

    public String getDescription();

    default public void applyTooltip(List<String> currentTooltip) {
        currentTooltip.add(this.getDescription());
    }

    public double apply(double var1, @Nonnull World var3, @Nonnull List<ItemStack> var4, Entity var5, EntityLiving var6);

    default public void writeToByteBuf(ByteBuf byteBuf) {
    }

    default public void readFromByteBuf(ByteBuf byteBuf) {
    }

    public static void saveToByteBuf(ByteBuf byteBuf, IChanceModifier modifier) {
        String className = modifier.getClass().getName();
        ByteBufHelper.writeString(byteBuf, className);
        modifier.writeToByteBuf(byteBuf);
    }

    public static IChanceModifier loadFromByteBuf(ByteBuf byteBuf) {
        String className = ByteBufHelper.readString(byteBuf);
        try {
            Class<IChanceModifier> cl = Class.forName(className, false, null);
            if (!cl.isAssignableFrom(IChanceModifier.class)) {
                throw new SecurityException();
            }
            IChanceModifier modifier = (IChanceModifier)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            modifier.readFromByteBuf(byteBuf);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

