/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.block.render;

import com.rwtema.extrautils.ExtraUtilsProxy;
import com.rwtema.extrautils.block.Box;
import com.rwtema.extrautils.block.BoxModel;
import com.rwtema.extrautils.block.IMultiBoxBlock;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockMultiBlock
implements ISimpleBlockRenderingHandler {
    static boolean rendering = true;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (!(block instanceof IMultiBoxBlock)) {
            return;
        }
        BoxModel boxes = ((IMultiBoxBlock)block).getInventoryModel(metadata);
        if (boxes == null) {
            return;
        }
        if (boxes.size() == 0) {
            return;
        }
        ((IMultiBoxBlock)block).prepareForRender(boxes.label);
        Box union = boxes.boundingBox();
        float dx = (union.maxX + union.minX) / 2.0f - 0.5f;
        float dy = (union.maxY + union.minY) / 2.0f - 0.5f;
        float dz = (union.maxZ + union.minZ) / 2.0f - 0.5f;
        GL11.glTranslatef((float)(-dx), (float)(-dy), (float)(-dz));
        GL11.glRotatef((float)boxes.invModelRotate, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        for (Box b : boxes) {
            block.func_149676_a(b.minX, b.minY, b.minZ, b.maxX, b.maxY, b.maxZ);
            ((IMultiBoxBlock)block).prepareForRender(b.label);
            Tessellator tessellator = Tessellator.field_78398_a;
            renderer.func_147775_a(block);
            GL11.glColor3f((float)((float)(b.color >> 16 & 0xFF) / 255.0f), (float)((float)(b.color >> 8 & 0xFF) / 255.0f), (float)((float)(b.color & 0xFF) / 255.0f));
            renderer.field_147875_q = b.uvRotateEast;
            renderer.field_147873_r = b.uvRotateWest;
            renderer.field_147871_s = b.uvRotateSouth;
            renderer.field_147869_t = b.uvRotateNorth;
            renderer.field_147867_u = b.uvRotateTop;
            renderer.field_147865_v = b.uvRotateBottom;
            if (!b.invisibleSide[0]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                renderer.func_147768_a(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 0, metadata));
                tessellator.func_78381_a();
            }
            if (!b.invisibleSide[1]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                renderer.func_147806_b(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 1, metadata));
                tessellator.func_78381_a();
            }
            if (!b.invisibleSide[2]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                renderer.func_147798_e(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 2, metadata));
                tessellator.func_78381_a();
            }
            if (!b.invisibleSide[3]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                renderer.field_147842_e = true;
                renderer.func_147764_f(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 3, metadata));
                renderer.field_147842_e = false;
                tessellator.func_78381_a();
            }
            if (!b.invisibleSide[4]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                renderer.func_147761_c(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 4, metadata));
                tessellator.func_78381_a();
            }
            if (!b.invisibleSide[5]) {
                tessellator.func_78382_b();
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                renderer.field_147842_e = true;
                renderer.func_147734_d(block, 0.0, 0.0, 0.0, this.getTexture(null, 0, 0, 0, renderer, b, block, 5, metadata));
                renderer.field_147842_e = false;
                tessellator.func_78381_a();
            }
            renderer.field_147875_q = 0;
            renderer.field_147873_r = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147867_u = 0;
            renderer.field_147865_v = 0;
        }
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glTranslatef((float)dx, (float)dy, (float)dz);
    }

    public IIcon getTexture(IBlockAccess world, int x, int y, int z, RenderBlocks renderer, Box box, Block block, int side, int metadata) {
        if (box.textureSide[side] != null) {
            return box.textureSide[side];
        }
        if (box.texture != null) {
            return box.texture;
        }
        if (world == null) {
            return renderer.func_147787_a(block, side, metadata);
        }
        return renderer.func_147793_a(block, world, x, y, z, side);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int metadata = world.func_72805_g(x, y, z);
        if (!(block instanceof IMultiBoxBlock)) {
            return false;
        }
        BoxModel boxes = ((IMultiBoxBlock)block).getWorldModel(world, x, y, z);
        if (boxes == null || boxes.size() == 0) {
            return false;
        }
        ((IMultiBoxBlock)block).prepareForRender(boxes.label);
        for (Box b1 : boxes) {
            float r = (float)(b1.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(b1.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(b1.color & 0xFF) / 255.0f;
            ((IMultiBoxBlock)block).prepareForRender(b1.label);
            block.func_149676_a(b1.minX, b1.minY, b1.minZ, b1.maxX, b1.maxY, b1.maxZ);
            renderer.field_147875_q = b1.uvRotateEast;
            renderer.field_147873_r = b1.uvRotateWest;
            renderer.field_147871_s = b1.uvRotateSouth;
            renderer.field_147869_t = b1.uvRotateNorth;
            renderer.field_147867_u = b1.uvRotateTop;
            renderer.field_147865_v = b1.uvRotateBottom;
            renderer.func_147775_a(block);
            if (b1.renderAsNormalBlock) {
                renderer.func_147784_q(block, x + b1.offsetx, y + b1.offsety, z + b1.offsetz);
            } else {
                renderer.field_147863_w = false;
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78380_c(block.func_149677_c(world, x + b1.offsetx, y + b1.offsety, z + b1.offsetz));
                tessellator.func_78386_a(r * 0.5f, g * 0.5f, b * 0.5f);
                renderer.field_147842_e = false;
                if (!b1.invisibleSide[0]) {
                    renderer.func_147768_a(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 0, metadata));
                }
                tessellator.func_78386_a(r, g, b);
                if (!b1.invisibleSide[1]) {
                    renderer.func_147806_b(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 1, metadata));
                }
                tessellator.func_78386_a(r * 0.8f, g * 0.8f, b * 0.8f);
                renderer.field_147842_e = true;
                if (!b1.invisibleSide[2]) {
                    renderer.func_147761_c(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 2, metadata));
                }
                renderer.field_147842_e = false;
                if (!b1.invisibleSide[3]) {
                    renderer.func_147734_d(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 3, metadata));
                }
                tessellator.func_78386_a(r * 0.6f, g * 0.6f, b * 0.6f);
                if (!b1.invisibleSide[4]) {
                    renderer.func_147798_e(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 4, metadata));
                }
                renderer.field_147842_e = true;
                if (!b1.invisibleSide[5]) {
                    renderer.func_147764_f(block, (double)(x + b1.offsetx), (double)(y + b1.offsety), (double)(z + b1.offsetz), this.getTexture(world, x, y, z, renderer, b1, block, 5, metadata));
                }
                renderer.field_147842_e = false;
            }
            renderer.field_147865_v = 0;
            renderer.field_147867_u = 0;
            renderer.field_147871_s = 0;
            renderer.field_147869_t = 0;
            renderer.field_147873_r = 0;
            renderer.field_147875_q = 0;
        }
        block.func_149719_a(world, x, y, z);
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return ExtraUtilsProxy.multiBlockID;
    }
}

