/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.container.SubContainer;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SubContainerWrench
extends SubContainer {
    public InventoryBasic basic = new InventoryBasic("default", false, 2);

    public SubContainerWrench(EntityPlayer player) {
        super(player, true);
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.basic, 0, 10, 5));
        this.addSlotToContainer(new Slot((IInventory)this.basic, 1, 40, 5));
        this.addPlayerSlotsToContainer(this.player);
    }

    public static ArrayList<ItemTileContainer.BlockEntry> getMissing(ArrayList<LittleTilePreview> tiles, ArrayList<ItemTileContainer.BlockEntry> entries) {
        ArrayList<ItemTileContainer.BlockEntry> missing = new ArrayList<ItemTileContainer.BlockEntry>();
        for (LittleTilePreview tile : tiles) {
            Block blockofTile = Block.func_149684_b((String)tile.nbt.func_74779_i("block"));
            int meta = tile.nbt.func_74762_e("meta");
            float size = tile.size.getPercentVolume();
            int j = 0;
            boolean found = false;
            while (j < entries.size()) {
                if (blockofTile == entries.get((int)j).block && meta == entries.get((int)j).meta) {
                    float amount = Math.min(entries.get((int)j).value, size);
                    entries.get((int)j).value -= amount;
                    size -= amount;
                    if (entries.get((int)j).value <= 0.0f) {
                        entries.remove(j);
                        if (size > 0.0f) continue;
                    }
                    if (size <= 0.0f) {
                        found = true;
                        break;
                    }
                }
                ++j;
            }
            if (found) continue;
            ItemTileContainer.BlockEntry entry = new ItemTileContainer.BlockEntry(blockofTile, meta, size);
            int index = missing.indexOf(entry);
            if (index == -1) {
                missing.add(entry);
                continue;
            }
            missing.get((int)index).value += size;
        }
        return missing;
    }

    public static ArrayList<ItemTileContainer.BlockEntry> getContentofStack(ItemStack stack) {
        ArrayList<ItemTileContainer.BlockEntry> entries = new ArrayList<ItemTileContainer.BlockEntry>();
        if (stack != null) {
            Block block;
            ArrayList<LittleTilePreview> tiles;
            ILittleTile tile = PlacementHelper.getLittleInterface(stack);
            if (tile != null && (tiles = tile.getLittlePreview(stack)) != null) {
                for (LittleTilePreview littleTilePreview : tiles) {
                    Block block2;
                    if (!littleTilePreview.nbt.func_74764_b("block") || (block2 = Block.func_149684_b((String)littleTilePreview.nbt.func_74779_i("block"))) == null || block2 instanceof BlockAir) continue;
                    entries.add(new ItemTileContainer.BlockEntry(block2, littleTilePreview.nbt.func_74762_e("meta"), littleTilePreview.size.getPercentVolume()));
                }
            }
            if (stack.func_77973_b() instanceof ItemTileContainer) {
                entries.addAll(ItemTileContainer.loadMap(stack));
            }
            if ((block = Block.func_149634_a((Item)stack.func_77973_b())) != null && !(block instanceof BlockAir) && SubContainerHammer.isBlockValid(block)) {
                entries.add(new ItemTileContainer.BlockEntry(block, stack.func_77960_j(), 1.0f));
            }
        }
        return entries;
    }

    public void onGuiPacket(int controlID, NBTTagCompound nbt, EntityPlayer player) {
        if (controlID == 0) {
            ItemStack stack1 = this.basic.func_70301_a(0);
            ItemStack stack2 = this.basic.func_70301_a(1);
            if (stack1 != null) {
                if (stack1.func_77973_b() instanceof ItemRecipe) {
                    if (stack1.field_77990_d != null && !stack1.field_77990_d.func_74764_b("x")) {
                        boolean enough = true;
                        ArrayList<ItemTileContainer.BlockEntry> entries = SubContainerWrench.getContentofStack(stack2);
                        ArrayList<LittleTilePreview> tiles = ItemRecipe.getPreview(stack1);
                        if (!player.field_71075_bZ.field_75098_d) {
                            boolean bl = enough = SubContainerWrench.getMissing(tiles, entries).size() == 0;
                        }
                        if (enough) {
                            if (stack2 != null && !player.field_71075_bZ.field_75098_d) {
                                if (stack2.func_77973_b() instanceof ItemTileContainer) {
                                    ItemTileContainer.saveMap(stack2, entries);
                                } else {
                                    --stack2.field_77994_a;
                                    if (stack2.field_77994_a == 0) {
                                        this.basic.func_70299_a(1, null);
                                    }
                                    if (entries.size() > 0) {
                                        for (ItemTileContainer.BlockEntry entry : entries) {
                                            ItemTileContainer.addBlock(player, entry.block, entry.meta, entry.value);
                                        }
                                    }
                                }
                            }
                            ItemStack stack = new ItemStack(LittleTiles.multiTiles);
                            stack.field_77990_d = (NBTTagCompound)stack1.field_77990_d.func_74737_b();
                            if (!player.field_71071_by.func_70441_a(stack)) {
                                WorldUtils.dropItem((EntityPlayer)player, (ItemStack)stack);
                            }
                        }
                    }
                } else {
                    ILittleTile tile = PlacementHelper.getLittleInterface(stack1);
                    if (tile != null && stack2 != null && stack2.func_77973_b() instanceof ItemRecipe) {
                        stack2.field_77990_d = (NBTTagCompound)stack1.field_77990_d.func_74737_b();
                    }
                }
            }
        }
    }

    public void onGuiClosed() {
        for (int i = 0; i < this.basic.func_70302_i_(); ++i) {
            if (this.basic.func_70301_a(i) == null) continue;
            this.player.func_71019_a(this.basic.func_70301_a(i), false);
        }
    }
}

