/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.client.renderer;

import com.github.bartimaeusnek.bartworks.common.blocks.BioFluidBlock;
import com.github.bartimaeusnek.bartworks.common.loaders.FluidLoader;
import com.github.bartimaeusnek.bartworks.common.tileentities.multis.GT_TileEntity_BioVat;
import com.github.bartimaeusnek.bartworks.util.Coords;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.IFluidBlock;

@SideOnly(value=Side.CLIENT)
public class RendererSwitchingColorFluid
implements ISimpleBlockRenderingHandler {
    private static final float LIGHT_Y_NEG = 0.5f;
    private static final float LIGHT_Y_POS = 1.0f;
    private static final float LIGHT_XZ_NEG = 0.8f;
    private static final float LIGHT_XZ_POS = 0.6f;
    private static final float THREE_QUARTERS_FILLED = 0.875f;
    private static final double RENDER_OFFSET = (double)0.001f;
    public static RendererSwitchingColorFluid instance = new RendererSwitchingColorFluid();

    private float getFluidHeightAverage(float[] flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (float aFlow : flow) {
            if (aFlow >= 0.875f && end != 1.0f) {
                end = aFlow;
            }
            if (!(aFlow >= 0.0f)) continue;
            total += aFlow;
            ++count;
        }
        if (end == 0.0f && count != 0) {
            end = total / (float)count;
        }
        return end;
    }

    private float getFluidHeightForRender(IBlockAccess world, int x, int y, int z, BlockFluidBase block) {
        if (world.func_147439_a(x, y, z) == block) {
            Block vOrigin = world.func_147439_a(x, y + 1, z);
            if (vOrigin.func_149688_o().func_76224_d() || vOrigin instanceof IFluidBlock) {
                return 1.0f;
            }
            if (world.func_72805_g(x, y, z) == block.getMaxRenderHeightMeta()) {
                return 0.875f;
            }
        }
        return !world.func_147439_a(x, y, z).func_149688_o().func_76220_a() && world.func_147439_a(x, y + 1, z) == block ? 1.0f : block.getQuantaPercentage(world, x, y, z) * 0.875f;
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        double heightNE;
        double heightSE;
        double heightSW;
        double heightNW;
        int b;
        int g;
        int r;
        if (!(block instanceof BioFluidBlock)) {
            return false;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        Coords blockat = new Coords(x, y, z, iBlockAccess.func_147438_o((int)x, (int)y, (int)z).func_145831_w().field_73011_w.field_76574_g);
        Integer rgb = GT_TileEntity_BioVat.staticColorMap.get(blockat);
        if (rgb != null) {
            r = rgb >> 16 & 0xFF;
            g = rgb >> 8 & 0xFF;
            b = rgb & 0xFF;
        } else {
            r = 0;
            g = 0;
            b = 255;
        }
        float red = (float)r / 255.0f;
        float green = (float)g / 255.0f;
        float blue = (float)b / 255.0f;
        BlockFluidBase blockFluidBase = (BlockFluidBase)block;
        boolean renderTop = iBlockAccess.func_147439_a(x, y + 1, z) != blockFluidBase;
        boolean renderBottom = block.func_149646_a(iBlockAccess, x, y - 1, z, 0) && iBlockAccess.func_147439_a(x, y - 1, z) != blockFluidBase;
        boolean[] renderSides = new boolean[]{block.func_149646_a(iBlockAccess, x, y, z - 1, 2), block.func_149646_a(iBlockAccess, x, y, z + 1, 3), block.func_149646_a(iBlockAccess, x - 1, y, z, 4), block.func_149646_a(iBlockAccess, x + 1, y, z, 5)};
        if (!(renderTop || renderBottom || renderSides[0] || renderSides[1] || renderSides[2] || renderSides[3])) {
            return false;
        }
        boolean rendered = false;
        float fluidHeightForRender = this.getFluidHeightForRender(iBlockAccess, x, y, z, blockFluidBase);
        if (fluidHeightForRender != 1.0f) {
            float fluidHeightForRender1 = this.getFluidHeightForRender(iBlockAccess, x - 1, y, z - 1, blockFluidBase);
            float fluidHeightForRender2 = this.getFluidHeightForRender(iBlockAccess, x - 1, y, z, blockFluidBase);
            float fluidHeightForRender3 = this.getFluidHeightForRender(iBlockAccess, x - 1, y, z + 1, blockFluidBase);
            float fluidHeightForRender4 = this.getFluidHeightForRender(iBlockAccess, x, y, z - 1, blockFluidBase);
            float fluidHeightForRender5 = this.getFluidHeightForRender(iBlockAccess, x, y, z + 1, blockFluidBase);
            float fluidHeightForRender6 = this.getFluidHeightForRender(iBlockAccess, x + 1, y, z - 1, blockFluidBase);
            float fluidHeightForRender7 = this.getFluidHeightForRender(iBlockAccess, x + 1, y, z, blockFluidBase);
            float fluidHeightForRender8 = this.getFluidHeightForRender(iBlockAccess, x + 1, y, z + 1, blockFluidBase);
            heightNW = this.getFluidHeightAverage(new float[]{fluidHeightForRender1, fluidHeightForRender2, fluidHeightForRender4, fluidHeightForRender});
            heightSW = this.getFluidHeightAverage(new float[]{fluidHeightForRender2, fluidHeightForRender3, fluidHeightForRender5, fluidHeightForRender});
            heightSE = this.getFluidHeightAverage(new float[]{fluidHeightForRender5, fluidHeightForRender7, fluidHeightForRender8, fluidHeightForRender});
            heightNE = this.getFluidHeightAverage(new float[]{fluidHeightForRender4, fluidHeightForRender6, fluidHeightForRender7, fluidHeightForRender});
        } else {
            heightNW = fluidHeightForRender;
            heightSW = fluidHeightForRender;
            heightSE = fluidHeightForRender;
            heightNE = fluidHeightForRender;
        }
        if (renderer.field_147837_f || renderTop) {
            double dInterpolatedV4;
            double dInterpolatedU4;
            double dInterpolatedV3;
            double dInterpolatedU3;
            double dInterpolatedV2;
            double dInterpolatedU2;
            double dInterpolatedV;
            double dInterpolatedU;
            rendered = true;
            IIcon iconStill = this.getNullCheckedIiconOrFallbackTexture();
            float flowDir = (float)BlockFluidBase.getFlowDirection((IBlockAccess)iBlockAccess, (int)x, (int)y, (int)z);
            heightNW -= (double)0.001f;
            heightSW -= (double)0.001f;
            heightSE -= (double)0.001f;
            heightNE -= (double)0.001f;
            if (flowDir < -999.0f) {
                dInterpolatedU = iconStill.func_94214_a(0.0);
                dInterpolatedV = iconStill.func_94207_b(0.0);
                dInterpolatedU2 = dInterpolatedU;
                dInterpolatedV2 = iconStill.func_94207_b(16.0);
                dInterpolatedU3 = iconStill.func_94214_a(16.0);
                dInterpolatedV3 = dInterpolatedV2;
                dInterpolatedU4 = dInterpolatedU3;
                dInterpolatedV4 = dInterpolatedV;
            } else {
                float xFlow = MathHelper.func_76126_a((float)flowDir) * 0.25f;
                float zFlow = MathHelper.func_76134_b((float)flowDir) * 0.25f;
                dInterpolatedU = iconStill.func_94214_a((double)(8.0f + (-zFlow - xFlow) * 16.0f));
                dInterpolatedV = iconStill.func_94207_b((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                dInterpolatedU2 = iconStill.func_94214_a((double)(8.0f + (-zFlow + xFlow) * 16.0f));
                dInterpolatedV2 = iconStill.func_94207_b((double)(8.0f + (zFlow + xFlow) * 16.0f));
                dInterpolatedU3 = iconStill.func_94214_a((double)(8.0f + (zFlow + xFlow) * 16.0f));
                dInterpolatedV3 = iconStill.func_94207_b((double)(8.0f + (zFlow - xFlow) * 16.0f));
                dInterpolatedU4 = iconStill.func_94214_a((double)(8.0f + (zFlow - xFlow) * 16.0f));
                dInterpolatedV4 = iconStill.func_94207_b((double)(8.0f + (-zFlow - xFlow) * 16.0f));
            }
            tessellator.func_78380_c(block.func_149677_c(iBlockAccess, x, y, z));
            tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
            tessellator.func_78374_a((double)x, (double)y + heightNW, (double)z, dInterpolatedU, dInterpolatedV);
            tessellator.func_78374_a((double)x, (double)y + heightSW, (double)(z + 1), dInterpolatedU2, dInterpolatedV2);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightSE, (double)(z + 1), dInterpolatedU3, dInterpolatedV3);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightNE, (double)z, dInterpolatedU4, dInterpolatedV4);
            tessellator.func_78374_a((double)x, (double)y + heightNW, (double)z, dInterpolatedU, dInterpolatedV);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightNE, (double)z, dInterpolatedU4, dInterpolatedV4);
            tessellator.func_78374_a((double)(x + 1), (double)y + heightSE, (double)(z + 1), dInterpolatedU3, dInterpolatedV3);
            tessellator.func_78374_a((double)x, (double)y + heightSW, (double)(z + 1), dInterpolatedU2, dInterpolatedV2);
        }
        if (renderer.field_147837_f || renderBottom) {
            rendered = true;
            tessellator.func_78380_c(block.func_149677_c(iBlockAccess, x, y - 1, z));
            tessellator.func_78386_a(0.5f * red, 0.5f * green, 0.5f * blue);
            renderer.func_147768_a(block, (double)x, (double)y + (double)0.001f, (double)z, this.getNullCheckedIiconOrFallbackTexture());
        }
        for (int side = 0; side < 4; ++side) {
            double d;
            double dZcoord1;
            double dXcoord2;
            double dXcoord1;
            double dHeight2;
            double dHeight1;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --z2;
                    break;
                }
                case 1: {
                    ++z2;
                    break;
                }
                case 2: {
                    --x2;
                    break;
                }
                case 3: {
                    ++x2;
                    break;
                }
            }
            IIcon iconFlow = this.getNullCheckedIiconOrFallbackTexture();
            if (!renderer.field_147837_f && !renderSides[side]) continue;
            rendered = true;
            switch (side) {
                case 0: {
                    dHeight1 = heightNW;
                    dHeight2 = heightNE;
                    dXcoord1 = x;
                    dXcoord2 = x + 1;
                    dZcoord1 = (double)z + (double)0.001f;
                    d = (double)z + (double)0.001f;
                    break;
                }
                case 1: {
                    dHeight1 = heightSE;
                    dHeight2 = heightSW;
                    dXcoord1 = x + 1;
                    dXcoord2 = x;
                    dZcoord1 = (double)(z + 1) - (double)0.001f;
                    d = (double)(z + 1) - (double)0.001f;
                    break;
                }
                case 2: {
                    dHeight1 = heightSW;
                    dHeight2 = heightNW;
                    dXcoord1 = (double)x + (double)0.001f;
                    dXcoord2 = (double)x + (double)0.001f;
                    dZcoord1 = z + 1;
                    d = z;
                    break;
                }
                default: {
                    dHeight1 = heightNE;
                    dHeight2 = heightSE;
                    dXcoord1 = (double)(x + 1) - (double)0.001f;
                    dXcoord2 = (double)(x + 1) - (double)0.001f;
                    dZcoord1 = z;
                    d = z + 1;
                }
            }
            double dZcoord2 = d;
            float u1Flow = iconFlow.func_94214_a(0.0);
            float u2Flow = iconFlow.func_94214_a(8.0);
            float v1Flow = iconFlow.func_94207_b((1.0 - dHeight1) * 16.0 * 0.5);
            float v2Flow = iconFlow.func_94207_b((1.0 - dHeight2) * 16.0 * 0.5);
            float v3Flow = iconFlow.func_94207_b(8.0);
            tessellator.func_78380_c(block.func_149677_c(iBlockAccess, x2, y, z2));
            float sideLighting = side < 2 ? 0.8f : 0.6f;
            tessellator.func_78386_a(1.0f * sideLighting * red, 1.0f * sideLighting * green, 1.0f * sideLighting * blue);
            tessellator.func_78374_a(dXcoord1, (double)y + dHeight1, dZcoord1, (double)u1Flow, (double)v1Flow);
            tessellator.func_78374_a(dXcoord2, (double)y + dHeight2, dZcoord2, (double)u2Flow, (double)v2Flow);
            tessellator.func_78374_a(dXcoord2, (double)y, dZcoord2, (double)u2Flow, (double)v3Flow);
            tessellator.func_78374_a(dXcoord1, (double)y, dZcoord1, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(dXcoord1, (double)y + dHeight1, dZcoord1, (double)u1Flow, (double)v1Flow);
            tessellator.func_78374_a(dXcoord1, (double)y, dZcoord1, (double)u1Flow, (double)v3Flow);
            tessellator.func_78374_a(dXcoord2, (double)y, dZcoord2, (double)u2Flow, (double)v3Flow);
            tessellator.func_78374_a(dXcoord2, (double)y + dHeight2, dZcoord2, (double)u2Flow, (double)v2Flow);
        }
        renderer.field_147855_j = 0.0;
        renderer.field_147857_k = 1.0;
        return rendered;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return FluidLoader.renderID;
    }

    private IIcon getNullCheckedIiconOrFallbackTexture() {
        return FluidLoader.autogenIIcon != null ? FluidLoader.autogenIIcon : ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
    }
}

