/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.bartworks.util;

import com.github.bartimaeusnek.bartworks.util.Pair;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeFinderForParallel {
    public static int handleParallelRecipe(GT_Recipe aRecipe, FluidStack[] aFluidInputs, ItemStack[] aItemStacks, int aMaxParallel) {
        int tOldSize;
        int tItem;
        int tFluid;
        if (aFluidInputs == null) {
            aFluidInputs = new FluidStack[]{};
        }
        if (aItemStacks == null) {
            aItemStacks = new ItemStack[]{};
        }
        HashMap<Integer, Integer> tCompressedFluidInput = RecipeFinderForParallel.compressFluid(aFluidInputs);
        HashMap<Integer, Integer> tCompressedItemInput = RecipeFinderForParallel.compressItem(aItemStacks);
        HashMap<Integer, Integer> tCompressedFluidRecipe = RecipeFinderForParallel.compressFluid(aRecipe.mFluidInputs);
        HashMap<Integer, Integer> tCompressedItemRecipe = RecipeFinderForParallel.compressItem(aRecipe.mInputs);
        int tCurrentPara = aMaxParallel;
        FluidStack[] fluidStackArray = tCompressedFluidRecipe.keySet().iterator();
        while (fluidStackArray.hasNext()) {
            tFluid = fluidStackArray.next();
            if (!tCompressedFluidInput.containsKey(tFluid) || tCompressedFluidRecipe.get(tFluid) == 0) continue;
            tCurrentPara = Math.min(tCurrentPara, tCompressedFluidInput.get(tFluid) / tCompressedFluidRecipe.get(tFluid));
        }
        fluidStackArray = tCompressedItemRecipe.keySet().iterator();
        while (fluidStackArray.hasNext()) {
            tItem = fluidStackArray.next();
            if (tItem >> 16 == Short.MAX_VALUE) {
                int tCountWildcard = 0;
                for (int tInputItem : tCompressedItemInput.keySet()) {
                    if ((tInputItem & 0xFFFF) != (tItem & 0xFFFF)) continue;
                    tCountWildcard += tCompressedItemInput.get(tInputItem).intValue();
                }
                tCurrentPara = Math.min(tCurrentPara, tCountWildcard / tCompressedItemRecipe.get(tItem));
                continue;
            }
            if (tCompressedItemRecipe.get(tItem) == 0) continue;
            int tCountOre = 0;
            ItemStack tRealRecipe = GT_Utility.intToStack((int)tItem);
            for (int tInputItem : tCompressedItemInput.keySet()) {
                ItemStack tRealStack = GT_Utility.intToStack((int)tInputItem);
                if (!GT_OreDictUnificator.isInputStackEqual((ItemStack)tRealStack, (ItemStack)tRealRecipe)) continue;
                tCountOre += tCompressedItemInput.get(tInputItem).intValue();
            }
            tCurrentPara = Math.min(tCurrentPara, tCountOre / tCompressedItemRecipe.get(tItem));
        }
        fluidStackArray = tCompressedFluidRecipe.keySet().iterator();
        while (fluidStackArray.hasNext()) {
            tFluid = fluidStackArray.next();
            tOldSize = tCompressedFluidRecipe.get(tFluid);
            tCompressedFluidRecipe.put(tFluid, tOldSize * tCurrentPara);
        }
        fluidStackArray = tCompressedItemRecipe.keySet().iterator();
        while (fluidStackArray.hasNext()) {
            tItem = fluidStackArray.next();
            tOldSize = tCompressedItemRecipe.get(tItem);
            tCompressedItemRecipe.put(tItem, tOldSize * tCurrentPara);
        }
        for (FluidStack tFluid2 : aFluidInputs) {
            if (tFluid2 == null || !tCompressedFluidRecipe.containsKey(tFluid2.getFluidID())) continue;
            if (tFluid2.amount >= tCompressedFluidRecipe.get(tFluid2.getFluidID())) {
                tFluid2.amount -= tCompressedFluidRecipe.get(tFluid2.getFluidID()).intValue();
                tCompressedFluidRecipe.remove(tFluid2.getFluidID());
                continue;
            }
            tCompressedFluidRecipe.put(tFluid2.getFluidID(), tCompressedFluidRecipe.get(tFluid2.getFluidID()) - tFluid2.amount);
            tFluid2.amount = 0;
        }
        Iterator<Integer> i = tCompressedItemRecipe.keySet().iterator();
        block7: while (i.hasNext()) {
            tItem = i.next();
            if (tItem >> 16 == Short.MAX_VALUE) {
                for (ItemStack tInputItem : aItemStacks) {
                    int InputID = GT_Utility.stackToInt((ItemStack)tInputItem);
                    if ((InputID & 0xFFFF) != (tItem & 0xFFFF)) continue;
                    if (tInputItem.field_77994_a >= tCompressedItemRecipe.get(tItem)) {
                        tInputItem.field_77994_a -= tCompressedItemRecipe.get(tItem).intValue();
                        i.remove();
                        continue block7;
                    }
                    tCompressedItemRecipe.put(tItem, tCompressedItemRecipe.get(tItem) - tInputItem.field_77994_a);
                    tInputItem.field_77994_a = 0;
                }
                continue;
            }
            ItemStack tRealRecipe = GT_Utility.intToStack((int)tItem);
            int tTargetAmount = tCompressedItemRecipe.get(tItem);
            for (ItemStack input : aItemStacks) {
                if (GT_OreDictUnificator.isInputStackEqual((ItemStack)input, (ItemStack)tRealRecipe)) {
                    int d = Math.min(tTargetAmount, input.field_77994_a);
                    tCompressedItemRecipe.put(tItem, tTargetAmount -= d);
                    input.field_77994_a -= d;
                }
                if (tTargetAmount != 0) continue;
                i.remove();
                continue block7;
            }
        }
        return tCurrentPara;
    }

    public static Pair<ArrayList<FluidStack>, ArrayList<ItemStack>> getMultiOutput(GT_Recipe aRecipe, int aPall) {
        ArrayList<FluidStack> tFluidList = new ArrayList<FluidStack>();
        ArrayList<ItemStack> tItemList = new ArrayList<ItemStack>();
        if (aRecipe == null) {
            return new Pair<ArrayList<FluidStack>, ArrayList<ItemStack>>(tFluidList, tItemList);
        }
        if (aRecipe.mFluidOutputs != null && aRecipe.mFluidOutputs.length > 0) {
            for (FluidStack fluidStack : aRecipe.mFluidOutputs) {
                if (fluidStack == null || fluidStack.amount <= 0) continue;
                tFluidList.add(new FluidStack(fluidStack.getFluid(), fluidStack.amount * aPall));
            }
        }
        if (aRecipe.mOutputs != null && aRecipe.mOutputs.length > 0) {
            for (FluidStack fluidStack : aRecipe.mOutputs) {
                int tAmount;
                if (fluidStack == null || fluidStack.field_77994_a <= 0) continue;
                for (tAmount = fluidStack.field_77994_a * aPall; tAmount > fluidStack.func_77976_d(); tAmount -= fluidStack.func_77976_d()) {
                    tItemList.add(GT_Utility.copyAmount((int)fluidStack.func_77976_d(), (ItemStack)fluidStack));
                }
                tItemList.add(GT_Utility.copyAmount((int)tAmount, (ItemStack)fluidStack));
            }
        }
        return new Pair<ArrayList<FluidStack>, ArrayList<ItemStack>>(tFluidList, tItemList);
    }

    public static HashMap<Integer, Integer> compressItem(ItemStack[] aItemStacks) {
        HashMap<Integer, Integer> tCompressed = new HashMap<Integer, Integer>();
        for (ItemStack tItem : aItemStacks) {
            if (tItem == null) continue;
            int tItemID = GT_Utility.stackToInt((ItemStack)tItem);
            int tItemSize = tItem.field_77994_a;
            tCompressed.merge(tItemID, tItemSize, Integer::sum);
        }
        return tCompressed;
    }

    public static HashMap<Integer, Integer> compressFluid(FluidStack[] aFluidStack) {
        HashMap<Integer, Integer> tCompressed = new HashMap<Integer, Integer>();
        for (FluidStack tFluid : aFluidStack) {
            if (tFluid == null) continue;
            int tFluidID = tFluid.getFluidID();
            int tFluidSize = tFluid.amount;
            tCompressed.merge(tFluidID, tFluidSize, Integer::sum);
        }
        return tCompressed;
    }
}

