/*
 * Decompiled with CFR 0.152.
 */
package com.lulan.compactkineticgenerators.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigHandler {
    public static Configuration config;
    public static boolean debugMode;
    public static int customKGTier;
    public static Property propOutput;
    public static Property propDamage;
    public static Property propOutputWater;
    public static Property propDamageWater;
    public static double[] scaleOutput;
    public static double[] scaleDamage;
    public static double[] scaleOutputWater;
    public static double[] scaleDamageWater;

    private static void loadConfiguration() {
        debugMode = config.getBoolean("Debug Mode", "general", false, "Enable debug message (SPAM WARNING)");
        customKGTier = config.getInt("ExtremeKG Tier", "general", 7, 7, 13, "Extreme Kinetic Generator energy tier, default 7 = max 131,072 EU/t");
        propOutput = config.get("general", "Wind Output Scale", scaleOutput, "output scale vs classic wind generator");
        propDamage = config.get("general", "Wind Rotor Damage Scale", scaleDamage, "rotor damage scale vs classic wind generator");
        propOutputWater = config.get("general", "Water Output Scale", scaleOutputWater, "output scale vs classic water generator");
        propDamageWater = config.get("general", "Water Rotor Damage Scale", scaleDamageWater, "rotor damage scale vs classic water generator");
        scaleOutput = ConfigHandler.getDoubleArrayFromConfig(scaleOutput, propOutput);
        scaleDamage = ConfigHandler.getDoubleArrayFromConfig(scaleDamage, propDamage);
        scaleOutputWater = ConfigHandler.getDoubleArrayFromConfig(scaleOutputWater, propOutputWater);
        scaleDamageWater = ConfigHandler.getDoubleArrayFromConfig(scaleDamageWater, propDamageWater);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static int[] getIntArraySpecialLength(int[] defaultValue, Property target, int type) {
        int[] geti = target.getIntList();
        switch (type) {
            case 0: {
                if (geti != null && geti.length % 10 == 0) {
                    return geti;
                }
                target.set(defaultValue);
                return defaultValue;
            }
        }
        return geti;
    }

    public static int[] getIntArrayFromConfig(int[] defaultValue, Property target) {
        int size = defaultValue.length;
        int[] geti = target.getIntList();
        if (geti != null && geti.length == size) {
            return geti;
        }
        target.set(defaultValue);
        return defaultValue;
    }

    public static double[] getDoubleArrayFromConfig(double[] defaultValue, Property target) {
        int size = defaultValue.length;
        double[] getd = target.getDoubleList();
        if (getd != null && getd.length == size) {
            return getd;
        }
        target.set(defaultValue);
        return defaultValue;
    }

    public static boolean[] getBooleanArrayFromConfig(boolean[] defaultValue, Property target) {
        int size = defaultValue.length;
        boolean[] getd = target.getBooleanList();
        if (getd != null && getd.length == size) {
            return getd;
        }
        target.set(defaultValue);
        return defaultValue;
    }

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("compactkineticgenerators")) {
            ConfigHandler.loadConfiguration();
        }
    }

    static {
        debugMode = false;
        customKGTier = 7;
        scaleOutput = new double[]{4.0, 16.0, 64.0, 256.0};
        scaleDamage = new double[]{4.0, 16.0, 64.0, 256.0};
        scaleOutputWater = new double[]{4.0, 16.0, 64.0, 256.0};
        scaleDamageWater = new double[]{4.0, 16.0, 64.0, 256.0};
    }
}

