/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class MudProjectile
extends EnergyBlastProjectile {
    private boolean doesBlindness;

    public MudProjectile(World par1World) {
        super(par1World);
    }

    public MudProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public MudProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, boolean flag) {
        super(par1World, par2EntityPlayer, damage);
        this.doesBlindness = flag;
    }

    public MudProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, boolean flag) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
        this.doesBlindness = flag;
    }

    public MudProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir, boolean flag) {
        super(par1World, par2EntityLivingBase, par3EntityLivingBase, par4, par5, damage, maxTicksInAir);
        this.doesBlindness = flag;
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.func_76358_a((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && mop.field_72308_g != null) {
            if (mop.field_72308_g == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.field_72308_g);
        } else if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            // empty if block
        }
        this.func_70106_y();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.func_70106_y();
        } else if (mop instanceof EntityLivingBase) {
            if (this.doesBlindness) {
                ((EntityLivingBase)mop).func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 100, 0));
            } else {
                ((EntityLivingBase)mop).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 100, 2));
            }
            this.doDamage(this.projectileDamage, mop);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.func_70106_y();
    }

    @Override
    public void doFiringParticles() {
        SpellHelper.sendParticleToAllAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 30, this.field_70170_p.field_73011_w.field_76574_g, "mobSpellAmbient", this.field_70165_t + this.smallGauss(0.1), this.field_70163_u + this.smallGauss(0.1), this.field_70161_v + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        SpellHelper.sendParticleToAllAround(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 30, this.field_70170_p.field_73011_w.field_76574_g, "mobSpell", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.5, 0.297f, 0.0664f);
    }

    @Override
    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70014_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("doesBlindness", this.doesBlindness);
    }

    @Override
    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70037_a(par1NBTTagCompound);
        this.doesBlindness = par1NBTTagCompound.func_74767_n("doesBlindness");
    }
}

