/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.spell.complex.effect.cse.wind;

import WayofTime.alchemicalWizardry.api.spell.ComplexSpellEffect;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellModifier;
import WayofTime.alchemicalWizardry.api.spell.ComplexSpellType;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigm;
import WayofTime.alchemicalWizardry.api.spell.SpellParadigmSelf;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.impactEffects.wind.SelfEnvironmentalWind;

public class CSESelfEnvironmentalWind
extends ComplexSpellEffect {
    public CSESelfEnvironmentalWind() {
        super(ComplexSpellType.WIND, ComplexSpellModifier.ENVIRONMENTAL);
    }

    public CSESelfEnvironmentalWind(int power, int cost, int potency) {
        this();
        this.powerEnhancement = power;
        this.costEnhancement = cost;
        this.potencyEnhancement = potency;
    }

    @Override
    public void modifyParadigm(SpellParadigm parad) {
        if (parad instanceof SpellParadigmSelf) {
            ((SpellParadigmSelf)parad).addSelfSpellEffect(new SelfEnvironmentalWind(this.powerEnhancement, this.potencyEnhancement, this.costEnhancement));
        }
    }

    @Override
    public ComplexSpellEffect copy(int power, int cost, int potency) {
        return new CSESelfEnvironmentalWind(power, cost, potency);
    }

    @Override
    public int getCostOfEffect() {
        return (int)(500.0 * (0.7 * (double)this.powerEnhancement + 1.0) * (0.2 * (double)this.potencyEnhancement + 1.0) * Math.pow(0.85, this.costEnhancement));
    }
}

