/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.fluids;

import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.creativetabs.CreativeTabsManager;
import eu.usrv.yamcore.events.BucketHandler;
import eu.usrv.yamcore.fluids.ModBucketItem;
import eu.usrv.yamcore.fluids.ModSimpleBaseFluid;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;

public class ModFluidManager {
    public Map<String, ModSimpleBaseFluid> FluidCollection = null;
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private String _mModID;

    public ModFluidManager(String pModID) {
        this.FluidCollection = new HashMap<String, ModSimpleBaseFluid>();
        this._mModID = pModID;
    }

    public ModSimpleBaseFluid GetModFluid(ModSimpleBaseFluid pModItem) {
        return this.GetModFluid(pModItem.getFluid().getUnlocalizedName());
    }

    public ModSimpleBaseFluid GetModFluid(String pModItemName) {
        if (this.FluidCollection.containsKey(pModItemName)) {
            return this.FluidCollection.get(pModItemName);
        }
        return null;
    }

    public boolean AddItemToManagedRegistry(ModSimpleBaseFluid pModFluid) {
        if (this.GetModFluid(pModFluid) == null) {
            this.FluidCollection.put(pModFluid.getFluid().getUnlocalizedName(), pModFluid);
            this._mLog.debug(String.format("Adding Fluid to managed registry: %s", pModFluid.getFluid().getUnlocalizedName()));
            return true;
        }
        this._mLog.debug(String.format("Not adding Fluid to managed registry, since it's already registered! > %s", pModFluid.getFluid().getUnlocalizedName()));
        return false;
    }

    public boolean RegisterItems(CreativeTabsManager pTabManager) {
        try {
            for (ModSimpleBaseFluid modFluid : this.FluidCollection.values()) {
                try {
                    Block tB;
                    CreativeTabs tTargetTab = pTabManager.GetCreativeTabInstance(modFluid.getCreativeTabName());
                    if (tTargetTab == null) {
                        tTargetTab = CreativeTabs.field_78026_f;
                        this._mLog.warn(String.format("CreativeTab name %s requested, but not registered in TabManager. Adding fluid %s to Tab 'Misc'", modFluid.getCreativeTabName(), modFluid.func_149739_a()));
                    }
                    modFluid.func_149647_a(tTargetTab);
                    Fluid tFluid = modFluid.getFluid();
                    if (tFluid == null) {
                        this._mLog.error(String.format("Unable to grab fluid for preregistered modFluid %s", modFluid.func_149739_a()));
                        continue;
                    }
                    this._mLog.debug(String.format("Grabbed fluid: %s Preparing to register...", tFluid.getUnlocalizedName()));
                    String tUnlocFluidName = tFluid.getUnlocalizedName().substring(6);
                    modFluid.SetTextures(this._mModID, tUnlocFluidName);
                    modFluid.func_149663_c(tUnlocFluidName);
                    this._mLog.debug(String.format("FluidBlock: %s Fluid: %s", modFluid.func_149739_a(), tFluid.getUnlocalizedName()));
                    if (modFluid.getRegisterBucket()) {
                        ModBucketItem fluidBucket = new ModBucketItem((Block)modFluid);
                        fluidBucket.func_77655_b(tUnlocFluidName + "_bucket").func_77642_a(Items.field_151133_ar);
                        fluidBucket.func_111206_d(String.format("%s:item%s_bucket", this._mModID, tUnlocFluidName));
                        fluidBucket.func_77637_a(tTargetTab);
                        FluidContainerRegistry.registerFluidContainer((Fluid)tFluid, (ItemStack)new ItemStack((Item)fluidBucket), (ItemStack)new ItemStack(Items.field_151133_ar));
                        GameRegistry.registerItem((Item)fluidBucket, (String)(this._mModID + "_" + fluidBucket.func_77658_a().substring(5)));
                        BucketHandler.INSTANCE.buckets.put((Block)modFluid, (Item)fluidBucket);
                    }
                    if ((tB = GameRegistry.registerBlock((Block)modFluid, (String)(this._mModID + "_" + modFluid.func_149739_a().substring(5)))) == null) {
                        this._mLog.error(String.format("Failed to register fluidblock %s", modFluid.func_149739_a()));
                    }
                    tFluid.setUnlocalizedName(tUnlocFluidName);
                }
                catch (Exception e) {
                    this._mLog.error(String.format("Error while registering fluid %s, skipping", modFluid.func_149739_a()));
                    this._mLog.DumpStack(e);
                }
            }
            return true;
        }
        catch (Exception e) {
            this._mLog.error(String.format("Error while registering fluids", new Object[0]));
            this._mLog.DumpStack(e);
            return false;
        }
    }

    public static Fluid GetNewFluid(String pFluidName) {
        Fluid tFluid = new Fluid(pFluidName);
        if (!FluidRegistry.registerFluid((Fluid)tFluid)) {
            YAMCore.instance.getLogger().error("Can't register fluid " + pFluidName + " to forge");
            return null;
        }
        YAMCore.instance.getLogger().debug("Registered " + pFluidName + " to forge");
        return tFluid;
    }
}

