/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.venus.dimension.sky;

import galaxyspace.core.render.sky.SkyProviderBase;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;

public class WeatherProviderVenus
extends IRenderHandler {
    float[] rainXCoords;
    float[] rainYCoords;
    private int rendererUpdateCount;
    private Random random = new Random();

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        ++this.rendererUpdateCount;
        this.renderNormalWeather(partialTicks, mc);
    }

    private void renderNormalWeather(float partialTicks, Minecraft mc) {
        float rainStrength = mc.field_71441_e.func_72867_j(partialTicks);
        if (rainStrength > 0.0f) {
            mc.field_71460_t.func_78463_b((double)partialTicks);
            this.initializeRainCoords();
            EntityLivingBase entitylivingbase = mc.field_71451_h;
            WorldClient worldclient = mc.field_71441_e;
            int k2 = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int l2 = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int i3 = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)partialTicks;
            double d2 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)partialTicks;
            double d3 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)partialTicks;
            int j = MathHelper.func_76128_c((double)d2);
            int range = 5;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            int b1 = -1;
            float f5 = (float)this.rendererUpdateCount + partialTicks;
            if (mc.field_71474_y.field_74347_j) {
                range = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int m = i3 - range; m <= i3 + range; ++m) {
                for (int i4 = k2 - range; i4 <= k2 + range; ++i4) {
                    double xDist;
                    float downwardsMotion;
                    int j2 = (m - i3 + 16) * 32 + i4 - k2 + 16;
                    float f6 = this.rainXCoords[j2] * 0.5f;
                    float f7 = this.rainYCoords[j2] * 0.5f;
                    BiomeGenBase biomegenbase = worldclient.func_72807_a(i4, m);
                    if (!biomegenbase.func_76738_d() && !biomegenbase.func_76746_c()) continue;
                    int k3 = worldclient.func_72874_g(i4, m);
                    int l3 = l2 - range;
                    int i5 = l2 + range;
                    if (l3 < k3) {
                        l3 = k3;
                    }
                    if (i5 < k3) {
                        i5 = k3;
                    }
                    float f8 = 1.0f;
                    int j3 = k3;
                    if (j3 < j) {
                        j3 = j;
                    }
                    if (l3 == i5) continue;
                    this.random.setSeed(i4 * i4 * 3121 + i4 * 45238971 ^ m * m * 418711 + m * 13761);
                    float f9 = biomegenbase.func_150564_a(i4, l3, m);
                    if (worldclient.func_72959_q().func_76939_a(f9, k3) >= 0.15f) {
                        if (b1 != 0) {
                            if (b1 >= 0) {
                                tessellator.func_78381_a();
                            }
                            b1 = 0;
                            mc.func_110434_K().func_110577_a(SkyProviderBase.venusRainTexture);
                            tessellator.func_78382_b();
                        }
                        downwardsMotion = ((float)(this.rendererUpdateCount + i4 * i4 * 3121 + i4 * 45238971 + m * m * 418711 + m * 13761 & 0x1F) + partialTicks) / 32.0f * (3.0f + this.random.nextFloat());
                        double d4 = (double)((float)i4 + 0.5f) - entitylivingbase.field_70165_t;
                        xDist = (double)((float)m + 0.5f) - entitylivingbase.field_70161_v;
                        float f10 = MathHelper.func_76133_a((double)(d4 * d4 + xDist * xDist)) / (float)range;
                        float f11 = 1.0f;
                        tessellator.func_78380_c(worldclient.func_72802_i(i4, j3, m, 0));
                        tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - f10 * f10) * 0.5f + 0.5f) * rainStrength);
                        tessellator.func_78373_b(-d0 * 1.0, -d2 * 1.0, -d3 * 1.0);
                        tessellator.func_78374_a((double)((float)i4 - f6) + 0.5, (double)l3, (double)((float)m - f7) + 0.5, 0.0, (double)((float)l3 * 1.0f / 4.0f + downwardsMotion * 1.0f));
                        tessellator.func_78374_a((double)((float)i4 + f6) + 0.5, (double)l3, (double)((float)m + f7) + 0.5, 1.0, (double)((float)l3 * 1.0f / 4.0f + downwardsMotion * 1.0f));
                        tessellator.func_78374_a((double)((float)i4 + f6) + 0.5, (double)i5, (double)((float)m + f7) + 0.5, 1.0, (double)((float)i5 * 1.0f / 4.0f + downwardsMotion * 1.0f));
                        tessellator.func_78374_a((double)((float)i4 - f6) + 0.5, (double)i5, (double)((float)m - f7) + 0.5, 0.0, (double)((float)i5 * 1.0f / 4.0f + downwardsMotion * 1.0f));
                        tessellator.func_78373_b(0.0, 0.0, 0.0);
                        continue;
                    }
                    if (b1 != 1) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 1;
                        mc.func_110434_K().func_110577_a(SkyProviderBase.snowTexture);
                        tessellator.func_78382_b();
                    }
                    downwardsMotion = ((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    float f12 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f13 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    xDist = (double)((float)i4 + 0.5f) - entitylivingbase.field_70165_t;
                    double zDist = (double)((float)m + 0.5f) - entitylivingbase.field_70161_v;
                    float f14 = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist)) / (float)range;
                    float f15 = 1.0f;
                    tessellator.func_78380_c((worldclient.func_72802_i(i4, j3, m, 0) * 3 + 0xF000F0) / 4);
                    tessellator.func_78369_a(1.0f, 1.0f, 1.0f, ((1.0f - f14 * f14) * 0.3f + 0.5f) * rainStrength);
                    tessellator.func_78373_b(-d0 * 1.0, -d2 * 1.0, -d3 * 1.0);
                    tessellator.func_78374_a((double)((float)i4 - f6) + 0.5, (double)l3, (double)((float)m - f7) + 0.5, (double)(0.0f + f12), (double)((float)l3 * 1.0f / 4.0f + downwardsMotion * 1.0f + f13));
                    tessellator.func_78374_a((double)((float)i4 + f6) + 0.5, (double)l3, (double)((float)m + f7) + 0.5, (double)(1.0f + f12), (double)((float)l3 * 1.0f / 4.0f + downwardsMotion * 1.0f + f13));
                    tessellator.func_78374_a((double)((float)i4 + f6) + 0.5, (double)i5, (double)((float)m + f7) + 0.5, (double)(1.0f + f12), (double)((float)i5 * 1.0f / 4.0f + downwardsMotion * 1.0f + f13));
                    tessellator.func_78374_a((double)((float)i4 - f6) + 0.5, (double)i5, (double)((float)m - f7) + 0.5, (double)(0.0f + f12), (double)((float)i5 * 1.0f / 4.0f + downwardsMotion * 1.0f + f13));
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            mc.field_71460_t.func_78483_a((double)partialTicks);
        }
    }

    private void initializeRainCoords() {
        if (this.rainXCoords == null) {
            this.rainXCoords = new float[1024];
            this.rainYCoords = new float[1024];
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    float f2 = j - 16;
                    float f3 = i - 16;
                    float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                    this.rainXCoords[i << 5 | j] = -f3 / f4;
                    this.rainYCoords[i << 5 | j] = f2 / f4;
                }
            }
        }
    }
}

