/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.energy;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ISegmentedReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import WayofTime.alchemicalWizardry.api.items.interfaces.IReagentManipulator;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemTankSegmenter
extends Item
implements IReagentManipulator {
    @SideOnly(value=Side.CLIENT)
    public IIcon crystalBody;
    @SideOnly(value=Side.CLIENT)
    public IIcon crystalLabel;

    public ItemTankSegmenter() {
        this.func_77637_a(AlchemicalWizardry.tabBloodMagic);
        this.field_77787_bX = true;
        this.field_77777_bU = 1;
    }

    public String func_77653_i(ItemStack stack) {
        Reagent reagent = this.getReagent(stack);
        String name = super.func_77653_i(stack);
        if (reagent != null) {
            name = name + " (" + reagent.name + ")";
        }
        return name;
    }

    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        Reagent reagent;
        par3List.add(StatCollector.func_74838_a((String)"tooltip.tanksegmenter.desc1"));
        par3List.add(StatCollector.func_74838_a((String)"tooltip.tanksegmenter.desc2"));
        if (par1ItemStack.func_77978_p() != null && (reagent = this.getReagent(par1ItemStack)) != null) {
            par3List.add(StatCollector.func_74838_a((String)"tooltip.reagent.selectedreagent") + " " + reagent.name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.crystalBody = iconRegister.func_94245_a("AlchemicalWizardry:TankSegmenter1");
        this.crystalLabel = iconRegister.func_94245_a("AlchemicalWizardry:TankSegmenter2");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        switch (pass) {
            case 0: {
                return 0xFFFFFF;
            }
            case 1: {
                Reagent reagent = this.getReagent(stack);
                if (reagent == null) break;
                return reagent.getColourRed() * 256 * 256 + reagent.getColourGreen() * 256 + reagent.getColourBlue();
            }
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int meta) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        switch (pass) {
            case 0: {
                return this.crystalBody;
            }
            case 1: {
                return this.crystalLabel;
            }
        }
        return this.field_77791_bV;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemStack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, false);
        if (movingobjectposition == null) {
            return itemStack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (!(tile instanceof ISegmentedReagentHandler)) {
                return itemStack;
            }
            ISegmentedReagentHandler reagentHandler = (ISegmentedReagentHandler)tile;
            if (player.func_70093_af()) {
                ReagentContainerInfo[] infos = reagentHandler.getContainerInfo(ForgeDirection.UNKNOWN);
                if (infos != null) {
                    LinkedList<Reagent> reagentList = new LinkedList<Reagent>();
                    for (ReagentContainerInfo info : infos) {
                        Reagent reagent;
                        ReagentStack reagentStack;
                        if (info == null || (reagentStack = info.reagent) == null || (reagent = reagentStack.reagent) == null) continue;
                        reagentList.add(reagent);
                    }
                    Reagent pastReagent = this.getReagent(itemStack);
                    boolean goForNext = false;
                    boolean hasFound = false;
                    for (Reagent reagent : reagentList) {
                        if (goForNext) {
                            goForNext = false;
                            break;
                        }
                        if (reagent != pastReagent) continue;
                        goForNext = true;
                        hasFound = true;
                    }
                    if (hasFound) {
                        if (goForNext) {
                            this.setReagentWithNotification(itemStack, (Reagent)reagentList.get(0), player);
                        }
                    } else if (reagentList.size() >= 1) {
                        this.setReagentWithNotification(itemStack, (Reagent)reagentList.get(0), player);
                    }
                }
            } else {
                Reagent reagent = this.getReagent(itemStack);
                if (reagent == null) {
                    reagentHandler.getAttunedTankMap().clear();
                    return itemStack;
                }
                int totalTankSize = reagentHandler.getNumberOfTanks();
                int numberAssigned = reagentHandler.getTanksTunedToReagent(reagent) + 1;
                if (numberAssigned > totalTankSize) {
                    numberAssigned = 0;
                }
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.tanksegmenter.nowhas") + " " + numberAssigned + " " + StatCollector.func_74838_a((String)"message.tanksegmenter.tankssetto") + " " + reagent.name));
                reagentHandler.setTanksTunedToReagent(reagent, numberAssigned);
            }
        } else if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.MISS) {
            this.setReagent(itemStack, null);
        }
        return itemStack;
    }

    public Reagent getReagent(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        return ReagentRegistry.getReagentForKey(tag.func_74779_i("reagent"));
    }

    public void setReagent(ItemStack stack, Reagent reagent) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74778_a("reagent", ReagentRegistry.getKeyForReagent(reagent));
    }

    public void setReagentWithNotification(ItemStack stack, Reagent reagent, EntityPlayer player) {
        this.setReagent(stack, reagent);
        if (reagent != null) {
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"message.tanksegmenter.setto") + " " + reagent.name));
        }
    }
}

