/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import glowredman.amazingtrophies.model.complex.BaseModelStructure;
import glowredman.amazingtrophies.model.complex.CustomRenderBlocks;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    private static final float TROPHY_BASE_RATIO = 0.75f;

    private static void centreModel(BaseModelStructure model) {
        String[][] testShape = model.getStructureString();
        int x = testShape.length / 2;
        int z = testShape[0][0].length() / 2;
        GL11.glTranslated((double)(-x), (double)-0.5, (double)(-1 - z));
    }

    private static void buildModel(BaseModelStructure model) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        CustomRenderBlocks renderBlocks = new CustomRenderBlocks((World)Minecraft.func_71410_x().field_71441_e);
        renderBlocks.field_147863_w = false;
        for (int x = 0; x < model.getXLength(); ++x) {
            for (int y = 0; y < model.getYLength(); ++y) {
                for (int z = 0; z < model.getZLength(); ++z) {
                    Character blockChar = Character.valueOf(model.getStructureString()[x][z].charAt(y));
                    if (blockChar.equals(Character.valueOf(' ')) || model.renderFacesArray[x][z][y].allHidden()) continue;
                    Pair<Block, Integer> blockInfo = model.getAssociatedBlockInfo(blockChar.charValue());
                    renderBlocks.setRenderFacesInfo(model.renderFacesArray[x][z][y]);
                    RenderHelper.renderBlock((Block)blockInfo.getLeft(), (Integer)blockInfo.getRight(), renderBlocks, x, z + 1, y + 1);
                }
            }
        }
    }

    private static void scaleModel(BaseModelStructure model) {
        float maxScale = 0.75f / model.maxAxisSize();
        GL11.glScalef((float)maxScale, (float)maxScale, (float)maxScale);
    }

    public static void renderModel(BaseModelStructure model) {
        if (model == null) {
            return;
        }
        GL11.glPushMatrix();
        RenderHelper.scaleModel(model);
        RenderHelper.centreModel(model);
        RenderHelper.buildModel(model);
        GL11.glPopMatrix();
    }

    public static void renderBlock(Block block, int metadata, CustomRenderBlocks renderBlocks, int x, int y, int z) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
        renderBlocks.func_147800_a(block, metadata, 1.0f);
        GL11.glPopMatrix();
    }
}

