/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.IRecipeMap;
import gregtech.api.recipe.RecipeCategories;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.RecipeMetadataKey;
import gregtech.api.recipe.metadata.SimpleRecipeMetadataKey;
import gregtech.api.util.GT_AssemblyLineUtils;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_RecipeMapUtil;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_RecipeConstants {
    public static final RecipeMetadataKey<Boolean> LOW_GRAVITY = SimpleRecipeMetadataKey.create(Boolean.class, "low_gravity");
    public static final RecipeMetadataKey<Boolean> CLEANROOM = SimpleRecipeMetadataKey.create(Boolean.class, "cleanroom");
    public static final RecipeMetadataKey<Integer> ADDITIVE_AMOUNT = SimpleRecipeMetadataKey.create(Integer.class, "additives");
    public static final RecipeMetadataKey<Integer> FUSION_THRESHOLD = SimpleRecipeMetadataKey.create(Integer.class, "fusion_threshold");
    public static final RecipeMetadataKey<Integer> RESEARCH_TIME = SimpleRecipeMetadataKey.create(Integer.class, "research_time");
    public static final RecipeMetadataKey<Integer> FUEL_TYPE = SimpleRecipeMetadataKey.create(Integer.class, "fuel_type");
    public static final RecipeMetadataKey<Integer> FUEL_VALUE = SimpleRecipeMetadataKey.create(Integer.class, "fuel_value");
    public static final RecipeMetadataKey<Integer> COIL_HEAT = SimpleRecipeMetadataKey.create(Integer.class, "coil_heat");
    public static final RecipeMetadataKey<ItemStack> RESEARCH_ITEM = SimpleRecipeMetadataKey.create(ItemStack.class, "research_item");
    public static final RecipeMetadataKey<Object> OREDICT_INPUT = SimpleRecipeMetadataKey.create(Object.class, "oredict_input");
    public static final RecipeMetadataKey<Materials> MATERIAL = SimpleRecipeMetadataKey.create(Materials.class, "material");
    public static final RecipeMetadataKey<Boolean> RECYCLE = SimpleRecipeMetadataKey.create(Boolean.class, "recycle");
    public static final RecipeMetadataKey<Boolean> EXPLODE = SimpleRecipeMetadataKey.create(Boolean.class, "explode");
    public static final RecipeMetadataKey<Boolean> ON_FIRE = SimpleRecipeMetadataKey.create(Boolean.class, "on_fire");
    public static final IRecipeMap UniversalArcFurnace = IRecipeMap.newRecipeMap(builder -> {
        if (!GT_Utility.isArrayOfLength(builder.getItemInputsBasic(), 1) || GT_Utility.isArrayEmptyOrNull(builder.getItemOutputs())) {
            return Collections.emptyList();
        }
        int aDuration = builder.getDuration();
        aDuration = GregTech_API.sRecipeFile.get((Object)"arcfurnace", builder.getItemInputBasic(0), aDuration);
        if (aDuration <= 0) {
            return Collections.emptyList();
        }
        builder.duration(aDuration);
        boolean recycle = builder.getMetadataOrDefault(RECYCLE, false);
        ArrayList<GT_Recipe> ret = new ArrayList<GT_Recipe>();
        for (Materials mat : new Materials[]{Materials.Argon, Materials.Nitrogen}) {
            int tPlasmaAmount = (int)Math.max(1L, (long)aDuration / (mat.getMass() * 16L));
            GT_RecipeBuilder plasmaBuilder = builder.copy().fluidInputs(mat.getPlasma(tPlasmaAmount)).fluidOutputs(mat.getGas(tPlasmaAmount));
            if (recycle) {
                plasmaBuilder.recipeCategory(RecipeCategories.plasmaArcFurnaceRecycling);
            }
            ret.addAll(RecipeMaps.plasmaArcFurnaceRecipes.doAdd(plasmaBuilder));
        }
        GT_RecipeBuilder arcBuilder = builder.copy().fluidInputs(Materials.Oxygen.getGas(aDuration));
        if (recycle) {
            arcBuilder.recipeCategory(RecipeCategories.arcFurnaceRecycling);
        }
        ret.addAll(RecipeMaps.arcFurnaceRecipes.doAdd(arcBuilder));
        return ret;
    });
    public static final IRecipeMap UniversalChemical = IRecipeMap.newRecipeMap(builder -> {
        for (ItemStack input : builder.getItemInputsBasic()) {
            if (!GT_Utility.isAnyIntegratedCircuit(input) || input.func_77960_j() < 10) continue;
            return builder.addTo(RecipeMaps.chemicalReactorRecipes);
        }
        return GT_Utility.concat(builder.copy().addTo(RecipeMaps.chemicalReactorRecipes), GT_RecipeMapUtil.convertCellToFluid(builder, false).metadata(CLEANROOM, false).addTo(RecipeMaps.multiblockChemicalReactorRecipes));
    });
    public static final IRecipeMap AssemblyLine = IRecipeMap.newRecipeMap(builder -> {
        Optional<GT_Recipe.GT_Recipe_WithAlt> rr = builder.forceOreDictInput().validateInputCount(4, 16).validateOutputCount(1, 1).validateOutputFluidCount(-1, 0).validateInputFluidCount(0, 4).buildWithAlt();
        if (!rr.isPresent()) {
            return Collections.emptyList();
        }
        GT_Recipe.GT_Recipe_WithAlt r = rr.get();
        ItemStack[][] mOreDictAlt = r.mOreDictAlt;
        Object[] inputs = builder.getItemInputsOreDict();
        ItemStack aResearchItem = builder.getMetadata(RESEARCH_ITEM);
        if (aResearchItem == null) {
            return Collections.emptyList();
        }
        ItemStack aOutput = r.mOutputs[0];
        int tPersistentHash = 1;
        int mOreDictAltLength = mOreDictAlt.length;
        for (int i = 0; i < mOreDictAltLength; ++i) {
            ItemStack[] alts = mOreDictAlt[i];
            Object input = inputs[i];
            if (input == null) {
                GT_Log.err.println("addAssemblingLineRecipe " + aResearchItem.func_82833_r() + " --> " + aOutput.func_77977_a() + " there is some null item in that recipe");
            }
            if (input instanceof ItemStack) {
                tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash((ItemStack)input, true, false);
                continue;
            }
            if (input instanceof ItemStack[]) {
                for (ItemStack alt : (ItemStack[])input) {
                    tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(alt, true, false);
                    if (alt != null) continue;
                    GT_Log.err.println("addAssemblingLineRecipe " + aResearchItem.func_82833_r() + " --> " + aOutput.func_77977_a() + " there is some null alt item in that recipe");
                }
                tPersistentHash *= 31;
                continue;
            }
            if (!(input instanceof Object[])) continue;
            Object[] objs = (Object[])input;
            Arrays.sort(alts, Comparator.comparing(s -> GameRegistry.findUniqueIdentifierFor((Item)s.func_77973_b()).modId).thenComparing(s -> GameRegistry.findUniqueIdentifierFor((Item)s.func_77973_b()).name).thenComparingInt(arg_0 -> ((Item)Items.field_151008_G).getDamage(arg_0)).thenComparingInt(s -> s.field_77994_a));
            tPersistentHash = tPersistentHash * 31 + (objs[0] == null ? "" : objs[0].toString()).hashCode();
            tPersistentHash = tPersistentHash * 31 + ((Number)objs[1]).intValue();
        }
        tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aResearchItem, true, false);
        tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(aOutput, true, false);
        for (FluidStack fluidInput : r.mFluidInputs) {
            if (fluidInput == null) continue;
            tPersistentHash = tPersistentHash * 31 + GT_Utility.persistentHash(fluidInput, true, false);
        }
        int aResearchTime = builder.getMetadataOrDefault(RESEARCH_TIME, 0);
        tPersistentHash = tPersistentHash * 31 + aResearchTime;
        tPersistentHash = tPersistentHash * 31 + r.mDuration;
        tPersistentHash = tPersistentHash * 31 + r.mEUt;
        ArrayList<GT_Recipe> ret = new ArrayList<GT_Recipe>(3);
        ret.add(RecipeMaps.scannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{aResearchItem}, new ItemStack[]{aOutput}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Writes Research result", new Object[0])}, null, null, aResearchTime, 30, -201));
        ret.add(RecipeMaps.assemblylineVisualRecipes.addFakeRecipe(false, r.mInputs, new ItemStack[]{aOutput}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Reads Research result", new Object[0])}, r.mFluidInputs, null, r.mDuration, r.mEUt, 0, r.mOreDictAlt, false));
        GT_Recipe.GT_Recipe_AssemblyLine tRecipe = new GT_Recipe.GT_Recipe_AssemblyLine(aResearchItem, aResearchTime, r.mInputs, r.mFluidInputs, aOutput, r.mDuration, r.mEUt, r.mOreDictAlt);
        tRecipe.setPersistentHash(tPersistentHash);
        GT_Recipe.GT_Recipe_AssemblyLine.sAssemblylineRecipes.add(tRecipe);
        GT_AssemblyLineUtils.addRecipeToCache(tRecipe);
        return ret;
    });
    public static IRecipeMap AssemblerOD = IRecipeMap.newRecipeMap(builder -> {
        ArrayList<GT_Recipe> ret = new ArrayList<GT_Recipe>();
        for (ItemStack input : GT_OreDictUnificator.getOresImmutable(builder.getMetadata(OREDICT_INPUT))) {
            ret.addAll(builder.copy().itemInputs(GT_RecipeMapUtil.appendArray(builder.getItemInputsBasic(), input)).addTo(RecipeMaps.assemblerRecipes));
        }
        return ret;
    });
    public static IRecipeMap Fuel = IRecipeMap.newRecipeMap(builder -> {
        builder.validateInputCount(1, 1).validateNoInputFluid().validateOutputCount(-1, 1).validateNoOutputFluid();
        if (!builder.isValid()) {
            return Collections.emptyList();
        }
        Integer fuelType = builder.getMetadata(FUEL_TYPE);
        if (fuelType == null) {
            return Collections.emptyList();
        }
        builder.metadata(FUEL_VALUE, GregTech_API.sRecipeFile.get((Object)("fuel_" + fuelType), builder.getItemInputBasic(0), (int)builder.getMetadataOrDefault(FUEL_VALUE, 0)));
        return FuelType.get(fuelType).getTarget().doAdd((GT_RecipeBuilder)builder);
    });

    static {
        GT_RecipeMapUtil.SPECIAL_VALUE_ALIASES.add(COIL_HEAT);
        GT_RecipeMapUtil.SPECIAL_VALUE_ALIASES.add(FUSION_THRESHOLD);
        GT_RecipeMapUtil.SPECIAL_VALUE_ALIASES.add(FUEL_VALUE);
    }

    public static enum FuelType {
        DieselFuel(RecipeMaps.dieselFuels),
        GasTurbine(RecipeMaps.gasTurbineFuels),
        HotFuel(RecipeMaps.hotFuels),
        SemiFluid(RecipeMaps.denseLiquidFuels),
        PlasmaTurbine(RecipeMaps.plasmaFuels),
        Magic(RecipeMaps.magicFuels);

        private static final FuelType[] VALUES;
        private final IRecipeMap target;

        private FuelType(IRecipeMap target) {
            this.target = target;
        }

        public static FuelType get(int fuelType) {
            if (fuelType < 0 || fuelType >= VALUES.length) {
                return SemiFluid;
            }
            return VALUES[fuelType];
        }

        public IRecipeMap getTarget() {
            return this.target;
        }

        static {
            VALUES = FuelType.values();
        }
    }
}

