/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.util.GT_ToolHarvestHelper;
import gregtech.common.items.behaviors.Behaviour_Wrench;
import gregtech.common.tools.GT_Tool;
import ic2.api.tile.IWrenchable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public class GT_Tool_Wrench
extends GT_Tool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(46) + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 800;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 200;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.IC2_TOOLS_WRENCH.toString();
    }

    @Override
    public String getEntityHitSound() {
        return null;
    }

    @Override
    public String getMiningSound() {
        return SoundResource.IC2_TOOLS_WRENCH.toString();
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean isCrowbar() {
        return false;
    }

    @Override
    public boolean isWrench() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, byte aMetaData) {
        return GT_ToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "wrench") || GT_ToolHarvestHelper.isAppropriateMaterial(aBlock, Material.field_76233_E) || GT_ToolHarvestHelper.isSpecialBlock(aBlock, new Block[]{Blocks.field_150438_bZ, Blocks.field_150367_z, Blocks.field_150409_cd});
    }

    @Override
    public ItemStack getBrokenItem(ItemStack aStack) {
        return null;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? Textures.ItemIcons.WRENCH : null;
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).mRGBa : null;
    }

    @Override
    public void onStatsAddedToTool(GT_MetaGenerated_Tool aItem, int aID) {
        aItem.addItemBehavior(aID, new Behaviour_Wrench(100));
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE + " threw a Monkey Wrench into the Plans of " + EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE);
    }

    @Override
    public float getMiningSpeed(Block block, byte metadata, float mineSpeed, EntityPlayer player, World world, int x, int y, int z) {
        Item item;
        ItemStack holding = player.func_71045_bC();
        if (holding == null || !((item = holding.func_77973_b()) instanceof GT_MetaGenerated_Tool)) {
            return mineSpeed;
        }
        GT_MetaGenerated_Tool tool = (GT_MetaGenerated_Tool)item;
        IToolStats stats = tool.getToolStats(holding);
        if (stats == null) {
            return mineSpeed;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null) {
            return mineSpeed;
        }
        float newSpeed = Math.max(Float.MIN_NORMAL, this.getSpeedMultiplier() * GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)holding).mToolSpeed);
        if (tile instanceof IWrenchable) {
            return newSpeed;
        }
        return mineSpeed;
    }

    @Override
    public void onBreakBlock(@Nonnull EntityPlayer player, int x, int y, int z, @Nonnull Block block, byte metadata, TileEntity tile, @Nonnull BlockEvent.BreakEvent event) {
        World world = player.field_70170_p;
        if (tile instanceof IWrenchable) {
            IWrenchable wrenchable = (IWrenchable)tile;
            ItemStack drop = wrenchable.getWrenchDrop(player);
            world.func_147468_f(x, y, z);
            world.func_72838_d((Entity)new EntityItem(world, (double)x, (double)y, (double)z, drop));
        }
    }
}

