/*
 * Decompiled with CFR 0.152.
 */
package openmods.fakeplayer;

import com.google.common.base.Preconditions;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.UUID;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import openmods.Log;

public class OpenModsFakePlayer
extends FakePlayer {
    OpenModsFakePlayer(WorldServer world, int id) {
        super(world, OpenModsFakePlayer.createProfile(String.format("OpenModsFakePlayer-%03d", id)));
        GameProfile profile = this.func_146103_bH();
        Log.debug("Creating new fake player: name = %s, id = %s", profile.getName(), profile.getId());
    }

    private static GameProfile createProfile(String name) {
        UUID uuid = UUID.nameUUIDFromBytes(name.getBytes());
        return new GameProfile(uuid, name);
    }

    public void func_70106_y() {
        this.field_71071_by.func_146027_a(null, -1);
        this.field_70128_L = true;
    }

    public void dropItemAt(ItemStack itemStack, int x, int y, int z, ForgeDirection direction) {
        this.func_70107_b((float)x + 0.5f, (double)y - 1.5, (float)z + 0.5f);
        Preconditions.checkArgument((direction == ForgeDirection.DOWN ? 1 : 0) != 0, (Object)"Other directions than down are not implemented");
        this.func_70101_b(0.0f, 90.0f);
        EntityItem entityItem = this.func_71019_a(itemStack, false);
        if (entityItem != null) {
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
        } else {
            Log.info("Item %s drop from player %s aborted by event", new Object[]{itemStack, this});
        }
    }

    public boolean tryPlaceItem(ItemStack itemStack, int x, int y, int z, ForgeDirection side, float hitX, float hitY, float hitZ) {
        if (itemStack == null) {
            return false;
        }
        int opposite = side.getOpposite().ordinal();
        PlayerInteractEvent event = ForgeEventFactory.onPlayerInteract((EntityPlayer)this, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)opposite, (World)this.field_70170_p);
        if (event.isCanceled()) {
            return false;
        }
        Item usedItem = itemStack.func_77973_b();
        if (usedItem.onItemUseFirst(itemStack, (EntityPlayer)this, this.field_70170_p, x, y, z, opposite, hitX, hitY, hitZ)) {
            return true;
        }
        if (event.useItem == Event.Result.DENY) {
            return false;
        }
        try {
            return itemStack.func_77943_a((EntityPlayer)this, this.field_70170_p, x, y, z, opposite, hitX, hitY, hitZ);
        }
        catch (Throwable t) {
            Log.warn(t, "Invalid use of fake player with item %s @ (%d,%d,%d), aborting. Don't do it again", usedItem, x, y, z);
            return false;
        }
    }
}

