/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkContainerInfo;
import codechicken.nei.Button;
import codechicken.nei.ButtonCycled;
import codechicken.nei.ItemPanel;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.LayoutManager;
import codechicken.nei.LayoutStyleMinecraft;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PanelWidget;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IBookmarkContainerHandler;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.BookmarkRecipeId;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import codechicken.nei.util.ReadableNumberConverter;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.GL11;

public class BookmarkPanel
extends PanelWidget {
    protected File bookmarkFile;
    protected boolean bookmarksIsLoaded = false;
    public int sortedStackIndex = -1;
    public int sortedNamespaceIndex = -1;
    public Button namespacePrev;
    public Button namespaceNext;
    public Button pullBookmarkedItems;
    public Label namespaceLabel;
    protected List<BookmarkGrid> namespaces = new ArrayList<BookmarkGrid>();
    protected int activeNamespaceIndex = 0;

    public BookmarkPanel() {
        this.grid = new BookmarkGrid();
    }

    @Override
    public void init() {
        super.init();
        this.namespaceLabel = new Label("1", true);
        this.namespacePrev = new Button("Prev"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.prevNamespace();
            }

            @Override
            public String getRenderLabel() {
                return "<";
            }
        };
        this.namespaceNext = new Button("Next"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.nextNamespace();
            }

            @Override
            public String getRenderLabel() {
                return ">";
            }
        };
        this.pullBookmarkedItems = new Button("Pull"){

            @Override
            public boolean onButtonPress(boolean rightclick) {
                if (rightclick) {
                    return false;
                }
                return BookmarkPanel.this.pullBookmarkItems();
            }

            @Override
            public String getRenderLabel() {
                return "P";
            }
        };
        this.namespaces.add(new BookmarkGrid());
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
    }

    @Override
    public String getLabelText() {
        int size = this.grid.size();
        if (((BookmarkGrid)this.grid).getViewMode() == BookmarkViewMode.TODO_LIST) {
            size = ((BookmarkGrid)this.grid).todoItemsCount;
        }
        return String.format("(%d/%d) [%d]", this.getPage(), Math.max(1, this.getNumPages()), size);
    }

    public void addItem(ItemStack itemStack) {
        this.addItem(itemStack, true);
    }

    public void addItem(ItemStack itemStack, boolean saveStackSize) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        int idx = BGrid.indexOf(itemStack, true);
        if (idx != -1) {
            BGrid.removeItem(idx);
        }
        this.addOrRemoveItem(itemStack, null, null, false, saveStackSize);
    }

    public int getNameSpaceSize() {
        return this.namespaces.size();
    }

    public void addOrRemoveItem(ItemStack stackA) {
        this.addOrRemoveItem(stackA, null, null, false, false);
    }

    public void addOrRemoveItem(ItemStack stackover, String handlerName, List<PositionedStack> ingredients, boolean saveIngredients, boolean saveStackSize) {
        this.loadBookmarksIfNeeded();
        Point mousePos = GuiDraw.getMousePosition();
        ItemPanel.ItemPanelSlot slot = this.getSlotMouseOver(mousePos.x, mousePos.y);
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        if (slot != null && StackInfo.equalItemAndNBT(slot.item, stackover, true)) {
            BGrid.removeRecipe(slot.slotIndex, saveIngredients);
        } else {
            int idx;
            NBTTagCompound nbTagA = StackInfo.itemStackToNBT(stackover, saveStackSize);
            ItemStack normalizedA = StackInfo.loadFromNBT(nbTagA);
            BookmarkRecipeId recipeId = null;
            if (handlerName != "" && ingredients != null) {
                recipeId = new BookmarkRecipeId(handlerName, ingredients);
            }
            if ((idx = BGrid.indexOf(normalizedA, recipeId)) != -1) {
                BGrid.removeRecipe(idx, saveIngredients);
            } else {
                if (saveIngredients && handlerName != "" && ingredients != null) {
                    HashMap<NBTTagCompound, Integer> unique = new HashMap<NBTTagCompound, Integer>();
                    ArrayList<NBTTagCompound> sorted = new ArrayList<NBTTagCompound>();
                    BGrid.removeRecipe(recipeId);
                    for (PositionedStack stack : ingredients) {
                        NBTTagCompound nbTag = StackInfo.itemStackToNBT(stack.item, saveStackSize);
                        if (unique.get(nbTag) == null) {
                            unique.put(nbTag, 1);
                            sorted.add(nbTag);
                            continue;
                        }
                        unique.put(nbTag, (Integer)unique.get(nbTag) + 1);
                    }
                    for (NBTTagCompound nbTag : sorted) {
                        int count = nbTag.func_74762_e("Count") * (Integer)unique.get(nbTag);
                        nbTag.func_74768_a("Count", count);
                        BGrid.addItem(StackInfo.loadFromNBT(nbTag), new BookmarkStackMeta(recipeId != null ? recipeId.copy() : null, (saveStackSize ? 1 : -1) * count, true, nbTag.func_74764_b("gtFluidName")));
                    }
                }
                BGrid.addItem(normalizedA, new BookmarkStackMeta(recipeId, (saveStackSize ? 1 : -1) * nbTagA.func_74762_e("Count"), false, nbTagA.func_74764_b("gtFluidName")));
            }
        }
        this.fixCountOfNamespaces();
        this.saveBookmarks();
    }

    public BookmarkRecipeId getBookmarkRecipeId(int slotIndex) {
        return ((BookmarkGrid)this.grid).getRecipeId(slotIndex);
    }

    public BookmarkRecipeId getBookmarkRecipeId(ItemStack stackA) {
        BookmarkRecipeId recipeId = ((BookmarkGrid)this.grid).findRecipeId(stackA);
        if (recipeId == null) {
            for (int idx = 0; idx < this.getNameSpaceSize() && recipeId == null; ++idx) {
                if (idx == this.activeNamespaceIndex) continue;
                recipeId = this.namespaces.get(idx).findRecipeId(stackA);
            }
        }
        return recipeId;
    }

    protected String getNamespaceLabelText(boolean shortFormat) {
        String activePage = String.valueOf(this.activeNamespaceIndex + 1);
        return shortFormat ? activePage : activePage + "/" + this.fixCountOfNamespaces();
    }

    protected int fixCountOfNamespaces() {
        if (this.namespaces.get(this.getNameSpaceSize() - 1).size() > 0) {
            this.namespaces.add(new BookmarkGrid());
        } else if (this.activeNamespaceIndex == this.getNameSpaceSize() - 2 && this.grid.size() == 0) {
            this.namespaces.remove(this.getNameSpaceSize() - 1);
        }
        return this.getNameSpaceSize();
    }

    protected boolean removeEmptyNamespaces() {
        if (this.activeNamespaceIndex != this.getNameSpaceSize() - 1 && this.grid.size() == 0) {
            this.namespaces.remove(this.activeNamespaceIndex);
            this.grid = this.namespaces.get(this.activeNamespaceIndex);
            return true;
        }
        return false;
    }

    protected boolean prevNamespace() {
        if (!this.bookmarksIsLoaded) {
            return false;
        }
        this.fixCountOfNamespaces();
        this.removeEmptyNamespaces();
        this.activeNamespaceIndex = this.activeNamespaceIndex == 0 ? this.getNameSpaceSize() - 1 : --this.activeNamespaceIndex;
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        return true;
    }

    protected boolean nextNamespace() {
        if (!this.bookmarksIsLoaded) {
            return false;
        }
        if (this.removeEmptyNamespaces()) {
            return true;
        }
        this.activeNamespaceIndex = this.activeNamespaceIndex == this.fixCountOfNamespaces() - 1 ? 0 : ++this.activeNamespaceIndex;
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
        return true;
    }

    public void setBookmarkFile(String worldPath) {
        File dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.bookmarkFile = new File(dir, "bookmarks.ini");
        if (!this.bookmarkFile.exists()) {
            File defaultBookmarks;
            File globalBookmarks = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/bookmarks.ini");
            File configBookmarks = new File(NEIClientConfig.configDir, "bookmarks.ini");
            File file = defaultBookmarks = configBookmarks.exists() ? configBookmarks : globalBookmarks;
            if (defaultBookmarks.exists()) {
                try {
                    this.bookmarkFile.createNewFile();
                    FileInputStream src = new FileInputStream(defaultBookmarks);
                    FileOutputStream dst = new FileOutputStream(this.bookmarkFile);
                    IOUtils.copy((InputStream)src, (OutputStream)dst);
                    ((InputStream)src).close();
                    ((OutputStream)dst).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.bookmarksIsLoaded = false;
    }

    public void saveBookmarks() {
        if (this.bookmarkFile == null) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int grpIdx = 0; grpIdx < this.getNameSpaceSize() - 1; ++grpIdx) {
            BookmarkGrid grid = this.namespaces.get(grpIdx);
            JsonObject settings = new JsonObject();
            settings.add("viewmode", (JsonElement)new JsonPrimitive(grid.getViewMode().toString()));
            settings.add("active", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.activeNamespaceIndex == grpIdx)));
            strings.add("; " + NBTJson.toJson((JsonElement)settings));
            for (int idx = 0; idx < grid.size(); ++idx) {
                try {
                    NBTTagCompound nbTag = StackInfo.itemStackToNBT(grid.getItem(idx));
                    if (nbTag == null) continue;
                    JsonObject row = new JsonObject();
                    BookmarkStackMeta meta = grid.getMetadata(idx);
                    row.add("item", NBTJson.toJsonObject((NBTBase)nbTag));
                    row.add("factor", (JsonElement)new JsonPrimitive((Number)meta.factor));
                    row.add("ingredient", (JsonElement)new JsonPrimitive(Boolean.valueOf(meta.ingredient)));
                    if (meta.recipeId != null) {
                        row.add("recipeId", (JsonElement)meta.recipeId.toJsonObject());
                    }
                    strings.add(NBTJson.toJson((JsonElement)row));
                    continue;
                }
                catch (JsonSyntaxException e) {
                    NEIClientConfig.logger.error("Failed to stringify bookmarked ItemStack to json string");
                }
            }
        }
        try (FileOutputStream output = new FileOutputStream(this.bookmarkFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save bookmarks list to file {}", new Object[]{this.bookmarkFile, e});
        }
    }

    public void loadBookmarksIfNeeded() {
        List itemStrings;
        if (this.bookmarksIsLoaded) {
            return;
        }
        this.bookmarksIsLoaded = true;
        if (this.bookmarkFile == null || !this.bookmarkFile.exists()) {
            return;
        }
        try (FileInputStream reader = new FileInputStream(this.bookmarkFile);){
            NEIClientConfig.logger.info("Loading bookmarks from file {}", new Object[]{this.bookmarkFile});
            itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load bookmarks from file {}", new Object[]{this.bookmarkFile, e});
            return;
        }
        this.namespaces.clear();
        this.namespaces.add(new BookmarkGrid());
        this.activeNamespaceIndex = -1;
        JsonParser parser = new JsonParser();
        int namespaceIndex = 0;
        for (String itemStr : itemStrings) {
            try {
                ItemStack itemStack;
                if (itemStr.isEmpty()) {
                    itemStr = "; {}";
                }
                if (itemStr.startsWith("; ")) {
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (this.namespaces.get(namespaceIndex).size() > 0) {
                        this.namespaces.add(new BookmarkGrid());
                        ++namespaceIndex;
                    }
                    if (settings.get("viewmode") != null) {
                        this.namespaces.get(namespaceIndex).setViewMode(BookmarkViewMode.valueOf(settings.get("viewmode").getAsString()));
                    }
                    if (settings.get("active") == null || !settings.get("active").getAsBoolean()) continue;
                    this.activeNamespaceIndex = namespaceIndex;
                    continue;
                }
                JsonObject jsonObject = parser.parse(itemStr).getAsJsonObject();
                BookmarkRecipeId recipeId = null;
                NBTTagCompound itemStackNBT = jsonObject.get("item") != null ? (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item")) : (NBTTagCompound)NBTJson.toNbt((JsonElement)jsonObject);
                if (jsonObject.get("recipeId") != null && jsonObject.get("recipeId") instanceof JsonObject) {
                    recipeId = new BookmarkRecipeId((JsonObject)jsonObject.get("recipeId"));
                }
                if ((itemStack = StackInfo.loadFromNBT(itemStackNBT)) != null) {
                    this.namespaces.get(namespaceIndex).addItem(itemStack, new BookmarkStackMeta(recipeId, jsonObject.has("factor") ? jsonObject.get("factor").getAsInt() : 0, jsonObject.has("ingredient") ? jsonObject.get("ingredient").getAsBoolean() : false, itemStackNBT.func_74764_b("gtFluidName")), false);
                    continue;
                }
                NEIClientConfig.logger.warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", new Object[]{itemStr});
            }
            catch (JsonSyntaxException | IllegalArgumentException e) {
                NEIClientConfig.logger.error("Failed to load bookmarked ItemStack from json string:\n{}", new Object[]{itemStr});
            }
        }
        if (this.activeNamespaceIndex == -1) {
            this.activeNamespaceIndex = namespaceIndex;
        }
        this.grid = this.namespaces.get(this.activeNamespaceIndex);
    }

    @Override
    public void resize(GuiContainer gui) {
        this.loadBookmarksIfNeeded();
        super.resize(gui);
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        LayoutStyleMinecraft layout = (LayoutStyleMinecraft)LayoutManager.getLayoutStyle();
        int rows = (int)Math.ceil((double)layout.buttonCount / (double)layout.numButtons);
        int diff = rows * 18 + this.getMarginTop(gui) - this.y;
        if (diff > 0) {
            this.y += diff;
            this.h -= diff;
        }
        return super.resizeHeader(gui);
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        int BUTTON_SIZE = 16;
        ButtonCycled button = LayoutManager.bookmarksButton;
        int leftBorder = this.y + this.h > button.y ? button.x + button.w + 2 : this.x;
        int rightBorder = this.x + this.w;
        int center = leftBorder + Math.max(0, (rightBorder - leftBorder) / 2);
        int labelWidth = 2;
        this.pullBookmarkedItems.h = 16;
        this.namespaceNext.h = 16;
        this.namespacePrev.h = 16;
        this.pullBookmarkedItems.w = 16;
        this.namespaceNext.w = 16;
        this.namespacePrev.w = 16;
        this.namespaceNext.y = this.pullBookmarkedItems.y = this.y + this.h - 16;
        this.namespacePrev.y = this.pullBookmarkedItems.y;
        if (rightBorder - leftBorder >= 70) {
            labelWidth = 36;
            this.namespaceLabel.text = this.getNamespaceLabelText(false);
        } else {
            labelWidth = 18;
            this.namespaceLabel.text = this.getNamespaceLabelText(true);
        }
        this.namespaceLabel.y = this.namespacePrev.y + 5;
        this.namespaceLabel.x = center;
        this.namespacePrev.x = center - labelWidth / 2 - 2 - this.namespacePrev.w;
        this.namespaceNext.x = center + labelWidth / 2 + 2;
        this.pullBookmarkedItems.x = center + 2 * labelWidth / 2 + 2;
        return 18;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (this.grid.getPerPage() > 0) {
            LayoutManager.addWidget(this.namespacePrev);
            LayoutManager.addWidget(this.namespaceNext);
            LayoutManager.addWidget(this.namespaceLabel);
            if (BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
                LayoutManager.addWidget(this.pullBookmarkedItems);
            }
        }
    }

    @Override
    protected String getPositioningSettingName() {
        return "world.panels.bookmarks";
    }

    @Override
    public int getMarginLeft(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getMarginTop(GuiContainer gui) {
        return 2;
    }

    @Override
    public int getWidth(GuiContainer gui) {
        return gui.field_146294_l - (gui.field_146999_f + gui.field_146294_l) / 2 - 4;
    }

    @Override
    public int getHeight(GuiContainer gui) {
        return gui.field_146295_m - this.getMarginTop(gui) - 2;
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(int mouseDownSlot) {
        ItemStack stack = this.grid.getItem(mouseDownSlot);
        if (stack == null) {
            return null;
        }
        BookmarkStackMeta meta = ((BookmarkGrid)this.grid).getMetadata(mouseDownSlot);
        int amount = stack.field_77994_a;
        if (meta.factor < 0 && !meta.fluidDisplay) {
            int n = amount = NEIClientConfig.showItemQuantityWidget() ? NEIClientConfig.getItemQuantity() : 0;
            if (amount == 0) {
                amount = stack.func_77976_d();
            }
        }
        return NEIServerUtils.copyStack(stack, amount);
    }

    @Override
    public void mouseDragged(int mousex, int mousey, int button, long heldTime) {
        if (button == 0 && NEIClientUtils.shiftKey() && this.mouseDownSlot >= 0) {
            ItemPanel.ItemPanelSlot mouseOverSlot = this.getSlotMouseOver(mousex, mousey);
            if (this.sortedStackIndex == -1) {
                ItemStack stack = this.grid.getItem(this.mouseDownSlot);
                if (stack != null && (mouseOverSlot == null || mouseOverSlot.slotIndex != this.mouseDownSlot || heldTime > 250L)) {
                    this.sortedNamespaceIndex = this.activeNamespaceIndex;
                    this.sortedStackIndex = this.mouseDownSlot;
                    this.grid.onGridChanged();
                }
            } else if (this.sortedNamespaceIndex != this.activeNamespaceIndex) {
                BookmarkGrid hoverGrid = this.namespaces.get(this.activeNamespaceIndex);
                BookmarkGrid sortedGrid = this.namespaces.get(this.sortedNamespaceIndex);
                if (mouseOverSlot != null || this.getNextSlot(new Point(mousex, mousey)) >= 0) {
                    ItemStack stack = sortedGrid.getItem(this.sortedStackIndex);
                    BookmarkStackMeta meta = sortedGrid.getMetadata(this.sortedStackIndex);
                    sortedGrid.removeItem(this.sortedStackIndex);
                    hoverGrid.addItem(stack, meta, false);
                    this.sortedNamespaceIndex = this.activeNamespaceIndex;
                    this.sortedStackIndex = hoverGrid.indexOf(stack, meta.recipeId);
                }
            } else if (mouseOverSlot == null || mouseOverSlot.slotIndex != this.sortedStackIndex) {
                BookmarkGrid sortedGrid = this.namespaces.get(this.sortedNamespaceIndex);
                if (mouseOverSlot != null && sortedGrid.getViewMode() == BookmarkViewMode.DEFAULT) {
                    sortedGrid.moveItem(this.sortedStackIndex, mouseOverSlot.slotIndex);
                    this.sortedStackIndex = mouseOverSlot.slotIndex;
                } else if (sortedGrid.getViewMode() == BookmarkViewMode.TODO_LIST) {
                    boolean isIngredient;
                    ItemStack stack = sortedGrid.getItem(this.sortedStackIndex);
                    BookmarkStackMeta meta = sortedGrid.getMetadata(this.sortedStackIndex);
                    boolean bl = isIngredient = this.sortedStackIndex > 0 && meta.recipeId != null && meta.ingredient && meta.recipeId.equals(sortedGrid.getRecipeId(this.sortedStackIndex - 1));
                    if (!isIngredient) {
                        mouseOverSlot = this.getSlotMouseOver(this.grid.marginLeft + this.grid.paddingLeft, mousey);
                        if (mouseOverSlot != null && this.sortedStackIndex != mouseOverSlot.slotIndex) {
                            sortedGrid.moveItem(this.sortedStackIndex, mouseOverSlot.slotIndex);
                            this.sortedStackIndex = sortedGrid.indexOf(stack, meta.recipeId);
                        }
                    } else if (mouseOverSlot != null && meta.recipeId != null && sortedGrid.getMetadata((int)mouseOverSlot.slotIndex).ingredient && meta.recipeId.equals(sortedGrid.getRecipeId(mouseOverSlot.slotIndex))) {
                        sortedGrid.moveItem(this.sortedStackIndex, mouseOverSlot.slotIndex);
                        this.sortedStackIndex = sortedGrid.indexOf(stack, meta.recipeId);
                    }
                }
            }
            return;
        }
        super.mouseDragged(mousex, mousey, button, heldTime);
    }

    private int getNextSlot(Point point) {
        List<Integer> mask = this.grid.getMask();
        int columns = this.grid.getColumns();
        int perPage = this.grid.getRows() * columns;
        boolean line = ((BookmarkGrid)this.grid).getViewMode() == BookmarkViewMode.TODO_LIST;
        for (int i = mask.size(); i < perPage; ++i) {
            if (this.grid.isInvalidSlot(i) || line && i % columns != 0) continue;
            if (point == null || this.grid.getSlotRect(i).contains(point.x, point.y)) {
                return i;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public void postDraw(int mousex, int mousey) {
        int idx;
        if (this.sortedStackIndex != -1) {
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            GuiContainerManager.drawItem(mousex - 8, mousey - 8, this.namespaces.get(this.sortedNamespaceIndex).getItem(this.sortedStackIndex).func_77946_l(), true);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
        }
        if (ItemPanels.itemPanel.draggedStack != null && this.contains(mousex, mousey) && (idx = this.getNextSlot(null)) >= 0) {
            Rectangle4i rect = this.grid.getSlotRect(idx);
            GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
        }
        super.postDraw(mousex, mousey);
    }

    @Override
    public boolean handleClickExt(int mousex, int mousey, int button) {
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mousex, mousey)) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            if (BGrid.getViewMode() == BookmarkViewMode.DEFAULT) {
                BGrid.setViewMode(BookmarkViewMode.TODO_LIST);
            } else {
                BGrid.setViewMode(BookmarkViewMode.DEFAULT);
            }
            this.saveBookmarks();
            return true;
        }
        return super.handleClickExt(mousex, mousey, button);
    }

    @Override
    public List<String> handleTooltip(int mx, int my, List<String> tooltip) {
        if (new Rectangle4i(this.pagePrev.x + this.pagePrev.w, this.pagePrev.y, this.pageNext.x - (this.pagePrev.x + this.pagePrev.w), this.pagePrev.h).contains(mx, my)) {
            tooltip.add(NEIClientUtils.translate("bookmark.viewmode.toggle.tip", new Object[0]));
        }
        if (new Rectangle4i(this.pullBookmarkedItems.x, this.pullBookmarkedItems.y, this.pullBookmarkedItems.w, this.pullBookmarkedItems.h).contains(mx, my) && BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer()) != null) {
            tooltip.add(NEIClientUtils.translate("bookmark.pullBookmarkedItems.tip", new Object[0]));
        }
        return super.handleTooltip(mx, my, tooltip);
    }

    @Override
    public void mouseUp(int mousex, int mousey, int button) {
        if (this.sortedStackIndex != -1) {
            this.draggedStack = null;
            this.sortedNamespaceIndex = -1;
            this.sortedStackIndex = -1;
            this.mouseDownSlot = -1;
            this.grid.onGridChanged();
            this.saveBookmarks();
        } else {
            super.mouseUp(mousex, mousey, button);
        }
    }

    @Override
    public boolean onMouseWheel(int shift, int mousex, int mousey) {
        ItemPanel.ItemPanelSlot slot;
        if (new Rectangle4i(this.namespacePrev.x, this.namespacePrev.y, this.namespaceNext.x + this.namespaceNext.w - this.namespacePrev.x, this.namespacePrev.h).contains(mousex, mousey)) {
            if (shift > 0) {
                this.prevNamespace();
            } else {
                this.nextNamespace();
            }
            this.saveBookmarks();
            return true;
        }
        if (!this.contains(mousex, mousey)) {
            return false;
        }
        if (NEIClientUtils.controlKey() && (slot = this.getSlotMouseOver(mousex, mousey)) != null) {
            BookmarkGrid BGrid = (BookmarkGrid)this.grid;
            BookmarkRecipeId recipeId = BGrid.getRecipeId(slot.slotIndex);
            boolean addFullRecipe = NEIClientUtils.shiftKey();
            if (NEIClientUtils.altKey()) {
                shift *= slot.item.func_77976_d();
            }
            if (addFullRecipe) {
                for (int slotIndex = this.grid.size() - 1; slotIndex >= 0; --slotIndex) {
                    BookmarkStackMeta iMeta = BGrid.getMetadata(slotIndex);
                    if (iMeta.recipeId == null || !iMeta.recipeId.equals(recipeId) || slotIndex == slot.slotIndex) continue;
                    this.shiftStackSize(slotIndex, shift);
                }
            }
            this.shiftStackSize(slot.slotIndex, shift);
            this.saveBookmarks();
            return true;
        }
        return super.onMouseWheel(shift, mousex, mousey);
    }

    protected void shiftStackSize(int slotIndex, int shift) {
        BookmarkGrid BGrid = (BookmarkGrid)this.grid;
        NBTTagCompound nbTag = StackInfo.itemStackToNBT(BGrid.getItem(slotIndex), true);
        BookmarkStackMeta meta = BGrid.getMetadata(slotIndex);
        int factor = Math.abs(meta.factor);
        if (nbTag.func_74762_e("Count") == factor && meta.factor < 0 && shift > 0) {
            meta.factor = factor;
        } else {
            int n = meta.factor = nbTag.func_74762_e("Count") == factor && shift < 0 ? -1 * factor : factor;
            if ((long)nbTag.func_74762_e("Count") + (long)factor * (long)shift <= Integer.MAX_VALUE) {
                nbTag.func_74768_a("Count", Math.max(nbTag.func_74762_e("Count") + factor * shift, factor));
                BGrid.replaceItem(slotIndex, StackInfo.loadFromNBT(nbTag));
            }
        }
    }

    public boolean pullBookmarkItems() {
        IBookmarkContainerHandler containerHandler = BookmarkContainerInfo.getBookmarkContainerHandler(NEIClientUtils.getGuiContainer());
        if (containerHandler == null) {
            return false;
        }
        containerHandler.pullBookmarkItemsFromContainer(NEIClientUtils.getGuiContainer(), ((BookmarkGrid)this.grid).realItems);
        return true;
    }

    public static class BookmarkGrid
    extends ItemsGrid {
        protected static final float SCALE_SPEED = 0.1f;
        protected List<List<Integer>> gridMask;
        protected List<BookmarkStackMeta> metadata = new ArrayList<BookmarkStackMeta>();
        protected WeakHashMap<ItemStack, Float> animation = new WeakHashMap();
        protected BookmarkViewMode viewMode = BookmarkViewMode.DEFAULT;
        protected boolean[] todoSpaces;
        protected int todoItemsCount = 0;

        public BookmarkGrid() {
            this.setShowRecipeTooltips(true);
        }

        public void setViewMode(BookmarkViewMode mode) {
            if (this.viewMode == mode) {
                return;
            }
            this.viewMode = mode;
            if (mode == BookmarkViewMode.DEFAULT) {
                this.sortIngredients(false);
                this.todoItemsCount = 0;
                this.gridMask = null;
            }
            this.onGridChanged();
        }

        public BookmarkViewMode getViewMode() {
            return this.viewMode;
        }

        @Override
        public int getNumPages() {
            if (this.gridMask != null) {
                return this.gridMask.size();
            }
            return super.getNumPages();
        }

        @Override
        protected List<Integer> getMask() {
            if (this.gridMask != null) {
                return this.gridMask.size() > this.page ? this.gridMask.get(this.page) : new ArrayList<Integer>();
            }
            return super.getMask();
        }

        private void sortIngredients(boolean forward) {
            int dir = forward ? 1 : -1;
            for (int i = 0; i < this.realItems.size(); ++i) {
                int j;
                BookmarkStackMeta meta = this.metadata.get(i);
                if (meta.recipeId == null || meta.ingredient) continue;
                int shift = 0;
                for (j = i + 1; j < this.realItems.size(); ++j) {
                    if (!meta.recipeId.equals(this.metadata.get((int)j).recipeId)) continue;
                    if (i + shift + dir != j) {
                        this.realItems.add(i + shift + Math.max(dir, 0), this.realItems.remove(j));
                        this.metadata.add(i + shift + Math.max(dir, 0), this.metadata.remove(j));
                    }
                    ++shift;
                }
                for (j = i + shift - 1; j >= 0; --j) {
                    if (!meta.recipeId.equals(this.metadata.get((int)j).recipeId)) continue;
                    if (i + shift + dir != j) {
                        this.realItems.add(i + shift + Math.min(dir, 0), this.realItems.remove(j));
                        this.metadata.add(i + shift + Math.min(dir, 0), this.metadata.remove(j));
                    }
                    --shift;
                }
                i += Math.max(0, shift);
            }
        }

        private void generateToDoSpaces() {
            this.todoItemsCount = 0;
            this.gridMask = new ArrayList<List<Integer>>();
            if (this.rows * this.columns == 0) {
                return;
            }
            boolean isFirstColumn = false;
            boolean isIngredient = false;
            int size = this.size();
            int idx = 0;
            while (idx < size) {
                ArrayList<Integer> pmask = new ArrayList<Integer>();
                int lastIdx = idx;
                int perPage = this.rows * this.columns;
                for (int i = 0; i < perPage && idx < size; ++i) {
                    if (this.isInvalidSlot(i)) {
                        pmask.add(null);
                        continue;
                    }
                    BookmarkStackMeta meta = this.getMetadata(idx);
                    isFirstColumn = i % this.columns == 0;
                    boolean bl = isIngredient = meta.recipeId != null && meta.ingredient;
                    if (isFirstColumn && !isIngredient) {
                        pmask.add(idx++);
                        ++this.todoItemsCount;
                        continue;
                    }
                    if (isIngredient && (!isFirstColumn || i + 1 < perPage && this.isInvalidSlot(i + 1))) {
                        pmask.add(idx++);
                        continue;
                    }
                    pmask.add(null);
                }
                if (lastIdx == idx) break;
                this.gridMask.add(pmask);
            }
        }

        @Override
        protected void onGridChanged() {
            super.onGridChanged();
            if (this.getViewMode() == BookmarkViewMode.TODO_LIST) {
                this.sortIngredients(true);
                this.generateToDoSpaces();
            }
        }

        public int indexOf(ItemStack stackA, BookmarkRecipeId recipeId) {
            boolean useNBT = NEIClientConfig.useNBTInBookmarks();
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                BookmarkStackMeta meta = this.getMetadata(idx);
                if ((recipeId != null || meta.recipeId != null) && (recipeId == null || meta.recipeId == null || !recipeId.equals(meta.recipeId)) || !StackInfo.equalItemAndNBT(stackA, this.getItem(idx), useNBT)) continue;
                return idx;
            }
            return -1;
        }

        public BookmarkStackMeta getMetadata(int idx) {
            return this.metadata.get(idx);
        }

        public void addItem(ItemStack stackA, BookmarkStackMeta meta) {
            this.addItem(stackA, meta, true);
        }

        public void addItem(ItemStack stackA, BookmarkStackMeta meta, boolean animate) {
            this.realItems.add(stackA);
            this.metadata.add(meta);
            if (animate && !NEIClientConfig.shouldCacheItemRendering() && NEIClientConfig.areBookmarksAnimated()) {
                this.animation.put(stackA, Float.valueOf(0.0f));
            }
            this.onGridChanged();
        }

        public void replaceItem(int idx, ItemStack stack) {
            this.realItems.set(idx, stack);
            this.onGridChanged();
        }

        public void removeRecipe(int idx, boolean removeFullRecipe) {
            BookmarkStackMeta meta = this.getMetadata(idx);
            if (meta.recipeId != null && (removeFullRecipe || !meta.ingredient)) {
                this.removeRecipe(meta.recipeId);
            } else {
                this.removeItem(idx);
            }
        }

        public void removeRecipe(BookmarkRecipeId recipeIdA) {
            for (int slotIndex = this.metadata.size() - 1; slotIndex >= 0; --slotIndex) {
                BookmarkRecipeId recipeIdB = this.getRecipeId(slotIndex);
                if (recipeIdB == null || !recipeIdB.equals(recipeIdA)) continue;
                this.removeItem(slotIndex);
            }
        }

        protected boolean removeItem(int idx) {
            this.animation.remove(this.getItem(idx));
            this.realItems.remove(idx);
            this.metadata.remove(idx);
            this.onGridChanged();
            return true;
        }

        public BookmarkRecipeId getRecipeId(int idx) {
            return this.getMetadata((int)idx).recipeId;
        }

        public BookmarkRecipeId findRecipeId(ItemStack stackA) {
            boolean useNBT = NEIClientConfig.useNBTInBookmarks();
            for (int idx = 0; idx < this.realItems.size(); ++idx) {
                if (!StackInfo.equalItemAndNBT(stackA, this.getItem(idx), useNBT)) continue;
                return this.getRecipeId(idx);
            }
            return null;
        }

        public void moveItem(int src, int dst) {
            this.realItems.add(dst, this.realItems.remove(src));
            this.metadata.add(dst, this.metadata.remove(src));
            this.onGridChanged();
        }

        private boolean isPartOfFocusedRecipe(ItemPanel.ItemPanelSlot focused, int myIdx) {
            return NEIClientUtils.shiftKey() && focused != null && LayoutManager.bookmarkPanel.sortedStackIndex == -1 && this.getRecipeId(focused.slotIndex) != null && this.getRecipeId(myIdx) != null && this.getRecipeId(focused.slotIndex).equals(this.getRecipeId(myIdx));
        }

        @Override
        protected void drawSlotOutline(@Nullable ItemPanel.ItemPanelSlot focus, int idx, Rectangle4i rect) {
            if (LayoutManager.bookmarkPanel.sortedNamespaceIndex == LayoutManager.bookmarkPanel.activeNamespaceIndex && LayoutManager.bookmarkPanel.sortedStackIndex == idx) {
                GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
            } else if (focus != null) {
                BookmarkStackMeta meta = this.getMetadata(idx);
                if (this.isPartOfFocusedRecipe(focus, idx)) {
                    GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)(meta.ingredient ? -2001489152 : -2013226701));
                } else if (focus.slotIndex == idx) {
                    GuiDraw.drawRect((int)rect.x, (int)rect.y, (int)rect.w, (int)rect.h, (int)-296397483);
                }
            }
        }

        @Override
        protected void drawItem(Rectangle4i rect, int idx) {
            if (LayoutManager.bookmarkPanel.sortedNamespaceIndex != LayoutManager.bookmarkPanel.activeNamespaceIndex || LayoutManager.bookmarkPanel.sortedStackIndex != idx) {
                String stackSize;
                ItemStack stack = this.getItem(idx);
                BookmarkStackMeta meta = this.getMetadata(idx);
                String string = stackSize = meta.factor < 0 || meta.fluidDisplay ? "" : ReadableNumberConverter.INSTANCE.toWideReadableForm(stack.field_77994_a);
                if (this.animation.containsKey(stack) && this.animation.get(stack).floatValue() < 1.0f) {
                    float currentScale = this.animation.get(stack).floatValue() + 0.1f;
                    this.animation.put(stack, Float.valueOf(currentScale));
                    this.drawPoppingItem(rect, stack, stackSize, currentScale);
                } else {
                    GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, stack, true, stackSize);
                    if (meta.recipeId != null && !meta.ingredient && NEIClientConfig.showRecipeMarker()) {
                        this.drawRecipeMarker(rect.x, rect.y, GuiContainerManager.getFontRenderer(stack));
                    }
                }
            }
        }

        protected void drawPoppingItem(Rectangle4i rect, ItemStack stack, String stackSize, float currentScale) {
            GL11.glScalef((float)currentScale, (float)currentScale, (float)currentScale);
            GuiContainerManager.drawItem(Math.round(((float)(rect.x + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), Math.round(((float)(rect.y + 1) + (9.0f - currentScale * 18.0f / 2.0f)) / currentScale), stack, true, stackSize);
            GL11.glScalef((float)(1.0f / currentScale), (float)(1.0f / currentScale), (float)(1.0f / currentScale));
        }

        protected void drawRecipeMarker(int offsetX, int offsetY, FontRenderer fontRenderer) {
            float scaleFactor = fontRenderer.func_82883_a() ? 0.85f : 0.5f;
            float inverseScaleFactor = 1.0f / scaleFactor;
            GuiContainerManager.enable2DRender();
            GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
            int X = (int)(((float)offsetX + 1.0f) * inverseScaleFactor);
            int Y = (int)(((float)offsetY + 1.0f) * inverseScaleFactor);
            fontRenderer.func_78261_a("R", X, Y, 0xA0A0A0);
            GL11.glScaled((double)inverseScaleFactor, (double)inverseScaleFactor, (double)inverseScaleFactor);
            GuiContainerManager.enable3DRender();
        }
    }

    public static enum BookmarkViewMode {
        DEFAULT,
        TODO_LIST;

    }

    protected static class BookmarkStackMeta {
        public int factor;
        public BookmarkRecipeId recipeId;
        public boolean ingredient = false;
        public boolean fluidDisplay = false;

        public BookmarkStackMeta(BookmarkRecipeId recipeId, int count, boolean ingredient, boolean fluidDisplay) {
            this.recipeId = recipeId;
            this.factor = count;
            this.ingredient = ingredient;
            this.fluidDisplay = fluidDisplay;
        }
    }
}

