/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.CatalystInfo;
import codechicken.nei.recipe.CatalystInfoList;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.shadow.org.apache.commons.csv.CSVFormat;
import codechicken.nei.shadow.org.apache.commons.csv.CSVParser;
import codechicken.nei.shadow.org.apache.commons.csv.CSVRecord;
import com.google.common.base.Objects;
import cpw.mods.fml.common.Loader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RecipeCatalysts {
    private static final Map<String, CatalystInfoList> catalystsAdderFromAPI = new HashMap<String, CatalystInfoList>();
    private static final Map<String, List<ItemStack>> catalystsRemoverFromAPI = new HashMap<String, List<ItemStack>>();
    public static final Map<String, CatalystInfoList> catalystsAdderFromIMC = new HashMap<String, CatalystInfoList>();
    public static final Map<String, List<ItemStack>> catalystsRemoverFromIMC = new HashMap<String, List<ItemStack>>();
    private static final Map<String, CatalystInfoList> recipeCatalystMap = new HashMap<String, CatalystInfoList>();
    private static Map<String, List<PositionedStack>> positionedRecipeCatalystMap = new HashMap<String, List<PositionedStack>>();
    private static final List<String> forceClassNameList = new ArrayList<String>();
    private static int heightCache;

    public static void addRecipeCatalyst(String handlerID, CatalystInfo catalystInfo) {
        if (handlerID == null || handlerID.isEmpty() || catalystInfo.getStack() == null) {
            return;
        }
        RecipeCatalysts.addOrPut(catalystsAdderFromAPI, handlerID, catalystInfo);
    }

    public static void removeRecipeCatalyst(String handlerID, ItemStack stack) {
        if (handlerID == null || handlerID.isEmpty() || stack == null) {
            return;
        }
        if (catalystsRemoverFromAPI.containsKey(handlerID)) {
            catalystsRemoverFromAPI.get(handlerID).add(stack);
        } else {
            catalystsRemoverFromAPI.put(handlerID, new ArrayList<ItemStack>(Collections.singletonList(stack)));
        }
    }

    public static Map<String, List<PositionedStack>> getPositionedRecipeCatalystMap() {
        return positionedRecipeCatalystMap;
    }

    public static List<PositionedStack> getRecipeCatalysts(IRecipeHandler handler) {
        return RecipeCatalysts.getRecipeCatalysts(RecipeCatalysts.getRecipeID(handler));
    }

    public static List<PositionedStack> getRecipeCatalysts(String handlerID) {
        if (!NEIClientConfig.areJEIStyleTabsVisible() || !NEIClientConfig.areJEIStyleRecipeCatalystsVisible()) {
            return Collections.emptyList();
        }
        return positionedRecipeCatalystMap.getOrDefault(handlerID, Collections.emptyList());
    }

    public static boolean containsCatalyst(IRecipeHandler handler, ItemStack candidate) {
        return RecipeCatalysts.containsCatalyst(RecipeCatalysts.getRecipeID(handler), candidate);
    }

    public static boolean containsCatalyst(String handlerID, ItemStack candidate) {
        if (recipeCatalystMap.containsKey(handlerID)) {
            return recipeCatalystMap.get(handlerID).contains(candidate);
        }
        return false;
    }

    public static void updatePosition(int availableHeight, boolean force) {
        if (availableHeight == heightCache && !force) {
            return;
        }
        HashMap<String, List<PositionedStack>> newMap = new HashMap<String, List<PositionedStack>>();
        for (Map.Entry<String, CatalystInfoList> entry : recipeCatalystMap.entrySet()) {
            CatalystInfoList catalysts = entry.getValue();
            catalysts.sort();
            ArrayList<PositionedStack> newStacks = new ArrayList<PositionedStack>();
            int rowCount = RecipeCatalysts.getRowCount(availableHeight, catalysts.size());
            for (int index = 0; index < catalysts.size(); ++index) {
                ItemStack catalyst = ((CatalystInfo)catalysts.get(index)).getStack();
                int column = index / rowCount;
                int row = index % rowCount;
                newStacks.add(new PositionedStack(catalyst, -column * 16, row * 16));
            }
            newMap.put(entry.getKey(), newStacks);
        }
        positionedRecipeCatalystMap = newMap;
        heightCache = availableHeight;
    }

    public static void updatePosition(int availableHeight) {
        RecipeCatalysts.updatePosition(availableHeight, false);
    }

    public static int getHeight() {
        return heightCache;
    }

    public static int getColumnCount(int availableHeight, int catalystsSize) {
        int maxItemsPerColumn = availableHeight / 16;
        return NEIServerUtils.divideCeil(catalystsSize, maxItemsPerColumn);
    }

    public static int getRowCount(int availableHeight, int catalystsSize) {
        int columnCount = RecipeCatalysts.getColumnCount(availableHeight, catalystsSize);
        return NEIServerUtils.divideCeil(catalystsSize, columnCount);
    }

    public static void loadCatalystInfo() {
        URL url;
        boolean fromJar = NEIClientConfig.loadCatalystsFromJar();
        NEIClientConfig.logger.info("Loading catalyst info from " + (fromJar ? "JAR" : "Config"));
        recipeCatalystMap.clear();
        URL handlerUrl = RecipeCatalysts.class.getResource("/assets/nei/csv/catalysts.csv");
        RecipeCatalysts.resolveAdderQueue();
        if (fromJar) {
            url = handlerUrl;
            if (url == null) {
                NEIClientConfig.logger.warn("Invalid URL for catalysts csv.");
                return;
            }
        } else {
            File catalystFile = NEIClientConfig.catalystFile;
            if (!catalystFile.exists()) {
                NEIClientConfig.logger.info("Config file doesn't exist, creating");
                try {
                    assert (handlerUrl != null);
                    ReadableByteChannel readableByteChannel = Channels.newChannel(handlerUrl.openStream());
                    FileOutputStream fileOutputStream = new FileOutputStream(catalystFile.getAbsoluteFile());
                    FileChannel fileChannel = fileOutputStream.getChannel();
                    fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
            try {
                url = NEIClientConfig.catalystFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                NEIClientConfig.logger.warn("Invalid URL for catalysts csv (via config).");
                e.printStackTrace();
                return;
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
            CSVParser csvParser = CSVFormat.EXCEL.withFirstRecordAsHeader().parse(reader);
            for (CSVRecord record : csvParser) {
                String handlerID;
                String itemName;
                String handler = record.get("handler");
                String modId = record.get("modId");
                boolean requiresMod = Boolean.parseBoolean(record.get("modRequired"));
                String excludedModId = record.get("excludedModId");
                int priority = RecipeCatalysts.intOrDefault(record.get("priority"), 0);
                String minVersion = record.get("minVersion");
                String maxVersion = record.get("maxVersion");
                boolean forceClassName = Boolean.parseBoolean(record.get("forceClassName"));
                if (requiresMod && !Loader.isModLoaded((String)modId) || excludedModId != null && Loader.isModLoaded((String)excludedModId) || (itemName = record.get("itemName")) == null || itemName.isEmpty()) continue;
                ItemStack stack = NEIServerUtils.getModdedItem(itemName, record.get("nbtInfo"));
                if (stack == null) {
                    NEIClientConfig.logger.debug("Couldn't find ItemStack " + itemName);
                    continue;
                }
                CatalystInfo catalystInfo = new CatalystInfo(stack, priority);
                try {
                    Class<?> clazz = Class.forName(handler);
                    Object object = clazz.newInstance();
                    if (object instanceof IRecipeHandler) {
                        if (forceClassName) {
                            forceClassNameList.add(handler);
                        }
                        handlerID = RecipeCatalysts.getRecipeID((IRecipeHandler)object);
                    } else {
                        handlerID = handler;
                    }
                }
                catch (ClassNotFoundException ignored) {
                    handlerID = handler;
                }
                catch (InstantiationException ignored) {
                    NEIClientConfig.logger.warn("failed to create instance for " + handler);
                    handlerID = handler;
                }
                RecipeCatalysts.addOrPut(recipeCatalystMap, handlerID, catalystInfo, !fromJar);
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.warn("Error parsing CSV");
            e.printStackTrace();
        }
        if (fromJar) {
            RecipeCatalysts.resolveRemoverQueue();
        }
        RecipeCatalysts.updatePosition(RecipeCatalysts.getHeight(), true);
    }

    private static void resolveAdderQueue() {
        CatalystInfo catalyst;
        Iterator iterator;
        String handlerID;
        for (Map.Entry<String, CatalystInfoList> entry : catalystsAdderFromAPI.entrySet()) {
            handlerID = entry.getKey();
            iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                catalyst = (CatalystInfo)iterator.next();
                RecipeCatalysts.addOrPut(recipeCatalystMap, handlerID, catalyst);
            }
        }
        for (Map.Entry<String, CatalystInfoList> entry : catalystsAdderFromIMC.entrySet()) {
            handlerID = entry.getKey();
            iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                catalyst = (CatalystInfo)iterator.next();
                RecipeCatalysts.addOrPut(recipeCatalystMap, handlerID, catalyst);
            }
        }
        if (!catalystsAdderFromIMC.isEmpty()) {
            HashSet<String> handlerIds = new HashSet<String>(GuiRecipeTab.handlerMap.keySet());
            catalystsAdderFromIMC.keySet().forEach(handlerName -> {
                if (!handlerIds.contains(handlerName)) {
                    NEIClientConfig.logger.warn("Could not find a registered handlerID that matches " + handlerName);
                    handlerIds.forEach(handler -> {
                        if (handler.equalsIgnoreCase((String)handlerName)) {
                            NEIClientConfig.logger.warn("  -- Did you mean: " + handler);
                        }
                    });
                }
            });
        }
    }

    private static void resolveRemoverQueue() {
        CatalystInfoList catalysts;
        String handlerID;
        for (Map.Entry<String, List<ItemStack>> entry : catalystsRemoverFromAPI.entrySet()) {
            handlerID = entry.getKey();
            if (!recipeCatalystMap.containsKey(handlerID)) continue;
            catalysts = recipeCatalystMap.get(handlerID);
            entry.getValue().forEach(catalysts::remove);
        }
        for (Map.Entry<String, List<ItemStack>> entry : catalystsRemoverFromIMC.entrySet()) {
            handlerID = entry.getKey();
            if (!recipeCatalystMap.containsKey(handlerID)) continue;
            catalysts = recipeCatalystMap.get(handlerID);
            entry.getValue().forEach(catalysts::remove);
        }
    }

    public static String getRecipeID(IRecipeHandler handler) {
        if (forceClassNameList.stream().anyMatch(s -> s.equals(handler.getHandlerId()))) {
            return handler.getHandlerId();
        }
        return (String)Objects.firstNonNull((Object)handler.getOverlayIdentifier(), (Object)handler.getHandlerId());
    }

    public static void addOrPut(Map<String, CatalystInfoList> map, String handlerID, CatalystInfo catalyst) {
        RecipeCatalysts.addOrPut(map, handlerID, catalyst, false);
    }

    public static void addOrPut(Map<String, CatalystInfoList> map, String handlerID, CatalystInfo catalyst, boolean overwrite) {
        if (map.containsKey(handlerID)) {
            map.get(handlerID).add(catalyst, overwrite);
        } else {
            map.put(handlerID, new CatalystInfoList(handlerID, catalyst));
        }
    }

    private static int intOrDefault(String str, int defaultValue) {
        if (str == null || str.equals("")) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Deprecated
    public static void addRecipeCatalyst(List<ItemStack> stacks, Class<? extends IRecipeHandler> handler) {
    }

    @Deprecated
    public static List<PositionedStack> getRecipeCatalysts(Class<? extends IRecipeHandler> handler) {
        return Collections.emptyList();
    }

    @Deprecated
    public static boolean containsCatalyst(Class<? extends IRecipeHandler> handler, ItemStack candidate) {
        return false;
    }
}

