/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import ru.timeconqueror.lootgames.LootGames;
import ru.timeconqueror.lootgames.api.LootGamesAPI;
import ru.timeconqueror.lootgames.api.block.GameBlock;
import ru.timeconqueror.lootgames.common.block.tile.PuzzleMasterTile;
import ru.timeconqueror.lootgames.common.config.LGConfigs;
import ru.timeconqueror.lootgames.registry.LGAchievements;
import ru.timeconqueror.lootgames.utils.future.BlockPos;
import ru.timeconqueror.lootgames.utils.future.WorldExt;
import ru.timeconqueror.timecore.api.util.NetworkUtils;

public class PuzzleMasterBlock
extends GameBlock {
    @SideOnly(value=Side.CLIENT)
    protected IIcon icon;

    public PuzzleMasterBlock() {
        this.func_149715_a(1.0f);
        this.func_149647_a(LootGames.CREATIVE_TAB);
        this.func_149663_c(LootGames.dotted("puzzle_master"));
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public void func_149734_b(World worldIn, int x, int y, int z, Random rand) {
        int particleCount = rand.nextInt(30);
        for (int i = 0; i <= particleCount; ++i) {
            worldIn.func_72869_a("enchantmenttable", (double)x + 0.5 + rand.nextGaussian() * 0.8, (double)((float)y + rand.nextFloat()), (double)z + 0.5 + rand.nextGaussian() * 0.8, rand.nextGaussian() * 0.02, 0.5 + rand.nextGaussian() * 0.02, rand.nextGaussian() * 0.02);
        }
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        if (!worldIn.field_72995_K) {
            try {
                if (LGConfigs.GENERAL.disableMinigames) {
                    NetworkUtils.sendMessage(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.puzzle_master.turned_off", new Object[0]));
                    return true;
                }
                BlockPos pos = BlockPos.of(x, y, z);
                Block block = WorldExt.getBlock(worldIn, pos);
                WorldExt.setBlock(worldIn, pos, Blocks.field_150350_a);
                Optional<String> error = LootGamesAPI.getGameManager().generateRandomGame(worldIn, pos);
                if (!error.isPresent()) {
                    LGAchievements.FIND_DUNGEON.trigger(player);
                } else {
                    NetworkUtils.sendMessage(player, (IChatComponent)new ChatComponentText(error.get()));
                    WorldExt.setBlock(worldIn, pos, block, 2);
                }
            }
            catch (Throwable e) {
                NetworkUtils.sendMessage(player, (IChatComponent)new ChatComponentTranslation("msg.lootgames.puzzle_master.broken", new Object[0]));
                LootGames.LOGGER.error((Object)e);
            }
        }
        return true;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new PuzzleMasterTile();
    }

    @Override
    public void func_149651_a(IIconRegister reg) {
        this.icon = reg.func_94245_a(LootGames.namespaced("puzzle_master"));
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }
}

