/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.recipes;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.scripts.IScriptLoader;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeRemover {
    private static boolean bufferingRecipes = true;
    private static final ArrayList<IRecipe> tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
    private static final HashMap<GT_Utility.ItemId, List<Function<IRecipe, Boolean>>> bufferMap = new HashMap();
    private static Field recipeWidthField = null;

    private static void addToBuffer(HashSet<GT_Utility.ItemId> outputs, Function<IRecipe, Boolean> whenToRemove) {
        for (GT_Utility.ItemId output : outputs) {
            bufferMap.computeIfAbsent(output, o -> new ArrayList()).add(whenToRemove);
        }
        if (!bufferingRecipes) {
            RecipeRemover.stopBuffering();
        }
    }

    private static void stopBuffering() {
        int i = tList.size();
        tList.removeIf(r -> {
            ItemStack rCopy = r.func_77571_b();
            if (rCopy == null) {
                return false;
            }
            if (rCopy.func_77973_b() == null) {
                MainRegistry.Logger.warn((Object)"Someone is adding recipes with null items!");
                for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                    MainRegistry.Logger.warn((Object)element.toString());
                }
                return true;
            }
            if (rCopy.field_77990_d != null) {
                rCopy = rCopy.func_77946_l();
                rCopy.field_77990_d = null;
            }
            GT_Utility.ItemId key = GT_Utility.ItemId.createNoCopy((ItemStack)rCopy);
            rCopy = rCopy.func_77946_l();
            Items.field_151008_G.setDamage(rCopy, Short.MAX_VALUE);
            GT_Utility.ItemId keyWildcard = GT_Utility.ItemId.createNoCopy((ItemStack)rCopy);
            List<Function<IRecipe, Boolean>> listWhenToRemove = bufferMap.get(key);
            if (listWhenToRemove == null) {
                listWhenToRemove = bufferMap.get(keyWildcard);
            }
            if (listWhenToRemove == null) {
                return false;
            }
            for (Function<IRecipe, Boolean> whenToRemove : listWhenToRemove) {
                if (!whenToRemove.apply((IRecipe)r).booleanValue()) continue;
                return true;
            }
            return false;
        });
        MainRegistry.Logger.info((Object)("Removed " + (i - tList.size()) + " recipes!"));
        bufferMap.clear();
    }

    private static HashSet<GT_Utility.ItemId> getItemsHashed(Object item, boolean includeWildcardVariants) {
        HashSet<GT_Utility.ItemId> hashedItems = new HashSet<GT_Utility.ItemId>();
        if (item instanceof ItemStack) {
            ItemStack iCopy = ((ItemStack)item).func_77946_l();
            iCopy.field_77990_d = null;
            hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)iCopy));
            if (includeWildcardVariants) {
                iCopy = iCopy.func_77946_l();
                Items.field_151008_G.setDamage(iCopy, Short.MAX_VALUE);
                hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)iCopy));
            }
        } else if (item instanceof String) {
            for (ItemStack stack : OreDictionary.getOres((String)((String)item))) {
                hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)stack));
                if (!includeWildcardVariants) continue;
                stack = stack.func_77946_l();
                Items.field_151008_G.setDamage(stack, Short.MAX_VALUE);
                hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)stack));
            }
        } else if (item instanceof ArrayList) {
            for (ItemStack stack : (ArrayList)item) {
                ItemStack iCopy = stack.func_77946_l();
                iCopy.field_77990_d = null;
                hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)iCopy));
                if (!includeWildcardVariants) continue;
                iCopy = iCopy.func_77946_l();
                Items.field_151008_G.setDamage(iCopy, Short.MAX_VALUE);
                hashedItems.add(GT_Utility.ItemId.createNoCopy((ItemStack)iCopy));
            }
        } else {
            throw new IllegalArgumentException("Invalid input");
        }
        return hashedItems;
    }

    public static void removeRecipeShapelessDelayed(Object aOutput, Object ... aRecipe) {
        ArrayList<Object> aRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> {
            if (!(r instanceof ShapelessOreRecipe) && !(r instanceof ShapelessRecipes)) {
                return false;
            }
            if (aRecipeList.isEmpty()) {
                return true;
            }
            ArrayList recipe = (ArrayList)aRecipeList.clone();
            List rInputs = r instanceof ShapelessOreRecipe ? ((ShapelessOreRecipe)r).getInput() : ((ShapelessRecipes)r).field_77579_b;
            for (Object rInput : rInputs) {
                HashSet<GT_Utility.ItemId> rInputHashedNoWildcard;
                HashSet<GT_Utility.ItemId> rInputHashed;
                try {
                    rInputHashed = RecipeRemover.getItemsHashed(rInput, true);
                    rInputHashedNoWildcard = RecipeRemover.getItemsHashed(rInput, false);
                }
                catch (Exception ex) {
                    return false;
                }
                boolean found = false;
                Iterator iterator = recipe.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    for (GT_Utility.ItemId id : RecipeRemover.getItemsHashed(o, false)) {
                        if (!rInputHashed.contains(id)) continue;
                        found = true;
                        iterator.remove();
                        break;
                    }
                    if (!found) {
                        for (GT_Utility.ItemId id : RecipeRemover.getItemsHashed(o, true)) {
                            if (!rInputHashedNoWildcard.contains(id)) continue;
                            found = true;
                            iterator.remove();
                            break;
                        }
                    }
                    if (!found) continue;
                    break;
                }
                if (found) continue;
                return false;
            }
            return recipe.isEmpty();
        });
    }

    public static void removeRecipeShapedDelayed(Object aOutput, Object[] row1, Object[] row2, Object[] row3) {
        if (recipeWidthField == null) {
            try {
                recipeWidthField = ShapedOreRecipe.class.getDeclaredField("width");
                recipeWidthField.setAccessible(true);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        Object[][] recipe = new Object[][]{row1, row2, row3};
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> {
            int width;
            if (!(r instanceof ShapedOreRecipe) && !(r instanceof ShapedRecipes)) {
                return false;
            }
            Object[] inputs = r instanceof ShapedOreRecipe ? ((ShapedOreRecipe)r).getInput() : ((ShapedRecipes)r).field_77574_d;
            try {
                width = r instanceof ShapedOreRecipe ? (Integer)recipeWidthField.get(r) : ((ShapedRecipes)r).field_77576_b;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            int height = r instanceof ShapedOreRecipe ? r.func_77570_a() / width : ((ShapedRecipes)r).field_77577_c;
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    HashSet<GT_Utility.ItemId> rInputHashed;
                    Object rRecipe;
                    Object rStack = y >= height || x >= width ? null : inputs[x + y * width];
                    if (rStack == null ^ (rRecipe = x >= recipe[y].length ? null : recipe[y][x]) == null) {
                        return false;
                    }
                    if (rStack == null) continue;
                    try {
                        rInputHashed = RecipeRemover.getItemsHashed(rStack, true);
                    }
                    catch (Exception ex) {
                        return false;
                    }
                    boolean found = false;
                    for (GT_Utility.ItemId id : RecipeRemover.getItemsHashed(rRecipe, false)) {
                        if (!rInputHashed.contains(id)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        rInputHashed = RecipeRemover.getItemsHashed(rStack, false);
                        for (GT_Utility.ItemId id : RecipeRemover.getItemsHashed(rRecipe, true)) {
                            if (!rInputHashed.contains(id)) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    return false;
                }
            }
            return true;
        });
    }

    public static void removeRecipeShapedDelayed(Object aOutput) {
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> r instanceof ShapedOreRecipe || r instanceof ShapedRecipes);
    }

    public static void removeRecipeByOutputDelayed(Object aOutput) {
        RecipeRemover.addToBuffer(RecipeRemover.getItemsHashed(aOutput, false), r -> true);
    }

    /*
     * Opcode count of 21451 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public static void run() {
        long timeStart = System.currentTimeMillis();
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.stickLong, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadUniversalSpade, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.spring, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gearGtSmall, (Object)Materials.Sunnarium, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Backpack", (String)"boundLeather", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"gravel", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"quartz_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"FloodLights", (String)"rawFilament", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"GalacticraftMars", (String)"item.itemBasicAsteroids", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"GalacticraftMars", (String)"tile.asteroidsBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"GalacticraftCore", (String)"item.meteoricIronRaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"GalacticraftMars", (String)"item.null", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"chainmail_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"blockRubWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"slime_ball", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemMugCoffee", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"obsidian", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"clay_ball", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"netherrack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)ItemList.Food_Raw_Bread.get(1L, new Object[0]));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"oreBerries", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"oreBerries", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"oreBerries", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"oreBerries", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"oreBerries", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"sand", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"soul_sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"heatsand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"redwood", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Natura", (String)"redwood", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"minecraft", (String)"stone", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.ore", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)46, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCustomOre", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gemOre", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreBasalt, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreRedgranite, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreEndstone, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockores", (long)1L, (int)514, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreMarble, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreBlackgranite, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.oreNetherrack, (Object)Materials.Amber, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Obsidian, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Obsidian, (long)1L));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemDust", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemPlates", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Railcraft", (String)"dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TwilightForest", (String)"tile.GiantObsidian", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.beta", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"IC2", (String)"itemDensePlates", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)ItemList.Conveyor_Module_LV.get(1L, new Object[0]));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)ItemList.Automation_ItemDistributor_ULV.get(1L, new Object[0]));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)ItemList.Automation_ItemDistributor_LV.get(1L, new Object[0]));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBrick", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"GravelOre", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        GT_ModHandler.removeFurnaceSmelting((ItemStack)GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.ironwoodRaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockFluix", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartz", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartzChiseled", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockController", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockEnergyCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockDenseEnergyCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockDrive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartzGrowthAccelerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingUnit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingUnit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockMolecularAssembler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCharger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockInscriber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuantumRing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuantumLinkChamber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSpatialPylon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSpatialIOPort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockInterface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCellWorkbench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockIOPort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCondenser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockEnergyAcceptor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockVibrationChamber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSecurity", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)140, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyCompass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)180, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)380, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)360, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)480, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)340, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolWirelessTerminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartzGlass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartzLamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockQuartzTorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockLightDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockTinyTNT", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)52, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)52, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)53, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)300, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)120, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)260, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)320, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)240, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)460, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)180, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolCertusQuartzCuttingKnife", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolCertusQuartzWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolMassCannon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolMemoryCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolChargedStaff", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolEntropyManipulator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolColorApplicator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolBiometricCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemCrystalSeed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemCrystalSeed", (long)1L, (int)600, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemCrystalSeed", (long)1L, (int)1200, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolNetherQuartzCuttingKnife", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolNetherQuartzWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyStone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyStone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyStone", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockSkyChest", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockWireless", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingStorage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingStorage", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingStorage", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingStorage", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"tile.BlockCraftingMonitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)420, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)200, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)160, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)400, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)220, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)280, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiPart", (long)1L, (int)100, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemBasicStorageCell.1k", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemBasicStorageCell.4k", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemBasicStorageCell.16k", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemBasicStorageCell.64k", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)35, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)37, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemSpatialStorageCell.2Cubed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemSpatialStorageCell.16Cubed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemSpatialStorageCell.128Cubed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemViewCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ItemMultiMaterial", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"appliedenergistics2", (String)"item.ToolPortableCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"Encoder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"Grower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"Inscriber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"Wireless", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"WirelessKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ae2stuff", (String)"Visualiser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"BlockMolecularTransformer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"advanced_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"hybrid_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"ultimate_solar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Automagy", (String)"blockHourglass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Double_Craft", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Triple_Craft", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Dire_Crafting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Crystal_Matrix", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource_Block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource_Block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Avaritia", (String)"Resource", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"eternalsingularity", (String)"combined_singularity", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Backpack", (String)"backpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Backpack", (String)"workbenchbackpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Backpack", (String)"boundLeather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"betterbuilderswands", (String)"wandStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"betterbuilderswands", (String)"wandIron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"betterbuilderswands", (String)"wandDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"betterbuilderswands", (String)"wandUnbreakable", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"questbook", (String)"ItemQuestBook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"fieldKit", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gemOre", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"jarEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"dartBlower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"dart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"scytheDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"ash", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"coal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gemOre", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gemOre", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"gemOre", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"planks", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_iron_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_stick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stained_glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stained_ice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stained_ice_packed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_glowstone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_diamond_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"life_infuser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"lp_materializer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"compacter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_pickaxe_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_axe_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_shovel_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_sword_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_pickaxe_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_axe_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_shovel_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_sword_iron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_pickaxe_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_axe_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_shovel_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_infused_sword_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_burned_string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_money", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_money", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_money", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"life_imbued_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"life_imbued_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"life_imbued_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"life_imbued_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"amorphic_catalyst", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"transparent_orb", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sigil_of_augmented_holding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sigil_of_lightning", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sigil_of_swimming", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sigil_of_ender", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sigil_of_divinity", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"self_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"empowered_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"empowered_self_sacrifice_amulet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"glass_sacrificial_dagger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"glass_dagger_of_sacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"vampire_ring", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"Altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sacrificialKnife", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blankSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockWritingTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"waterSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"lavaSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"reinforcedSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"imbuedSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"demonicSlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stone", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"BloodArsenal", (String)"blood_stone", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"divinationSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"speedRune", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"ritualStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"masterStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"largeBloodStoneBrick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockHomHeart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"lavaCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"runeOfSacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"runeOfSelfSacrifice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"airSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfTheFastMiner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"growthSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"voidSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemBloodPack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"emptySocket", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"armourForge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfElementalAffinity", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfHolding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfTheBridge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfMagnetism", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemBloodLightSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"seerSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"imperfectRitualStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemRitualDiviner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemRitualDiviner", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemRitualDiviner", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"ritualDismantler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrybloodRune", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockTeleposer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"reinforcedTelepositionFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"demonicTelepositionFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"energyBazooka", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockPedestal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockPlinth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockAlchemicCalcinator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemAttunedCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemDestinationClearer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemTankSegmenter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockCrystalBelljar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockReagentConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockStabilityGlyph", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockEnchantmentGlyph", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockEnchantmentGlyph", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicBaseItems", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemKeyOfDiablo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"armourInhibitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"inputRoutingFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"outputRoutingFocus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"outputRoutingFocus", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"outputRoutingFocus", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"outputRoutingFocus", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"inputRoutingFocus", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfHaste", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfWind", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfSupression", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"sigilOfEnderSeverance", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemHarvestSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"itemCompressionSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockCrucible", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"blockConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"bloodMagicIncenseItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellParadigm", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellModifier", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AWWayofTime", (String)"AlchemicalWizardrytile.blockSpellEffect", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"trowelWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"trowelStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"trowelIron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"trowelGold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"trowelDiamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"insulatedTube", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Botany", (String)"soilMeter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersCollapsibleBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"itemCarpentersChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"itemCarpentersHammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersSafe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersDaylightSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"itemCarpentersBed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersTorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersGarageDoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersBarrier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersButton", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersFlowerPot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersSlope", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"blockCarpentersStairs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"itemCarpentersTile", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"CarpentersBlocks", (String)"itemCarpentersDoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"support_column", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"sturdy_rail_powered", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"cagedLadder_north_unlit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"scaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"sturdy_rail_detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"catwalk_unlit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"sturdy_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"sturdy_rail_activator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"ropeLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"steelgrate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"catwalks", (String)"blowtorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"chisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"obsidianChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"diamondChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"netherStarChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"cloudinabottle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"ballomoss", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"smashingrock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"autoChisel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"upgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"upgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"upgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"upgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"chisel", (String)"voidstone2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"BlockCkg", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"IridiumBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"compactkineticgenerators", (String)"IridiumRotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"DraconicEvolution", (String)"dissEnchanter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"AdvancedSolarPanel", (String)"asp_crafting_items", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticSolid", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"DiamondChainsaw", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"FeatherWing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"EMTItems", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EMT", (String)"Omnitool", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockStirlingGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockCombustionGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockZombieGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockFrankenzombieGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockEnderGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSolarPanel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSolarPanel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSolarPanel", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSagMill", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockAlloySmelter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockCapBank", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockPainter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockCrafter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemBasicCapacitor", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMachinePart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockVat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockPowerMonitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockFarmStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockWirelessCharger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockTank", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockReservoir", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockVacuumChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockBuffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockBuffer", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockBuffer", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockInventoryPanel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMachinePart", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBall", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGrindingBallEndergy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.endSteel_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockEnderIo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockTravelAnchor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockTelePad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSliceAndSplice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSoulBinder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockPoweredSpawner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockKillerJoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockAttractor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSpawnGuard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockExperienceObelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockWeatherObelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockEnchanter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockDarkSteelPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockDarkSteelPressurePlate", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockDarkSteelAnvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockDarkIronBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockSoulariumBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockEndSteelBars", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockDarkSteelLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockElectricLight", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"blockReinforcedObsidian", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemCoordSelector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemFusedQuartzFrame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemConduitFacade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemConduitFacade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemRedstoneConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemRedstoneConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemRedstoneConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerConduitEndergy", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemLiquidConduit", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemItemConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemBasicFilterUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemBasicFilterUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemExistingItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemModItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemBigFilterUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemBigFilterUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowerItemFilter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemExtractSpeedUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemExtractSpeedUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemFunctionUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemYetaWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemConduitProbe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemTravelStaff", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemXpTransfer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemSoulVessel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGliderWing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemGliderWing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMagnet", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemOCConduit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMachinePart", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMachinePart", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.darkSteel_shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"item.stellar_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"alveary", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.cage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.cocoa", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.soul", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.cocoa", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.cage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraBees", (String)"hiveFrame.soul", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"machine", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"hammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"durableHammer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"misc", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"door", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"gate", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"fence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraTrees", (String)"multifence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelRing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelRing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelRing", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelRing", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelRing", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarry", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderThermicPump", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"endMarker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"curtains", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"timer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderQuarryUpgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"paintbrush", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"drum", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"drum", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"bedrockiumIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"block_bedrockium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"angelBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"conveyor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"filing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"filing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"watering_can", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"magnumTorch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"sound_muffler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"sound_muffler", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes.1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"pipes", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base_remote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base_remote", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"extractor_base", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"cobblestone_compressed", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"trashcan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"trashcan", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"trashcan", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"dark_portal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"dark_portal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"chestFull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"chestMini", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"enderCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"endConstructor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"endConstructor", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"budoff", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"budoff", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"chandelier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"decorativeBlock1", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"trading_post", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"spike_base_wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"spike_base", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"spike_base_gold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"spike_base_diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"generator", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"generator.8", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"generator.64", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"heatingElement", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"nodeUpgrade", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"golden_lasso", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"scanner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"builderswand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"creativebuilderswand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"ethericsword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"lawSword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"erosionShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"destructionpickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"defoliageAxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"temporalHoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"electricFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"carbonFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"smallElectricFloodlightMetaBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"smallElectricFloodlightMetaBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"uvFloodlight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"rawFilament", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"electricIncandescentLightBulb", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"carbonDissolver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"carbonLantern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"mantle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"FloodLights", (String)"growLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"RidingCrop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)Mods.ForbiddenMagic.ID, (String)"WandCaps", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"sturdyMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"core", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"factory2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"mail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"mail", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"mulch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"engine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ffarm", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ffarm", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ffarm", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ffarm", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ffarm", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"bronzePickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"kitPickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"bronzeShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"kitShovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"infuser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"canEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"waxCapsule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"refractoryEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"gearBronze", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"gearCopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"gearTin", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"stamps", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"wrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"pipette", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"naturalistHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"soil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"soil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"craftingMaterial", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"fertilizerBio", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"fertilizerCompound", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"bituminousPeat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"habitatLocator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"scoop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"frameUntreated", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"frameImpregnated", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"waxCast", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiaristHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiaristChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiaristLegs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiaristBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"candle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"honeyedSlice", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"ambrosia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"honeyPot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"letters", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"fencesFireproof", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"catalogue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiaristBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"lepidopteristBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"minerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"diggerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"foresterBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"hunterBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"adventurerBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"builderBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiculture", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apiculture", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"apicultureChest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"alveary", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"arboriculture", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"lepidopterology", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"fences", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Forestry", (String)"cart.beehouse", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)875, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameAccelerated", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameMutagenic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameBusy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameDecaying", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameSlowing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameStabilizing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"frameArborists", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"personalCloakingDevice-0.0", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Motor_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Pump_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Conveyor_Module_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Electric_Piston_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Robot_Arm_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Emitter_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Sensor_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Field_Generator_UHV.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)946, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)947, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)948, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)949, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)950, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)798, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)753, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"itemBoilerChassis", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)754, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"itemBoilerChassis", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)755, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"itemBoilerChassis", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.blockmachines", (long)1L, (int)820, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"miscutils", (String)"blockCompressedObsidian", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"IndustrialApiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"MutagenProducer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Mutatron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Imprinter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Sampler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"MutatronAdv", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Liquifier", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Extractor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Transposer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Replicator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"UpgradeFrame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"Labware", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"MutagenTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"BeeReceptacle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"PowerModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"GeneticsProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"EnvProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"ApiaryUpgrade", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"IndustrialGrafter", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"IndustrialScoop", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"MutagenTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"BeeReceptacle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"PowerModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"ClimateModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"GeneticsProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"EnvProcessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"EjectCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"ImportCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"ErrorSensorCover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"machine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"machine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"labMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"labMachine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"labMachine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"labMachine", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"labMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"advMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"misc", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"analyst", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Genetics", (String)"registry", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"vajra", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"itemSimpleItem", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"advChainsaw", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"advDDrill", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"graviTool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"GraviSuite", (String)"ultimateLappack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"gravisuiteneo", (String)"epicLappack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSword, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPickaxe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadAxe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadHoe, (Object)Materials.Diamond, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRTGPellet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(ItemList.Teleporter.get(1L, new Object[0]));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"altar_nexus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"essence_altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"void_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"endium_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"biome_compass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"endium_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"obsidian_rod", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"ravaged_brick_slab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"decomposition_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"experience_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"energy_extraction_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"accumulation_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"spectral_tear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"living_matter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"energy_wand_core", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"energy_wand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"spooky_log", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"spooky_leaves", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"blank_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"spatial_dash_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"transference_gem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"schorching_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"charm_pouch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)256, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)257, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)258, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)259, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)260, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)261, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)262, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)263, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)264, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)265, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"HardcoreEnderExpansion", (String)"curse", (long)1L, (int)266, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"sink", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"market", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"spamcompressedsaltBlockalt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"oven", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"mixingbowlItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"cuttingboardItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"mortarandpestleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"bakewareItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"juicerItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"apiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"mortarandpestleItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"potItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"presser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"skilletItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"saucepanItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"hardenedleatherItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"hardenedleatherhelmItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"hardenedleatherchestItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"hardenedleatherleggingsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"hardenedleatherbootsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"waxItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco3", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco4", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco5", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco6", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco7", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco8", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco9", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco10", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco11", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco12", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco13", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco14", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco15", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco16", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"pamcandleDeco16", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"churn", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"quern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"freshwaterItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"freshmilkItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"boiledeggItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"onionsoupItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"honeycombchocolatebarItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"netherPlanks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"netherbedItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"Quartz Sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"Quartz Shovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"Quartz Pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"Quartz Axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"Quartz Hoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"quartzhelmItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"quartzchestItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"quartzleggingsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestthenether", (String)"quartzbootsItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockHeatGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockReactorChamber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockHeatGenerator", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockElectric", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockScaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockIronScaffold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMetal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolMiningLaser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockITNT", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorPlating", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorPlatingHeat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorPlatingExplosive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolCutter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCable", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCable", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCable", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCable", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPartCoalChunk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPartCarbonMesh", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockAlloyGlass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolIridiumDrill", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolWrenchElectric", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"windmeter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemwoodrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemironrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemsteelrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemwcarbonrotor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolWrench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemupgradekit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemFluidCell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorReflector", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorReflectorThick", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorVent", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorVentCore", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorVentGold", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorVentDiamond", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorVentSpread", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorHeatSwitch", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorHeatSwitchCore", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorHeatSwitchSpread", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorHeatSwitchDiamond", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorCondensator", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorCondensatorLap", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTreetap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockRubber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemSteamTurbineBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemSteamTurbine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemIronBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemAdvIronBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemDiamondBlockCuttingBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBarrel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemMugEmpty", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemMugCoffee", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemMugCoffee", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemMugCoffee", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBoat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBoat", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBoat", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemDynamiteSticky", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemDynamite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemWeedingTrowel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCropnalyzer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolMEter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemFuelPlantBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemScrapbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPartCoalBall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPartCFPowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemDoorAlloy", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterBlack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterRed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterGreen", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterBrown", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterBlue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterPurple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterCyan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterLightGrey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterDarkGrey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterPink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterLime", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterYellow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterCloud", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterMagenta", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterOrange", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolPainterWhite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBatSU", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRemote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemFreq", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"upgradeModule", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBP", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPCultivation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPIrrigation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPChilling", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPDesertification", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPFlatification", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTFBPMushroom", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorHazmatHelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorHazmatChestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorHazmatLeggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorHazmatLeggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorCoolantSimple", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorCoolantTriple", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"reactorCoolantSix", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorRubBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemStaticBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockKineticGenerator", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockHeatGenerator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockHeatGenerator", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockPersonal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockCrop", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemFoamSprayer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorCFPack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemArmorAlloyChestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemNanoSaber", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"obscurator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemScanner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemScannerAdv", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemOreIridium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPlutonium", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemUran235small", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemUran235", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemLathingTool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTurningBlanksWood", (long)1L, (int)209715, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemTurningBlanks", (long)1L, (int)349525, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemContainmentbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemToolbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPlutoniumSmall", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemMOX", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemUran", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemRecipePart", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockNuke", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockLuminatorDark", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockLuminator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockPersonal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockPersonal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine3", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMachine", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockChargepad", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockChargepad", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockChargepad", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockChargepad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockreactorvessel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockReactorFluidPort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockReactorAccessHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockReactorRedstonePort", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockMiningPipe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"blockGenerator", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadAxe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadHoe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSense, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPickaxe, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadPlow, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSword, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadSaw, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadShovel, (Object)Materials.Iridium, (long)1L));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemBatLamaCrystal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemDust2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemPartCFPowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"backpack.thaumaturgeT1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"capsule.magic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"capsule.void", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"effectJar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"magicApiary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameMagic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameResilient", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameGentle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameMetabolic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameNecrotic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameTemporal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"frameOblivion", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"miscResources", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"moonDial", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"magnet", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MagicBees", (String)"magicbees.enchantedEarth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"iron_trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"sliding_trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"player_sensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"vanishing_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"vanishing_block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"vanishing_block", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"vanishing_block", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"block_mixer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"door_factory", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"rustyHatch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"garage_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.rustyHandle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"rustyLadder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.door_acacia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.door_birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.door_dark_oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.door_jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.door_spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.wood_sliding_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.iron_sliding_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.jail_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.laboratory_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.factory_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.shoji_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_purple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_yellow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_magenta", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_pink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_white", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_blue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_gray", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_cyan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_red", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_brown", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_lime", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_orange", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_silver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_green", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_light_blue", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.curtain_black", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.saloon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"item.forcefieldItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"acaciaFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"birchFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"darkOakFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"jungleFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"spruceFenceGate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"trapdoor_acacia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"trapdoor_birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"trapdoor_dark_oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"trapdoor_jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"malisisdoors", (String)"trapdoor_spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"RedstoneMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"RedstoneMachine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"RedstoneMachine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"RedstoneMachine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"SignalBus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"SignalTerminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"LengthWire", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TMechworks", (String)"SpoolWire", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"trapped_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"crafting_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"furnace", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bedrock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dispenser", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dropper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"piston", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sticky_piston", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"golden_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"detector_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"activator_rail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"noteblock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"jukebox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"mossy_cobblestone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stonebrick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"lit_pumpkin", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"trapdoor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_pressure_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"torch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"lever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_button", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"glass_pane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"redstone_torch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"ladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"fence", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"fence_gate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"enchanting_table", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"redstone_lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"ender_chest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"tripwire_hook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"beacon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"anvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"daylight_detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"hopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"book", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"brick_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wooden_pressure_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"saddle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wool", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_glass_pane", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"carpet", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stained_hardened_clay", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sandstone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sandstone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sandstone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"tnt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"snow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"clay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"nether_brick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"quartz_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"quartz_block", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"brewing_stand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"clock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"compass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_sword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_shovel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_pickaxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_axe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_hoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"ender_eye", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"golden_apple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"golden_apple", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"golden_carrot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"cake", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"pumpkin_seeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"melon_seeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"fermented_spider_eye", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"magma_cream", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"fire_charge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"melon_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"soul_sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"nether_brick_fence", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"name_tag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"lead", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"pumpkin_pie", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"comparator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"repeater", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"skull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"skull", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"skull", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"flower_pot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"hay_block", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wheat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"slime_ball", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"item_frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"fishing_rod", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"poisonous_potato", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sign", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"boat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"painting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"flint_and_steel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dragon_egg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"map", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wooden_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"iron_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"skull", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"nether_star", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wooden_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"iron_door", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"planks", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.stick", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"Natura.workbench", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.flintandblaze", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"Natura.bookshelf", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"Natura.fence", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"plankSlab1", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"plankSlab2", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"pressureplate.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"NetherPressurePlate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"trapdoor.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"button.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.eucalyptus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.sakura", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.redwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.hopseed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.maple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.amaranth", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.silverbell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.tiger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.willow", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"fenceGate.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.emptybowl", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"redwoodDoorItem", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"blackberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"blueberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"raspberryItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"Blazerail", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"BrailPowered", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"BrailDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"BrailActivator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"NetherFurnace", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"Obelisk", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"NetherButton", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"NetherLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.bow.ghostwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.bow.bloodwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.bow.darkwood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"natura.bow.fusewood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlMain", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlLight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"blockNuclearControlLight", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemToolThermometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemToolDigitalThermometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemRemoteSensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemEnergySensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemMultipleSensorKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemMultipleSensorKit", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemMultipleSensorKit", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"KitAppeng", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemTimeCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemUpgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemTextCard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"networkLink", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"remoteMonitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"IC2NuclearControl", (String)"ItemVanilliaKit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"hangglider", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"luggage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"autoenchantmenttable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"autoanvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"xpdrain", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"path", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"fan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"elevator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"elevator_rotating", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"vacuumhopper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sprinkler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"guide", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"builder_guide", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"blockPlacer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"blockbreaker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"itemDropper", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sleepingBag", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"ropeladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"ladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"beartrap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"cannon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sponge", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"goldenegg", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"village_highlighter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sky", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sky", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"projector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"paintmixer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"canvas", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"xpbottler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"drawingtable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"imaginary", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"imaginary", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"xpshower", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"scaffolding", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"craneControl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"craneBackpack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"emptyMap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"generic", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"cartographer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"slimalyzer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"sonicglasses", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"devnull", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"pedometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"tastyClay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"cursor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openglasses", (String)"openglassesterminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openglasses", (String)"openglasses", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"baseTierWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"baseTierOneBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"baseTierTwoBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"baseTierThreeBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"baseTierFourBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"sensorTierOneItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"sensorTierTwoItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"sensorTierThreeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"sensorTierFiveItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"sensorTierFourItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"chamberTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"chamberTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"chamberTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"chamberTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"chamberTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"barrelTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"barrelTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"barrelTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"barrelTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"barrelTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"disposeItemTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"potatoCannonTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"machineGunTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"incendiaryTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"grenadeTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"relativisticTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"rocketTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"teleporterTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"railGunTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"laserTurret", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"hardWallTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"hardWallTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"hardWallTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"hardWallTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"hardWallTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fenceTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fenceTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fenceTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fenceTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fenceTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"ioBus", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderPowerTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderPowerTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderPowerTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderPowerTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderPowerTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderInvTierOne", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderInvTierTwo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderInvTierThree", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderInvTierFour", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"expanderInvTierFive", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"leverBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"bulletCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"blazingClayCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"grenadeCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"rocketCraftable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"ferroSlug", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"accuraccyUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"fireRateUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"rangeUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"scattershotUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"efficiencyUpgradeItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"damageAmpAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"solarPanelAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"serialPortAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"concealerAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"recyclerAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"potentiaAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"openmodularturrets", (String)"redstoneReactorAddon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine1", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.solar_panel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.battery", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)56, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.stone", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.backpack", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.barrel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transmission", (String)"projectred.transmission.wire", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sawgold", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sawruby", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sawsapphire", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sawperidot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.rubyboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.rubychestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.rubyhelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.rubyleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sapphireboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sapphirechestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sapphirehelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.sapphireleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.peridotboots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.peridotchestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.peridothelmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Exploration", (String)"projectred.exploration.peridotleggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.jetpack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.part", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.screwdriver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.wiredebugger", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Core", (String)"projectred.core.datacard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.electric_screwdriver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.pipe", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routingchip", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Transportation", (String)"projectred.transportation.routerutil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Fabrication", (String)"projectred.integration.icblock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Fabrication", (String)"projectred.integration.icblock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Fabrication", (String)"projectred.fabrication.icblueprint", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Fabrication", (String)"projectred.fabrication.icchip", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"MCFrames", (String)"mcframes.frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.machine2", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ProjRed|Expansion", (String)"projectred.expansion.plan", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"stair", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.stone", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"lantern.metal", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cube", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"fuel.coke", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cube", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"slab", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cube", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"slab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"anvil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"track", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"track.elevator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"signal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.railbed", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.railbed", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.rail", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.tie", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"detector", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.epsilon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.epsilon", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.epsilon", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.epsilon", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"post", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"post", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"post", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"post", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"post", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.signal.lamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.gear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.gear", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.gear", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"part.gear", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.alpha", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"brick.sandy", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"backpack.trackman.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"backpack.iceman.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"backpack.apothecary.t1", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"frame", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"tool.steel.shears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"brick.infernal", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"upgrade.lapotron", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.cargo", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.track.relayer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.undercutter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.track.layer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.track.remover", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"firestone.cut", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"firestone.refined", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.redstone.flux", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"machine.gamma", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"brick.bloodstained", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"onlineDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"moonSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"bloodMoonSensor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"lapisLamp", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"imbuingStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"energyDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"enderEnergyDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"itemCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"advancedItemCollector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"dyeingMachine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"playerinterface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"filter", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"ingredient", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"fertilizedDirt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"fluidDisplay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"advancedFluidDisplay", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"wirelessLever", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"voidStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"dropFilter", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RandomThings", (String)"spectreKey", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"tile.remote_interface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"tile.machine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"tile.machine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"skylight", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"intelligentWorkbench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.wireless_transmitter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.chip.location", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.io_tool", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.blank_plate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.chip.transfer", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.chip.upgrade", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.pda", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.remoteAccessor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"RIO", (String)"item.linker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"stargateRing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"stargateRing", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"stargateBase", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"stargateController", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"naquadahBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"naquadahOre", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"ic2PowerUnit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"rfPowerUnit", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"ocInterface", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"naquadahIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"naquadah", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"sgChevronUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"sgIrisUpgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"sgIrisBlade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"SGCraft", (String)"ic2Capacitor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockCartAssembler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockCargoManager", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDistributor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDetector", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockActivator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDetector", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDetector", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockDetector", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockAdvDetector", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockJunction", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockMetalStorage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockMetalStorage", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockMetalStorage", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)47, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)82, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)37, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)83, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)84, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)45, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)56, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)69, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)70, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)44, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)35, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)37, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)38, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)39, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)84, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)79, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)80, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)61, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)62, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)63, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)23, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)51, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)52, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)53, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)58, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)88, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"BlockLiquidManager", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)59, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"upgrade", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)101, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)65, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)64, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)71, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)87, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)92, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)91, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)93, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)33, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)34, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)43, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)59, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)36, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)60, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)57, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)85, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)68, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)95, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)19, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)40, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)75, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)77, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)78, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)82, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)83, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)86, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)89, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)94, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"CartModule", (long)1L, (int)99, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesCarts", (String)"ModuleComponents", (long)1L, (int)17, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesAddons", (String)"cable_rf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesAddons", (String)"cable_ae", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesAddons", (String)"duplicator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"StevesAddons", (String)"labeler", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemShadowmetalHoe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemShadowmetalPick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemShadowmetalAxe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemShadowmetalSpade", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemShadowmetalSword", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCrystal", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticOpaque", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticOpaque", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"WandCap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"WandCasting", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticSolid", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCandle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemNugget", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemThaumometer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemBaubleBlanks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemBaubleBlanks", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemBaubleBlanks", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticSolid", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockMetalDevice", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticSlabStone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockTaint", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemNugget", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemAxeVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemSwordVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemPickVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShovelVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemHoeVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemHelmetVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemChestplateVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemLeggingsVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemBootsVoid", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"voidFAS", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"voidShears", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"quicksilverBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"wireless.essentia.terminal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"part.base", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"part.base", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.casing", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"storage.essentia", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"thaumicenergistics", (String)"thaumicenergistics.block.essentia.cell.workbench", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicExploration", (String)"blankSeal", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"shareBook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"darkQuartzItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"darkQuartz", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"darkQuartz", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"darkQuartz", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"darkQuartzSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"ThaumicTinkerer", (String)"kamiResource", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MetalBlock", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"slime.gel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"slime.gel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTankNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPane", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"helmetWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"chestplateWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"leggingsWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"bootsWood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedBlock", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedBlock", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedBlock", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedBlock", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickfancy", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickmetal", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickmetal", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickmetal", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.multibrickmetal", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"heartCanister", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)25, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"toolRod", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"blankPattern", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"decoration.stoneladder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"trap.punji", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"MeatBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"WoolSlab1", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"WoolSlab2", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedSlab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Smeltery", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SmelteryNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlockNether", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlock", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlockNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CastingChannel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CastingChannel", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlock", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SearedBlockNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTank", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTankNether", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTank", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"LavaTankNether", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassBlock.StainedClear", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)41, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)42, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)20, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)21, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)31, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)24, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)32, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)27, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)28, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)29, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)30, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)8, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)11, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)13, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"GlassPaneClearStained", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"knapsack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelGoggles", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelVest", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelGlove", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelWings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelBelt", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"travelBoots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"trap.barricade.oak", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"trap.barricade.spruce", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"trap.barricade.birch", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"trap.barricade.jungle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"explosive.slime", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"slime.channel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"blood.channel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"slime.pad", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"rail.wood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingStation", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"ToolStationBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"ToolStationBlock", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"ToolForgeBlock", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftingSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"FurnaceSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"CraftedSoil", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"SpeedSlab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"strangeFood", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"goldHead", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Armor.DryingRack", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)14, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)15, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)18, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"diamondApple", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"heartCanister", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"heartCanister", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"heartCanister", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Redstone.Landmine", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Redstone.Landmine", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Redstone.Landmine", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TConstruct", (String)"Redstone.Landmine", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"AeonSteelIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"AeonSteelBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"QueensGoldIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"QueensGoldBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"DogbeariumIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"tinkersdefense", (String)"DogbeariumBlock", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"tile.TFTowerDevice", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.emptyMagicMap", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.ironwoodRaw", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"tile.TFUncraftingTable", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"obsidianStick", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"stoneBowl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"retherPearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"wirelessTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"blazeTransceiver", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"recieverDish", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Core", (String)"blazeRecieverDish", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Logic", (String)"wirelessLogic", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Logic", (String)"wirelessLogic", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Logic", (String)"wirelessLogic", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"triangulator", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"remote", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"sniffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"map", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"tracker", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"rep", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"WR-CBE|Addons", (String)"psniffer", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"witchesovenidle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"fumefunnel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"filteredfumefunnel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)73, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"altar", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"kettle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"arthana", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)153, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)16, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)26, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"spinningwheel", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"distilleryidle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)140, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)81, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)106, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)127, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)46, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)107, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"cauldronbook", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)47, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)48, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)49, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"chalkritual", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"circletalisman", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"earmuffs", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)10, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)92, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)12, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"rubyslippers", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"snowpressureplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeByOutputDelayed("nuggetLead");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetSilver");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetTin");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetCopper");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetSteel");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetPulsatingIron");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetVibrantAlloy");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetDraconium");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetDraconiumAwakened");
        RecipeRemover.removeRecipeByOutputDelayed("blockObsidian");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetGold");
        RecipeRemover.removeRecipeByOutputDelayed("nuggetIron");
        RecipeRemover.removeRecipeByOutputDelayed("torchStone");
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Ruby, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)3L, (int)15, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"bones", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)6L, (int)15, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"bones", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)12L, (int)15, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"bones", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)9, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"flowers", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"flowers", (long)1L, (int)9, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"flowers2", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"flowers2", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"mushrooms", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)7, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"moss", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"mushrooms", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"misc", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"plants", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Ruby, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Apatite, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Apatite, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Diamond, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Sapphire, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Wheat, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.NetherStar, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Iridium, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Saltpeter, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustEnderPearl", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemEnderPearl", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustEnderEye", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemEnderEye", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGreenSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGreenSapphire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustOlivine", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemOlivine", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTanzanite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTanzanite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustAmethyst", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemAmethyst", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustJasper", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemJasper", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGarnetYellow", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGarnetYellow", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustGarnetRed", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemGarnetRed", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForce", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForce", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForcillium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForcillium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustForcicium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemForcicium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustDilithium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemDilithium", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustAmber", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemAmber", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustFoolsRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemFoolsRuby", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustBlueTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemBlueTopaz", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustMonazite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemMonazite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustQuartzite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemQuartzite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustLazurite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemLazurite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustSodalite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemSodalite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustNiter", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemNiter", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustTricalciumPhosphate", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemTricalciumPhosphate", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustLignite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemLignite", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedEntropy", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedEntropy", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedOrder", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedOrder", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustVinteum", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemVinteum", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedAir", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedAir", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedFire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedFire", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedEarth", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedEarth", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustInfusedWater", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("gemInfusedWater", new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed("dustCoal", "blockCoal");
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"coal", (long)9L, (int)1, (ItemStack)IScriptLoader.missing), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.Charcoal, (long)1L));
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Charcoal, (long)9L), GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.Charcoal, (long)1L));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"harvestcraft", (String)"cottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"IC2", (String)"itemCofeePowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"IC2", (String)"itemCofeeBeans", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)2, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)3, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemShard", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Lapis, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Emerald, (long)1L), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"gunpowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"coal", (long)1L, (int)1, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"glowstone_dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"dye", (long)3L, (int)15, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"bone", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"nether_star", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"glowstone_dust", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"Natura", (String)"Bluebells", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemInkwell", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"glass_bottle", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"feather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), "dyeBlack");
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.fieryIngot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[0]);
        RecipeRemover.removeRecipeShapelessDelayed(GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)130, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"witchery", (String)"ingredient", (long)1L, (int)130, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"magma_cream", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"blaze_powder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapelessDelayed("ingotThauminite", GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"thaumicbases", (String)"resource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)2, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"BinnieCore", (String)"storage", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wheat", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"plants", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemAlloy", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"}, new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"}, new Object[]{"nuggetDarkSteel", "nuggetDarkSteel", "nuggetDarkSteel"});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"EnderIO", (String)"itemAlloy", (long)1L, (int)8, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemMaterial", (long)1L, (int)11, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"ender_pearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderIO", (String)"itemPowderIngot", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"ender_pearl", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{null, GT_ModHandler.getModItem((String)"EnderZoo", (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null}, new Object[]{GT_ModHandler.getModItem((String)"EnderZoo", (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderZoo", (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"EnderZoo", (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{null, GT_ModHandler.getModItem((String)"EnderZoo", (String)"enderFragment", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"unstableingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"minecraft", (String)"iron_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"ExtraUtilities", (String)"divisionSigil", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"minecraft", (String)"diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)9L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"minecraft", (String)"emerald", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)2L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"GeneSampleBlank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"gendustry", (String)"GeneTemplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.gem, (Object)Materials.Apatite, (long)1L), new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7)}, new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7)}, new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)7)});
        RecipeRemover.removeRecipeShapedDelayed("ingotSilver", new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"}, new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"}, new Object[]{"nuggetSilver", "nuggetSilver", "nuggetSilver"});
        RecipeRemover.removeRecipeShapedDelayed("ingotLead", new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"}, new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"}, new Object[]{"nuggetLead", "nuggetLead", "nuggetLead"});
        RecipeRemover.removeRecipeShapedDelayed("ingotDraconium", new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"}, new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"}, new Object[]{"nuggetDraconium", "nuggetDraconium", "nuggetDraconium"});
        RecipeRemover.removeRecipeShapedDelayed("ingotDraconiumAwakened", new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"}, new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"}, new Object[]{"nuggetDraconiumAwakened", "nuggetDraconiumAwakened", "nuggetDraconiumAwakened"});
        RecipeRemover.removeRecipeShapedDelayed("ingotVibrantAlloy", new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"}, new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"}, new Object[]{"nuggetVibrantAlloy", "nuggetVibrantAlloy", "nuggetVibrantAlloy"});
        RecipeRemover.removeRecipeShapedDelayed("ingotPulsatingIron", new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"}, new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"}, new Object[]{"nuggetPulsatingIron", "nuggetPulsatingIron", "nuggetPulsatingIron"});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_button", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"string", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"cropCotton", "cropCotton", "cropCotton"}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"speckled_melon", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)1, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)3, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)4, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)5, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)6, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"stone_slab", (long)1L, (int)7, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"bookshelf", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"packed_ice", (long)4L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"gunpowder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), null}, new Object[]{GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)4, (ItemStack)IScriptLoader.missing), null}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"chest_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"furnace_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"hopper_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"tnt_minecart", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"iron_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"}, new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"}, new Object[]{"nuggetIron", "nuggetIron", "nuggetIron"});
        RecipeRemover.removeRecipeShapedDelayed("nuggetIron");
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"gold_ingot", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"}, new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"}, new Object[]{"nuggetGold", "nuggetGold", "nuggetGold"});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"wooden_slab", (long)6L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"minecraft", (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"planks", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"blaze_powder", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCustomPlant", (long)1L, (int)3, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"leather_helmet", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"leather_chestplate", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"leather_leggings", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"leather_boots", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), null, GT_ModHandler.getModItem((String)"harvestcraft", (String)"wovencottonItem", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"emerald", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"ForbiddenMagic", (String)"FMResource", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"diamond", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"MagicBees", (String)"beeNugget", (long)1L, (int)5, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"paper", (long)2L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"minecraft", (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"minecraft", (String)"reeds", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"sand", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"minecraft", (String)"leather", (long)1L, (int)0, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"Natura", (String)"barleyFood", (long)1L, (int)6, (ItemStack)IScriptLoader.missing)}, new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"paintBrush", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"OpenBlocks", (String)"goldenEye", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.energy.batbox", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.energy.cesu", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.energy.mfe", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.tank", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.anchor.personal", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.anchor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"cart.work", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"tool.electric.meter", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"armor.goggles", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"tool.magnifying.glass", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"tool.signal.tuner", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Railcraft", (String)"tool.surveyor", (long)1L, (int)0, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticOpaque", (long)1L, (int)0, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)6, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockCosmeticOpaque", (long)1L, (int)1, (ItemStack)IScriptLoader.missing)}, new Object[0], new Object[0]);
        RecipeRemover.removeRecipeShapedDelayed("ingotThaumium", new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"}, new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"}, new Object[]{"nuggetThaumium", "nuggetThaumium", "nuggetThaumium"});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"crystalSlab", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"thaumicbases", (String)"genericSlab", (long)1L, (int)Short.MAX_VALUE, (ItemStack)IScriptLoader.missing));
        RecipeRemover.removeRecipeShapedDelayed("ingotTin", new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"}, new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"}, new Object[]{"nuggetTin", "nuggetTin", "nuggetTin"});
        RecipeRemover.removeRecipeShapedDelayed("ingotCopper", new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"}, new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"}, new Object[]{"nuggetCopper", "nuggetCopper", "nuggetCopper"});
        RecipeRemover.removeRecipeShapedDelayed("ingotSteel", new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"}, new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"}, new Object[]{"nuggetSteel", "nuggetSteel", "nuggetSteel"});
        RecipeRemover.removeRecipeShapedDelayed("ingotBronze", new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"}, new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"}, new Object[]{"nuggetBronze", "nuggetBronze", "nuggetBronze"});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)11019, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)}, new Object[]{GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing), GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)22, (ItemStack)IScriptLoader.missing)});
        RecipeRemover.removeRecipeShapedDelayed(GT_ModHandler.getModItem((String)"gregtech", (String)"gt.metaitem.01", (long)1L, (int)11019, (ItemStack)IScriptLoader.missing), new Object[]{GT_ModHandler.getModItem((String)"TConstruct", (String)"materials", (long)1L, (int)12, (ItemStack)IScriptLoader.missing), null, null}, new Object[0], new Object[0]);
        RecipeRemover.stopBuffering();
        bufferingRecipes = false;
        long timeToLoad = System.currentTimeMillis() - timeStart;
        MainRegistry.Logger.info((Object)("Recipes removal took " + timeToLoad + " ms."));
    }
}

