/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.asm;

import com.mitchej123.hodgepodge.Common;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;

public enum AsmTransformers {
    SPEEDUP_PROGRESS_BAR("Speed up Progress Bar by speeding up stripSpecialCharacters", () -> Common.config.speedupProgressBar, Side.CLIENT, "com.mitchej123.hodgepodge.asm.transformers.fml.SpeedupProgressBarTransformer"),
    THERMOS_SLEDGEHAMMER_FURNACE_FIX("Take a sledgehammer to CraftServer.resetRecipes() to prevent it from breaking our Furnace Fix", () -> Common.thermosTainted && Common.config.speedupVanillaFurnace, Side.BOTH, "com.mitchej123.hodgepodge.asm.transformers.thermos.ThermosFurnaceSledgeHammer"),
    OPTIFINE_REMOVE_GLERROR_LOGGING("Removes the logging of GL errors from OptiFine/Shadersmod", () -> Common.config.removeOptifineGLErrors, Side.CLIENT, "com.mitchej123.hodgepodge.asm.transformers.optifine.GLErrorLoggingTransformer");

    private final Supplier<Boolean> applyIf;
    private final Side side;
    private final String[] transformerClasses;

    private AsmTransformers(String description, Supplier<Boolean> applyIf, Side side, String ... transformers) {
        this.applyIf = applyIf;
        this.side = side;
        this.transformerClasses = transformers;
    }

    private boolean shouldBeLoaded() {
        return this.applyIf.get() != false && this.shouldLoadSide();
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    public static String[] getTransformers() {
        ArrayList<String> list = new ArrayList<String>();
        for (AsmTransformers transformer : AsmTransformers.values()) {
            if (transformer.shouldBeLoaded()) {
                Common.log.info("Loading transformer {}", (Object[])transformer.transformerClasses);
                list.addAll(Arrays.asList(transformer.transformerClasses));
                continue;
            }
            Common.log.info("Not loading transformer {}", (Object[])transformer.transformerClasses);
        }
        return list.toArray(new String[0]);
    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }
}

