/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.splicer;

import binnie.core.machines.Machine;
import binnie.core.machines.power.ComponentProcessSetCost;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.core.util.I18N;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.machine.splicer.Splicer;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class SplicerComponentLogic
extends ComponentProcessSetCost
implements IProcess {
    public int nOfGenes = 0;

    public SplicerComponentLogic(Machine machine) {
        super(machine, 12000000, 1200);
    }

    @Override
    public int getProcessLength() {
        int temp;
        float n = this.getNumberOfGenes();
        if (n > 1.0f) {
            n = 1.0f + (n - 1.0f) * 0.5f;
        }
        return (temp = (int)((float)super.getProcessLength() * n)) != 0 ? temp : 1;
    }

    @Override
    public int getProcessEnergy() {
        float n = this.getNumberOfGenes();
        if (n > 1.0f) {
            n = 1.0f + (n - 1.0f) * 0.5f;
        }
        return (int)((float)super.getProcessEnergy() * n);
    }

    @Override
    public void onInventoryUpdate() {
        super.onInventoryUpdate();
        this.nOfGenes = this.getGenesToUse();
    }

    protected int getGenesToUse() {
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        if (serum == null || target == null) {
            return 1;
        }
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(target);
        IGene[] genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum);
        if (ind.getGenome().getSpeciesRoot() != ((IItemSerum)serum.func_77973_b()).getSpeciesRoot(serum)) {
            return 1;
        }
        int i = 0;
        for (IGene gene : genes) {
            if (ind.getGenome().getActiveAllele(gene.getChromosome()) == gene.getAllele() && ind.getGenome().getInactiveAllele(gene.getChromosome()) == gene.getAllele()) continue;
            ++i;
        }
        return i < 1 ? 1 : i;
    }

    private int getFullNumberOfGenes() {
        ItemStack serum = this.getUtil().getStack(0);
        if (serum == null) {
            return 1;
        }
        return Engineering.getGenes(serum).length;
    }

    private int getNumberOfGenes() {
        return this.nOfGenes;
    }

    @Override
    public String getTooltip() {
        int n = this.getNumberOfGenes();
        int f = this.getFullNumberOfGenes();
        if (f > 1) {
            if (n > 1) {
                return I18N.localise("genetics.machine.splicer.splicingIn.0", n, f);
            }
            return I18N.localise("genetics.machine.splicer.splicingIn.1", n, f);
        }
        if (n > 1) {
            return I18N.localise("genetics.machine.splicer.splicingIn.2", n);
        }
        return I18N.localise("genetics.machine.splicer.splicingIn.3", n);
    }

    @Override
    public ErrorState canWork() {
        if (this.getUtil().isSlotEmpty(9)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.splicer.error.noIndividual"), 9);
        }
        if (this.getUtil().isSlotEmpty(0)) {
            return new ErrorState.NoItem(I18N.localise("genetics.machine.splicer.error.noSerum"), 0);
        }
        ErrorState state = this.isValidSerum();
        if (state != null) {
            return state;
        }
        if (this.getUtil().getStack(0) != null && Engineering.getCharges(this.getUtil().getStack(0)) == 0) {
            return new ErrorState(I18N.localise("genetics.machine.splicer.error.emptySerum.title"), I18N.localise("genetics.machine.splicer.error.emptySerum"));
        }
        return super.canWork();
    }

    public ErrorState isValidSerum() {
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        IGene[] genes = Engineering.getGenes(serum);
        if (genes.length == 0) {
            return new ErrorState(I18N.localise("genetics.machine.splicer.error.invalidSerum.title"), I18N.localise("genetics.machine.splicer.error.invalidSerum.0"));
        }
        if (!genes[0].getSpeciesRoot().isMember(target)) {
            return new ErrorState(I18N.localise("genetics.machine.splicer.error.invalidSerum.title"), I18N.localise("genetics.machine.splicer.error.invalidSerum.1"));
        }
        IIndividual individual = genes[0].getSpeciesRoot().getMember(target);
        boolean hasAll = true;
        for (IGene gene : genes) {
            if (!hasAll) continue;
            IGenome genome = individual.getGenome();
            IChromosomeType chromosome = gene.getChromosome();
            String geneAlleleUID = gene.getAllele().getUID();
            IAllele a = genome.getActiveAllele(chromosome);
            IAllele b = genome.getInactiveAllele(chromosome);
            hasAll = a.getUID().equals(geneAlleleUID) && b.getUID().equals(geneAlleleUID);
        }
        if (hasAll) {
            return new ErrorState(I18N.localise("genetics.machine.splicer.error.defunctSerum.title"), I18N.localise("genetics.machine.splicer.error.defunctSerum"));
        }
        return null;
    }

    @Override
    public ErrorState canProgress() {
        return super.canProgress();
    }

    @Override
    protected void onFinishTask() {
        IGene[] genes;
        super.onFinishTask();
        ItemStack serum = this.getUtil().getStack(0);
        ItemStack target = this.getUtil().getStack(9);
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(target);
        if (!ind.isAnalyzed()) {
            ind.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ind.writeToNBT(nbttagcompound);
            target.func_77982_d(nbttagcompound);
        }
        for (IGene gene : genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum)) {
            Splicer.setGene(gene, target, 0);
            Splicer.setGene(gene, target, 1);
        }
        this.getUtil().damageItem(0, 1);
    }

    @Override
    protected void onTickTask() {
    }
}

