/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TagMouseOver
extends Tag {
    @Override
    public String getCategory() {
        return "mouseover";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Name().setName("mouseovername"));
        TagRegistry.INSTANCE.register(new UniqueName().setName("mouseoveruniquename"));
        TagRegistry.INSTANCE.register(new Id().setName("mouseoverid"));
        TagRegistry.INSTANCE.register(new Metadata().setName("mouseovermetadata"));
        TagRegistry.INSTANCE.register(new PowerWeak().setName("mouseoverpowerweak"));
        TagRegistry.INSTANCE.register(new PowerStrong().setName("mouseoverpowerstrong"));
        TagRegistry.INSTANCE.register(new PowerInput().setName("mouseoverpowerinput"));
    }

    public static class PowerInput
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = PowerInput.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                return String.valueOf(world.func_94577_B(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d));
            }
            return "-1";
        }
    }

    public static class PowerStrong
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = PowerStrong.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                ForgeDirection side;
                Block block = world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
                int power = -1;
                ForgeDirection[] forgeDirectionArray = ForgeDirection.VALID_DIRECTIONS;
                int n = forgeDirectionArray.length;
                for (int i = 0; i < n && (power = Math.max(power, block.func_149748_c((IBlockAccess)world, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d, (side = forgeDirectionArray[i]).ordinal()))) < 15; ++i) {
                }
                return String.valueOf(power);
            }
            return "-1";
        }
    }

    public static class PowerWeak
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = PowerWeak.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                int power = -1;
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    int x = objectMouseOver.field_72311_b + side.offsetX;
                    int y = objectMouseOver.field_72312_c + side.offsetY;
                    int z = objectMouseOver.field_72309_d + side.offsetZ;
                    if ((power = Math.max(power, world.func_147439_a(x, y, z).func_149709_b((IBlockAccess)world, x, y, z, side.ordinal()))) >= 15) break;
                }
                return String.valueOf(power);
            }
            return "-1";
        }
    }

    public static class Metadata
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = Metadata.minecraft.field_71476_x;
            if (objectMouseOver != null && objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                return String.valueOf(world.func_72805_g(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d));
            }
            return "0";
        }
    }

    public static class Id
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = Id.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                Block block;
                if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    return String.valueOf(objectMouseOver.field_72308_g.func_145782_y());
                }
                if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                    return String.valueOf(GameData.getBlockRegistry().getId((Object)block));
                }
            }
            return "0";
        }
    }

    public static class UniqueName
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = UniqueName.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                Block block;
                if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    String name = EntityList.func_75621_b((Entity)objectMouseOver.field_72308_g);
                    if (name != null) {
                        return name;
                    }
                } else if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                    return GameData.getBlockRegistry().func_148750_c((Object)block);
                }
            }
            return "";
        }
    }

    public static class Name
    extends TagMouseOver {
        @Override
        public String getValue() {
            MovingObjectPosition objectMouseOver = Name.minecraft.field_71476_x;
            if (objectMouseOver != null) {
                Block block;
                if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                    return objectMouseOver.field_72308_g.func_145748_c_().func_150254_d();
                }
                if (objectMouseOver.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && (block = world.func_147439_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d)) != null) {
                    ItemStack pickBlock = block.getPickBlock(objectMouseOver, world, objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
                    if (pickBlock != null) {
                        return pickBlock.func_82833_r();
                    }
                    return block.func_149732_F();
                }
            }
            return "";
        }
    }
}

