/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.util.MathHelper;

public abstract class TagPlayerPosition
extends Tag {
    private static final int TICKS = 20;
    protected static final String[] ROUGHDIRECTION = new String[]{"South", "West", "North", "East"};
    protected static final String[] FINEDIRECTION = new String[]{"South", "South West", "West", "North West", "North", "North East", "East", "South East"};
    protected static final String[] ABRROUGHDIRECTION = new String[]{"S", "W", "N", "E"};
    protected static final String[] ABRFINEDIRECTION = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};

    @Override
    public String getCategory() {
        return "playerposition";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new ChunkX().setName("chunkx"));
        TagRegistry.INSTANCE.register(new ChunkZ().setName("chunkz"));
        TagRegistry.INSTANCE.register(new ChunkOffsetX().setName("chunkoffsetx"));
        TagRegistry.INSTANCE.register(new ChunkOffsetZ().setName("chunkoffsetz"));
        TagRegistry.INSTANCE.register(new X().setName("x").setAliases("xr"));
        TagRegistry.INSTANCE.register(new Y().setName("y").setAliases("yr"));
        TagRegistry.INSTANCE.register(new YFeet().setName("yfeet").setAliases("yfeetr"));
        TagRegistry.INSTANCE.register(new Z().setName("z").setAliases("zr"));
        TagRegistry.INSTANCE.register(new Xi().setName("xi"));
        TagRegistry.INSTANCE.register(new Yi().setName("yi"));
        TagRegistry.INSTANCE.register(new YFeeti().setName("yfeeti"));
        TagRegistry.INSTANCE.register(new Zi().setName("zi"));
        TagRegistry.INSTANCE.register(new Speed().setName("speed"));
        TagRegistry.INSTANCE.register(new SpeedX().setName("speedx"));
        TagRegistry.INSTANCE.register(new SpeedY().setName("speedy"));
        TagRegistry.INSTANCE.register(new SpeedZ().setName("speedz"));
        TagRegistry.INSTANCE.register(new SpeedXZ().setName("speedxz"));
        TagRegistry.INSTANCE.register(new Direction().setName("direction"));
        TagRegistry.INSTANCE.register(new RoughDirection().setName("roughdirection"));
        TagRegistry.INSTANCE.register(new FineDirection().setName("finedirection"));
        TagRegistry.INSTANCE.register(new AbbreviatedRoughDirection().setName("abrroughdirection"));
        TagRegistry.INSTANCE.register(new AbbreviatedFineDirection().setName("abrfinedirection"));
        TagRegistry.INSTANCE.register(new DirectionHud().setName("directionhud"));
    }

    public static class DirectionHud
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            int direction = MathHelper.func_76128_c((double)((double)(DirectionHud.player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
            String left = ABRFINEDIRECTION[(direction / 2 + ABRFINEDIRECTION.length - 1) % ABRFINEDIRECTION.length];
            String center = ABRFINEDIRECTION[(direction / 2 + ABRFINEDIRECTION.length) % ABRFINEDIRECTION.length];
            String right = ABRFINEDIRECTION[(direction / 2 + ABRFINEDIRECTION.length + 1) % ABRFINEDIRECTION.length];
            if (direction % 2 == 0) {
                return String.format("\u00a7r%s   \u00a7c%s\u00a7r   %s", left, center, right);
            }
            return String.format("\u00a7r   %2s   %2s   ", center, right);
        }
    }

    public static class AbbreviatedFineDirection
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return ABRFINEDIRECTION[MathHelper.func_76128_c((double)((double)AbbreviatedFineDirection.player.field_70177_z * 8.0 / 360.0 + 0.5)) & 7];
        }
    }

    public static class AbbreviatedRoughDirection
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return ABRROUGHDIRECTION[MathHelper.func_76128_c((double)((double)AbbreviatedRoughDirection.player.field_70177_z * 4.0 / 360.0 + 0.5)) & 3];
        }
    }

    public static class FineDirection
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return FINEDIRECTION[MathHelper.func_76128_c((double)((double)FineDirection.player.field_70177_z * 8.0 / 360.0 + 0.5)) & 7];
        }
    }

    public static class RoughDirection
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return ROUGHDIRECTION[MathHelper.func_76128_c((double)((double)RoughDirection.player.field_70177_z * 4.0 / 360.0 + 0.5)) & 3];
        }
    }

    public static class Direction
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            float direction = Direction.player.field_70177_z % 360.0f;
            if (direction >= 180.0f) {
                direction -= 360.0f;
            } else if (direction < -180.0f) {
                direction += 360.0f;
            }
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(direction));
        }
    }

    public static class SpeedXZ
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.3f", 20.0 * Math.sqrt(SpeedXZ.playerMotion.x * SpeedXZ.playerMotion.x + SpeedXZ.playerMotion.z * SpeedXZ.playerMotion.z));
        }
    }

    public static class SpeedZ
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.3f", Float.valueOf(20.0f * Math.abs(SpeedZ.playerMotion.z)));
        }
    }

    public static class SpeedY
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.3f", Float.valueOf(20.0f * Math.abs(SpeedY.playerMotion.y)));
        }
    }

    public static class SpeedX
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.3f", Float.valueOf(20.0f * Math.abs(SpeedX.playerMotion.x)));
        }
    }

    public static class Speed
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.3f", 20.0 * Math.sqrt(Speed.playerMotion.x * Speed.playerMotion.x + Speed.playerMotion.y * Speed.playerMotion.y + Speed.playerMotion.z * Speed.playerMotion.z));
        }
    }

    public static class Zi
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(Zi.playerPosition.z);
        }
    }

    public static class YFeeti
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf((int)Math.floor(YFeeti.player.field_70121_D.field_72338_b));
        }
    }

    public static class Yi
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(Yi.playerPosition.y);
        }
    }

    public static class Xi
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(Xi.playerPosition.x);
        }
    }

    public static class Z
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Z.player.field_70161_v);
        }
    }

    public static class YFeet
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", YFeet.player.field_70121_D.field_72338_b);
        }
    }

    public static class Y
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Y.player.field_70163_u);
        }
    }

    public static class X
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", X.player.field_70165_t);
        }
    }

    public static class ChunkOffsetZ
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(ChunkOffsetZ.playerPosition.z & 0xF);
        }
    }

    public static class ChunkOffsetX
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(ChunkOffsetX.playerPosition.x & 0xF);
        }
    }

    public static class ChunkZ
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(ChunkZ.playerPosition.z >> 4);
        }
    }

    public static class ChunkX
    extends TagPlayerPosition {
        @Override
        public String getValue() {
            return String.valueOf(ChunkX.playerPosition.x >> 4);
        }
    }
}

