/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.painter;

import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.painter.IPaintedBlock;
import crazypants.enderio.machine.painter.PaintSourceParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class PaintSourceValidator {
    public static PaintSourceValidator instance = new PaintSourceValidator();
    private boolean listsPopulated = false;
    private final List<RecipeInput> whitelist = new ArrayList<RecipeInput>();
    private final List<RecipeInput> blacklist = new ArrayList<RecipeInput>();

    public boolean isValidSourceDefault(ItemStack paintSource) {
        if (paintSource == null) {
            return false;
        }
        Block block = Util.getBlockFromItemId((ItemStack)paintSource);
        if (block == null || block instanceof IPaintedBlock) {
            return false;
        }
        if (this.isBlacklisted(paintSource)) {
            return false;
        }
        if (this.isWhitelisted(paintSource)) {
            return true;
        }
        if (!Config.allowTileEntitiesAsPaintSource && block instanceof ITileEntityProvider) {
            return false;
        }
        return block.func_149662_c() || block.func_149688_o().func_76218_k() && block.func_149686_d() || block == Blocks.field_150359_w;
    }

    public boolean isWhitelisted(ItemStack paintSource) {
        return this.isInList(paintSource, this.whitelist);
    }

    public boolean isBlacklisted(ItemStack paintSource) {
        return this.isInList(paintSource, this.blacklist);
    }

    public void addToWhitelist(ItemStack input) {
        this.addToWhitelist(new RecipeInput(input, true));
    }

    public void addToWhitelist(RecipeInput input) {
        this.whitelist.add(input);
    }

    public void addToBlacklist(ItemStack input) {
        this.addToBlacklist(new RecipeInput(input, true));
    }

    public void addToBlacklist(RecipeInput input) {
        this.blacklist.add(input);
    }

    public void removeFromWhitelist(RecipeInput input) {
        this.removeFromList(input, this.whitelist);
    }

    public void removeFromBlackList(RecipeInput input) {
        this.removeFromList(input, this.blacklist);
    }

    protected boolean isInList(ItemStack paintSource, List<RecipeInput> list) {
        if (paintSource == null) {
            return false;
        }
        for (RecipeInput ri : list) {
            if (ri == null || !ri.isInput(paintSource)) continue;
            return true;
        }
        return false;
    }

    protected void removeFromList(RecipeInput input, List<RecipeInput> list) {
        ItemStack inStack = input.getInput();
        if (inStack == null) {
            return;
        }
        RecipeInput toRemove = null;
        for (RecipeInput in : list) {
            if (!ItemUtil.areStacksEqual((ItemStack)inStack, (ItemStack)in.getInput())) continue;
            toRemove = in;
            break;
        }
        if (toRemove != null) {
            list.remove(toRemove);
        }
    }

    public void loadConfig() {
        PaintSourceParser.loadConfig();
    }
}

