/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.hud;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.gui.hud.BasicHUDGui;
import logisticspipes.interfaces.IHUDConfig;
import logisticspipes.pipes.PipeItemsCraftingLogistics;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class HUDCrafting
extends BasicHUDGui {
    private final PipeItemsCraftingLogistics pipe;

    public HUDCrafting(PipeItemsCraftingLogistics pipe) {
        this.pipe = pipe;
    }

    @Override
    public void renderHeadUpDisplay(double d, boolean day, boolean shifted, Minecraft mc, IHUDConfig config) {
        String message;
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)64);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)64);
        }
        if (this.pipe.displayList.size() > 0) {
            GuiGraphics.drawGuiBackGround(mc, -50, -28, 50, 30, 0.0f, false);
        } else {
            GuiGraphics.drawGuiBackGround(mc, -30, -22, 30, 25, 0.0f, false);
        }
        if (day) {
            GL11.glColor4b((byte)64, (byte)64, (byte)64, (byte)127);
        } else {
            GL11.glColor4b((byte)127, (byte)127, (byte)127, (byte)127);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.005f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.0E-4f);
        if (this.pipe.displayList.size() > 0) {
            message = "Result:";
            mc.field_71466_p.func_78276_b(message, -28, -10, 0);
            message = "Todo:";
            mc.field_71466_p.func_78276_b(message, -28, 5, 0);
        } else {
            message = "Result:";
            mc.field_71466_p.func_78276_b(message, -16, -10, 0);
        }
        GL11.glScalef((float)0.8f, (float)0.8f, (float)-1.0f);
        ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>();
        List<ItemIdentifierStack> craftables = this.pipe.getCraftedItems();
        if (craftables != null && craftables.size() > 0) {
            list.add(craftables.get(0));
        }
        if (this.pipe.displayList.size() > 0) {
            ItemStackRenderer.renderItemIdentifierStackListIntoGui(list, null, 0, 11, -18, 1, 1, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS, true, false, shifted);
            ItemStackRenderer.renderItemIdentifierStackListIntoGui(this.pipe.displayList, null, 0, 13, 3, 1, 1, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS, true, false, shifted);
        } else {
            ItemStackRenderer.renderItemIdentifierStackListIntoGui(list, null, 0, -9, -1, 1, 1, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS, true, false, shifted);
        }
    }

    @Override
    public boolean display(IHUDConfig config) {
        return config.isHUDCrafting() && (!this.pipe.hasCraftingSign() && this.pipe.getCraftedItems() != null || this.pipe.displayList.size() > 0);
    }

    @Override
    public boolean cursorOnWindow(int x, int y) {
        if (this.pipe.displayList.size() > 0) {
            return -50 < x && x < 50 && -28 < y && y < 30;
        }
        return -30 < x && x < 30 && -22 < y && y < 25;
    }
}

