/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.resources.DictResource;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsItemOrder
extends LogisticsOrder {
    private final DictResource resource;
    private final IRequestItems destination;

    public LogisticsItemOrder(DictResource item, IRequestItems destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        super(type, info);
        if (item == null) {
            throw new NullPointerException();
        }
        this.resource = item;
        this.destination = destination;
    }

    @Override
    public IRouter getRouter() {
        if (this.destination == null) {
            return null;
        }
        return this.destination.getRouter();
    }

    @Override
    public void sendFailed() {
        if (this.destination == null) {
            return;
        }
        this.destination.itemCouldNotBeSend(this.getResource().stack, this.getInformation());
    }

    @Override
    public ItemIdentifierStack getAsDisplayItem() {
        return this.resource.stack;
    }

    @Override
    public int getAmount() {
        return this.resource.stack.getStackSize();
    }

    @Override
    public void reduceAmountBy(int amount) {
        this.resource.stack.setStackSize(this.resource.stack.getStackSize() - amount);
    }

    public DictResource getResource() {
        return this.resource;
    }

    public IRequestItems getDestination() {
        return this.destination;
    }
}

