/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.pathfinder.changedetection;

import java.util.ArrayList;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.asm.te.ITileEntityChangeListener;
import logisticspipes.asm.te.LPTileEntityObject;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.ticks.LPTickHandler;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TEControl {
    private static boolean block = false;

    public static void validate(TileEntity tile) {
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        if (!MainProxy.isServer(world)) {
            return;
        }
        if (tile.getClass().getName().startsWith("net.minecraft.tileentity")) {
            return;
        }
        LPPosition pos = new LPPosition(tile);
        if (pos.getX() == 0 && pos.getY() <= 0 && pos.getZ() == 0) {
            return;
        }
        if (SimpleServiceLocator.pipeInformationManager.isPipe(tile, false) || SimpleServiceLocator.specialtileconnection.isType(tile)) {
            ((ILPTEInformation)tile).setObject(new LPTileEntityObject());
            ((ILPTEInformation)tile).getObject().initialised = LPTickHandler.getWorldInfo(world).getWorldTick();
            if (((ILPTEInformation)tile).getObject().initialised < 5L) {
                return;
            }
            QueuedTasks.queueTask(() -> {
                if (!SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                    return null;
                }
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity nextTile;
                    LPPosition newPos = pos.copy();
                    newPos.moveForward(dir);
                    if (!newPos.blockExists(world) || (nextTile = newPos.getTileEntity(world)) == null || ((ILPTEInformation)nextTile).getObject() == null) continue;
                    if (SimpleServiceLocator.pipeInformationManager.isItemPipe(nextTile)) {
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(nextTile).refreshTileCacheOnSide(dir.getOpposite());
                    }
                    if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile)) {
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile).refreshTileCacheOnSide(dir);
                        SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile).refreshTileCacheOnSide(dir.getOpposite());
                    }
                    for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)nextTile).getObject().changeListeners)) {
                        listener.pipeAdded(pos, dir.getOpposite());
                    }
                }
                return null;
            });
        }
    }

    public static void invalidate(TileEntity tile) {
        World world = tile.func_145831_w();
        if (world == null) {
            return;
        }
        if (!MainProxy.isServer(world)) {
            return;
        }
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).isRoutingPipe()) {
            return;
        }
        if (((ILPTEInformation)tile).getObject() != null) {
            QueuedTasks.queueTask(() -> {
                LPPosition pos = new LPPosition(tile);
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity nextTile;
                    LPPosition newPos = pos.copy();
                    newPos.moveForward(dir);
                    if (!newPos.blockExists(world) || (nextTile = newPos.getTileEntity(world)) == null || ((ILPTEInformation)nextTile).getObject() == null || !SimpleServiceLocator.pipeInformationManager.isItemPipe(nextTile)) continue;
                    SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(nextTile).refreshTileCacheOnSide(dir.getOpposite());
                }
                for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)tile).getObject().changeListeners)) {
                    listener.pipeRemoved(pos);
                }
                return null;
            });
        }
    }

    public static void notifyBlocksOfNeighborChange_Start(World world, int x, int y, int z) {
        block = true;
        if (!MainProxy.isServer(world)) {
            return;
        }
        TEControl.handleBlockUpdate(world, LPTickHandler.getWorldInfo(world), x, y, z);
    }

    public static void notifyBlocksOfNeighborChange_Stop(World world, int x, int y, int z) {
        block = false;
    }

    public static void notifyBlockOfNeighborChange(World world, int x, int y, int z) {
        if (block) {
            return;
        }
        TEControl.handleBlockUpdate(world, LPTickHandler.getWorldInfo(world), x, y, z);
    }

    public static void handleBlockUpdate(World world, LPTickHandler.LPWorldInfo info, int x, int y, int z) {
        if (info.getWorldTick() < 5L) {
            return;
        }
        LPPosition pos = new LPPosition(x, y, z);
        if (info.getUpdateQueued().contains(pos)) {
            return;
        }
        if (!pos.blockExists(world)) {
            return;
        }
        TileEntity tile = pos.getTileEntity(world);
        if (tile == null || ((ILPTEInformation)tile).getObject() == null) {
            return;
        }
        if (SimpleServiceLocator.pipeInformationManager.isItemPipe(tile) || SimpleServiceLocator.specialtileconnection.isType(tile)) {
            info.getUpdateQueued().add(pos);
            QueuedTasks.queueTask(() -> {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity nextTile;
                    LPPosition newPos = pos.copy();
                    newPos.moveForward(dir);
                    if (!newPos.blockExists(world) || (nextTile = newPos.getTileEntity(world)) == null || ((ILPTEInformation)nextTile).getObject() == null) continue;
                    for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)nextTile).getObject().changeListeners)) {
                        listener.pipeModified(pos);
                    }
                }
                for (ITileEntityChangeListener listener : new ArrayList<ITileEntityChangeListener>(((ILPTEInformation)tile).getObject().changeListeners)) {
                    listener.pipeModified(pos);
                }
                info.getUpdateQueued().remove(pos);
                return null;
            });
        }
    }
}

