/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.api;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.helper.EnderIOHelper;
import com.kuba6000.mobsinfo.api.helper.InfernalMobsCoreHelper;
import com.kuba6000.mobsinfo.loader.MobRecipeLoader;
import com.kuba6000.mobsinfo.mixin.InfernalMobs.InfernalMobsCoreAccessor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class MobRecipe {
    public final ArrayList<MobDrop> mOutputs;
    public int mMaxDamageChance;
    public final boolean infernalityAllowed;
    public final boolean alwaysinfernal;
    public static MobRecipeLoader.droplist infernaldrops;
    public final boolean isPeacefulAllowed;
    public final EntityLiving entity;
    public final float maxEntityHealth;
    public final boolean isUsableInVial;
    public final String entityName;
    public static HashMap<String, MobRecipe> MobNameToRecipeMap;

    public MobRecipe copy() {
        return new MobRecipe((ArrayList)this.mOutputs.clone(), this.mMaxDamageChance, this.infernalityAllowed, this.alwaysinfernal, this.isPeacefulAllowed, this.entity, this.maxEntityHealth, this.isUsableInVial, this.entityName);
    }

    private MobRecipe(ArrayList<MobDrop> mOutputs, int mMaxDamageChance, boolean infernalityAllowed, boolean alwaysinfernal, boolean isPeacefulAllowed, EntityLiving entity, float maxEntityHealth, boolean isUsable, String entityName) {
        this.mOutputs = mOutputs;
        this.mMaxDamageChance = mMaxDamageChance;
        this.infernalityAllowed = infernalityAllowed;
        this.alwaysinfernal = alwaysinfernal;
        this.isPeacefulAllowed = isPeacefulAllowed;
        this.entity = entity;
        this.maxEntityHealth = maxEntityHealth;
        this.isUsableInVial = isUsable;
        this.entityName = entityName;
    }

    public static MobRecipe generateMobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
        return new MobRecipe(e, entityID, outputs);
    }

    private MobRecipe(EntityLiving e, String entityID, ArrayList<MobDrop> outputs) {
        if (LoaderReference.InfernalMobs) {
            InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
            if (infernaldrops == null) {
                infernaldrops = MobRecipeLoader.getInfernalDrops();
            }
            this.infernalityAllowed = InfernalMobsCoreHelper.callIsClassAllowed((InfernalMobsCore)infernalMobsCore, (EntityLivingBase)e);
            this.alwaysinfernal = infernalMobsCore.callCheckEntityClassForced((EntityLivingBase)e);
        } else {
            this.infernalityAllowed = false;
            this.alwaysinfernal = false;
        }
        if (infernaldrops == null) {
            infernaldrops = new MobRecipeLoader.droplist();
        }
        this.isPeacefulAllowed = !(e instanceof IMob);
        this.mOutputs = (ArrayList)outputs.clone();
        int maxdamagechance = 0;
        for (MobDrop o : this.mOutputs) {
            if (o.damages == null) continue;
            for (int v : o.damages.values()) {
                maxdamagechance += v;
            }
        }
        this.mMaxDamageChance = maxdamagechance;
        this.maxEntityHealth = e.func_110138_aP();
        this.entity = e;
        this.isUsableInVial = EnderIOHelper.canEntityBeCapturedWithSoulVial((Entity)e, entityID);
        this.entityName = entityID;
    }

    public void refresh() {
        int maxdamagechance = 0;
        for (MobDrop o : this.mOutputs) {
            if (o.damages == null) continue;
            for (int v : o.damages.values()) {
                maxdamagechance += v;
            }
        }
        this.mMaxDamageChance = maxdamagechance;
    }

    public ItemStack[] generateRandomOutputs(World world, Random rnd, int lootinglevel, boolean includePlayerOnlyLoot, boolean includeInfernalDropsIfPossible) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(this.mOutputs.size());
        for (MobDrop o : this.mOutputs) {
            int chance = o.chance;
            if (o.playerOnly && !includePlayerOnlyLoot) continue;
            int amount = o.stack.field_77994_a;
            if (o.lootable && lootinglevel > 0 && (chance += lootinglevel * 5000) > 10000) {
                int div = (int)Math.ceil((double)chance / 10000.0);
                amount *= div;
                chance /= div;
            }
            if (chance != 10000 && rnd.nextInt(10000) >= chance) continue;
            ItemStack s = o.stack.func_77946_l();
            s.field_77994_a = amount;
            if (o.enchantable != null) {
                EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)s, (int)o.enchantable);
            }
            if (o.damages != null) {
                int rChance = rnd.nextInt(this.mMaxDamageChance);
                int cChance = 0;
                for (Map.Entry<Integer, Integer> damage : o.damages.entrySet()) {
                    if (rChance > (cChance += damage.getValue().intValue())) continue;
                    s.func_77964_b(damage.getKey().intValue());
                    break;
                }
            }
            stacks.add(s);
        }
        if (LoaderReference.InfernalMobs && includeInfernalDropsIfPossible) {
            InfernalMobsCoreAccessor infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance();
            if (this.infernalityAllowed && !InfernalMobsCoreHelper.getDimensionBlackList((InfernalMobsCore)infernalMobsCore).contains(world.field_73011_w.field_76574_g)) {
                int p = 0;
                if (this.alwaysinfernal || rnd.nextInt(infernalMobsCore.getEliteRarity()) == 0) {
                    p = 1;
                    if (rnd.nextInt(infernalMobsCore.getUltraRarity()) == 0) {
                        p = 2;
                        if (rnd.nextInt(infernalMobsCore.getInfernoRarity()) == 0) {
                            p = 3;
                        }
                    }
                }
                ArrayList<ItemStack> infernalstacks = null;
                if (p > 0) {
                    infernalstacks = p == 1 ? infernalMobsCore.getDropIdListElite() : (p == 2 ? infernalMobsCore.getDropIdListUltra() : infernalMobsCore.getDropIdListInfernal());
                }
                if (infernalstacks != null) {
                    ItemStack infernalstack = infernalstacks.get(rnd.nextInt(infernalstacks.size())).func_77946_l();
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)infernalstack, (int)infernalstack.func_77973_b().func_77619_b());
                    stacks.add(infernalstack);
                }
            }
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public EntityLiving createEntityCopy() throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        EntityLiving entityCopy = (EntityLiving)this.entity.getClass().getConstructor(World.class).newInstance(this.entity.field_70170_p);
        MobRecipeLoader.preGenerationEntityModifiers(entityCopy, this.entityName);
        return entityCopy;
    }

    public static MobRecipe getRecipeByEntityName(String mobName) {
        return MobNameToRecipeMap.get(mobName);
    }

    static {
        MobNameToRecipeMap = new HashMap();
    }
}

