/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.nei;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.IUsageHandler;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.kuba6000.mobsinfo.MobsInfo;
import com.kuba6000.mobsinfo.api.IChanceModifier;
import com.kuba6000.mobsinfo.api.LoaderReference;
import com.kuba6000.mobsinfo.api.MobDrop;
import com.kuba6000.mobsinfo.api.event.MobNEIRegistrationEvent;
import com.kuba6000.mobsinfo.api.helper.EnderIOHelper;
import com.kuba6000.mobsinfo.api.helper.InfernalMobsCoreHelper;
import com.kuba6000.mobsinfo.api.helper.TranslationHelper;
import com.kuba6000.mobsinfo.api.utils.FastRandom;
import com.kuba6000.mobsinfo.api.utils.MobUtils;
import com.kuba6000.mobsinfo.api.utils.ModUtils;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.mixin.InfernalMobs.InfernalMobsCoreAccessor;
import com.kuba6000.mobsinfo.mixin.minecraft.GuiContainerAccessor;
import com.kuba6000.mobsinfo.nei.EnderIOGetter;
import com.kuba6000.mobsinfo.nei.NEI_Config;
import com.kuba6000.mobsinfo.savedata.PlayerData;
import com.kuba6000.mobsinfo.savedata.PlayerDataManager;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.eventhandler.Event;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import java.awt.Point;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.BossStatus;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.Rectangle;
import org.lwjgl.util.glu.GLU;

public class MobHandler
extends TemplateRecipeHandler {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Mob Handler]");
    private static final MobHandler instance = new MobHandler();
    private static final List<MobCachedRecipe> cachedRecipes = new ArrayList<MobCachedRecipe>();
    public static int cycleTicksStatic = Math.abs((int)System.currentTimeMillis());
    private static final int itemsPerRow = 8;
    private static final int itemXShift = 18;
    private static final int itemYShift = 18;
    private static final int nextRowYShift = 35;
    private static final FloatBuffer matrixBuffer = BufferUtils.createFloatBuffer((int)16);
    private static final java.awt.Rectangle extendedTooltipRect = new java.awt.Rectangle(28, 62, 8, 16);

    public static void addRecipe(EntityLiving e, List<MobDrop> drop) {
        int xorigin;
        ArrayList<MobPositionedStack> positionedStacks = new ArrayList<MobPositionedStack>();
        int xoffset = xorigin = 7;
        int yoffset = 95;
        int normaldrops = 0;
        int raredrops = 0;
        int additionaldrops = 0;
        int infernaldrops = 0;
        MobDrop.DropType i = null;
        for (MobDrop d : drop) {
            if (i == d.type && (xoffset += 18) >= xorigin + 144) {
                xoffset = xorigin;
                yoffset += 18;
            }
            if (i != null && i != d.type) {
                xoffset = xorigin;
                yoffset += 35;
            }
            i = d.type;
            if (d.type == MobDrop.DropType.Normal) {
                ++normaldrops;
            } else if (d.type == MobDrop.DropType.Rare) {
                ++raredrops;
            } else if (d.type == MobDrop.DropType.Additional) {
                ++additionaldrops;
            } else if (d.type == MobDrop.DropType.Infernal) break;
            positionedStacks.add(new MobPositionedStack(d.stack.func_77946_l(), xoffset, yoffset, d));
        }
        instance.addRecipeInt(e, positionedStacks, normaldrops, raredrops, additionaldrops, infernaldrops);
    }

    private void addRecipeInt(EntityLiving e, List<MobPositionedStack> l, int normaldrops, int raredrops, int additionaldrops, int infernalDrops) {
        cachedRecipes.add(new MobCachedRecipe(e, l, normaldrops, raredrops, additionaldrops, infernalDrops));
    }

    public static void clearRecipes() {
        cachedRecipes.clear();
    }

    public static void sortCachedRecipes() {
        cachedRecipes.sort((o1, o2) -> {
            boolean u1 = o1.isUnlocked();
            boolean u2 = o2.isUnlocked();
            if (u1 && !u2) {
                return -1;
            }
            if (!u1 && u2) {
                return 1;
            }
            boolean m1 = o1.mod.equals("Minecraft");
            boolean m2 = o2.mod.equals("Minecraft");
            if (m1 && !m2) {
                return -1;
            }
            if (!m1 && m2) {
                return 1;
            }
            if (!o1.mod.equals(o2.mod)) {
                return o1.mod.compareTo(o2.mod);
            }
            return o1.localizedName.compareTo(o2.localizedName);
        });
    }

    public MobHandler() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new java.awt.Rectangle(7, 62, 16, 16), this.getOverlayIdentifier(), new Object[0]));
        if (!NEI_Config.isAdded) {
            FMLInterModComms.sendRuntimeMessage((Object)MobsInfo.instance, (String)"NEIPlugins", (String)"register-crafting-handler", (String)("MobsInfo@" + this.getRecipeName() + "@" + this.getOverlayIdentifier()));
            GuiCraftingRecipe.craftinghandlers.add(this);
            GuiUsageRecipe.usagehandlers.add(this);
        }
    }

    public TemplateRecipeHandler newInstance() {
        return new MobHandler();
    }

    public String getOverlayIdentifier() {
        return "mobsinfo.mobhandler";
    }

    public String getGuiTexture() {
        return "mobsinfo:textures/gui/MobHandler.png";
    }

    public void drawBackground(int recipe) {
        int err;
        int i;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)168, (int)192);
        MobCachedRecipe currentrecipe = (MobCachedRecipe)((Object)this.arecipes.get(recipe));
        if (!currentrecipe.isUnlocked()) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)20.0f, (float)20.0f, (float)0.0f);
            GL11.glScalef((float)4.0f, (float)4.0f, (float)0.0f);
            GuiDraw.drawString((String)"?", (int)0, (int)0, (int)-11184811, (boolean)false);
            GL11.glPopMatrix();
            return;
        }
        int x = 6;
        int y = 94;
        int yshift = 35;
        if (currentrecipe.normalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.normalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.normalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.rareOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.rareOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.rareOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.additionalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.additionalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.infernalOutputsCount > 0) {
            for (i = 0; i < (currentrecipe.infernalOutputsCount - 1) / 8 + 1; ++i) {
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + 18 * i), (int)0, (int)192, (int)144, (int)18);
                if (i <= 0) continue;
                GuiDraw.drawTexturedModalRect((int)x, (int)(y + (18 * i - 1)), (int)0, (int)193, (int)144, (int)2);
            }
        }
        GL11.glEnable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scale = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = scale.func_78326_a();
        int height = scale.func_78328_b();
        int mouseX = Mouse.getX() * width / mc.field_71443_c;
        int mouseZ = height - Mouse.getY() * height / mc.field_71440_d - 1;
        matrixBuffer.clear();
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixBuffer);
        float x2 = matrixBuffer.get(12);
        float y2 = matrixBuffer.get(13);
        int stackdepth = GL11.glGetInteger((int)2979);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        float healthScale = BossStatus.field_82828_a;
        int statusBarTime = BossStatus.field_82826_b;
        String bossName = BossStatus.field_82827_c;
        boolean hasColorModifier = BossStatus.field_82825_d;
        BossStatus.field_82826_b = 0;
        try {
            EntityLiving e = currentrecipe.mob;
            int mobx = 31;
            int moby = 50;
            e.func_70107_b(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v);
            e.field_70142_S = e.field_70165_t;
            e.field_70137_T = e.field_70163_u;
            e.field_70136_U = e.field_70161_v;
            Rectangle v = MobUtils.getMobSizeInGui(e, mobx, moby, 20);
            float ylocal = (float)(v.getY() + v.getHeight()) - y2;
            float wantedy = 54.0f;
            float new_scale = 40.0f / (float)v.getHeight();
            float new_scale_x = 38.0f / (float)v.getWidth();
            if (new_scale_x < new_scale) {
                new_scale = new_scale_x;
            }
            new_scale = (float)Math.round(20.0f * new_scale) / 20.0f;
            float a = (float)moby - ylocal;
            float aa = a - a * new_scale;
            float aaa = wantedy - ylocal - aa;
            GuiInventory.func_147046_a((int)mobx, (int)((int)((float)moby + aaa)), (int)Math.round(20.0f * new_scale), (float)(x2 + (float)mobx - (float)mouseX), (float)(y2 + (float)moby - 25.0f - (float)mouseZ), (EntityLivingBase)e);
        }
        catch (Throwable ex) {
            Tessellator tes = Tessellator.field_78398_a;
            try {
                tes.func_78381_a();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (BossStatus.field_82826_b > 0 && currentrecipe.isBoss.isEmpty()) {
            currentrecipe.isBoss = BossStatus.field_82827_c;
        }
        BossStatus.field_82828_a = healthScale;
        BossStatus.field_82826_b = statusBarTime;
        BossStatus.field_82827_c = bossName;
        BossStatus.field_82825_d = hasColorModifier;
        GL11.glMatrixMode((int)2982);
        if ((stackdepth -= GL11.glGetInteger((int)2979)) < 0) {
            while (stackdepth < 0) {
                GL11.glPopMatrix();
                ++stackdepth;
            }
        }
        if (stackdepth > 0) {
            while (stackdepth > 0) {
                GL11.glPushMatrix();
                --stackdepth;
            }
            GL11.glLoadMatrix((FloatBuffer)matrixBuffer);
        }
        GL11.glPopAttrib();
        while ((err = GL11.glGetError()) != 0) {
            if (!Config.Debug.showRenderErrors) continue;
            LOG.error(currentrecipe.mobname + " | GL ERROR: " + err + " / " + GLU.gluErrorString((int)err));
        }
        GL11.glDisable((int)2929);
    }

    private int drawStringWithWordWrap(String string, int x, int y, int yshift, int width, int color, boolean shadow) {
        List s = GuiDraw.fontRenderer.func_78271_c(string, width);
        int sSize = s.size();
        for (int i = 0; i < sSize; ++i) {
            String s1 = (String)s.get(i);
            if (i > 0) {
                GuiDraw.drawString((String)(" " + s1), (int)x, (int)y, (int)color, (boolean)shadow);
            } else {
                GuiDraw.drawString((String)s1, (int)x, (int)y, (int)color, (boolean)shadow);
            }
            y += yshift;
        }
        return yshift * s.size();
    }

    public void drawForeground(int recipe) {
        MobCachedRecipe currentrecipe = (MobCachedRecipe)((Object)this.arecipes.get(recipe));
        int y = 7;
        int yshift = 10;
        int x = 57;
        y += this.drawStringWithWordWrap(currentrecipe.localizedName, x, y, yshift, 168 - x, -11184811, false) - yshift;
        if (Minecraft.func_71410_x().field_71474_y.field_82882_x && NEIClientUtils.shiftKey()) {
            GuiDraw.drawString((String)currentrecipe.mobname, (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        }
        GuiDraw.drawString((String)(Translations.MOD.get() + currentrecipe.mod), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        if (!currentrecipe.isUnlocked()) {
            x = 6;
            y = 83;
            GuiDraw.drawStringC((String)Translations.LOCKED.get(), (int)84, (int)(y += yshift), (int)-11184811, (boolean)false);
            GuiDraw.drawStringC((String)Translations.LOCKED_1.get(), (int)84, (int)(y += yshift), (int)-11184811, (boolean)false);
            return;
        }
        GuiDraw.drawString((String)(Translations.MAX_HEALTH.get() + currentrecipe.maxHealth), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        switch (currentrecipe.infernaltype) {
            case -1: {
                break;
            }
            case 0: {
                GuiDraw.drawString((String)Translations.INFERNAL_CANNOT.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
                break;
            }
            case 1: {
                GuiDraw.drawString((String)Translations.INFERNAL_CAN.get(), (int)x, (int)(y += yshift), (int)-65536, (boolean)false);
                break;
            }
            case 2: {
                GuiDraw.drawString((String)Translations.INFERNAL_ALWAYS.get(), (int)x, (int)(y += yshift), (int)-65536, (boolean)false);
            }
        }
        if (!currentrecipe.isBoss.isEmpty()) {
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + "" + Translations.BOSS.get()), (int)x, (int)(y += yshift), (int)-2715904, (boolean)false);
        }
        if (currentrecipe.isPeacefulAllowed) {
            GuiDraw.drawString((String)Translations.PEACEFUL_ALLOWED.get(), (int)x, (int)(y += yshift), (int)-16755456, (boolean)false);
        }
        if (!currentrecipe.isUsableInVial) {
            GuiDraw.drawString((String)Translations.CANNOT_USE_VIAL.get(), (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
        }
        if (!currentrecipe.additionalInformation.isEmpty()) {
            for (String s : currentrecipe.additionalInformation) {
                GuiDraw.drawString((String)s, (int)x, (int)(y += yshift), (int)-11184811, (boolean)false);
            }
        }
        x = 6;
        y = 83;
        yshift = 35;
        if (currentrecipe.normalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.NORMAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.normalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.rareOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.RARE_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.rareOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.additionalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.ADDITIONAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        if (currentrecipe.infernalOutputsCount > 0) {
            GuiDraw.drawString((String)Translations.INFERNAL_DROPS.get(), (int)x, (int)y, (int)-11184811, (boolean)false);
            y += yshift + (currentrecipe.additionalOutputsCount - 1) / 8 * 18;
        }
        yshift = 10;
    }

    public String getRecipeName() {
        return "Mob Info";
    }

    public IUsageHandler getUsageAndCatalystHandler(String inputId, Object ... ingredients) {
        ItemStack candidate;
        TemplateRecipeHandler handler;
        if (inputId.equals("item") && RecipeCatalysts.containsCatalyst((IRecipeHandler)(handler = this.newInstance()), (ItemStack)(candidate = (ItemStack)ingredients[0]))) {
            handler.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
            return handler;
        }
        return this.getUsageHandler(inputId, ingredients);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            this.arecipes.addAll(cachedRecipes);
            return;
        }
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (LoaderReference.Gregtech5) {
            List<ItemStack> results = GT5Helper.getAssociated(result);
            for (MobCachedRecipe r : cachedRecipes) {
                if (!results.stream().anyMatch(i -> r.contains(r.mOutputs, (ItemStack)i)) || !r.isUnlocked()) continue;
                this.arecipes.add(r);
            }
        } else {
            for (MobCachedRecipe r : cachedRecipes) {
                if (!r.contains(r.mOutputs, result) || !r.isUnlocked()) continue;
                this.arecipes.add(r);
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Item item;
        if (LoaderReference.EnderIO && ((item = ingredient.func_77973_b()) == Item.func_150898_a((Block)EnderIOGetter.blockPoweredSpawner()) || item == EnderIOGetter.itemSoulVessel() || item == EnderIOGetter.itemBrokenSpawner())) {
            String mobType = EnderIOGetter.getContainedMobOrNull(ingredient);
            if (mobType == null) {
                this.loadCraftingRecipes(this.getOverlayIdentifier(), new Object[]{null});
                return;
            }
            for (MobCachedRecipe r : cachedRecipes) {
                if (!r.mobname.equals(mobType)) continue;
                this.arecipes.add(r);
            }
            return;
        }
        for (MobCachedRecipe r : cachedRecipes) {
            if (!r.mInput.stream().anyMatch(arg_0 -> ((ItemStack)ingredient).func_77969_a(arg_0))) continue;
            this.arecipes.add(r);
        }
    }

    public static boolean isUsageInfernalMob(ItemStack ingredient) {
        Item item;
        if (LoaderReference.EnderIO && ((item = ingredient.func_77973_b()) == Item.func_150898_a((Block)EnderIOGetter.blockPoweredSpawner()) || item == EnderIOGetter.itemSoulVessel() || item == EnderIOGetter.itemBrokenSpawner())) {
            String mobType = EnderIOGetter.getContainedMobOrNull(ingredient);
            if (mobType == null) {
                return false;
            }
            for (MobCachedRecipe r : cachedRecipes) {
                if (!r.mobname.equals(mobType)) continue;
                return r.infernaltype > 0;
            }
            return false;
        }
        for (MobCachedRecipe r : cachedRecipes) {
            if (!r.mInput.stream().anyMatch(arg_0 -> ((ItemStack)ingredient).func_77969_a(arg_0)) || r.infernaltype <= 0) continue;
            return true;
        }
        return false;
    }

    public void onUpdate() {
        ++cycleTicksStatic;
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> currenttip, int recipe) {
        currenttip = super.handleTooltip(gui, currenttip, recipe);
        Point pos = GuiDraw.getMousePosition();
        Point offset = gui.getRecipePosition(recipe);
        Point relMouse = new Point(pos.x - ((GuiContainerAccessor)gui).getGuiLeft() - offset.x, pos.y - ((GuiContainerAccessor)gui).getGuiTop() - offset.y);
        if (extendedTooltipRect.contains(relMouse)) {
            currenttip.addAll(Translations.EXTENDED_INFO.getAllLines());
        }
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe<?> gui, ItemStack stack, List<String> currenttip, int recipe) {
        MobCachedRecipe currentrecipe = (MobCachedRecipe)((Object)this.arecipes.get(recipe));
        PositionedStack positionedStack = currentrecipe.mOutputs.stream().filter(ps -> ps.item == stack).findFirst().orElse(null);
        if (positionedStack instanceof MobPositionedStack) {
            currenttip.addAll(((MobPositionedStack)positionedStack).extraTooltip);
        }
        return currenttip;
    }

    private static class GT5Helper {
        private GT5Helper() {
        }

        public static List<ItemStack> getAssociated(ItemStack aResult) {
            ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation((ItemStack)aResult);
            ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
            tResults.add(aResult);
            tResults.add(GT_OreDictUnificator.get((boolean)true, (ItemStack)aResult));
            if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
                for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                    tResults.add(GT_OreDictUnificator.get((OrePrefixes)tPrefix, (Object)tPrefixMaterial.mMaterial.mMaterial, (long)1L));
                }
            }
            if (aResult.func_77977_a().startsWith("gt.blockores")) {
                for (int i = 0; i < 8; ++i) {
                    tResults.add(new ItemStack(aResult.func_77973_b(), 1, aResult.func_77960_j() % 1000 + i * 1000));
                }
            }
            return tResults;
        }
    }

    private class MobCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final EntityLiving mob;
        public final List<PositionedStack> mOutputs;
        public final List<ItemStack> mInput;
        public final String mobname;
        public final int infernaltype;
        public final PositionedStack ingredient;
        public final String localizedName;
        public final String mod;
        public final float maxHealth;
        public final int normalOutputsCount;
        public final int rareOutputsCount;
        public final int additionalOutputsCount;
        public final int infernalOutputsCount;
        public final boolean isUsableInVial;
        public final boolean isPeacefulAllowed;
        public final List<String> additionalInformation;
        public String isBoss;

        public MobCachedRecipe(EntityLiving mob, List<MobPositionedStack> mOutputs, int normalOutputsCount, int rareOutputsCount, int additionalOutputsCount, int infernalOutputsCount) {
            InfernalMobsCoreAccessor infernalMobsCore;
            super((TemplateRecipeHandler)MobHandler.this);
            this.isBoss = "";
            String classname = mob.getClass().getName();
            this.mod = ModUtils.getModNameFromClassName(classname);
            this.mob = mob;
            this.maxHealth = mob.func_110138_aP();
            this.mOutputs = new ArrayList<PositionedStack>(mOutputs.size());
            this.mOutputs.addAll(mOutputs);
            this.normalOutputsCount = normalOutputsCount;
            this.rareOutputsCount = rareOutputsCount;
            this.additionalOutputsCount = additionalOutputsCount;
            this.infernalOutputsCount = infernalOutputsCount;
            this.mInput = new ArrayList<ItemStack>();
            this.isPeacefulAllowed = !(mob instanceof IMob);
            int id = EntityList.func_75619_a((Entity)mob);
            this.mobname = EntityList.func_75621_b((Entity)mob);
            String string = this.mobname.equals("Skeleton") && ((EntitySkeleton)mob).func_82202_m() == 1 ? "Wither Skeleton" : (this.localizedName = !mob.func_70005_c_().startsWith("entity.") ? mob.func_70005_c_() : this.mobname);
            if (id != 0) {
                this.mInput.add(new ItemStack(Items.field_151063_bx, 1, id));
                this.mInput.add(new ItemStack(Blocks.field_150474_ac, 1, id));
            }
            if (LoaderReference.EnderIO) {
                this.mInput.add(0, EnderIOGetter.BlockPoweredSpawner$createItemStackForMob(this.mobname));
                this.mInput.add(1, EnderIOGetter.ItemSoulVessel$createVesselWithEntityStub(this.mobname));
                this.mInput.add(2, EnderIOGetter.ItemBrokenSpawner$createStackForMobType(this.mobname));
            }
            this.ingredient = !this.mInput.isEmpty() ? new PositionedStack(this.mInput, 38, 44, true) : null;
            this.isUsableInVial = EnderIOHelper.canEntityBeCapturedWithSoulVial((Entity)mob, this.mobname);
            this.infernaltype = !LoaderReference.InfernalMobs ? -1 : (!InfernalMobsCoreHelper.callIsClassAllowed((InfernalMobsCore)(infernalMobsCore = (InfernalMobsCoreAccessor)InfernalMobsCore.instance()), (EntityLivingBase)mob) ? 0 : (infernalMobsCore.callCheckEntityClassForced((EntityLivingBase)mob) ? 2 : 1));
            this.additionalInformation = new ArrayList<String>();
            MinecraftForge.EVENT_BUS.post((Event)new MobNEIRegistrationEvent(this.mobname, mob, this.additionalInformation));
        }

        public boolean isUnlocked() {
            if (!Config.MobHandler.hiddenMode) {
                return true;
            }
            PlayerData localData = PlayerDataManager.getPlayer(null);
            return localData.killedMobs.contains(this.mobname);
        }

        public PositionedStack getIngredient() {
            if (!NEIClientUtils.shiftKey() && this.ingredient != null) {
                this.ingredient.setPermutationToRender(cycleTicksStatic / 10 % this.ingredient.items.length);
            }
            return this.ingredient;
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            if (!this.isUnlocked()) {
                return Collections.emptyList();
            }
            if (!NEIClientUtils.shiftKey() && cycleTicksStatic % 10 == 0) {
                this.mOutputs.forEach(p -> p.setPermutationToRender(0));
            }
            return this.mOutputs;
        }
    }

    public static class MobPositionedStack
    extends PositionedStack {
        public final MobDrop.DropType type;
        public final int chance;
        public final boolean enchantable;
        public final boolean randomdamage;
        public final List<Integer> damages;
        public final int enchantmentLevel;
        private final Random rand = new FastRandom();
        public final List<String> extraTooltip;

        public MobPositionedStack(Object object, int x, int y, MobDrop drop) {
            super(object, x, y, false);
            this.type = drop.type;
            this.chance = drop.chance;
            this.enchantable = drop.enchantable != null;
            this.enchantmentLevel = this.enchantable ? drop.enchantable : 0;
            this.randomdamage = drop.damages != null;
            this.damages = this.randomdamage ? new ArrayList<Integer>(drop.damages.keySet()) : null;
            this.extraTooltip = new ArrayList<String>();
            if (!drop.variableChance) {
                this.extraTooltip.add(EnumChatFormatting.RESET + Translations.CHANCE.get(this.chance == 0 ? "<0.01%" : Double.valueOf((double)this.chance / 100.0)));
            } else {
                for (IChanceModifier chanceModifier : drop.chanceModifiers) {
                    chanceModifier.applyTooltip(this.extraTooltip);
                }
            }
            if (drop.lootable) {
                this.extraTooltip.add(EnumChatFormatting.RESET + Translations.LOOTABLE.get());
            }
            if (drop.playerOnly) {
                this.extraTooltip.add(EnumChatFormatting.RESET + Translations.PLAYER_ONLY.get());
            }
            if (drop.additionalInfo != null && !drop.additionalInfo.isEmpty()) {
                this.extraTooltip.addAll(drop.additionalInfo);
            }
            this.extraTooltip.add(EnumChatFormatting.RESET + Translations.AVERAGE_REMINDER.get());
            this.setPermutationToRender(0);
        }

        public void setPermutationToRender(int index) {
            if (this.item == null) {
                this.item = this.items[0].func_77946_l();
            }
            if (this.enchantable) {
                if (this.item.func_77973_b() == Items.field_151134_bR) {
                    this.item = this.items[0].func_77946_l();
                }
                if (this.item.func_77942_o()) {
                    this.item.func_77978_p().func_82580_o("ench");
                }
                EnchantmentHelper.func_77504_a((Random)this.rand, (ItemStack)this.item, (int)this.enchantmentLevel);
            }
            if (this.randomdamage) {
                this.item.func_77964_b(this.damages.get(this.rand.nextInt(this.damages.size())).intValue());
            }
        }
    }

    static enum Translations {
        NORMAL_DROPS,
        RARE_DROPS,
        ADDITIONAL_DROPS,
        INFERNAL_DROPS,
        INFERNAL_CANNOT,
        INFERNAL_CAN,
        INFERNAL_ALWAYS,
        CANNOT_USE_VIAL,
        CHANCE,
        AVERAGE_REMINDER,
        MOD,
        MAX_HEALTH,
        BOSS,
        LOOTABLE,
        PLAYER_ONLY,
        PEACEFUL_ALLOWED,
        LOCKED,
        LOCKED_1,
        EXTENDED_INFO;

        final String key = "mobsinfo.mobhandler." + this.name().toLowerCase();

        public String get() {
            return StatCollector.func_74838_a((String)this.key);
        }

        public List<String> getAllLines() {
            ArrayList<String> lines = new ArrayList<String>(Collections.singletonList(StatCollector.func_74838_a((String)this.key)));
            int i = 1;
            while (StatCollector.func_94522_b((String)(this.key + "_" + i))) {
                lines.add(StatCollector.func_74838_a((String)(this.key + "_" + i++)));
            }
            return lines;
        }

        public String get(Object ... args) {
            return TranslationHelper.translateFormattedFixed(this.key, args);
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.get();
        }
    }
}

