/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.imgur;

import alexiil.mods.load.BetterLoadingScreen;
import alexiil.mods.load.imgur.ImgurClient;
import alexiil.mods.load.imgur.LateInitDynamicTexture;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ImgurCacheManager {
    private static final boolean OFFLINE_MODE = Boolean.getBoolean("bls.offlineMode");
    private static final String IMGUR_CACHE_DIR = "bls-imgur-cache";
    private final Map<String, AbstractTexture> textureCache = new ConcurrentHashMap<String, AbstractTexture>();
    private String appClientId;
    private String galleryId;
    private int requestTimeout;
    private volatile boolean cancelSetup;

    public void loadConfig(Configuration config) {
        this.appClientId = config.getString("imgurAppClientId", "imgur", "", "The client ID of your imgur application. Required to access the imgur api.");
        this.galleryId = config.getString("imgurGalleryId", "imgur", "", "ID of the imgur gallery/album. For example: Ks0TrYE");
        this.requestTimeout = config.getInt("imgurRequestTimeout", "imgur", 5000, 100, Integer.MAX_VALUE, "Request timeout (ms) for imgur requests");
    }

    public AbstractTexture getCachedTexture(ResourceLocation location) {
        if (!location.func_110624_b().equals(IMGUR_CACHE_DIR)) {
            return null;
        }
        return this.textureCache.get(location.func_110623_a());
    }

    public void cleanUp() {
        this.textureCache.values().forEach(AbstractTexture::func_147631_c);
        this.textureCache.clear();
        this.cancelSetup = true;
    }

    public void setupImgurGallery(Consumer<ResourceLocation> textureLocationConsumer) {
        List<String> cachedImageIDs;
        Path cacheFolder = Paths.get(IMGUR_CACHE_DIR, new String[0]);
        if (Files.notExists(cacheFolder, new LinkOption[0])) {
            try {
                Files.createDirectory(cacheFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                BetterLoadingScreen.log.error("Error while creating imgur cache directory", (Throwable)e);
                return;
            }
        }
        if ((cachedImageIDs = this.getCachedImageIDs()) == null) {
            return;
        }
        this.loadAnyImageFromDisk(cachedImageIDs, textureLocationConsumer);
        CompletableFuture.runAsync(() -> {
            try (ImgurClient client = OFFLINE_MODE ? null : new ImgurClient(this.appClientId, this.requestTimeout);){
                Consumer<String> imageHandler = imageID -> {
                    List list = cachedImageIDs;
                    synchronized (list) {
                        cachedImageIDs.remove(imageID);
                    }
                    if (this.cancelSetup) {
                        return;
                    }
                    if (this.textureCache.containsKey(imageID)) {
                        return;
                    }
                    Path imageFile = ImgurCacheManager.getCachedImagePath(imageID);
                    try {
                        if (Files.exists(ImgurCacheManager.getCachedImagePath(imageID), new LinkOption[0])) {
                            this.readAndCacheImageFromStream((String)imageID, new BufferedInputStream(Files.newInputStream(imageFile, new OpenOption[0]), 0x100000), false);
                        } else {
                            if (OFFLINE_MODE) {
                                return;
                            }
                            this.readAndCacheImageFromStream((String)imageID, new ByteArrayInputStream(client.fetchImage((String)imageID)), true);
                        }
                    }
                    catch (IOException e) {
                        BetterLoadingScreen.log.error("Error while loading imgur image", (Throwable)e);
                        return;
                    }
                    Consumer consumer = textureLocationConsumer;
                    synchronized (consumer) {
                        textureLocationConsumer.accept(new ResourceLocation(IMGUR_CACHE_DIR, imageID));
                    }
                };
                if (OFFLINE_MODE) {
                    ((Stream)cachedImageIDs.stream().parallel()).forEach(imageHandler);
                } else {
                    ((Stream)client.fetchGalleryImageIDs(this.galleryId, true).stream().parallel()).forEach(imageHandler);
                }
            }
            catch (Exception e) {
                BetterLoadingScreen.log.error("Error while fetching imgur gallery", (Throwable)e);
            }
        }).thenRunAsync(() -> {
            if (OFFLINE_MODE) {
                return;
            }
            try {
                for (String id : cachedImageIDs) {
                    Files.deleteIfExists(ImgurCacheManager.getCachedImagePath(id));
                }
            }
            catch (IOException e) {
                BetterLoadingScreen.log.error("Error while deleting unused cached imgur images", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnyImageFromDisk(List<String> cachedImageIDs, Consumer<ResourceLocation> textureLocationConsumer) {
        if (cachedImageIDs.isEmpty()) {
            return;
        }
        String imageID = cachedImageIDs.get(ThreadLocalRandom.current().nextInt(cachedImageIDs.size()));
        try {
            this.readAndCacheImageFromDisk(imageID);
        }
        catch (IOException e) {
            BetterLoadingScreen.log.error("Error while loading first cached imgur image", (Throwable)e);
            return;
        }
        Consumer<ResourceLocation> consumer = textureLocationConsumer;
        synchronized (consumer) {
            textureLocationConsumer.accept(new ResourceLocation(IMGUR_CACHE_DIR, imageID));
        }
    }

    private void readAndCacheImageFromStream(String imageID, InputStream imageStream, boolean saveToDisk) throws IOException {
        BufferedImage image = ImageIO.read(imageStream);
        this.textureCache.put(imageID, new LateInitDynamicTexture(image, image.getWidth(), image.getHeight()));
        if (saveToDisk && Files.notExists(ImgurCacheManager.getCachedImagePath(imageID), new LinkOption[0])) {
            this.writeImageToCache(imageID, image);
        }
    }

    private void readAndCacheImageFromDisk(String imageID) throws IOException {
        this.readAndCacheImageFromStream(imageID, new BufferedInputStream(Files.newInputStream(ImgurCacheManager.getCachedImagePath(imageID), new OpenOption[0]), 0x100000), false);
    }

    private void writeImageToCache(String imageID, BufferedImage image) throws IOException {
        ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(Files.newOutputStream(ImgurCacheManager.getCachedImagePath(imageID), new OpenOption[0]), 0x100000));
    }

    private static Path getCachedImagePath(String imageID) {
        return Paths.get(IMGUR_CACHE_DIR, new String[0]).resolve(imageID + ".png");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getCachedImageIDs() {
        try (Stream<Path> cacheFolderStream = Files.list(Paths.get(IMGUR_CACHE_DIR, new String[0]));){
            List<String> list = cacheFolderStream.map(path -> path.getFileName().toString().replace(".png", "")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            BetterLoadingScreen.log.error("Error while iterating imgur cache folder", (Throwable)e);
            return null;
        }
    }
}

