/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.bauble;

import baubles.api.BaubleType;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.bauble.BaseBauble;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class FireProtectionBauble
extends BaseBauble {
    private static Field isImmuneToFire = ReflectionUtils.getField(Entity.class, !CORE_Preloader.DEV_ENVIRONMENT ? "func_70045_F" : "isImmuneToFire");

    public static boolean fireImmune(Entity aEntity) {
        return aEntity.func_70045_F();
    }

    public static boolean setEntityImmuneToFire(Entity aEntity, boolean aImmune) {
        try {
            return ReflectionUtils.setField((Object)aEntity, isImmuneToFire, (Object)aImmune);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public FireProtectionBauble() {
        super(BaubleType.RING, "GTPP.bauble.fireprotection.0.name", 0);
        String aUnlocalName = "GTPP.bauble.fireprotection.0.name";
        this.func_77655_b(aUnlocalName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + this.getTextureNameForBauble());
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(AddToCreativeTab.tabMachines);
        if (GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)aUnlocalName) == null) {
            GameRegistry.registerItem((Item)this, (String)aUnlocalName);
        }
    }

    public void func_77663_a(ItemStack itemStack, World worldObj, Entity player, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(itemStack, worldObj, player, p_77663_4_, p_77663_5_);
    }

    @Override
    public String func_77653_i(ItemStack p_77653_1_) {
        return EnumChatFormatting.DARK_RED + super.func_77653_i(p_77653_1_) + EnumChatFormatting.GRAY;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        super.func_77624_a(stack, aPlayer, list, bool);
    }

    @Override
    public boolean canEquip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public boolean canUnequip(ItemStack arg0, EntityLivingBase arg1) {
        return true;
    }

    @Override
    public void onEquipped(ItemStack arg0, EntityLivingBase aPlayer) {
        if (!aPlayer.field_70170_p.field_72995_K && aPlayer instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)aPlayer;
        }
    }

    @Override
    public void onUnequipped(ItemStack arg0, EntityLivingBase aPlayer) {
        if (!aPlayer.field_70170_p.field_72995_K && aPlayer instanceof EntityPlayer) {
            EntityPlayer bPlayer = (EntityPlayer)aPlayer;
            if (bPlayer.func_70644_a(Potion.field_76426_n)) {
                bPlayer.func_82170_o(Potion.field_76426_n.field_76415_H);
            }
            FireProtectionBauble.setEntityImmuneToFire((Entity)bPlayer, false);
        }
    }

    @Override
    public void onWornTick(ItemStack aBaubleStack, EntityLivingBase aPlayer) {
        if (!aPlayer.field_70170_p.field_72995_K && aPlayer instanceof EntityPlayer) {
            EntityPlayer bPlayer = (EntityPlayer)aPlayer;
            if (!FireProtectionBauble.fireImmune((Entity)bPlayer)) {
                FireProtectionBauble.setEntityImmuneToFire((Entity)bPlayer, true);
            }
            if (!bPlayer.func_70644_a(Potion.field_76426_n)) {
                bPlayer.func_70690_d(new PotionEffect(Potion.field_76426_n.field_76415_H, 100, 4));
            }
        }
    }

    public String getTextureNameForBauble() {
        return "baubles/itemFireProtectGlovesBetter";
    }
}

