/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.player;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.UUID;

public class PlayerCache {
    private static final File cache = new File("PlayerCache.dat");

    public static void initCache() {
        if (CORE.PlayerCache == null) {
            if (cache.exists()) {
                CORE.PlayerCache = PlayerCache.readPropertiesFileAsMap();
                Logger.INFO("Loaded PlayerCache.dat");
            }
            if (CORE.PlayerCache == null) {
                Logger.INFO("Failed to load PlayerCache.dat");
                PlayerCache.createPropertiesFile("PLAYER_", "DATA");
            }
        }
    }

    public static void createPropertiesFile(String playerName, String playerUUIDasString) {
        try {
            Properties props = new Properties();
            props.setProperty(playerName + " ", playerUUIDasString);
            FileOutputStream out = new FileOutputStream(cache);
            props.store(out, "Player Cache.");
            Logger.INFO("PlayerCache.dat created for future use.");
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, UUID> readPropertiesFileAsMap() {
        HashMap map = null;
        try {
            FileInputStream fis = new FileInputStream(cache);
            ObjectInputStream ois = new ObjectInputStream(fis);
            map = (HashMap)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException c) {
            Logger.INFO("Class not found");
            c.printStackTrace();
            return null;
        }
        Logger.WARNING("Deserialized PlayerCache..");
        return map;
    }
}

